# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.13.0.20200810.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class PaymentTokenDetailsAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'last4': 'str',
        'brand': 'str',
        'account_verification': 'bool',
        'type': 'str',
    }

    attribute_map = {
        'last4': 'last4',  # noqa: E501
        'brand': 'brand',  # noqa: E501
        'account_verification': 'accountVerification',  # noqa: E501
        'type': 'type',  # noqa: E501
    }

    def __init__(self, last4=None, brand=None, account_verification=None, type=None):  # noqa: E501
        """PaymentTokenDetailsAllOf - a model defined in OpenAPI



        Keyword Args:
            last4 (str): The last 4 numbers of a payment card.. [optional]  # noqa: E501
            brand (str): Card brand, only for tokenization with payment.. [optional]  # noqa: E501
            account_verification (bool): If the account the token was created from has been verified.. [optional]  # noqa: E501
            type (str): Inidcates the type of tokenization source.. [optional]  # noqa: E501
        """

        self._last4 = None
        self._brand = None
        self._account_verification = None
        self._type = None
        self.discriminator = None

        if last4 is not None:
            self.last4 = last4  # noqa: E501
        if brand is not None:
            self.brand = brand  # noqa: E501
        if account_verification is not None:
            self.account_verification = account_verification  # noqa: E501
        if type is not None:
            self.type = type  # noqa: E501

    @property
    def last4(self):
        """Gets the last4 of this PaymentTokenDetailsAllOf.  # noqa: E501

        The last 4 numbers of a payment card.  # noqa: E501

        :return: The last4 of this PaymentTokenDetailsAllOf.  # noqa: E501
        :rtype: str
        """
        return self._last4

    @last4.setter
    def last4(
            self,
            last4):
        """Sets the last4 of this PaymentTokenDetailsAllOf.

        The last 4 numbers of a payment card.  # noqa: E501

        :param last4: The last4 of this PaymentTokenDetailsAllOf.  # noqa: E501
        :type: str
        """

        self._last4 = (
            last4)

    @property
    def brand(self):
        """Gets the brand of this PaymentTokenDetailsAllOf.  # noqa: E501

        Card brand, only for tokenization with payment.  # noqa: E501

        :return: The brand of this PaymentTokenDetailsAllOf.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(
            self,
            brand):
        """Sets the brand of this PaymentTokenDetailsAllOf.

        Card brand, only for tokenization with payment.  # noqa: E501

        :param brand: The brand of this PaymentTokenDetailsAllOf.  # noqa: E501
        :type: str
        """

        self._brand = (
            brand)

    @property
    def account_verification(self):
        """Gets the account_verification of this PaymentTokenDetailsAllOf.  # noqa: E501

        If the account the token was created from has been verified.  # noqa: E501

        :return: The account_verification of this PaymentTokenDetailsAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._account_verification

    @account_verification.setter
    def account_verification(
            self,
            account_verification):
        """Sets the account_verification of this PaymentTokenDetailsAllOf.

        If the account the token was created from has been verified.  # noqa: E501

        :param account_verification: The account_verification of this PaymentTokenDetailsAllOf.  # noqa: E501
        :type: bool
        """

        self._account_verification = (
            account_verification)

    @property
    def type(self):
        """Gets the type of this PaymentTokenDetailsAllOf.  # noqa: E501

        Inidcates the type of tokenization source.  # noqa: E501

        :return: The type of this PaymentTokenDetailsAllOf.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(
            self,
            type):
        """Sets the type of this PaymentTokenDetailsAllOf.

        Inidcates the type of tokenization source.  # noqa: E501

        :param type: The type of this PaymentTokenDetailsAllOf.  # noqa: E501
        :type: str
        """

        self._type = (
            type)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentTokenDetailsAllOf):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
