# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.13.0.20200810.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class PaymentCardDisbursementTransactionAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'disbursement': 'Disbursement',
        'payment_method': 'PaymentCardPaymentMethod',
        'stored_credentials': 'StoredCredential',
        'create_token': 'CreatePaymentToken',
    }

    attribute_map = {
        'disbursement': 'disbursement',  # noqa: E501
        'payment_method': 'paymentMethod',  # noqa: E501
        'stored_credentials': 'storedCredentials',  # noqa: E501
        'create_token': 'createToken',  # noqa: E501
    }

    def __init__(self, disbursement, payment_method, stored_credentials=None, create_token=None):  # noqa: E501
        """PaymentCardDisbursementTransactionAllOf - a model defined in OpenAPI

        Args:
            disbursement (Disbursement):
            payment_method (PaymentCardPaymentMethod):

        Keyword Args:  # noqa: E501  # noqa: E501
            stored_credentials (StoredCredential): [optional]  # noqa: E501
            create_token (CreatePaymentToken): [optional]  # noqa: E501
        """

        self._disbursement = None
        self._payment_method = None
        self._stored_credentials = None
        self._create_token = None
        self.discriminator = None

        self.disbursement = disbursement
        self.payment_method = payment_method
        if stored_credentials is not None:
            self.stored_credentials = stored_credentials  # noqa: E501
        if create_token is not None:
            self.create_token = create_token  # noqa: E501

    @property
    def disbursement(self):
        """Gets the disbursement of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501


        :return: The disbursement of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :rtype: Disbursement
        """
        return self._disbursement

    @disbursement.setter
    def disbursement(
            self,
            disbursement):
        """Sets the disbursement of this PaymentCardDisbursementTransactionAllOf.


        :param disbursement: The disbursement of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :type: Disbursement
        """
        if disbursement is None:
            raise ValueError("Invalid value for `disbursement`, must not be `None`")  # noqa: E501

        self._disbursement = (
            disbursement)

    @property
    def payment_method(self):
        """Gets the payment_method of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501


        :return: The payment_method of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :rtype: PaymentCardPaymentMethod
        """
        return self._payment_method

    @payment_method.setter
    def payment_method(
            self,
            payment_method):
        """Sets the payment_method of this PaymentCardDisbursementTransactionAllOf.


        :param payment_method: The payment_method of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :type: PaymentCardPaymentMethod
        """
        if payment_method is None:
            raise ValueError("Invalid value for `payment_method`, must not be `None`")  # noqa: E501

        self._payment_method = (
            payment_method)

    @property
    def stored_credentials(self):
        """Gets the stored_credentials of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501


        :return: The stored_credentials of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :rtype: StoredCredential
        """
        return self._stored_credentials

    @stored_credentials.setter
    def stored_credentials(
            self,
            stored_credentials):
        """Sets the stored_credentials of this PaymentCardDisbursementTransactionAllOf.


        :param stored_credentials: The stored_credentials of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :type: StoredCredential
        """

        self._stored_credentials = (
            stored_credentials)

    @property
    def create_token(self):
        """Gets the create_token of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501


        :return: The create_token of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :rtype: CreatePaymentToken
        """
        return self._create_token

    @create_token.setter
    def create_token(
            self,
            create_token):
        """Sets the create_token of this PaymentCardDisbursementTransactionAllOf.


        :param create_token: The create_token of this PaymentCardDisbursementTransactionAllOf.  # noqa: E501
        :type: CreatePaymentToken
        """

        self._create_token = (
            create_token)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentCardDisbursementTransactionAllOf):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
