# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.13.0.20200810.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class EncryptedApplePayHeader(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ephemeral_public_key': 'str',
        'public_key_hash': 'str',
        'transaction_id': 'str',
        'application_data_hash': 'str',
    }

    attribute_map = {
        'ephemeral_public_key': 'ephemeralPublicKey',  # noqa: E501
        'public_key_hash': 'publicKeyHash',  # noqa: E501
        'transaction_id': 'transactionId',  # noqa: E501
        'application_data_hash': 'applicationDataHash',  # noqa: E501
    }

    def __init__(self, ephemeral_public_key, public_key_hash, transaction_id, application_data_hash=None):  # noqa: E501
        """EncryptedApplePayHeader - a model defined in OpenAPI

        Args:
            ephemeral_public_key (str): Temporary key for generating shared secret from a device.
            public_key_hash (str): Hash of the X.509 encoded public key bytes of the merchant’s certificate.
            transaction_id (str): Transaction identifier, generated on the device.

        Keyword Args:  # noqa: E501  # noqa: E501  # noqa: E501
            application_data_hash (str): Merchant supplied information about the payment request. Contains Base64-encoded SHA256 hash of the applicationData property of the original PKPaymentRequest. Note - applicationData from PaymentData of PKPaymentToken Refer to Apple Pay documentation.. [optional]  # noqa: E501
        """

        self._application_data_hash = None
        self._ephemeral_public_key = None
        self._public_key_hash = None
        self._transaction_id = None
        self.discriminator = None

        if application_data_hash is not None:
            self.application_data_hash = application_data_hash  # noqa: E501
        self.ephemeral_public_key = ephemeral_public_key
        self.public_key_hash = public_key_hash
        self.transaction_id = transaction_id

    @property
    def application_data_hash(self):
        """Gets the application_data_hash of this EncryptedApplePayHeader.  # noqa: E501

        Merchant supplied information about the payment request. Contains Base64-encoded SHA256 hash of the applicationData property of the original PKPaymentRequest. Note - applicationData from PaymentData of PKPaymentToken Refer to Apple Pay documentation.  # noqa: E501

        :return: The application_data_hash of this EncryptedApplePayHeader.  # noqa: E501
        :rtype: str
        """
        return self._application_data_hash

    @application_data_hash.setter
    def application_data_hash(
            self,
            application_data_hash):
        """Sets the application_data_hash of this EncryptedApplePayHeader.

        Merchant supplied information about the payment request. Contains Base64-encoded SHA256 hash of the applicationData property of the original PKPaymentRequest. Note - applicationData from PaymentData of PKPaymentToken Refer to Apple Pay documentation.  # noqa: E501

        :param application_data_hash: The application_data_hash of this EncryptedApplePayHeader.  # noqa: E501
        :type: str
        """

        self._application_data_hash = (
            application_data_hash)

    @property
    def ephemeral_public_key(self):
        """Gets the ephemeral_public_key of this EncryptedApplePayHeader.  # noqa: E501

        Temporary key for generating shared secret from a device.  # noqa: E501

        :return: The ephemeral_public_key of this EncryptedApplePayHeader.  # noqa: E501
        :rtype: str
        """
        return self._ephemeral_public_key

    @ephemeral_public_key.setter
    def ephemeral_public_key(
            self,
            ephemeral_public_key):
        """Sets the ephemeral_public_key of this EncryptedApplePayHeader.

        Temporary key for generating shared secret from a device.  # noqa: E501

        :param ephemeral_public_key: The ephemeral_public_key of this EncryptedApplePayHeader.  # noqa: E501
        :type: str
        """
        if ephemeral_public_key is None:
            raise ValueError("Invalid value for `ephemeral_public_key`, must not be `None`")  # noqa: E501
        if ephemeral_public_key is not None and not re.search(r'^(?!\s*$).+', ephemeral_public_key):  # noqa: E501
            raise ValueError(r"Invalid value for `ephemeral_public_key`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._ephemeral_public_key = (
            ephemeral_public_key)

    @property
    def public_key_hash(self):
        """Gets the public_key_hash of this EncryptedApplePayHeader.  # noqa: E501

        Hash of the X.509 encoded public key bytes of the merchant’s certificate.  # noqa: E501

        :return: The public_key_hash of this EncryptedApplePayHeader.  # noqa: E501
        :rtype: str
        """
        return self._public_key_hash

    @public_key_hash.setter
    def public_key_hash(
            self,
            public_key_hash):
        """Sets the public_key_hash of this EncryptedApplePayHeader.

        Hash of the X.509 encoded public key bytes of the merchant’s certificate.  # noqa: E501

        :param public_key_hash: The public_key_hash of this EncryptedApplePayHeader.  # noqa: E501
        :type: str
        """
        if public_key_hash is None:
            raise ValueError("Invalid value for `public_key_hash`, must not be `None`")  # noqa: E501
        if public_key_hash is not None and not re.search(r'^(?!\s*$).+', public_key_hash):  # noqa: E501
            raise ValueError(r"Invalid value for `public_key_hash`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._public_key_hash = (
            public_key_hash)

    @property
    def transaction_id(self):
        """Gets the transaction_id of this EncryptedApplePayHeader.  # noqa: E501

        Transaction identifier, generated on the device.  # noqa: E501

        :return: The transaction_id of this EncryptedApplePayHeader.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(
            self,
            transaction_id):
        """Sets the transaction_id of this EncryptedApplePayHeader.

        Transaction identifier, generated on the device.  # noqa: E501

        :param transaction_id: The transaction_id of this EncryptedApplePayHeader.  # noqa: E501
        :type: str
        """
        if transaction_id is None:
            raise ValueError("Invalid value for `transaction_id`, must not be `None`")  # noqa: E501
        if transaction_id is not None and not re.search(r'^(?!\s*$).+', transaction_id):  # noqa: E501
            raise ValueError(r"Invalid value for `transaction_id`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._transaction_id = (
            transaction_id)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EncryptedApplePayHeader):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
