# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.13.0.20200810.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class CarRental(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'agreement_number': 'str',
        'renter_name': 'str',
        'return_city': 'str',
        'return_date': 'date',
        'pickup_date': 'date',
        'rental_class_id': 'str',
        'extra_charges': 'list[CarRentalExtraCharges]',
        'no_show_indicator': 'bool',
    }

    attribute_map = {
        'agreement_number': 'agreementNumber',  # noqa: E501
        'renter_name': 'renterName',  # noqa: E501
        'return_city': 'returnCity',  # noqa: E501
        'return_date': 'returnDate',  # noqa: E501
        'pickup_date': 'pickupDate',  # noqa: E501
        'rental_class_id': 'rentalClassId',  # noqa: E501
        'extra_charges': 'extraCharges',  # noqa: E501
        'no_show_indicator': 'noShowIndicator',  # noqa: E501
    }

    def __init__(self, agreement_number=None, renter_name=None, return_city=None, return_date=None, pickup_date=None, rental_class_id=None, extra_charges=None, no_show_indicator=None):  # noqa: E501
        """CarRental - a model defined in OpenAPI



        Keyword Args:
            agreement_number (str): The car rental agreement number.. [optional]  # noqa: E501
            renter_name (str): The name of the person renting the car.. [optional]  # noqa: E501
            return_city (str): The city where the rental ends and the car is returned.. [optional]  # noqa: E501
            return_date (date): The date the car rental ends and the car is returned.. [optional]  # noqa: E501
            pickup_date (date): The date the car rental begins.. [optional]  # noqa: E501
            rental_class_id (str): The classification of the rental car.. [optional]  # noqa: E501
            extra_charges (list[CarRentalExtraCharges]): Array containing information about charges other than the rental rate.. [optional]  # noqa: E501
            no_show_indicator (bool): Indicates if the transaction is related to a no-show charge.. [optional]  # noqa: E501
        """

        self._agreement_number = None
        self._renter_name = None
        self._return_city = None
        self._return_date = None
        self._pickup_date = None
        self._rental_class_id = None
        self._extra_charges = None
        self._no_show_indicator = None
        self.discriminator = None

        if agreement_number is not None:
            self.agreement_number = agreement_number  # noqa: E501
        if renter_name is not None:
            self.renter_name = renter_name  # noqa: E501
        if return_city is not None:
            self.return_city = return_city  # noqa: E501
        if return_date is not None:
            self.return_date = return_date  # noqa: E501
        if pickup_date is not None:
            self.pickup_date = pickup_date  # noqa: E501
        if rental_class_id is not None:
            self.rental_class_id = rental_class_id  # noqa: E501
        if extra_charges is not None:
            self.extra_charges = extra_charges  # noqa: E501
        if no_show_indicator is not None:
            self.no_show_indicator = no_show_indicator  # noqa: E501

    @property
    def agreement_number(self):
        """Gets the agreement_number of this CarRental.  # noqa: E501

        The car rental agreement number.  # noqa: E501

        :return: The agreement_number of this CarRental.  # noqa: E501
        :rtype: str
        """
        return self._agreement_number

    @agreement_number.setter
    def agreement_number(
            self,
            agreement_number):
        """Sets the agreement_number of this CarRental.

        The car rental agreement number.  # noqa: E501

        :param agreement_number: The agreement_number of this CarRental.  # noqa: E501
        :type: str
        """
        if agreement_number is not None and len(agreement_number) > 20:
            raise ValueError("Invalid value for `agreement_number`, length must be less than or equal to `20`")  # noqa: E501

        self._agreement_number = (
            agreement_number)

    @property
    def renter_name(self):
        """Gets the renter_name of this CarRental.  # noqa: E501

        The name of the person renting the car.  # noqa: E501

        :return: The renter_name of this CarRental.  # noqa: E501
        :rtype: str
        """
        return self._renter_name

    @renter_name.setter
    def renter_name(
            self,
            renter_name):
        """Sets the renter_name of this CarRental.

        The name of the person renting the car.  # noqa: E501

        :param renter_name: The renter_name of this CarRental.  # noqa: E501
        :type: str
        """
        if renter_name is not None and len(renter_name) > 20:
            raise ValueError("Invalid value for `renter_name`, length must be less than or equal to `20`")  # noqa: E501

        self._renter_name = (
            renter_name)

    @property
    def return_city(self):
        """Gets the return_city of this CarRental.  # noqa: E501

        The city where the rental ends and the car is returned.  # noqa: E501

        :return: The return_city of this CarRental.  # noqa: E501
        :rtype: str
        """
        return self._return_city

    @return_city.setter
    def return_city(
            self,
            return_city):
        """Sets the return_city of this CarRental.

        The city where the rental ends and the car is returned.  # noqa: E501

        :param return_city: The return_city of this CarRental.  # noqa: E501
        :type: str
        """
        if return_city is not None and len(return_city) > 20:
            raise ValueError("Invalid value for `return_city`, length must be less than or equal to `20`")  # noqa: E501

        self._return_city = (
            return_city)

    @property
    def return_date(self):
        """Gets the return_date of this CarRental.  # noqa: E501

        The date the car rental ends and the car is returned.  # noqa: E501

        :return: The return_date of this CarRental.  # noqa: E501
        :rtype: date
        """
        return self._return_date

    @return_date.setter
    def return_date(
            self,
            return_date):
        """Sets the return_date of this CarRental.

        The date the car rental ends and the car is returned.  # noqa: E501

        :param return_date: The return_date of this CarRental.  # noqa: E501
        :type: date
        """

        self._return_date = (
            return_date)

    @property
    def pickup_date(self):
        """Gets the pickup_date of this CarRental.  # noqa: E501

        The date the car rental begins.  # noqa: E501

        :return: The pickup_date of this CarRental.  # noqa: E501
        :rtype: date
        """
        return self._pickup_date

    @pickup_date.setter
    def pickup_date(
            self,
            pickup_date):
        """Sets the pickup_date of this CarRental.

        The date the car rental begins.  # noqa: E501

        :param pickup_date: The pickup_date of this CarRental.  # noqa: E501
        :type: date
        """

        self._pickup_date = (
            pickup_date)

    @property
    def rental_class_id(self):
        """Gets the rental_class_id of this CarRental.  # noqa: E501

        The classification of the rental car.  # noqa: E501

        :return: The rental_class_id of this CarRental.  # noqa: E501
        :rtype: str
        """
        return self._rental_class_id

    @rental_class_id.setter
    def rental_class_id(
            self,
            rental_class_id):
        """Sets the rental_class_id of this CarRental.

        The classification of the rental car.  # noqa: E501

        :param rental_class_id: The rental_class_id of this CarRental.  # noqa: E501
        :type: str
        """
        if rental_class_id is not None and len(rental_class_id) > 6:
            raise ValueError("Invalid value for `rental_class_id`, length must be less than or equal to `6`")  # noqa: E501

        self._rental_class_id = (
            rental_class_id)

    @property
    def extra_charges(self):
        """Gets the extra_charges of this CarRental.  # noqa: E501

        Array containing information about charges other than the rental rate.  # noqa: E501

        :return: The extra_charges of this CarRental.  # noqa: E501
        :rtype: list[CarRentalExtraCharges]
        """
        return self._extra_charges

    @extra_charges.setter
    def extra_charges(
            self,
            extra_charges):
        """Sets the extra_charges of this CarRental.

        Array containing information about charges other than the rental rate.  # noqa: E501

        :param extra_charges: The extra_charges of this CarRental.  # noqa: E501
        :type: list[CarRentalExtraCharges]
        """

        self._extra_charges = (
            extra_charges)

    @property
    def no_show_indicator(self):
        """Gets the no_show_indicator of this CarRental.  # noqa: E501

        Indicates if the transaction is related to a no-show charge.  # noqa: E501

        :return: The no_show_indicator of this CarRental.  # noqa: E501
        :rtype: bool
        """
        return self._no_show_indicator

    @no_show_indicator.setter
    def no_show_indicator(
            self,
            no_show_indicator):
        """Sets the no_show_indicator of this CarRental.

        Indicates if the transaction is related to a no-show charge.  # noqa: E501

        :param no_show_indicator: The no_show_indicator of this CarRental.  # noqa: E501
        :type: bool
        """

        self._no_show_indicator = (
            no_show_indicator)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CarRental):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
