# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.13.0.20200810.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class TeleCheckICAPaymentMethod(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ach_type': 'str',
        'routing_number': 'str',
        'account_number': 'str',
        'account_type': 'str',
        'check_number': 'str',
        'check_type': 'str',
        'product_code': 'str',
        'manual_id_info': 'IdInfo',
        'supplement_id_info': 'IdInfo',
        'agent_id': 'str',
        'terminal_id': 'str',
        'registration_id': 'str',
        'registration_date': 'date',
        'release_type': 'str',
        'vip_customer': 'str',
        'session_id': 'str',
        'terminal_state': 'str',
        'terminal_city': 'str',
        'ach_bill_to': 'TeleCheckAchPaymentMethodAchBillTo',
        'customer_ip_address': 'str',
        'imei_code': 'str',
        'recurring_type': 'AchRecurringType'
    }

    attribute_map = {
        'ach_type': 'achType',
        'routing_number': 'routingNumber',
        'account_number': 'accountNumber',
        'account_type': 'accountType',
        'check_number': 'checkNumber',
        'check_type': 'checkType',
        'product_code': 'productCode',
        'manual_id_info': 'manualIdInfo',
        'supplement_id_info': 'supplementIdInfo',
        'agent_id': 'agentId',
        'terminal_id': 'terminalId',
        'registration_id': 'registrationId',
        'registration_date': 'registrationDate',
        'release_type': 'releaseType',
        'vip_customer': 'vipCustomer',
        'session_id': 'sessionId',
        'terminal_state': 'terminalState',
        'terminal_city': 'terminalCity',
        'ach_bill_to': 'achBillTo',
        'customer_ip_address': 'customerIpAddress',
        'imei_code': 'imeiCode',
        'recurring_type': 'recurringType'
    }

    def __init__(self, ach_type=None, routing_number=None, account_number=None, account_type=None, check_number=None, check_type=None, product_code=None, manual_id_info=None, supplement_id_info=None, agent_id=None, terminal_id=None, registration_id=None, registration_date=None, release_type=None, vip_customer=None, session_id=None, terminal_state=None, terminal_city=None, ach_bill_to=None, customer_ip_address=None, imei_code=None, recurring_type=None):  # noqa: E501
        """TeleCheckICAPaymentMethod - a model defined in OpenAPI"""  # noqa: E501

        self._ach_type = None
        self._routing_number = None
        self._account_number = None
        self._account_type = None
        self._check_number = None
        self._check_type = None
        self._product_code = None
        self._manual_id_info = None
        self._supplement_id_info = None
        self._agent_id = None
        self._terminal_id = None
        self._registration_id = None
        self._registration_date = None
        self._release_type = None
        self._vip_customer = None
        self._session_id = None
        self._terminal_state = None
        self._terminal_city = None
        self._ach_bill_to = None
        self._customer_ip_address = None
        self._imei_code = None
        self._recurring_type = None
        self.discriminator = None

        self.ach_type = ach_type
        self.routing_number = routing_number
        self.account_number = account_number
        self.account_type = account_type
        if check_number is not None:
            self.check_number = check_number
        self.check_type = check_type
        if product_code is not None:
            self.product_code = product_code
        if manual_id_info is not None:
            self.manual_id_info = manual_id_info
        if supplement_id_info is not None:
            self.supplement_id_info = supplement_id_info
        if agent_id is not None:
            self.agent_id = agent_id
        if terminal_id is not None:
            self.terminal_id = terminal_id
        if registration_id is not None:
            self.registration_id = registration_id
        if registration_date is not None:
            self.registration_date = registration_date
        if release_type is not None:
            self.release_type = release_type
        if vip_customer is not None:
            self.vip_customer = vip_customer
        self.session_id = session_id
        if terminal_state is not None:
            self.terminal_state = terminal_state
        if terminal_city is not None:
            self.terminal_city = terminal_city
        self.ach_bill_to = ach_bill_to
        self.customer_ip_address = customer_ip_address
        if imei_code is not None:
            self.imei_code = imei_code
        if recurring_type is not None:
            self.recurring_type = recurring_type

    @property
    def ach_type(self):
        """Gets the ach_type of this TeleCheckICAPaymentMethod.  # noqa: E501

        ACH application type values will be one of either TeleCheckICAPaymentMethod or TeleCheckCBPPaymentMethod.  # noqa: E501

        :return: The ach_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._ach_type

    @ach_type.setter
    def ach_type(self, ach_type):
        """Sets the ach_type of this TeleCheckICAPaymentMethod.

        ACH application type values will be one of either TeleCheckICAPaymentMethod or TeleCheckCBPPaymentMethod.  # noqa: E501

        :param ach_type: The ach_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if ach_type is None:
            raise ValueError("Invalid value for `ach_type`, must not be `None`")  # noqa: E501

        self._ach_type = ach_type

    @property
    def routing_number(self):
        """Gets the routing_number of this TeleCheckICAPaymentMethod.  # noqa: E501

        Bank routing number.  # noqa: E501

        :return: The routing_number of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._routing_number

    @routing_number.setter
    def routing_number(self, routing_number):
        """Sets the routing_number of this TeleCheckICAPaymentMethod.

        Bank routing number.  # noqa: E501

        :param routing_number: The routing_number of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if routing_number is None:
            raise ValueError("Invalid value for `routing_number`, must not be `None`")  # noqa: E501
        if routing_number is not None and len(routing_number) > 9:
            raise ValueError("Invalid value for `routing_number`, length must be less than or equal to `9`")  # noqa: E501
        if routing_number is not None and len(routing_number) < 9:
            raise ValueError("Invalid value for `routing_number`, length must be greater than or equal to `9`")  # noqa: E501
        if routing_number is not None and not re.search(r'^[0-9]+$', routing_number):  # noqa: E501
            raise ValueError(r"Invalid value for `routing_number`, must be a follow pattern or equal to `/^[0-9]+$/`")  # noqa: E501

        self._routing_number = routing_number

    @property
    def account_number(self):
        """Gets the account_number of this TeleCheckICAPaymentMethod.  # noqa: E501

        Bank account number.  # noqa: E501

        :return: The account_number of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this TeleCheckICAPaymentMethod.

        Bank account number.  # noqa: E501

        :param account_number: The account_number of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if account_number is None:
            raise ValueError("Invalid value for `account_number`, must not be `None`")  # noqa: E501
        if account_number is not None and len(account_number) > 56:
            raise ValueError("Invalid value for `account_number`, length must be less than or equal to `56`")  # noqa: E501
        if account_number is not None and len(account_number) < 1:
            raise ValueError("Invalid value for `account_number`, length must be greater than or equal to `1`")  # noqa: E501
        if account_number is not None and not re.search(r'^[0-9]+$', account_number):  # noqa: E501
            raise ValueError(r"Invalid value for `account_number`, must be a follow pattern or equal to `/^[0-9]+$/`")  # noqa: E501

        self._account_number = account_number

    @property
    def account_type(self):
        """Gets the account_type of this TeleCheckICAPaymentMethod.  # noqa: E501

        Identifies if the account type is checking or savings.  # noqa: E501

        :return: The account_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._account_type

    @account_type.setter
    def account_type(self, account_type):
        """Sets the account_type of this TeleCheckICAPaymentMethod.

        Identifies if the account type is checking or savings.  # noqa: E501

        :param account_type: The account_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if account_type is None:
            raise ValueError("Invalid value for `account_type`, must not be `None`")  # noqa: E501
        allowed_values = ["C", "S"]  # noqa: E501
        if account_type not in allowed_values:
            raise ValueError(
                "Invalid value for `account_type` ({0}), must be one of {1}"  # noqa: E501
                .format(account_type, allowed_values)
            )

        self._account_type = account_type

    @property
    def check_number(self):
        """Gets the check_number of this TeleCheckICAPaymentMethod.  # noqa: E501

        Check number.  # noqa: E501

        :return: The check_number of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._check_number

    @check_number.setter
    def check_number(self, check_number):
        """Sets the check_number of this TeleCheckICAPaymentMethod.

        Check number.  # noqa: E501

        :param check_number: The check_number of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if check_number is not None and len(check_number) > 10:
            raise ValueError("Invalid value for `check_number`, length must be less than or equal to `10`")  # noqa: E501
        if check_number is not None and not re.search(r'^[0-9]+$', check_number):  # noqa: E501
            raise ValueError(r"Invalid value for `check_number`, must be a follow pattern or equal to `/^[0-9]+$/`")  # noqa: E501

        self._check_number = check_number

    @property
    def check_type(self):
        """Gets the check_type of this TeleCheckICAPaymentMethod.  # noqa: E501

        Identifies if the check type is personal or company.  # noqa: E501

        :return: The check_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._check_type

    @check_type.setter
    def check_type(self, check_type):
        """Sets the check_type of this TeleCheckICAPaymentMethod.

        Identifies if the check type is personal or company.  # noqa: E501

        :param check_type: The check_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if check_type is None:
            raise ValueError("Invalid value for `check_type`, must not be `None`")  # noqa: E501
        allowed_values = ["P", "C"]  # noqa: E501
        if check_type not in allowed_values:
            raise ValueError(
                "Invalid value for `check_type` ({0}), must be one of {1}"  # noqa: E501
                .format(check_type, allowed_values)
            )

        self._check_type = check_type

    @property
    def product_code(self):
        """Gets the product_code of this TeleCheckICAPaymentMethod.  # noqa: E501

        Identifies the product code in the transaction.  # noqa: E501

        :return: The product_code of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """Sets the product_code of this TeleCheckICAPaymentMethod.

        Identifies the product code in the transaction.  # noqa: E501

        :param product_code: The product_code of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if product_code is not None and len(product_code) > 6:
            raise ValueError("Invalid value for `product_code`, length must be less than or equal to `6`")  # noqa: E501
        if product_code is not None and not re.search(r'^[0-9]+$', product_code):  # noqa: E501
            raise ValueError(r"Invalid value for `product_code`, must be a follow pattern or equal to `/^[0-9]+$/`")  # noqa: E501

        self._product_code = product_code

    @property
    def manual_id_info(self):
        """Gets the manual_id_info of this TeleCheckICAPaymentMethod.  # noqa: E501


        :return: The manual_id_info of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: IdInfo
        """
        return self._manual_id_info

    @manual_id_info.setter
    def manual_id_info(self, manual_id_info):
        """Sets the manual_id_info of this TeleCheckICAPaymentMethod.


        :param manual_id_info: The manual_id_info of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: IdInfo
        """

        self._manual_id_info = manual_id_info

    @property
    def supplement_id_info(self):
        """Gets the supplement_id_info of this TeleCheckICAPaymentMethod.  # noqa: E501


        :return: The supplement_id_info of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: IdInfo
        """
        return self._supplement_id_info

    @supplement_id_info.setter
    def supplement_id_info(self, supplement_id_info):
        """Sets the supplement_id_info of this TeleCheckICAPaymentMethod.


        :param supplement_id_info: The supplement_id_info of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: IdInfo
        """

        self._supplement_id_info = supplement_id_info

    @property
    def agent_id(self):
        """Gets the agent_id of this TeleCheckICAPaymentMethod.  # noqa: E501

        Used to track the agent transaction activity.  # noqa: E501

        :return: The agent_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """Sets the agent_id of this TeleCheckICAPaymentMethod.

        Used to track the agent transaction activity.  # noqa: E501

        :param agent_id: The agent_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if agent_id is not None and len(agent_id) > 6:
            raise ValueError("Invalid value for `agent_id`, length must be less than or equal to `6`")  # noqa: E501
        if agent_id is not None and not re.search(r'(?=.*[^\s])^[^|]+$', agent_id):  # noqa: E501
            raise ValueError(r"Invalid value for `agent_id`, must be a follow pattern or equal to `/(?=.*[^\s])^[^|]+$/`")  # noqa: E501

        self._agent_id = agent_id

    @property
    def terminal_id(self):
        """Gets the terminal_id of this TeleCheckICAPaymentMethod.  # noqa: E501

        Identifies the register or lane number where the original sale transaction occurred.  # noqa: E501

        :return: The terminal_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._terminal_id

    @terminal_id.setter
    def terminal_id(self, terminal_id):
        """Sets the terminal_id of this TeleCheckICAPaymentMethod.

        Identifies the register or lane number where the original sale transaction occurred.  # noqa: E501

        :param terminal_id: The terminal_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if terminal_id is not None and len(terminal_id) > 10:
            raise ValueError("Invalid value for `terminal_id`, length must be less than or equal to `10`")  # noqa: E501
        if terminal_id is not None and not re.search(r'^[0-9]+$', terminal_id):  # noqa: E501
            raise ValueError(r"Invalid value for `terminal_id`, must be a follow pattern or equal to `/^[0-9]+$/`")  # noqa: E501

        self._terminal_id = terminal_id

    @property
    def registration_id(self):
        """Gets the registration_id of this TeleCheckICAPaymentMethod.  # noqa: E501

        Unique ID assigned by the merchant for the consumer (never recycled). It is an additional level of authentication. To use this feature, the merchant must work with TeleCheck Risk to discuss. Registration IDs must not be generated for an existing or returning consumer returns. The single registration ID must be unique per consumer.  # noqa: E501

        :return: The registration_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._registration_id

    @registration_id.setter
    def registration_id(self, registration_id):
        """Sets the registration_id of this TeleCheckICAPaymentMethod.

        Unique ID assigned by the merchant for the consumer (never recycled). It is an additional level of authentication. To use this feature, the merchant must work with TeleCheck Risk to discuss. Registration IDs must not be generated for an existing or returning consumer returns. The single registration ID must be unique per consumer.  # noqa: E501

        :param registration_id: The registration_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if registration_id is not None and len(registration_id) > 50:
            raise ValueError("Invalid value for `registration_id`, length must be less than or equal to `50`")  # noqa: E501
        if registration_id is not None and not re.search(r'(?=.*[^\s])^[^|]+$', registration_id):  # noqa: E501
            raise ValueError(r"Invalid value for `registration_id`, must be a follow pattern or equal to `/(?=.*[^\s])^[^|]+$/`")  # noqa: E501

        self._registration_id = registration_id

    @property
    def registration_date(self):
        """Gets the registration_date of this TeleCheckICAPaymentMethod.  # noqa: E501

        Date the consumer originally registered in format MMDDYYYY.  # noqa: E501

        :return: The registration_date of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: date
        """
        return self._registration_date

    @registration_date.setter
    def registration_date(self, registration_date):
        """Sets the registration_date of this TeleCheckICAPaymentMethod.

        Date the consumer originally registered in format MMDDYYYY.  # noqa: E501

        :param registration_date: The registration_date of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: date
        """

        self._registration_date = registration_date

    @property
    def release_type(self):
        """Gets the release_type of this TeleCheckICAPaymentMethod.  # noqa: E501

        Release type is used as a risk variable to gauge risk level when the merchant is releasing the purchased merchandise.  # noqa: E501

        :return: The release_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._release_type

    @release_type.setter
    def release_type(self, release_type):
        """Sets the release_type of this TeleCheckICAPaymentMethod.

        Release type is used as a risk variable to gauge risk level when the merchant is releasing the purchased merchandise.  # noqa: E501

        :param release_type: The release_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        allowed_values = ["C", "D", "P", "T"]  # noqa: E501
        if release_type not in allowed_values:
            raise ValueError(
                "Invalid value for `release_type` ({0}), must be one of {1}"  # noqa: E501
                .format(release_type, allowed_values)
            )

        self._release_type = release_type

    @property
    def vip_customer(self):
        """Gets the vip_customer of this TeleCheckICAPaymentMethod.  # noqa: E501

        Flags a transaction as a VIP order (based on merchant criteria). This field should not be sent for non-VIP orders.  # noqa: E501

        :return: The vip_customer of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._vip_customer

    @vip_customer.setter
    def vip_customer(self, vip_customer):
        """Sets the vip_customer of this TeleCheckICAPaymentMethod.

        Flags a transaction as a VIP order (based on merchant criteria). This field should not be sent for non-VIP orders.  # noqa: E501

        :param vip_customer: The vip_customer of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        allowed_values = ["Y", "N"]  # noqa: E501
        if vip_customer not in allowed_values:
            raise ValueError(
                "Invalid value for `vip_customer` ({0}), must be one of {1}"  # noqa: E501
                .format(vip_customer, allowed_values)
            )

        self._vip_customer = vip_customer

    @property
    def session_id(self):
        """Gets the session_id of this TeleCheckICAPaymentMethod.  # noqa: E501

        Session identifier.  # noqa: E501

        :return: The session_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """Sets the session_id of this TeleCheckICAPaymentMethod.

        Session identifier.  # noqa: E501

        :param session_id: The session_id of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if session_id is None:
            raise ValueError("Invalid value for `session_id`, must not be `None`")  # noqa: E501
        if session_id is not None and len(session_id) > 128:
            raise ValueError("Invalid value for `session_id`, length must be less than or equal to `128`")  # noqa: E501
        if session_id is not None and not re.search(r'(?=.*[^\s])^[^|]+$', session_id):  # noqa: E501
            raise ValueError(r"Invalid value for `session_id`, must be a follow pattern or equal to `/(?=.*[^\s])^[^|]+$/`")  # noqa: E501

        self._session_id = session_id

    @property
    def terminal_state(self):
        """Gets the terminal_state of this TeleCheckICAPaymentMethod.  # noqa: E501

        Identifies the US state or territory where the original sale transaction occurred.  # noqa: E501

        :return: The terminal_state of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._terminal_state

    @terminal_state.setter
    def terminal_state(self, terminal_state):
        """Sets the terminal_state of this TeleCheckICAPaymentMethod.

        Identifies the US state or territory where the original sale transaction occurred.  # noqa: E501

        :param terminal_state: The terminal_state of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if terminal_state is not None and len(terminal_state) > 2:
            raise ValueError("Invalid value for `terminal_state`, length must be less than or equal to `2`")  # noqa: E501
        if terminal_state is not None and not re.search(r'^[A-Z]{2}$', terminal_state):  # noqa: E501
            raise ValueError(r"Invalid value for `terminal_state`, must be a follow pattern or equal to `/^[A-Z]{2}$/`")  # noqa: E501

        self._terminal_state = terminal_state

    @property
    def terminal_city(self):
        """Gets the terminal_city of this TeleCheckICAPaymentMethod.  # noqa: E501

        Identifies the city where the original sale transaction occurred.  # noqa: E501

        :return: The terminal_city of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._terminal_city

    @terminal_city.setter
    def terminal_city(self, terminal_city):
        """Sets the terminal_city of this TeleCheckICAPaymentMethod.

        Identifies the city where the original sale transaction occurred.  # noqa: E501

        :param terminal_city: The terminal_city of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if terminal_city is not None and len(terminal_city) > 16:
            raise ValueError("Invalid value for `terminal_city`, length must be less than or equal to `16`")  # noqa: E501
        if terminal_city is not None and not re.search(r'(?=.*[^\s])^[^|]+$', terminal_city):  # noqa: E501
            raise ValueError(r"Invalid value for `terminal_city`, must be a follow pattern or equal to `/(?=.*[^\s])^[^|]+$/`")  # noqa: E501

        self._terminal_city = terminal_city

    @property
    def ach_bill_to(self):
        """Gets the ach_bill_to of this TeleCheckICAPaymentMethod.  # noqa: E501


        :return: The ach_bill_to of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: TeleCheckAchPaymentMethodAchBillTo
        """
        return self._ach_bill_to

    @ach_bill_to.setter
    def ach_bill_to(self, ach_bill_to):
        """Sets the ach_bill_to of this TeleCheckICAPaymentMethod.


        :param ach_bill_to: The ach_bill_to of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: TeleCheckAchPaymentMethodAchBillTo
        """
        if ach_bill_to is None:
            raise ValueError("Invalid value for `ach_bill_to`, must not be `None`")  # noqa: E501

        self._ach_bill_to = ach_bill_to

    @property
    def customer_ip_address(self):
        """Gets the customer_ip_address of this TeleCheckICAPaymentMethod.  # noqa: E501

        Customer IP address from the terminal where the order was placed (as captured by merchant).  # noqa: E501

        :return: The customer_ip_address of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._customer_ip_address

    @customer_ip_address.setter
    def customer_ip_address(self, customer_ip_address):
        """Sets the customer_ip_address of this TeleCheckICAPaymentMethod.

        Customer IP address from the terminal where the order was placed (as captured by merchant).  # noqa: E501

        :param customer_ip_address: The customer_ip_address of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if customer_ip_address is None:
            raise ValueError("Invalid value for `customer_ip_address`, must not be `None`")  # noqa: E501
        if customer_ip_address is not None and len(customer_ip_address) > 15:
            raise ValueError("Invalid value for `customer_ip_address`, length must be less than or equal to `15`")  # noqa: E501
        if customer_ip_address is not None and not re.search(r'^[0-9\.]+$', customer_ip_address):  # noqa: E501
            raise ValueError(r"Invalid value for `customer_ip_address`, must be a follow pattern or equal to `/^[0-9\.]+$/`")  # noqa: E501

        self._customer_ip_address = customer_ip_address

    @property
    def imei_code(self):
        """Gets the imei_code of this TeleCheckICAPaymentMethod.  # noqa: E501

        International mobile equipment identity code.  # noqa: E501

        :return: The imei_code of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._imei_code

    @imei_code.setter
    def imei_code(self, imei_code):
        """Sets the imei_code of this TeleCheckICAPaymentMethod.

        International mobile equipment identity code.  # noqa: E501

        :param imei_code: The imei_code of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: str
        """
        if imei_code is not None and len(imei_code) > 25:
            raise ValueError("Invalid value for `imei_code`, length must be less than or equal to `25`")  # noqa: E501
        if imei_code is not None and not re.search(r'(?=.*[^\s])^[^|]+$', imei_code):  # noqa: E501
            raise ValueError(r"Invalid value for `imei_code`, must be a follow pattern or equal to `/(?=.*[^\s])^[^|]+$/`")  # noqa: E501

        self._imei_code = imei_code

    @property
    def recurring_type(self):
        """Gets the recurring_type of this TeleCheckICAPaymentMethod.  # noqa: E501


        :return: The recurring_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :rtype: AchRecurringType
        """
        return self._recurring_type

    @recurring_type.setter
    def recurring_type(self, recurring_type):
        """Sets the recurring_type of this TeleCheckICAPaymentMethod.


        :param recurring_type: The recurring_type of this TeleCheckICAPaymentMethod.  # noqa: E501
        :type: AchRecurringType
        """

        self._recurring_type = recurring_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TeleCheckICAPaymentMethod):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
