# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.13.0.20200810.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class InitiateClearingResponseAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'request_status': 'str',
        'clearing_details': 'ClearingDetails',
        'endpoint_responses': 'list[EndpointResponse]'
    }

    attribute_map = {
        'request_status': 'requestStatus',
        'clearing_details': 'clearingDetails',
        'endpoint_responses': 'endpointResponses'
    }

    def __init__(self, request_status=None, clearing_details=None, endpoint_responses=None):  # noqa: E501
        """InitiateClearingResponseAllOf - a model defined in OpenAPI"""  # noqa: E501

        self._request_status = None
        self._clearing_details = None
        self._endpoint_responses = None
        self.discriminator = None

        if request_status is not None:
            self.request_status = request_status
        if clearing_details is not None:
            self.clearing_details = clearing_details
        if endpoint_responses is not None:
            self.endpoint_responses = endpoint_responses

    @property
    def request_status(self):
        """Gets the request_status of this InitiateClearingResponseAllOf.  # noqa: E501

        Request status. If it is anything other than 'SUCCESS', please refer to 400s HTTP error codes or decline. See Error object for details.  # noqa: E501

        :return: The request_status of this InitiateClearingResponseAllOf.  # noqa: E501
        :rtype: str
        """
        return self._request_status

    @request_status.setter
    def request_status(self, request_status):
        """Sets the request_status of this InitiateClearingResponseAllOf.

        Request status. If it is anything other than 'SUCCESS', please refer to 400s HTTP error codes or decline. See Error object for details.  # noqa: E501

        :param request_status: The request_status of this InitiateClearingResponseAllOf.  # noqa: E501
        :type: str
        """
        allowed_values = ["SUCCESS", "PROCESSING_FAILED", "FAILURE"]  # noqa: E501
        if request_status not in allowed_values:
            raise ValueError(
                "Invalid value for `request_status` ({0}), must be one of {1}"  # noqa: E501
                .format(request_status, allowed_values)
            )

        self._request_status = request_status

    @property
    def clearing_details(self):
        """Gets the clearing_details of this InitiateClearingResponseAllOf.  # noqa: E501


        :return: The clearing_details of this InitiateClearingResponseAllOf.  # noqa: E501
        :rtype: ClearingDetails
        """
        return self._clearing_details

    @clearing_details.setter
    def clearing_details(self, clearing_details):
        """Sets the clearing_details of this InitiateClearingResponseAllOf.


        :param clearing_details: The clearing_details of this InitiateClearingResponseAllOf.  # noqa: E501
        :type: ClearingDetails
        """

        self._clearing_details = clearing_details

    @property
    def endpoint_responses(self):
        """Gets the endpoint_responses of this InitiateClearingResponseAllOf.  # noqa: E501

        The array holds response information of the involved endpoints.  # noqa: E501

        :return: The endpoint_responses of this InitiateClearingResponseAllOf.  # noqa: E501
        :rtype: list[EndpointResponse]
        """
        return self._endpoint_responses

    @endpoint_responses.setter
    def endpoint_responses(self, endpoint_responses):
        """Sets the endpoint_responses of this InitiateClearingResponseAllOf.

        The array holds response information of the involved endpoints.  # noqa: E501

        :param endpoint_responses: The endpoint_responses of this InitiateClearingResponseAllOf.  # noqa: E501
        :type: list[EndpointResponse]
        """

        self._endpoint_responses = endpoint_responses

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InitiateClearingResponseAllOf):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
