# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.13.0.20200810.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ExchangeRateDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'inquiry_rate_id': 'str',
        'foreign_currency': 'str',
        'foreign_amount': 'str',
        'exchange_rate': 'str',
        'dcc_offered': 'bool',
        'exchange_rate_source_timestamp': 'str',
        'expiration_timestamp': 'str',
        'margin_rate_percentage': 'str',
        'exchange_rate_source_name': 'str'
    }

    attribute_map = {
        'inquiry_rate_id': 'inquiryRateId',
        'foreign_currency': 'foreignCurrency',
        'foreign_amount': 'foreignAmount',
        'exchange_rate': 'exchangeRate',
        'dcc_offered': 'dccOffered',
        'exchange_rate_source_timestamp': 'exchangeRateSourceTimestamp',
        'expiration_timestamp': 'expirationTimestamp',
        'margin_rate_percentage': 'marginRatePercentage',
        'exchange_rate_source_name': 'exchangeRateSourceName'
    }

    def __init__(self, inquiry_rate_id=None, foreign_currency=None, foreign_amount=None, exchange_rate=None, dcc_offered=None, exchange_rate_source_timestamp=None, expiration_timestamp=None, margin_rate_percentage=None, exchange_rate_source_name=None):  # noqa: E501
        """ExchangeRateDetails - a model defined in OpenAPI"""  # noqa: E501

        self._inquiry_rate_id = None
        self._foreign_currency = None
        self._foreign_amount = None
        self._exchange_rate = None
        self._dcc_offered = None
        self._exchange_rate_source_timestamp = None
        self._expiration_timestamp = None
        self._margin_rate_percentage = None
        self._exchange_rate_source_name = None
        self.discriminator = None

        if inquiry_rate_id is not None:
            self.inquiry_rate_id = inquiry_rate_id
        if foreign_currency is not None:
            self.foreign_currency = foreign_currency
        if foreign_amount is not None:
            self.foreign_amount = foreign_amount
        if exchange_rate is not None:
            self.exchange_rate = exchange_rate
        if dcc_offered is not None:
            self.dcc_offered = dcc_offered
        if exchange_rate_source_timestamp is not None:
            self.exchange_rate_source_timestamp = exchange_rate_source_timestamp
        if expiration_timestamp is not None:
            self.expiration_timestamp = expiration_timestamp
        if margin_rate_percentage is not None:
            self.margin_rate_percentage = margin_rate_percentage
        if exchange_rate_source_name is not None:
            self.exchange_rate_source_name = exchange_rate_source_name

    @property
    def inquiry_rate_id(self):
        """Gets the inquiry_rate_id of this ExchangeRateDetails.  # noqa: E501

        Inquiry rate ID.  # noqa: E501

        :return: The inquiry_rate_id of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._inquiry_rate_id

    @inquiry_rate_id.setter
    def inquiry_rate_id(self, inquiry_rate_id):
        """Sets the inquiry_rate_id of this ExchangeRateDetails.

        Inquiry rate ID.  # noqa: E501

        :param inquiry_rate_id: The inquiry_rate_id of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._inquiry_rate_id = inquiry_rate_id

    @property
    def foreign_currency(self):
        """Gets the foreign_currency of this ExchangeRateDetails.  # noqa: E501

        Foreign currency in alphabetic ISO 4217 currency code format.  # noqa: E501

        :return: The foreign_currency of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._foreign_currency

    @foreign_currency.setter
    def foreign_currency(self, foreign_currency):
        """Sets the foreign_currency of this ExchangeRateDetails.

        Foreign currency in alphabetic ISO 4217 currency code format.  # noqa: E501

        :param foreign_currency: The foreign_currency of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._foreign_currency = foreign_currency

    @property
    def foreign_amount(self):
        """Gets the foreign_amount of this ExchangeRateDetails.  # noqa: E501

        Foreign amount.  # noqa: E501

        :return: The foreign_amount of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._foreign_amount

    @foreign_amount.setter
    def foreign_amount(self, foreign_amount):
        """Sets the foreign_amount of this ExchangeRateDetails.

        Foreign amount.  # noqa: E501

        :param foreign_amount: The foreign_amount of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._foreign_amount = foreign_amount

    @property
    def exchange_rate(self):
        """Gets the exchange_rate of this ExchangeRateDetails.  # noqa: E501

        Exchange rate.  # noqa: E501

        :return: The exchange_rate of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._exchange_rate

    @exchange_rate.setter
    def exchange_rate(self, exchange_rate):
        """Sets the exchange_rate of this ExchangeRateDetails.

        Exchange rate.  # noqa: E501

        :param exchange_rate: The exchange_rate of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._exchange_rate = exchange_rate

    @property
    def dcc_offered(self):
        """Gets the dcc_offered of this ExchangeRateDetails.  # noqa: E501

        Dcc offered.  # noqa: E501

        :return: The dcc_offered of this ExchangeRateDetails.  # noqa: E501
        :rtype: bool
        """
        return self._dcc_offered

    @dcc_offered.setter
    def dcc_offered(self, dcc_offered):
        """Sets the dcc_offered of this ExchangeRateDetails.

        Dcc offered.  # noqa: E501

        :param dcc_offered: The dcc_offered of this ExchangeRateDetails.  # noqa: E501
        :type: bool
        """

        self._dcc_offered = dcc_offered

    @property
    def exchange_rate_source_timestamp(self):
        """Gets the exchange_rate_source_timestamp of this ExchangeRateDetails.  # noqa: E501

        Exchange rate source timestamp. The used format is \"yyyy-MM-dd'T'HH:mm:ss.SSSXXX\"  # noqa: E501

        :return: The exchange_rate_source_timestamp of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._exchange_rate_source_timestamp

    @exchange_rate_source_timestamp.setter
    def exchange_rate_source_timestamp(self, exchange_rate_source_timestamp):
        """Sets the exchange_rate_source_timestamp of this ExchangeRateDetails.

        Exchange rate source timestamp. The used format is \"yyyy-MM-dd'T'HH:mm:ss.SSSXXX\"  # noqa: E501

        :param exchange_rate_source_timestamp: The exchange_rate_source_timestamp of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._exchange_rate_source_timestamp = exchange_rate_source_timestamp

    @property
    def expiration_timestamp(self):
        """Gets the expiration_timestamp of this ExchangeRateDetails.  # noqa: E501

        Expiration timestamp. The used format is \"yyyy-MM-dd'T'HH:mm:ss.SSSXXX\"  # noqa: E501

        :return: The expiration_timestamp of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._expiration_timestamp

    @expiration_timestamp.setter
    def expiration_timestamp(self, expiration_timestamp):
        """Sets the expiration_timestamp of this ExchangeRateDetails.

        Expiration timestamp. The used format is \"yyyy-MM-dd'T'HH:mm:ss.SSSXXX\"  # noqa: E501

        :param expiration_timestamp: The expiration_timestamp of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._expiration_timestamp = expiration_timestamp

    @property
    def margin_rate_percentage(self):
        """Gets the margin_rate_percentage of this ExchangeRateDetails.  # noqa: E501

        Margin rate percentage.  # noqa: E501

        :return: The margin_rate_percentage of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._margin_rate_percentage

    @margin_rate_percentage.setter
    def margin_rate_percentage(self, margin_rate_percentage):
        """Sets the margin_rate_percentage of this ExchangeRateDetails.

        Margin rate percentage.  # noqa: E501

        :param margin_rate_percentage: The margin_rate_percentage of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._margin_rate_percentage = margin_rate_percentage

    @property
    def exchange_rate_source_name(self):
        """Gets the exchange_rate_source_name of this ExchangeRateDetails.  # noqa: E501

        Exchange rate source name.  # noqa: E501

        :return: The exchange_rate_source_name of this ExchangeRateDetails.  # noqa: E501
        :rtype: str
        """
        return self._exchange_rate_source_name

    @exchange_rate_source_name.setter
    def exchange_rate_source_name(self, exchange_rate_source_name):
        """Sets the exchange_rate_source_name of this ExchangeRateDetails.

        Exchange rate source name.  # noqa: E501

        :param exchange_rate_source_name: The exchange_rate_source_name of this ExchangeRateDetails.  # noqa: E501
        :type: str
        """

        self._exchange_rate_source_name = exchange_rate_source_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExchangeRateDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
