# Generated by Django 4.0.10 on 2023-04-24 15:18

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("authentication", "0020_userprofile_language_userprofile_night_mode"),
        ("eveuniverse", "0007_evetype_description"),
        ("eveonline", "0017_alliance_and_corp_names_are_not_unique"),
        ("moonmining", "0006_add_labels"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="eveoretype",
            options={"verbose_name": "ore type", "verbose_name_plural": "ore types"},
        ),
        migrations.AlterModelOptions(
            name="eveoretypeextras",
            options={
                "verbose_name": "ore type extra",
                "verbose_name_plural": "ore type extras",
            },
        ),
        migrations.AlterModelOptions(
            name="extraction",
            options={
                "verbose_name": "extraction",
                "verbose_name_plural": "extractions",
            },
        ),
        migrations.AlterModelOptions(
            name="extractionproduct",
            options={
                "verbose_name": "extraction product",
                "verbose_name_plural": "extractions products",
            },
        ),
        migrations.AlterModelOptions(
            name="label",
            options={"verbose_name": "label", "verbose_name_plural": "labels"},
        ),
        migrations.AlterModelOptions(
            name="miningledgerrecord",
            options={
                "verbose_name": "ledger record",
                "verbose_name_plural": "ledger records",
            },
        ),
        migrations.AlterModelOptions(
            name="moon",
            options={"verbose_name": "moon", "verbose_name_plural": "moons"},
        ),
        migrations.AlterModelOptions(
            name="moonproduct",
            options={
                "verbose_name": "moon product",
                "verbose_name_plural": "moons products",
            },
        ),
        migrations.AlterModelOptions(
            name="notification",
            options={
                "verbose_name": "notification",
                "verbose_name_plural": "notifications",
            },
        ),
        migrations.AlterModelOptions(
            name="owner",
            options={"verbose_name": "owner", "verbose_name_plural": "owners"},
        ),
        migrations.AlterModelOptions(
            name="refinery",
            options={"verbose_name": "refinery", "verbose_name_plural": "refineries"},
        ),
        migrations.AlterField(
            model_name="eveoretypeextras",
            name="current_price",
            field=models.FloatField(
                default=None,
                help_text="Price used by all price calculations with this type",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="eveoretypeextras",
            name="pricing_method",
            field=models.CharField(
                choices=[
                    ("UN", "Undefined"),
                    ("EC", "Eve client"),
                    ("RP", "Reprocessed materials"),
                ],
                default="UN",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="extraction",
            name="auto_fracture_at",
            field=models.DateTimeField(
                help_text="When this extraction will be automatically fractured"
            ),
        ),
        migrations.AlterField(
            model_name="extraction",
            name="canceled_at",
            field=models.DateTimeField(
                default=None, help_text="When this extraction was canceled", null=True
            ),
        ),
        migrations.AlterField(
            model_name="extraction",
            name="chunk_arrival_at",
            field=models.DateTimeField(
                db_index=True, help_text="When this extraction is ready to be fractured"
            ),
        ),
        migrations.AlterField(
            model_name="extraction",
            name="fractured_at",
            field=models.DateTimeField(
                default=None, help_text="When this extraction was fractured", null=True
            ),
        ),
        migrations.AlterField(
            model_name="extraction",
            name="started_at",
            field=models.DateTimeField(
                db_index=True, help_text="When this extraction was started"
            ),
        ),
        migrations.AlterField(
            model_name="moon",
            name="eve_moon",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                primary_key=True,
                related_name="+",
                serialize=False,
                to="eveuniverse.evemoon",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="character_ownership",
            field=models.ForeignKey(
                default=None,
                help_text="Character used to sync this corporation from ESI",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="authentication.characterownership",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="corporation",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                primary_key=True,
                related_name="+",
                serialize=False,
                to="eveonline.evecorporationinfo",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="is_enabled",
            field=models.BooleanField(
                db_index=True,
                default=True,
                help_text="Disabled corporations are excluded from the update process",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="last_update_at",
            field=models.DateTimeField(
                default=None, help_text="Time of last successful update", null=True
            ),
        ),
    ]
