"use strict";
const lib_1 = require("../lib");
module.exports = {
    'row has the height of the tallest element'(test) {
        // WHEN
        const row = new lib_1.Row(new lib_1.Spacer({ width: 10, height: 1 }), new lib_1.Spacer({ width: 10, height: 4 }));
        // THEN
        test.equal(4, row.height);
        test.equal(20, row.width);
        test.done();
    },
    'spacer has default height and width'(test) {
        // WHEN
        const spacer = new lib_1.Spacer();
        // THEN
        test.equal(1, spacer.height);
        test.equal(1, spacer.width);
        test.done();
    },
    'column has the width of the tallest element'(test) {
        // WHEN
        const col = new lib_1.Column(new lib_1.Spacer({ width: 1, height: 1 }), new lib_1.Spacer({ width: 4, height: 4 }));
        // THEN
        test.equal(4, col.width);
        test.equal(5, col.height);
        test.done();
    },
    'row wraps to width of 24, taking tallest widget into account while wrapping'(test) {
        // Try the tall box in all positions
        for (const heights of [[4, 1, 1], [1, 4, 1], [1, 1, 4]]) {
            // GIVEN
            const widgets = [
                new lib_1.TextWidget({ width: 7, height: heights[0], markdown: 'a' }),
                new lib_1.TextWidget({ width: 7, height: heights[1], markdown: 'b' }),
                new lib_1.TextWidget({ width: 7, height: heights[2], markdown: 'c' }),
                new lib_1.TextWidget({ width: 7, height: 1, markdown: 'd' }),
            ];
            // WHEN
            const row = new lib_1.Row(...widgets);
            row.position(1000, 1000); // Check that we correctly offset all inner widgets
            // THEN
            test.equal(21, row.width);
            test.equal(5, row.height);
            function assertWidgetPos(x, y, w) {
                const json = w.toJson()[0];
                test.equal(x, json.x);
                test.equal(y, json.y);
            }
            assertWidgetPos(1000, 1000, widgets[0]);
            assertWidgetPos(1007, 1000, widgets[1]);
            assertWidgetPos(1014, 1000, widgets[2]);
            assertWidgetPos(1000, 1004, widgets[3]);
        }
        test.done();
    },
    'row can fit exactly 3 8-wide widgets without wrapping'(test) {
        // Try the tall box in all positions
        for (const heights of [[4, 1, 1], [1, 4, 1], [1, 1, 4]]) {
            // WHEN
            const row = new lib_1.Row(new lib_1.TextWidget({ width: 8, height: heights[0], markdown: 'a' }), new lib_1.TextWidget({ width: 8, height: heights[1], markdown: 'b' }), new lib_1.TextWidget({ width: 8, height: heights[2], markdown: 'c' }));
            // THEN
            test.equal(24, row.width);
            test.equal(4, row.height);
        }
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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