/***************************************************************************
  **************************************************************************
    
  Spherical Harmonic Transform Kit 2.7
    
  Copyright 1997-2003  Sean Moore, Dennis Healy,
                       Dan Rockmore, Peter Kostelec
  Copyright 2004  Peter Kostelec, Dan Rockmore

  This file is part of SpharmonicKit.

  SpharmonicKit is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  SpharmonicKit is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
  See the accompanying LICENSE file for details.

  ************************************************************************
  ************************************************************************/

/* indextables.c - source code to hard code bit reverse permutations */

#include <string.h> /* for memcpy */

static const int p2[2] = {0,1};

static const int p4[4] = {0,2,1,3};

static const int p8[8] = {0, 4, 2, 6, 1, 5, 3, 7};

static const int p16[16] = {0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};

static const int  p32[32] =
{0, 16, 8, 24, 4, 20, 12, 28, 2, 18, 10, 26, 6, 22, 14, 30, 1, 
 17, 9, 25, 5, 21, 13, 29, 3, 19, 11, 27, 7, 23, 15, 31};

static const int  p64[64] =
{0, 32, 16, 48, 8, 40, 24, 56, 4, 36, 20, 52, 12, 44, 28,60,2, 
 34, 18, 50, 10, 42, 26, 58, 6, 38, 22, 54, 14, 46, 30, 62, 1, 33, 17, 49, 9,41,
 25, 57, 5, 37, 21, 53, 13, 45, 29, 61, 3, 35, 19, 51, 11, 43, 27, 59, 7, 39, 
 23, 55, 15, 47, 31, 63};

static const int  p128[128] =
{0, 64, 32, 96, 16, 80, 48, 112, 8, 72, 40, 104, 24, 
 88, 56, 120, 4, 68, 36, 100, 20, 84, 52, 116, 12, 76, 44, 108, 28, 92, 60, 
 124, 2, 66, 34, 98, 18, 82, 50, 114, 10, 74, 42, 106, 26, 90, 58, 122, 6, 
 70, 38, 102, 22, 86, 54, 118, 14, 78, 46, 110, 30, 94, 62, 126, 1, 65, 33, 
 97, 17, 81, 49, 113, 9, 73, 41, 105, 25, 89, 57, 121, 5, 69, 37, 101, 21, 
 85, 53, 117, 13, 77, 45, 109, 29, 93, 61, 125, 3, 67, 35, 99, 19, 83, 51, 
 115, 11, 75, 43, 107, 27, 91, 59, 123, 7, 71, 39, 103, 23, 87, 55, 119, 15, 
 79, 47, 111, 31, 95, 63, 127};

static const int  p256[256] =
{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 
 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 
 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 
 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124,
 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 
 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 
 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142,
 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 
 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 
 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 
 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173,
 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 
 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235,
 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 
 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159,
 95, 223, 63, 191, 127, 255};

static const int  p512[512] =
{0, 256, 128, 384, 64, 320, 192, 448, 32, 288, 160, 416, 96, 352, 224, 480, 
 16, 272, 144, 400, 80, 336, 208, 464, 48, 304, 176, 432, 112, 368, 240, 
  496, 8, 264, 136, 392, 72, 328, 200, 456, 40, 296, 168, 424, 104, 360, 232, 
  488, 24, 280, 152, 408, 88, 344, 216, 472, 56, 312, 184, 440, 120, 376, 
  248, 504, 4, 260, 132, 388, 68, 324, 196, 452, 36, 292, 164, 420, 100, 356, 
  228, 484, 20, 276, 148, 404, 84, 340, 212, 468, 52, 308, 180, 436, 116, 
  372, 244, 500, 12, 268, 140, 396, 76, 332, 204, 460, 44, 300, 172, 428, 
  108, 364, 236, 492, 28, 284, 156, 412, 92, 348, 220, 476, 60, 316, 188, 
  444, 124, 380, 252, 508, 2, 258, 130, 386, 66, 322, 194, 450, 34, 290, 162, 
  418, 98, 354, 226, 482, 18, 274, 146, 402, 82, 338, 210, 466, 50, 306, 178, 
  434, 114, 370, 242, 498, 10, 266, 138, 394, 74, 330, 202, 458, 42, 298, 
  170, 426, 106, 362, 234, 490, 26, 282, 154, 410, 90, 346, 218, 474, 58, 
  314, 186, 442, 122, 378, 250, 506, 6, 262, 134, 390, 70, 326, 198, 454, 38, 
  294, 166, 422, 102, 358, 230, 486, 22, 278, 150, 406, 86, 342, 214, 470, 
  54, 310, 182, 438, 118, 374, 246, 502, 14, 270, 142, 398, 78, 334, 206, 
  462, 46, 302, 174, 430, 110, 366, 238, 494, 30, 286, 158, 414, 94, 350, 
  222, 478, 62, 318, 190, 446, 126, 382, 254, 510, 1, 257, 129, 385, 65, 321, 
  193, 449, 33, 289, 161, 417, 97, 353, 225, 481, 17, 273, 145, 401, 81, 337, 
  209, 465, 49, 305, 177, 433, 113, 369, 241, 497, 9, 265, 137, 393, 73, 329, 
  201, 457, 41, 297, 169, 425, 105, 361, 233, 489, 25, 281, 153, 409, 89, 
  345, 217, 473, 57, 313, 185, 441, 121, 377, 249, 505, 5, 261, 133, 389, 69, 
  325, 197, 453, 37, 293, 165, 421, 101, 357, 229, 485, 21, 277, 149, 405, 
  85, 341, 213, 469, 53, 309, 181, 437, 117, 373, 245, 501, 13, 269, 141, 
  397, 77, 333, 205, 461, 45, 301, 173, 429, 109, 365, 237, 493, 29, 285, 
  157, 413, 93, 349, 221, 477, 61, 317, 189, 445, 125, 381, 253, 509, 3, 259, 
  131, 387, 67, 323, 195, 451, 35, 291, 163, 419, 99, 355, 227, 483, 19, 275, 
  147, 403, 83, 339, 211, 467, 51, 307, 179, 435, 115, 371, 243, 499, 11, 
  267, 139, 395, 75, 331, 203, 459, 43, 299, 171, 427, 107, 363, 235, 491, 
  27, 283, 155, 411, 91, 347, 219, 475, 59, 315, 187, 443, 123, 379, 251, 
  507, 7, 263, 135, 391, 71, 327, 199, 455, 39, 295, 167, 423, 103, 359, 231, 
  487, 23, 279, 151, 407, 87, 343, 215, 471, 55, 311, 183, 439, 119, 375, 
  247, 503, 15, 271, 143, 399, 79, 335, 207, 463, 47, 303, 175, 431, 111, 
  367, 239, 495, 31, 287, 159, 415, 95, 351, 223, 479, 63, 319, 191, 447, 
  127, 383, 255, 511};

 static const int  p1024[1024] =
{0, 512, 256, 768, 128, 640, 384, 896, 64, 576, 320, 832, 192, 704, 448, 960, 
  32, 544, 288, 800, 160, 672, 416, 928, 96, 608, 352, 864, 224, 736, 480, 
  992, 16, 528, 272, 784, 144, 656, 400, 912, 80, 592, 336, 848, 208, 720, 
  464, 976, 48, 560, 304, 816, 176, 688, 432, 944, 112, 624, 368, 880, 240, 
  752, 496, 1008, 8, 520, 264, 776, 136, 648, 392, 904, 72, 584, 328, 840, 
  200, 712, 456, 968, 40, 552, 296, 808, 168, 680, 424, 936, 104, 616, 360, 
  872, 232, 744, 488, 1000, 24, 536, 280, 792, 152, 664, 408, 920, 88, 600, 
  344, 856, 216, 728, 472, 984, 56, 568, 312, 824, 184, 696, 440, 952, 120, 
  632, 376, 888, 248, 760, 504, 1016, 4, 516, 260, 772, 132, 644, 388, 900, 
  68, 580, 324, 836, 196, 708, 452, 964, 36, 548, 292, 804, 164, 676, 420, 
  932, 100, 612, 356, 868, 228, 740, 484, 996, 20, 532, 276, 788, 148, 660, 
  404, 916, 84, 596, 340, 852, 212, 724, 468, 980, 52, 564, 308, 820, 180, 
  692, 436, 948, 116, 628, 372, 884, 244, 756, 500, 1012, 12, 524, 268, 780, 
  140, 652, 396, 908, 76, 588, 332, 844, 204, 716, 460, 972, 44, 556, 300, 
  812, 172, 684, 428, 940, 108, 620, 364, 876, 236, 748, 492, 1004, 28, 540, 
  284, 796, 156, 668, 412, 924, 92, 604, 348, 860, 220, 732, 476, 988, 60, 
  572, 316, 828, 188, 700, 444, 956, 124, 636, 380, 892, 252, 764, 508, 1020, 
  2, 514, 258, 770, 130, 642, 386, 898, 66, 578, 322, 834, 194, 706, 450, 
  962, 34, 546, 290, 802, 162, 674, 418, 930, 98, 610, 354, 866, 226, 738, 
  482, 994, 18, 530, 274, 786, 146, 658, 402, 914, 82, 594, 338, 850, 210, 
  722, 466, 978, 50, 562, 306, 818, 178, 690, 434, 946, 114, 626, 370, 882, 
  242, 754, 498, 1010, 10, 522, 266, 778, 138, 650, 394, 906, 74, 586, 330, 
  842, 202, 714, 458, 970, 42, 554, 298, 810, 170, 682, 426, 938, 106, 618, 
  362, 874, 234, 746, 490, 1002, 26, 538, 282, 794, 154, 666, 410, 922, 90, 
  602, 346, 858, 218, 730, 474, 986, 58, 570, 314, 826, 186, 698, 442, 954, 
  122, 634, 378, 890, 250, 762, 506, 1018, 6, 518, 262, 774, 134, 646, 390, 
  902, 70, 582, 326, 838, 198, 710, 454, 966, 38, 550, 294, 806, 166, 678, 
  422, 934, 102, 614, 358, 870, 230, 742, 486, 998, 22, 534, 278, 790, 150, 
  662, 406, 918, 86, 598, 342, 854, 214, 726, 470, 982, 54, 566, 310, 822, 
  182, 694, 438, 950, 118, 630, 374, 886, 246, 758, 502, 1014, 14, 526, 270, 
  782, 142, 654, 398, 910, 78, 590, 334, 846, 206, 718, 462, 974, 46, 558, 
  302, 814, 174, 686, 430, 942, 110, 622, 366, 878, 238, 750, 494, 1006, 30, 
  542, 286, 798, 158, 670, 414, 926, 94, 606, 350, 862, 222, 734, 478, 990, 
  62, 574, 318, 830, 190, 702, 446, 958, 126, 638, 382, 894, 254, 766, 510, 
  1022, 1, 513, 257, 769, 129, 641, 385, 897, 65, 577, 321, 833, 193, 705, 
  449, 961, 33, 545, 289, 801, 161, 673, 417, 929, 97, 609, 353, 865, 225, 
  737, 481, 993, 17, 529, 273, 785, 145, 657, 401, 913, 81, 593, 337, 849, 
  209, 721, 465, 977, 49, 561, 305, 817, 177, 689, 433, 945, 113, 625, 369, 
  881, 241, 753, 497, 1009, 9, 521, 265, 777, 137, 649, 393, 905, 73, 585, 
  329, 841, 201, 713, 457, 969, 41, 553, 297, 809, 169, 681, 425, 937, 105, 
  617, 361, 873, 233, 745, 489, 1001, 25, 537, 281, 793, 153, 665, 409, 921, 
  89, 601, 345, 857, 217, 729, 473, 985, 57, 569, 313, 825, 185, 697, 441, 
  953, 121, 633, 377, 889, 249, 761, 505, 1017, 5, 517, 261, 773, 133, 645, 
  389, 901, 69, 581, 325, 837, 197, 709, 453, 965, 37, 549, 293, 805, 165, 
  677, 421, 933, 101, 613, 357, 869, 229, 741, 485, 997, 21, 533, 277, 789, 
  149, 661, 405, 917, 85, 597, 341, 853, 213, 725, 469, 981, 53, 565, 309, 
  821, 181, 693, 437, 949, 117, 629, 373, 885, 245, 757, 501, 1013, 13, 525, 
  269, 781, 141, 653, 397, 909, 77, 589, 333, 845, 205, 717, 461, 973, 45, 
  557, 301, 813, 173, 685, 429, 941, 109, 621, 365, 877, 237, 749, 493, 1005, 
  29, 541, 285, 797, 157, 669, 413, 925, 93, 605, 349, 861, 221, 733, 477, 
  989, 61, 573, 317, 829, 189, 701, 445, 957, 125, 637, 381, 893, 253, 765, 
  509, 1021, 3, 515, 259, 771, 131, 643, 387, 899, 67, 579, 323, 835, 195, 
  707, 451, 963, 35, 547, 291, 803, 163, 675, 419, 931, 99, 611, 355, 867, 
  227, 739, 483, 995, 19, 531, 275, 787, 147, 659, 403, 915, 83, 595, 339, 
  851, 211, 723, 467, 979, 51, 563, 307, 819, 179, 691, 435, 947, 115, 627, 
  371, 883, 243, 755, 499, 1011, 11, 523, 267, 779, 139, 651, 395, 907, 75, 
  587, 331, 843, 203, 715, 459, 971, 43, 555, 299, 811, 171, 683, 427, 939, 
  107, 619, 363, 875, 235, 747, 491, 1003, 27, 539, 283, 795, 155, 667, 411, 
  923, 91, 603, 347, 859, 219, 731, 475, 987, 59, 571, 315, 827, 187, 699, 
  443, 955, 123, 635, 379, 891, 251, 763, 507, 1019, 7, 519, 263, 775, 135, 
  647, 391, 903, 71, 583, 327, 839, 199, 711, 455, 967, 39, 551, 295, 807, 
  167, 679, 423, 935, 103, 615, 359, 871, 231, 743, 487, 999, 23, 535, 279, 
  791, 151, 663, 407, 919, 87, 599, 343, 855, 215, 727, 471, 983, 55, 567, 
  311, 823, 183, 695, 439, 951, 119, 631, 375, 887, 247, 759, 503, 1015, 15, 
  527, 271, 783, 143, 655, 399, 911, 79, 591, 335, 847, 207, 719, 463, 975, 
  47, 559, 303, 815, 175, 687, 431, 943, 111, 623, 367, 879, 239, 751, 495, 
  1007, 31, 543, 287, 799, 159, 671, 415, 927, 95, 607, 351, 863, 223, 735, 
  479, 991, 63, 575, 319, 831, 191, 703, 447, 959, 127, 639, 383, 895, 255, 
  767, 511, 1023};

 static const int  p2048[2048] = 
 {0, 1024, 512, 1536, 256, 1280, 768, 1792, 128, 1152, 640, 1664, 384, 1408, 
  896, 1920, 64, 1088, 576, 1600, 320, 1344, 832, 1856, 192, 1216, 704, 1728, 
  448, 1472, 960, 1984, 32, 1056, 544, 1568, 288, 1312, 800, 1824, 160, 1184, 
  672, 1696, 416, 1440, 928, 1952, 96, 1120, 608, 1632, 352, 1376, 864, 1888, 
  224, 1248, 736, 1760, 480, 1504, 992, 2016, 16, 1040, 528, 1552, 272, 1296, 
  784, 1808, 144, 1168, 656, 1680, 400, 1424, 912, 1936, 80, 1104, 592, 1616, 
  336, 1360, 848, 1872, 208, 1232, 720, 1744, 464, 1488, 976, 2000, 48, 1072, 
  560, 1584, 304, 1328, 816, 1840, 176, 1200, 688, 1712, 432, 1456, 944, 
  1968, 112, 1136, 624, 1648, 368, 1392, 880, 1904, 240, 1264, 752, 1776, 
  496, 1520, 1008, 2032, 8, 1032, 520, 1544, 264, 1288, 776, 1800, 136, 1160, 
  648, 1672, 392, 1416, 904, 1928, 72, 1096, 584, 1608, 328, 1352, 840, 1864, 
  200, 1224, 712, 1736, 456, 1480, 968, 1992, 40, 1064, 552, 1576, 296, 1320, 
  808, 1832, 168, 1192, 680, 1704, 424, 1448, 936, 1960, 104, 1128, 616, 
  1640, 360, 1384, 872, 1896, 232, 1256, 744, 1768, 488, 1512, 1000, 2024, 
  24, 1048, 536, 1560, 280, 1304, 792, 1816, 152, 1176, 664, 1688, 408, 1432, 
  920, 1944, 88, 1112, 600, 1624, 344, 1368, 856, 1880, 216, 1240, 728, 1752, 
  472, 1496, 984, 2008, 56, 1080, 568, 1592, 312, 1336, 824, 1848, 184, 1208, 
  696, 1720, 440, 1464, 952, 1976, 120, 1144, 632, 1656, 376, 1400, 888, 
  1912, 248, 1272, 760, 1784, 504, 1528, 1016, 2040, 4, 1028, 516, 1540, 260, 
  1284, 772, 1796, 132, 1156, 644, 1668, 388, 1412, 900, 1924, 68, 1092, 580, 
  1604, 324, 1348, 836, 1860, 196, 1220, 708, 1732, 452, 1476, 964, 1988, 36, 
  1060, 548, 1572, 292, 1316, 804, 1828, 164, 1188, 676, 1700, 420, 1444, 
  932, 1956, 100, 1124, 612, 1636, 356, 1380, 868, 1892, 228, 1252, 740, 
  1764, 484, 1508, 996, 2020, 20, 1044, 532, 1556, 276, 1300, 788, 1812, 148, 
  1172, 660, 1684, 404, 1428, 916, 1940, 84, 1108, 596, 1620, 340, 1364, 852, 
  1876, 212, 1236, 724, 1748, 468, 1492, 980, 2004, 52, 1076, 564, 1588, 308, 
  1332, 820, 1844, 180, 1204, 692, 1716, 436, 1460, 948, 1972, 116, 1140, 
  628, 1652, 372, 1396, 884, 1908, 244, 1268, 756, 1780, 500, 1524, 1012, 
  2036, 12, 1036, 524, 1548, 268, 1292, 780, 1804, 140, 1164, 652, 1676, 396, 
  1420, 908, 1932, 76, 1100, 588, 1612, 332, 1356, 844, 1868, 204, 1228, 716, 
  1740, 460, 1484, 972, 1996, 44, 1068, 556, 1580, 300, 1324, 812, 1836, 172, 
  1196, 684, 1708, 428, 1452, 940, 1964, 108, 1132, 620, 1644, 364, 1388, 
  876, 1900, 236, 1260, 748, 1772, 492, 1516, 1004, 2028, 28, 1052, 540, 
  1564, 284, 1308, 796, 1820, 156, 1180, 668, 1692, 412, 1436, 924, 1948, 92, 
  1116, 604, 1628, 348, 1372, 860, 1884, 220, 1244, 732, 1756, 476, 1500, 
  988, 2012, 60, 1084, 572, 1596, 316, 1340, 828, 1852, 188, 1212, 700, 1724, 
  444, 1468, 956, 1980, 124, 1148, 636, 1660, 380, 1404, 892, 1916, 252, 
  1276, 764, 1788, 508, 1532, 1020, 2044, 2, 1026, 514, 1538, 258, 1282, 770, 
  1794, 130, 1154, 642, 1666, 386, 1410, 898, 1922, 66, 1090, 578, 1602, 322, 
  1346, 834, 1858, 194, 1218, 706, 1730, 450, 1474, 962, 1986, 34, 1058, 546, 
  1570, 290, 1314, 802, 1826, 162, 1186, 674, 1698, 418, 1442, 930, 1954, 98, 
  1122, 610, 1634, 354, 1378, 866, 1890, 226, 1250, 738, 1762, 482, 1506, 
  994, 2018, 18, 1042, 530, 1554, 274, 1298, 786, 1810, 146, 1170, 658, 1682, 
  402, 1426, 914, 1938, 82, 1106, 594, 1618, 338, 1362, 850, 1874, 210, 1234, 
  722, 1746, 466, 1490, 978, 2002, 50, 1074, 562, 1586, 306, 1330, 818, 1842, 
  178, 1202, 690, 1714, 434, 1458, 946, 1970, 114, 1138, 626, 1650, 370, 
  1394, 882, 1906, 242, 1266, 754, 1778, 498, 1522, 1010, 2034, 10, 1034, 
  522, 1546, 266, 1290, 778, 1802, 138, 1162, 650, 1674, 394, 1418, 906, 
  1930, 74, 1098, 586, 1610, 330, 1354, 842, 1866, 202, 1226, 714, 1738, 458, 
  1482, 970, 1994, 42, 1066, 554, 1578, 298, 1322, 810, 1834, 170, 1194, 682, 
  1706, 426, 1450, 938, 1962, 106, 1130, 618, 1642, 362, 1386, 874, 1898, 
  234, 1258, 746, 1770, 490, 1514, 1002, 2026, 26, 1050, 538, 1562, 282, 
  1306, 794, 1818, 154, 1178, 666, 1690, 410, 1434, 922, 1946, 90, 1114, 602, 
  1626, 346, 1370, 858, 1882, 218, 1242, 730, 1754, 474, 1498, 986, 2010, 58, 
  1082, 570, 1594, 314, 1338, 826, 1850, 186, 1210, 698, 1722, 442, 1466, 
  954, 1978, 122, 1146, 634, 1658, 378, 1402, 890, 1914, 250, 1274, 762, 
  1786, 506, 1530, 1018, 2042, 6, 1030, 518, 1542, 262, 1286, 774, 1798, 134, 
  1158, 646, 1670, 390, 1414, 902, 1926, 70, 1094, 582, 1606, 326, 1350, 838, 
  1862, 198, 1222, 710, 1734, 454, 1478, 966, 1990, 38, 1062, 550, 1574, 294, 
  1318, 806, 1830, 166, 1190, 678, 1702, 422, 1446, 934, 1958, 102, 1126, 
  614, 1638, 358, 1382, 870, 1894, 230, 1254, 742, 1766, 486, 1510, 998, 
  2022, 22, 1046, 534, 1558, 278, 1302, 790, 1814, 150, 1174, 662, 1686, 406, 
  1430, 918, 1942, 86, 1110, 598, 1622, 342, 1366, 854, 1878, 214, 1238, 726, 
  1750, 470, 1494, 982, 2006, 54, 1078, 566, 1590, 310, 1334, 822, 1846, 182, 
  1206, 694, 1718, 438, 1462, 950, 1974, 118, 1142, 630, 1654, 374, 1398, 
  886, 1910, 246, 1270, 758, 1782, 502, 1526, 1014, 2038, 14, 1038, 526, 
  1550, 270, 1294, 782, 1806, 142, 1166, 654, 1678, 398, 1422, 910, 1934, 78, 
  1102, 590, 1614, 334, 1358, 846, 1870, 206, 1230, 718, 1742, 462, 1486, 
  974, 1998, 46, 1070, 558, 1582, 302, 1326, 814, 1838, 174, 1198, 686, 1710, 
  430, 1454, 942, 1966, 110, 1134, 622, 1646, 366, 1390, 878, 1902, 238, 
  1262, 750, 1774, 494, 1518, 1006, 2030, 30, 1054, 542, 1566, 286, 1310, 
  798, 1822, 158, 1182, 670, 1694, 414, 1438, 926, 1950, 94, 1118, 606, 1630, 
  350, 1374, 862, 1886, 222, 1246, 734, 1758, 478, 1502, 990, 2014, 62, 1086, 
  574, 1598, 318, 1342, 830, 1854, 190, 1214, 702, 1726, 446, 1470, 958, 
  1982, 126, 1150, 638, 1662, 382, 1406, 894, 1918, 254, 1278, 766, 1790, 
  510, 1534, 1022, 2046, 1, 1025, 513, 1537, 257, 1281, 769, 1793, 129, 1153, 
  641, 1665, 385, 1409, 897, 1921, 65, 1089, 577, 1601, 321, 1345, 833, 1857, 
  193, 1217, 705, 1729, 449, 1473, 961, 1985, 33, 1057, 545, 1569, 289, 1313, 
  801, 1825, 161, 1185, 673, 1697, 417, 1441, 929, 1953, 97, 1121, 609, 1633, 
  353, 1377, 865, 1889, 225, 1249, 737, 1761, 481, 1505, 993, 2017, 17, 1041, 
  529, 1553, 273, 1297, 785, 1809, 145, 1169, 657, 1681, 401, 1425, 913, 
  1937, 81, 1105, 593, 1617, 337, 1361, 849, 1873, 209, 1233, 721, 1745, 465, 
  1489, 977, 2001, 49, 1073, 561, 1585, 305, 1329, 817, 1841, 177, 1201, 689, 
  1713, 433, 1457, 945, 1969, 113, 1137, 625, 1649, 369, 1393, 881, 1905, 
  241, 1265, 753, 1777, 497, 1521, 1009, 2033, 9, 1033, 521, 1545, 265, 1289, 
  777, 1801, 137, 1161, 649, 1673, 393, 1417, 905, 1929, 73, 1097, 585, 1609, 
  329, 1353, 841, 1865, 201, 1225, 713, 1737, 457, 1481, 969, 1993, 41, 1065, 
  553, 1577, 297, 1321, 809, 1833, 169, 1193, 681, 1705, 425, 1449, 937, 
  1961, 105, 1129, 617, 1641, 361, 1385, 873, 1897, 233, 1257, 745, 1769, 
  489, 1513, 1001, 2025, 25, 1049, 537, 1561, 281, 1305, 793, 1817, 153, 
  1177, 665, 1689, 409, 1433, 921, 1945, 89, 1113, 601, 1625, 345, 1369, 857, 
  1881, 217, 1241, 729, 1753, 473, 1497, 985, 2009, 57, 1081, 569, 1593, 313, 
  1337, 825, 1849, 185, 1209, 697, 1721, 441, 1465, 953, 1977, 121, 1145, 
  633, 1657, 377, 1401, 889, 1913, 249, 1273, 761, 1785, 505, 1529, 1017, 
  2041, 5, 1029, 517, 1541, 261, 1285, 773, 1797, 133, 1157, 645, 1669, 389, 
  1413, 901, 1925, 69, 1093, 581, 1605, 325, 1349, 837, 1861, 197, 1221, 709, 
  1733, 453, 1477, 965, 1989, 37, 1061, 549, 1573, 293, 1317, 805, 1829, 165, 
  1189, 677, 1701, 421, 1445, 933, 1957, 101, 1125, 613, 1637, 357, 1381, 
  869, 1893, 229, 1253, 741, 1765, 485, 1509, 997, 2021, 21, 1045, 533, 1557, 
  277, 1301, 789, 1813, 149, 1173, 661, 1685, 405, 1429, 917, 1941, 85, 1109, 
  597, 1621, 341, 1365, 853, 1877, 213, 1237, 725, 1749, 469, 1493, 981, 
  2005, 53, 1077, 565, 1589, 309, 1333, 821, 1845, 181, 1205, 693, 1717, 437, 
  1461, 949, 1973, 117, 1141, 629, 1653, 373, 1397, 885, 1909, 245, 1269, 
  757, 1781, 501, 1525, 1013, 2037, 13, 1037, 525, 1549, 269, 1293, 781, 
  1805, 141, 1165, 653, 1677, 397, 1421, 909, 1933, 77, 1101, 589, 1613, 333, 
  1357, 845, 1869, 205, 1229, 717, 1741, 461, 1485, 973, 1997, 45, 1069, 557, 
  1581, 301, 1325, 813, 1837, 173, 1197, 685, 1709, 429, 1453, 941, 1965, 
  109, 1133, 621, 1645, 365, 1389, 877, 1901, 237, 1261, 749, 1773, 493, 
  1517, 1005, 2029, 29, 1053, 541, 1565, 285, 1309, 797, 1821, 157, 1181, 
  669, 1693, 413, 1437, 925, 1949, 93, 1117, 605, 1629, 349, 1373, 861, 1885, 
  221, 1245, 733, 1757, 477, 1501, 989, 2013, 61, 1085, 573, 1597, 317, 1341, 
  829, 1853, 189, 1213, 701, 1725, 445, 1469, 957, 1981, 125, 1149, 637, 
  1661, 381, 1405, 893, 1917, 253, 1277, 765, 1789, 509, 1533, 1021, 2045, 3, 
  1027, 515, 1539, 259, 1283, 771, 1795, 131, 1155, 643, 1667, 387, 1411, 
  899, 1923, 67, 1091, 579, 1603, 323, 1347, 835, 1859, 195, 1219, 707, 1731, 
  451, 1475, 963, 1987, 35, 1059, 547, 1571, 291, 1315, 803, 1827, 163, 1187, 
  675, 1699, 419, 1443, 931, 1955, 99, 1123, 611, 1635, 355, 1379, 867, 1891, 
  227, 1251, 739, 1763, 483, 1507, 995, 2019, 19, 1043, 531, 1555, 275, 1299, 
  787, 1811, 147, 1171, 659, 1683, 403, 1427, 915, 1939, 83, 1107, 595, 1619, 
  339, 1363, 851, 1875, 211, 1235, 723, 1747, 467, 1491, 979, 2003, 51, 1075, 
  563, 1587, 307, 1331, 819, 1843, 179, 1203, 691, 1715, 435, 1459, 947, 
  1971, 115, 1139, 627, 1651, 371, 1395, 883, 1907, 243, 1267, 755, 1779, 
  499, 1523, 1011, 2035, 11, 1035, 523, 1547, 267, 1291, 779, 1803, 139, 
  1163, 651, 1675, 395, 1419, 907, 1931, 75, 1099, 587, 1611, 331, 1355, 843, 
  1867, 203, 1227, 715, 1739, 459, 1483, 971, 1995, 43, 1067, 555, 1579, 299, 
  1323, 811, 1835, 171, 1195, 683, 1707, 427, 1451, 939, 1963, 107, 1131, 
  619, 1643, 363, 1387, 875, 1899, 235, 1259, 747, 1771, 491, 1515, 1003, 
  2027, 27, 1051, 539, 1563, 283, 1307, 795, 1819, 155, 1179, 667, 1691, 411, 
  1435, 923, 1947, 91, 1115, 603, 1627, 347, 1371, 859, 1883, 219, 1243, 731, 
  1755, 475, 1499, 987, 2011, 59, 1083, 571, 1595, 315, 1339, 827, 1851, 187, 
  1211, 699, 1723, 443, 1467, 955, 1979, 123, 1147, 635, 1659, 379, 1403, 
  891, 1915, 251, 1275, 763, 1787, 507, 1531, 1019, 2043, 7, 1031, 519, 1543, 
  263, 1287, 775, 1799, 135, 1159, 647, 1671, 391, 1415, 903, 1927, 71, 1095, 
  583, 1607, 327, 1351, 839, 1863, 199, 1223, 711, 1735, 455, 1479, 967, 
  1991, 39, 1063, 551, 1575, 295, 1319, 807, 1831, 167, 1191, 679, 1703, 423, 
  1447, 935, 1959, 103, 1127, 615, 1639, 359, 1383, 871, 1895, 231, 1255, 
  743, 1767, 487, 1511, 999, 2023, 23, 1047, 535, 1559, 279, 1303, 791, 1815, 
  151, 1175, 663, 1687, 407, 1431, 919, 1943, 87, 1111, 599, 1623, 343, 1367, 
  855, 1879, 215, 1239, 727, 1751, 471, 1495, 983, 2007, 55, 1079, 567, 1591, 
  311, 1335, 823, 1847, 183, 1207, 695, 1719, 439, 1463, 951, 1975, 119, 
  1143, 631, 1655, 375, 1399, 887, 1911, 247, 1271, 759, 1783, 503, 1527, 
  1015, 2039, 15, 1039, 527, 1551, 271, 1295, 783, 1807, 143, 1167, 655, 
  1679, 399, 1423, 911, 1935, 79, 1103, 591, 1615, 335, 1359, 847, 1871, 207, 
  1231, 719, 1743, 463, 1487, 975, 1999, 47, 1071, 559, 1583, 303, 1327, 815, 
  1839, 175, 1199, 687, 1711, 431, 1455, 943, 1967, 111, 1135, 623, 1647, 
  367, 1391, 879, 1903, 239, 1263, 751, 1775, 495, 1519, 1007, 2031, 31, 
  1055, 543, 1567, 287, 1311, 799, 1823, 159, 1183, 671, 1695, 415, 1439, 
  927, 1951, 95, 1119, 607, 1631, 351, 1375, 863, 1887, 223, 1247, 735, 1759, 
  479, 1503, 991, 2015, 63, 1087, 575, 1599, 319, 1343, 831, 1855, 191, 1215, 
  703, 1727, 447, 1471, 959, 1983, 127, 1151, 639, 1663, 383, 1407, 895, 
  1919, 255, 1279, 767, 1791, 511, 1535, 1023, 2047};

 static const int  p4096[4096] = 
{0, 2048, 1024, 3072, 512, 2560, 1536, 3584, 256, 2304, 1280, 3328, 768, 
  2816, 1792, 3840, 128, 2176, 1152, 3200, 640, 2688, 1664, 3712, 384, 2432, 
  1408, 3456, 896, 2944, 1920, 3968, 64, 2112, 1088, 3136, 576, 2624, 1600, 
  3648, 320, 2368, 1344, 3392, 832, 2880, 1856, 3904, 192, 2240, 1216, 3264, 
  704, 2752, 1728, 3776, 448, 2496, 1472, 3520, 960, 3008, 1984, 4032, 32, 
  2080, 1056, 3104, 544, 2592, 1568, 3616, 288, 2336, 1312, 3360, 800, 2848, 
  1824, 3872, 160, 2208, 1184, 3232, 672, 2720, 1696, 3744, 416, 2464, 1440, 
  3488, 928, 2976, 1952, 4000, 96, 2144, 1120, 3168, 608, 2656, 1632, 3680, 
  352, 2400, 1376, 3424, 864, 2912, 1888, 3936, 224, 2272, 1248, 3296, 736, 
  2784, 1760, 3808, 480, 2528, 1504, 3552, 992, 3040, 2016, 4064, 16, 2064, 
  1040, 3088, 528, 2576, 1552, 3600, 272, 2320, 1296, 3344, 784, 2832, 1808, 
  3856, 144, 2192, 1168, 3216, 656, 2704, 1680, 3728, 400, 2448, 1424, 3472, 
  912, 2960, 1936, 3984, 80, 2128, 1104, 3152, 592, 2640, 1616, 3664, 336, 
  2384, 1360, 3408, 848, 2896, 1872, 3920, 208, 2256, 1232, 3280, 720, 2768, 
  1744, 3792, 464, 2512, 1488, 3536, 976, 3024, 2000, 4048, 48, 2096, 1072, 
  3120, 560, 2608, 1584, 3632, 304, 2352, 1328, 3376, 816, 2864, 1840, 3888, 
  176, 2224, 1200, 3248, 688, 2736, 1712, 3760, 432, 2480, 1456, 3504, 944, 
  2992, 1968, 4016, 112, 2160, 1136, 3184, 624, 2672, 1648, 3696, 368, 2416, 
  1392, 3440, 880, 2928, 1904, 3952, 240, 2288, 1264, 3312, 752, 2800, 1776, 
  3824, 496, 2544, 1520, 3568, 1008, 3056, 2032, 4080, 8, 2056, 1032, 3080, 
  520, 2568, 1544, 3592, 264, 2312, 1288, 3336, 776, 2824, 1800, 3848, 136, 
  2184, 1160, 3208, 648, 2696, 1672, 3720, 392, 2440, 1416, 3464, 904, 2952, 
  1928, 3976, 72, 2120, 1096, 3144, 584, 2632, 1608, 3656, 328, 2376, 1352, 
  3400, 840, 2888, 1864, 3912, 200, 2248, 1224, 3272, 712, 2760, 1736, 3784, 
  456, 2504, 1480, 3528, 968, 3016, 1992, 4040, 40, 2088, 1064, 3112, 552, 
  2600, 1576, 3624, 296, 2344, 1320, 3368, 808, 2856, 1832, 3880, 168, 2216, 
  1192, 3240, 680, 2728, 1704, 3752, 424, 2472, 1448, 3496, 936, 2984, 1960, 
  4008, 104, 2152, 1128, 3176, 616, 2664, 1640, 3688, 360, 2408, 1384, 3432, 
  872, 2920, 1896, 3944, 232, 2280, 1256, 3304, 744, 2792, 1768, 3816, 488, 
  2536, 1512, 3560, 1000, 3048, 2024, 4072, 24, 2072, 1048, 3096, 536, 2584, 
  1560, 3608, 280, 2328, 1304, 3352, 792, 2840, 1816, 3864, 152, 2200, 1176, 
  3224, 664, 2712, 1688, 3736, 408, 2456, 1432, 3480, 920, 2968, 1944, 3992, 
  88, 2136, 1112, 3160, 600, 2648, 1624, 3672, 344, 2392, 1368, 3416, 856, 
  2904, 1880, 3928, 216, 2264, 1240, 3288, 728, 2776, 1752, 3800, 472, 2520, 
  1496, 3544, 984, 3032, 2008, 4056, 56, 2104, 1080, 3128, 568, 2616, 1592, 
  3640, 312, 2360, 1336, 3384, 824, 2872, 1848, 3896, 184, 2232, 1208, 3256, 
  696, 2744, 1720, 3768, 440, 2488, 1464, 3512, 952, 3000, 1976, 4024, 120, 
  2168, 1144, 3192, 632, 2680, 1656, 3704, 376, 2424, 1400, 3448, 888, 2936, 
  1912, 3960, 248, 2296, 1272, 3320, 760, 2808, 1784, 3832, 504, 2552, 1528, 
  3576, 1016, 3064, 2040, 4088, 4, 2052, 1028, 3076, 516, 2564, 1540, 3588, 
  260, 2308, 1284, 3332, 772, 2820, 1796, 3844, 132, 2180, 1156, 3204, 644, 
  2692, 1668, 3716, 388, 2436, 1412, 3460, 900, 2948, 1924, 3972, 68, 2116, 
  1092, 3140, 580, 2628, 1604, 3652, 324, 2372, 1348, 3396, 836, 2884, 1860, 
  3908, 196, 2244, 1220, 3268, 708, 2756, 1732, 3780, 452, 2500, 1476, 3524, 
  964, 3012, 1988, 4036, 36, 2084, 1060, 3108, 548, 2596, 1572, 3620, 292, 
  2340, 1316, 3364, 804, 2852, 1828, 3876, 164, 2212, 1188, 3236, 676, 2724, 
  1700, 3748, 420, 2468, 1444, 3492, 932, 2980, 1956, 4004, 100, 2148, 1124, 
  3172, 612, 2660, 1636, 3684, 356, 2404, 1380, 3428, 868, 2916, 1892, 3940, 
  228, 2276, 1252, 3300, 740, 2788, 1764, 3812, 484, 2532, 1508, 3556, 996, 
  3044, 2020, 4068, 20, 2068, 1044, 3092, 532, 2580, 1556, 3604, 276, 2324, 
  1300, 3348, 788, 2836, 1812, 3860, 148, 2196, 1172, 3220, 660, 2708, 1684, 
  3732, 404, 2452, 1428, 3476, 916, 2964, 1940, 3988, 84, 2132, 1108, 3156, 
  596, 2644, 1620, 3668, 340, 2388, 1364, 3412, 852, 2900, 1876, 3924, 212, 
  2260, 1236, 3284, 724, 2772, 1748, 3796, 468, 2516, 1492, 3540, 980, 3028, 
  2004, 4052, 52, 2100, 1076, 3124, 564, 2612, 1588, 3636, 308, 2356, 1332, 
  3380, 820, 2868, 1844, 3892, 180, 2228, 1204, 3252, 692, 2740, 1716, 3764, 
  436, 2484, 1460, 3508, 948, 2996, 1972, 4020, 116, 2164, 1140, 3188, 628, 
  2676, 1652, 3700, 372, 2420, 1396, 3444, 884, 2932, 1908, 3956, 244, 2292, 
  1268, 3316, 756, 2804, 1780, 3828, 500, 2548, 1524, 3572, 1012, 3060, 2036, 
  4084, 12, 2060, 1036, 3084, 524, 2572, 1548, 3596, 268, 2316, 1292, 3340, 
  780, 2828, 1804, 3852, 140, 2188, 1164, 3212, 652, 2700, 1676, 3724, 396, 
  2444, 1420, 3468, 908, 2956, 1932, 3980, 76, 2124, 1100, 3148, 588, 2636, 
  1612, 3660, 332, 2380, 1356, 3404, 844, 2892, 1868, 3916, 204, 2252, 1228, 
  3276, 716, 2764, 1740, 3788, 460, 2508, 1484, 3532, 972, 3020, 1996, 4044, 
  44, 2092, 1068, 3116, 556, 2604, 1580, 3628, 300, 2348, 1324, 3372, 812, 
  2860, 1836, 3884, 172, 2220, 1196, 3244, 684, 2732, 1708, 3756, 428, 2476, 
  1452, 3500, 940, 2988, 1964, 4012, 108, 2156, 1132, 3180, 620, 2668, 1644, 
  3692, 364, 2412, 1388, 3436, 876, 2924, 1900, 3948, 236, 2284, 1260, 3308, 
  748, 2796, 1772, 3820, 492, 2540, 1516, 3564, 1004, 3052, 2028, 4076, 28, 
  2076, 1052, 3100, 540, 2588, 1564, 3612, 284, 2332, 1308, 3356, 796, 2844, 
  1820, 3868, 156, 2204, 1180, 3228, 668, 2716, 1692, 3740, 412, 2460, 1436, 
  3484, 924, 2972, 1948, 3996, 92, 2140, 1116, 3164, 604, 2652, 1628, 3676, 
  348, 2396, 1372, 3420, 860, 2908, 1884, 3932, 220, 2268, 1244, 3292, 732, 
  2780, 1756, 3804, 476, 2524, 1500, 3548, 988, 3036, 2012, 4060, 60, 2108, 
  1084, 3132, 572, 2620, 1596, 3644, 316, 2364, 1340, 3388, 828, 2876, 1852, 
  3900, 188, 2236, 1212, 3260, 700, 2748, 1724, 3772, 444, 2492, 1468, 3516, 
  956, 3004, 1980, 4028, 124, 2172, 1148, 3196, 636, 2684, 1660, 3708, 380, 
  2428, 1404, 3452, 892, 2940, 1916, 3964, 252, 2300, 1276, 3324, 764, 2812, 
  1788, 3836, 508, 2556, 1532, 3580, 1020, 3068, 2044, 4092, 2, 2050, 1026, 
  3074, 514, 2562, 1538, 3586, 258, 2306, 1282, 3330, 770, 2818, 1794, 3842, 
  130, 2178, 1154, 3202, 642, 2690, 1666, 3714, 386, 2434, 1410, 3458, 898, 
  2946, 1922, 3970, 66, 2114, 1090, 3138, 578, 2626, 1602, 3650, 322, 2370, 
  1346, 3394, 834, 2882, 1858, 3906, 194, 2242, 1218, 3266, 706, 2754, 1730, 
  3778, 450, 2498, 1474, 3522, 962, 3010, 1986, 4034, 34, 2082, 1058, 3106, 
  546, 2594, 1570, 3618, 290, 2338, 1314, 3362, 802, 2850, 1826, 3874, 162, 
  2210, 1186, 3234, 674, 2722, 1698, 3746, 418, 2466, 1442, 3490, 930, 2978, 
  1954, 4002, 98, 2146, 1122, 3170, 610, 2658, 1634, 3682, 354, 2402, 1378, 
  3426, 866, 2914, 1890, 3938, 226, 2274, 1250, 3298, 738, 2786, 1762, 3810, 
  482, 2530, 1506, 3554, 994, 3042, 2018, 4066, 18, 2066, 1042, 3090, 530, 
  2578, 1554, 3602, 274, 2322, 1298, 3346, 786, 2834, 1810, 3858, 146, 2194, 
  1170, 3218, 658, 2706, 1682, 3730, 402, 2450, 1426, 3474, 914, 2962, 1938, 
  3986, 82, 2130, 1106, 3154, 594, 2642, 1618, 3666, 338, 2386, 1362, 3410, 
  850, 2898, 1874, 3922, 210, 2258, 1234, 3282, 722, 2770, 1746, 3794, 466, 
  2514, 1490, 3538, 978, 3026, 2002, 4050, 50, 2098, 1074, 3122, 562, 2610, 
  1586, 3634, 306, 2354, 1330, 3378, 818, 2866, 1842, 3890, 178, 2226, 1202, 
  3250, 690, 2738, 1714, 3762, 434, 2482, 1458, 3506, 946, 2994, 1970, 4018, 
  114, 2162, 1138, 3186, 626, 2674, 1650, 3698, 370, 2418, 1394, 3442, 882, 
  2930, 1906, 3954, 242, 2290, 1266, 3314, 754, 2802, 1778, 3826, 498, 2546, 
  1522, 3570, 1010, 3058, 2034, 4082, 10, 2058, 1034, 3082, 522, 2570, 1546, 
  3594, 266, 2314, 1290, 3338, 778, 2826, 1802, 3850, 138, 2186, 1162, 3210, 
  650, 2698, 1674, 3722, 394, 2442, 1418, 3466, 906, 2954, 1930, 3978, 74, 
  2122, 1098, 3146, 586, 2634, 1610, 3658, 330, 2378, 1354, 3402, 842, 2890, 
  1866, 3914, 202, 2250, 1226, 3274, 714, 2762, 1738, 3786, 458, 2506, 1482, 
  3530, 970, 3018, 1994, 4042, 42, 2090, 1066, 3114, 554, 2602, 1578, 3626, 
  298, 2346, 1322, 3370, 810, 2858, 1834, 3882, 170, 2218, 1194, 3242, 682, 
  2730, 1706, 3754, 426, 2474, 1450, 3498, 938, 2986, 1962, 4010, 106, 2154, 
  1130, 3178, 618, 2666, 1642, 3690, 362, 2410, 1386, 3434, 874, 2922, 1898, 
  3946, 234, 2282, 1258, 3306, 746, 2794, 1770, 3818, 490, 2538, 1514, 3562, 
  1002, 3050, 2026, 4074, 26, 2074, 1050, 3098, 538, 2586, 1562, 3610, 282, 
  2330, 1306, 3354, 794, 2842, 1818, 3866, 154, 2202, 1178, 3226, 666, 2714, 
  1690, 3738, 410, 2458, 1434, 3482, 922, 2970, 1946, 3994, 90, 2138, 1114, 
  3162, 602, 2650, 1626, 3674, 346, 2394, 1370, 3418, 858, 2906, 1882, 3930, 
  218, 2266, 1242, 3290, 730, 2778, 1754, 3802, 474, 2522, 1498, 3546, 986, 
  3034, 2010, 4058, 58, 2106, 1082, 3130, 570, 2618, 1594, 3642, 314, 2362, 
  1338, 3386, 826, 2874, 1850, 3898, 186, 2234, 1210, 3258, 698, 2746, 1722, 
  3770, 442, 2490, 1466, 3514, 954, 3002, 1978, 4026, 122, 2170, 1146, 3194, 
  634, 2682, 1658, 3706, 378, 2426, 1402, 3450, 890, 2938, 1914, 3962, 250, 
  2298, 1274, 3322, 762, 2810, 1786, 3834, 506, 2554, 1530, 3578, 1018, 3066, 
  2042, 4090, 6, 2054, 1030, 3078, 518, 2566, 1542, 3590, 262, 2310, 1286, 
  3334, 774, 2822, 1798, 3846, 134, 2182, 1158, 3206, 646, 2694, 1670, 3718, 
  390, 2438, 1414, 3462, 902, 2950, 1926, 3974, 70, 2118, 1094, 3142, 582, 
  2630, 1606, 3654, 326, 2374, 1350, 3398, 838, 2886, 1862, 3910, 198, 2246, 
  1222, 3270, 710, 2758, 1734, 3782, 454, 2502, 1478, 3526, 966, 3014, 1990, 
  4038, 38, 2086, 1062, 3110, 550, 2598, 1574, 3622, 294, 2342, 1318, 3366, 
  806, 2854, 1830, 3878, 166, 2214, 1190, 3238, 678, 2726, 1702, 3750, 422, 
  2470, 1446, 3494, 934, 2982, 1958, 4006, 102, 2150, 1126, 3174, 614, 2662, 
  1638, 3686, 358, 2406, 1382, 3430, 870, 2918, 1894, 3942, 230, 2278, 1254, 
  3302, 742, 2790, 1766, 3814, 486, 2534, 1510, 3558, 998, 3046, 2022, 4070, 
  22, 2070, 1046, 3094, 534, 2582, 1558, 3606, 278, 2326, 1302, 3350, 790, 
  2838, 1814, 3862, 150, 2198, 1174, 3222, 662, 2710, 1686, 3734, 406, 2454, 
  1430, 3478, 918, 2966, 1942, 3990, 86, 2134, 1110, 3158, 598, 2646, 1622, 
  3670, 342, 2390, 1366, 3414, 854, 2902, 1878, 3926, 214, 2262, 1238, 3286, 
  726, 2774, 1750, 3798, 470, 2518, 1494, 3542, 982, 3030, 2006, 4054, 54, 
  2102, 1078, 3126, 566, 2614, 1590, 3638, 310, 2358, 1334, 3382, 822, 2870, 
  1846, 3894, 182, 2230, 1206, 3254, 694, 2742, 1718, 3766, 438, 2486, 1462, 
  3510, 950, 2998, 1974, 4022, 118, 2166, 1142, 3190, 630, 2678, 1654, 3702, 
  374, 2422, 1398, 3446, 886, 2934, 1910, 3958, 246, 2294, 1270, 3318, 758, 
  2806, 1782, 3830, 502, 2550, 1526, 3574, 1014, 3062, 2038, 4086, 14, 2062, 
  1038, 3086, 526, 2574, 1550, 3598, 270, 2318, 1294, 3342, 782, 2830, 1806, 
  3854, 142, 2190, 1166, 3214, 654, 2702, 1678, 3726, 398, 2446, 1422, 3470, 
  910, 2958, 1934, 3982, 78, 2126, 1102, 3150, 590, 2638, 1614, 3662, 334, 
  2382, 1358, 3406, 846, 2894, 1870, 3918, 206, 2254, 1230, 3278, 718, 2766, 
  1742, 3790, 462, 2510, 1486, 3534, 974, 3022, 1998, 4046, 46, 2094, 1070, 
  3118, 558, 2606, 1582, 3630, 302, 2350, 1326, 3374, 814, 2862, 1838, 3886, 
  174, 2222, 1198, 3246, 686, 2734, 1710, 3758, 430, 2478, 1454, 3502, 942, 
  2990, 1966, 4014, 110, 2158, 1134, 3182, 622, 2670, 1646, 3694, 366, 2414, 
  1390, 3438, 878, 2926, 1902, 3950, 238, 2286, 1262, 3310, 750, 2798, 1774, 
  3822, 494, 2542, 1518, 3566, 1006, 3054, 2030, 4078, 30, 2078, 1054, 3102, 
  542, 2590, 1566, 3614, 286, 2334, 1310, 3358, 798, 2846, 1822, 3870, 158, 
  2206, 1182, 3230, 670, 2718, 1694, 3742, 414, 2462, 1438, 3486, 926, 2974, 
  1950, 3998, 94, 2142, 1118, 3166, 606, 2654, 1630, 3678, 350, 2398, 1374, 
  3422, 862, 2910, 1886, 3934, 222, 2270, 1246, 3294, 734, 2782, 1758, 3806, 
  478, 2526, 1502, 3550, 990, 3038, 2014, 4062, 62, 2110, 1086, 3134, 574, 
  2622, 1598, 3646, 318, 2366, 1342, 3390, 830, 2878, 1854, 3902, 190, 2238, 
  1214, 3262, 702, 2750, 1726, 3774, 446, 2494, 1470, 3518, 958, 3006, 1982, 
  4030, 126, 2174, 1150, 3198, 638, 2686, 1662, 3710, 382, 2430, 1406, 3454, 
  894, 2942, 1918, 3966, 254, 2302, 1278, 3326, 766, 2814, 1790, 3838, 510, 
  2558, 1534, 3582, 1022, 3070, 2046, 4094, 1, 2049, 1025, 3073, 513, 2561, 
  1537, 3585, 257, 2305, 1281, 3329, 769, 2817, 1793, 3841, 129, 2177, 1153, 
  3201, 641, 2689, 1665, 3713, 385, 2433, 1409, 3457, 897, 2945, 1921, 3969, 
  65, 2113, 1089, 3137, 577, 2625, 1601, 3649, 321, 2369, 1345, 3393, 833, 
  2881, 1857, 3905, 193, 2241, 1217, 3265, 705, 2753, 1729, 3777, 449, 2497, 
  1473, 3521, 961, 3009, 1985, 4033, 33, 2081, 1057, 3105, 545, 2593, 1569, 
  3617, 289, 2337, 1313, 3361, 801, 2849, 1825, 3873, 161, 2209, 1185, 3233, 
  673, 2721, 1697, 3745, 417, 2465, 1441, 3489, 929, 2977, 1953, 4001, 97, 
  2145, 1121, 3169, 609, 2657, 1633, 3681, 353, 2401, 1377, 3425, 865, 2913, 
  1889, 3937, 225, 2273, 1249, 3297, 737, 2785, 1761, 3809, 481, 2529, 1505, 
  3553, 993, 3041, 2017, 4065, 17, 2065, 1041, 3089, 529, 2577, 1553, 3601, 
  273, 2321, 1297, 3345, 785, 2833, 1809, 3857, 145, 2193, 1169, 3217, 657, 
  2705, 1681, 3729, 401, 2449, 1425, 3473, 913, 2961, 1937, 3985, 81, 2129, 
  1105, 3153, 593, 2641, 1617, 3665, 337, 2385, 1361, 3409, 849, 2897, 1873, 
  3921, 209, 2257, 1233, 3281, 721, 2769, 1745, 3793, 465, 2513, 1489, 3537, 
  977, 3025, 2001, 4049, 49, 2097, 1073, 3121, 561, 2609, 1585, 3633, 305, 
  2353, 1329, 3377, 817, 2865, 1841, 3889, 177, 2225, 1201, 3249, 689, 2737, 
  1713, 3761, 433, 2481, 1457, 3505, 945, 2993, 1969, 4017, 113, 2161, 1137, 
  3185, 625, 2673, 1649, 3697, 369, 2417, 1393, 3441, 881, 2929, 1905, 3953, 
  241, 2289, 1265, 3313, 753, 2801, 1777, 3825, 497, 2545, 1521, 3569, 1009, 
  3057, 2033, 4081, 9, 2057, 1033, 3081, 521, 2569, 1545, 3593, 265, 2313, 
  1289, 3337, 777, 2825, 1801, 3849, 137, 2185, 1161, 3209, 649, 2697, 1673, 
  3721, 393, 2441, 1417, 3465, 905, 2953, 1929, 3977, 73, 2121, 1097, 3145, 
  585, 2633, 1609, 3657, 329, 2377, 1353, 3401, 841, 2889, 1865, 3913, 201, 
  2249, 1225, 3273, 713, 2761, 1737, 3785, 457, 2505, 1481, 3529, 969, 3017, 
  1993, 4041, 41, 2089, 1065, 3113, 553, 2601, 1577, 3625, 297, 2345, 1321, 
  3369, 809, 2857, 1833, 3881, 169, 2217, 1193, 3241, 681, 2729, 1705, 3753, 
  425, 2473, 1449, 3497, 937, 2985, 1961, 4009, 105, 2153, 1129, 3177, 617, 
  2665, 1641, 3689, 361, 2409, 1385, 3433, 873, 2921, 1897, 3945, 233, 2281, 
  1257, 3305, 745, 2793, 1769, 3817, 489, 2537, 1513, 3561, 1001, 3049, 2025, 
  4073, 25, 2073, 1049, 3097, 537, 2585, 1561, 3609, 281, 2329, 1305, 3353, 
  793, 2841, 1817, 3865, 153, 2201, 1177, 3225, 665, 2713, 1689, 3737, 409, 
  2457, 1433, 3481, 921, 2969, 1945, 3993, 89, 2137, 1113, 3161, 601, 2649, 
  1625, 3673, 345, 2393, 1369, 3417, 857, 2905, 1881, 3929, 217, 2265, 1241, 
  3289, 729, 2777, 1753, 3801, 473, 2521, 1497, 3545, 985, 3033, 2009, 4057, 
  57, 2105, 1081, 3129, 569, 2617, 1593, 3641, 313, 2361, 1337, 3385, 825, 
  2873, 1849, 3897, 185, 2233, 1209, 3257, 697, 2745, 1721, 3769, 441, 2489, 
  1465, 3513, 953, 3001, 1977, 4025, 121, 2169, 1145, 3193, 633, 2681, 1657, 
  3705, 377, 2425, 1401, 3449, 889, 2937, 1913, 3961, 249, 2297, 1273, 3321, 
  761, 2809, 1785, 3833, 505, 2553, 1529, 3577, 1017, 3065, 2041, 4089, 5, 
  2053, 1029, 3077, 517, 2565, 1541, 3589, 261, 2309, 1285, 3333, 773, 2821, 
  1797, 3845, 133, 2181, 1157, 3205, 645, 2693, 1669, 3717, 389, 2437, 1413, 
  3461, 901, 2949, 1925, 3973, 69, 2117, 1093, 3141, 581, 2629, 1605, 3653, 
  325, 2373, 1349, 3397, 837, 2885, 1861, 3909, 197, 2245, 1221, 3269, 709, 
  2757, 1733, 3781, 453, 2501, 1477, 3525, 965, 3013, 1989, 4037, 37, 2085, 
  1061, 3109, 549, 2597, 1573, 3621, 293, 2341, 1317, 3365, 805, 2853, 1829, 
  3877, 165, 2213, 1189, 3237, 677, 2725, 1701, 3749, 421, 2469, 1445, 3493, 
  933, 2981, 1957, 4005, 101, 2149, 1125, 3173, 613, 2661, 1637, 3685, 357, 
  2405, 1381, 3429, 869, 2917, 1893, 3941, 229, 2277, 1253, 3301, 741, 2789, 
  1765, 3813, 485, 2533, 1509, 3557, 997, 3045, 2021, 4069, 21, 2069, 1045, 
  3093, 533, 2581, 1557, 3605, 277, 2325, 1301, 3349, 789, 2837, 1813, 3861, 
  149, 2197, 1173, 3221, 661, 2709, 1685, 3733, 405, 2453, 1429, 3477, 917, 
  2965, 1941, 3989, 85, 2133, 1109, 3157, 597, 2645, 1621, 3669, 341, 2389, 
  1365, 3413, 853, 2901, 1877, 3925, 213, 2261, 1237, 3285, 725, 2773, 1749, 
  3797, 469, 2517, 1493, 3541, 981, 3029, 2005, 4053, 53, 2101, 1077, 3125, 
  565, 2613, 1589, 3637, 309, 2357, 1333, 3381, 821, 2869, 1845, 3893, 181, 
  2229, 1205, 3253, 693, 2741, 1717, 3765, 437, 2485, 1461, 3509, 949, 2997, 
  1973, 4021, 117, 2165, 1141, 3189, 629, 2677, 1653, 3701, 373, 2421, 1397, 
  3445, 885, 2933, 1909, 3957, 245, 2293, 1269, 3317, 757, 2805, 1781, 3829, 
  501, 2549, 1525, 3573, 1013, 3061, 2037, 4085, 13, 2061, 1037, 3085, 525, 
  2573, 1549, 3597, 269, 2317, 1293, 3341, 781, 2829, 1805, 3853, 141, 2189, 
  1165, 3213, 653, 2701, 1677, 3725, 397, 2445, 1421, 3469, 909, 2957, 1933, 
  3981, 77, 2125, 1101, 3149, 589, 2637, 1613, 3661, 333, 2381, 1357, 3405, 
  845, 2893, 1869, 3917, 205, 2253, 1229, 3277, 717, 2765, 1741, 3789, 461, 
  2509, 1485, 3533, 973, 3021, 1997, 4045, 45, 2093, 1069, 3117, 557, 2605, 
  1581, 3629, 301, 2349, 1325, 3373, 813, 2861, 1837, 3885, 173, 2221, 1197, 
  3245, 685, 2733, 1709, 3757, 429, 2477, 1453, 3501, 941, 2989, 1965, 4013, 
  109, 2157, 1133, 3181, 621, 2669, 1645, 3693, 365, 2413, 1389, 3437, 877, 
  2925, 1901, 3949, 237, 2285, 1261, 3309, 749, 2797, 1773, 3821, 493, 2541, 
  1517, 3565, 1005, 3053, 2029, 4077, 29, 2077, 1053, 3101, 541, 2589, 1565, 
  3613, 285, 2333, 1309, 3357, 797, 2845, 1821, 3869, 157, 2205, 1181, 3229, 
  669, 2717, 1693, 3741, 413, 2461, 1437, 3485, 925, 2973, 1949, 3997, 93, 
  2141, 1117, 3165, 605, 2653, 1629, 3677, 349, 2397, 1373, 3421, 861, 2909, 
  1885, 3933, 221, 2269, 1245, 3293, 733, 2781, 1757, 3805, 477, 2525, 1501, 
  3549, 989, 3037, 2013, 4061, 61, 2109, 1085, 3133, 573, 2621, 1597, 3645, 
  317, 2365, 1341, 3389, 829, 2877, 1853, 3901, 189, 2237, 1213, 3261, 701, 
  2749, 1725, 3773, 445, 2493, 1469, 3517, 957, 3005, 1981, 4029, 125, 2173, 
  1149, 3197, 637, 2685, 1661, 3709, 381, 2429, 1405, 3453, 893, 2941, 1917, 
  3965, 253, 2301, 1277, 3325, 765, 2813, 1789, 3837, 509, 2557, 1533, 3581, 
  1021, 3069, 2045, 4093, 3, 2051, 1027, 3075, 515, 2563, 1539, 3587, 259, 
  2307, 1283, 3331, 771, 2819, 1795, 3843, 131, 2179, 1155, 3203, 643, 2691, 
  1667, 3715, 387, 2435, 1411, 3459, 899, 2947, 1923, 3971, 67, 2115, 1091, 
  3139, 579, 2627, 1603, 3651, 323, 2371, 1347, 3395, 835, 2883, 1859, 3907, 
  195, 2243, 1219, 3267, 707, 2755, 1731, 3779, 451, 2499, 1475, 3523, 963, 
  3011, 1987, 4035, 35, 2083, 1059, 3107, 547, 2595, 1571, 3619, 291, 2339, 
  1315, 3363, 803, 2851, 1827, 3875, 163, 2211, 1187, 3235, 675, 2723, 1699, 
  3747, 419, 2467, 1443, 3491, 931, 2979, 1955, 4003, 99, 2147, 1123, 3171, 
  611, 2659, 1635, 3683, 355, 2403, 1379, 3427, 867, 2915, 1891, 3939, 227, 
  2275, 1251, 3299, 739, 2787, 1763, 3811, 483, 2531, 1507, 3555, 995, 3043, 
  2019, 4067, 19, 2067, 1043, 3091, 531, 2579, 1555, 3603, 275, 2323, 1299, 
  3347, 787, 2835, 1811, 3859, 147, 2195, 1171, 3219, 659, 2707, 1683, 3731, 
  403, 2451, 1427, 3475, 915, 2963, 1939, 3987, 83, 2131, 1107, 3155, 595, 
  2643, 1619, 3667, 339, 2387, 1363, 3411, 851, 2899, 1875, 3923, 211, 2259, 
  1235, 3283, 723, 2771, 1747, 3795, 467, 2515, 1491, 3539, 979, 3027, 2003, 
  4051, 51, 2099, 1075, 3123, 563, 2611, 1587, 3635, 307, 2355, 1331, 3379, 
  819, 2867, 1843, 3891, 179, 2227, 1203, 3251, 691, 2739, 1715, 3763, 435, 
  2483, 1459, 3507, 947, 2995, 1971, 4019, 115, 2163, 1139, 3187, 627, 2675, 
  1651, 3699, 371, 2419, 1395, 3443, 883, 2931, 1907, 3955, 243, 2291, 1267, 
  3315, 755, 2803, 1779, 3827, 499, 2547, 1523, 3571, 1011, 3059, 2035, 4083, 
  11, 2059, 1035, 3083, 523, 2571, 1547, 3595, 267, 2315, 1291, 3339, 779, 
  2827, 1803, 3851, 139, 2187, 1163, 3211, 651, 2699, 1675, 3723, 395, 2443, 
  1419, 3467, 907, 2955, 1931, 3979, 75, 2123, 1099, 3147, 587, 2635, 1611, 
  3659, 331, 2379, 1355, 3403, 843, 2891, 1867, 3915, 203, 2251, 1227, 3275, 
  715, 2763, 1739, 3787, 459, 2507, 1483, 3531, 971, 3019, 1995, 4043, 43, 
  2091, 1067, 3115, 555, 2603, 1579, 3627, 299, 2347, 1323, 3371, 811, 2859, 
  1835, 3883, 171, 2219, 1195, 3243, 683, 2731, 1707, 3755, 427, 2475, 1451, 
  3499, 939, 2987, 1963, 4011, 107, 2155, 1131, 3179, 619, 2667, 1643, 3691, 
  363, 2411, 1387, 3435, 875, 2923, 1899, 3947, 235, 2283, 1259, 3307, 747, 
  2795, 1771, 3819, 491, 2539, 1515, 3563, 1003, 3051, 2027, 4075, 27, 2075, 
  1051, 3099, 539, 2587, 1563, 3611, 283, 2331, 1307, 3355, 795, 2843, 1819, 
  3867, 155, 2203, 1179, 3227, 667, 2715, 1691, 3739, 411, 2459, 1435, 3483, 
  923, 2971, 1947, 3995, 91, 2139, 1115, 3163, 603, 2651, 1627, 3675, 347, 
  2395, 1371, 3419, 859, 2907, 1883, 3931, 219, 2267, 1243, 3291, 731, 2779, 
  1755, 3803, 475, 2523, 1499, 3547, 987, 3035, 2011, 4059, 59, 2107, 1083, 
  3131, 571, 2619, 1595, 3643, 315, 2363, 1339, 3387, 827, 2875, 1851, 3899, 
  187, 2235, 1211, 3259, 699, 2747, 1723, 3771, 443, 2491, 1467, 3515, 955, 
  3003, 1979, 4027, 123, 2171, 1147, 3195, 635, 2683, 1659, 3707, 379, 2427, 
  1403, 3451, 891, 2939, 1915, 3963, 251, 2299, 1275, 3323, 763, 2811, 1787, 
  3835, 507, 2555, 1531, 3579, 1019, 3067, 2043, 4091, 7, 2055, 1031, 3079, 
  519, 2567, 1543, 3591, 263, 2311, 1287, 3335, 775, 2823, 1799, 3847, 135, 
  2183, 1159, 3207, 647, 2695, 1671, 3719, 391, 2439, 1415, 3463, 903, 2951, 
  1927, 3975, 71, 2119, 1095, 3143, 583, 2631, 1607, 3655, 327, 2375, 1351, 
  3399, 839, 2887, 1863, 3911, 199, 2247, 1223, 3271, 711, 2759, 1735, 3783, 
  455, 2503, 1479, 3527, 967, 3015, 1991, 4039, 39, 2087, 1063, 3111, 551, 
  2599, 1575, 3623, 295, 2343, 1319, 3367, 807, 2855, 1831, 3879, 167, 2215, 
  1191, 3239, 679, 2727, 1703, 3751, 423, 2471, 1447, 3495, 935, 2983, 1959, 
  4007, 103, 2151, 1127, 3175, 615, 2663, 1639, 3687, 359, 2407, 1383, 3431, 
  871, 2919, 1895, 3943, 231, 2279, 1255, 3303, 743, 2791, 1767, 3815, 487, 
  2535, 1511, 3559, 999, 3047, 2023, 4071, 23, 2071, 1047, 3095, 535, 2583, 
  1559, 3607, 279, 2327, 1303, 3351, 791, 2839, 1815, 3863, 151, 2199, 1175, 
  3223, 663, 2711, 1687, 3735, 407, 2455, 1431, 3479, 919, 2967, 1943, 3991, 
  87, 2135, 1111, 3159, 599, 2647, 1623, 3671, 343, 2391, 1367, 3415, 855, 
  2903, 1879, 3927, 215, 2263, 1239, 3287, 727, 2775, 1751, 3799, 471, 2519, 
  1495, 3543, 983, 3031, 2007, 4055, 55, 2103, 1079, 3127, 567, 2615, 1591, 
  3639, 311, 2359, 1335, 3383, 823, 2871, 1847, 3895, 183, 2231, 1207, 3255, 
  695, 2743, 1719, 3767, 439, 2487, 1463, 3511, 951, 2999, 1975, 4023, 119, 
  2167, 1143, 3191, 631, 2679, 1655, 3703, 375, 2423, 1399, 3447, 887, 2935, 
  1911, 3959, 247, 2295, 1271, 3319, 759, 2807, 1783, 3831, 503, 2551, 1527, 
  3575, 1015, 3063, 2039, 4087, 15, 2063, 1039, 3087, 527, 2575, 1551, 3599, 
  271, 2319, 1295, 3343, 783, 2831, 1807, 3855, 143, 2191, 1167, 3215, 655, 
  2703, 1679, 3727, 399, 2447, 1423, 3471, 911, 2959, 1935, 3983, 79, 2127, 
  1103, 3151, 591, 2639, 1615, 3663, 335, 2383, 1359, 3407, 847, 2895, 1871, 
  3919, 207, 2255, 1231, 3279, 719, 2767, 1743, 3791, 463, 2511, 1487, 3535, 
  975, 3023, 1999, 4047, 47, 2095, 1071, 3119, 559, 2607, 1583, 3631, 303, 
  2351, 1327, 3375, 815, 2863, 1839, 3887, 175, 2223, 1199, 3247, 687, 2735, 
  1711, 3759, 431, 2479, 1455, 3503, 943, 2991, 1967, 4015, 111, 2159, 1135, 
  3183, 623, 2671, 1647, 3695, 367, 2415, 1391, 3439, 879, 2927, 1903, 3951, 
  239, 2287, 1263, 3311, 751, 2799, 1775, 3823, 495, 2543, 1519, 3567, 1007, 
  3055, 2031, 4079, 31, 2079, 1055, 3103, 543, 2591, 1567, 3615, 287, 2335, 
  1311, 3359, 799, 2847, 1823, 3871, 159, 2207, 1183, 3231, 671, 2719, 1695, 
  3743, 415, 2463, 1439, 3487, 927, 2975, 1951, 3999, 95, 2143, 1119, 3167, 
  607, 2655, 1631, 3679, 351, 2399, 1375, 3423, 863, 2911, 1887, 3935, 223, 
  2271, 1247, 3295, 735, 2783, 1759, 3807, 479, 2527, 1503, 3551, 991, 3039, 
  2015, 4063, 63, 2111, 1087, 3135, 575, 2623, 1599, 3647, 319, 2367, 1343, 
  3391, 831, 2879, 1855, 3903, 191, 2239, 1215, 3263, 703, 2751, 1727, 3775, 
  447, 2495, 1471, 3519, 959, 3007, 1983, 4031, 127, 2175, 1151, 3199, 639, 
  2687, 1663, 3711, 383, 2431, 1407, 3455, 895, 2943, 1919, 3967, 255, 2303, 
  1279, 3327, 767, 2815, 1791, 3839, 511, 2559, 1535, 3583, 1023, 3071, 2047, 
  4095};

/************************************************************************/
static const int *ptable(int n)
{
  switch (n)
    {
    case 2: return p2;
    case 4: return p4;
    case 8: return p8;
    case 16: return p16;
    case 32: return p32;
    case 64: return p64;
    case 128: return p128;
    case 256: return p256;
    case 512: return p512;
    case 1024: return p1024;
    case 2048: return p2048;
    case 4096: return p4096;
    default: return 0;
    }
}
/************************************************************************/
/* performs a bit-reversal on the data, a double array of size n */
/* Needs workspace of size n */

void bitreverse(double *data,
		int n,
		double *workspace)
{
  
  int i;
  const int *perm;

  perm = ptable(n);
  
  for (i=0; i<n; i++)
    workspace[i] = data[perm[i]];

  memcpy(data, workspace, sizeof(double) * n);

}

