/***************************************************************************
  **************************************************************************
    
  Spherical Harmonic Transform Kit 2.7
    
  Copyright 1997-2003  Sean Moore, Dennis Healy,
                       Dan Rockmore, Peter Kostelec
  Copyright 2004  Peter Kostelec, Dan Rockmore

  This file is part of SpharmonicKit.

  SpharmonicKit is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  SpharmonicKit is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
  See the accompanying LICENSE file for details.

  ************************************************************************
  ************************************************************************/

/****

  OUR supermoduli arrays used in FCTs. See Sean's
  thesis for details. The interface function (defined at the
  bottom of this file) is

  const double *get_mods(int n)

  ****/

static const double mod2[2] = {-0.7071067811865475, 0.7071067811865475};

static const double mod4[4] = 
{-0.923879532511287, 0.923879532511287, 0.3826834323650897, 
  -0.3826834323650898};

static const double mod8[8] = 
{-0.98078528040323, 0.98078528040323, 0.1950903220161282, 
  -0.1950903220161283, -0.5555702330196023, 0.555570233019602, 
  0.831469612302545, -0.831469612302545};

static const double mod16[16] = 
{-0.995184726672197, 0.995184726672197, 0.0980171403295607, 
  -0.0980171403295608, -0.6343932841636457, 0.6343932841636453, 
  0.7730104533627369, -0.773010453362737, -0.881921264348355, 
  0.881921264348355, 0.4713967368259978, -0.4713967368259978, 
  -0.2902846772544623, 0.2902846772544622, 0.956940335732209, 
  -0.956940335732209};

static const double mod32[32] =
{-0.998795456205172, 0.998795456205172, 0.04906767432741801, 
  -0.04906767432741814, -0.6715589548470185, 0.6715589548470185, 
  0.7409511253549589, -0.7409511253549593, -0.903989293123443, 
  0.903989293123443, 0.4275550934302819, -0.4275550934302822, 
  -0.33688985339222, 0.3368898533922199, 0.941544065183021, 
  -0.941544065183021, -0.970031253194544, 0.970031253194544, 
  0.2429801799032639, -0.242980179903264, -0.5141027441932219, 
  0.5141027441932216, 0.857728610000272, -0.857728610000272, 
  -0.803207531480645, 0.803207531480645, 0.5956993044924333, 
  -0.5956993044924336, -0.1467304744553617, 0.1467304744553616, 
  0.989176509964781, -0.989176509964781};

static const double mod64[64] =
{-0.999698818696204, 0.999698818696204, 0.02454122852291214, 
  -0.02454122852291227, -0.689540544737067, 0.6895405447370669, 
  0.7242470829514668, -0.7242470829514671, -0.914209755703531, 
  0.914209755703531, 0.4052413140049898, -0.4052413140049899, 
  -0.3598950365349883, 0.3598950365349882, 0.932992798834739, 
  -0.932992798834739, -0.975702130038529, 0.975702130038528, 
  0.2191012401568697, -0.2191012401568698, -0.5349976198870974, 
  0.534997619887097, 0.844853565249707, -0.844853565249707, 
  -0.817584813151584, 0.817584813151584, 0.5758081914178454, 
  -0.5758081914178455, -0.1709618887603014, 0.1709618887603012, 
  0.985277642388941, -0.985277642388941, -0.99247953459871, 0.99247953459871, 
  0.1224106751992162, -0.1224106751992163, -0.6152315905806269, 
  0.6152315905806267, 0.7883464276266061, -0.7883464276266064, 
  -0.870086991108711, 0.870086991108711, 0.492898192229784, 
  -0.4928981922297842, -0.2667127574748984, 0.2667127574748983, 
  0.96377606579544, -0.96377606579544, -0.949528180593037, 0.949528180593037, 
  0.3136817403988914, -0.3136817403988915, -0.4496113296546067, 
  0.4496113296546067, 0.893224301195515, -0.893224301195515, 
  -0.7572088465064847, 0.7572088465064847, 0.6531728429537766, 
  -0.6531728429537769, -0.07356456359966746, 0.07356456359966735, 
  0.99729045667869, -0.99729045667869};

static const double mod128[128] =
{-0.999924701839145, 0.999924701839145, 0.01227153828571982, 
  -0.01227153828571994, -0.698376249408973, 0.6983762494089728, 
  0.7157308252838185, -0.7157308252838188, -0.919113851690058, 
  0.919113851690058, 0.393992040061048, -0.3939920400610481, 
  -0.3713171939518376, 0.3713171939518375, 0.928506080473215, 
  -0.928506080473215, -0.978317370719628, 0.978317370719628, 
  0.2071113761922184, -0.2071113761922186, -0.5453249884220466, 
  0.5453249884220462, 0.838224705554838, -0.838224705554838, 
  -0.824589302785025, 0.824589302785025, 0.5657318107836132, 
  -0.5657318107836132, -0.183039887955141, 0.1830398879551409, 
  0.983105487431216, -0.983105487431216, -0.993906970002356, 
  0.993906970002356, 0.1102222072938831, -0.1102222072938832, 
  -0.6248594881423865, 0.6248594881423863, 0.7807372285720944, 
  -0.7807372285720945, -0.876070094195407, 0.876070094195407, 
  0.4821837720791227, -0.4821837720791229, -0.278519689385053, 
  0.278519689385053, 0.960430519415566, -0.960430519415566, 
  -0.953306040354194, 0.953306040354194, 0.3020059493192281, 
  -0.3020059493192282, -0.4605387109582401, 0.4605387109582402, 
  0.887639620402854, -0.887639620402854, -0.765167265622459, 
  0.765167265622459, 0.6438315428897913, -0.6438315428897915, 
  -0.0857973123444399, 0.0857973123444398, 0.996312612182778, 
  -0.996312612182778, -0.998118112900149, 0.998118112900149, 
  0.06132073630220854, -0.06132073630220866, -0.6624157775901719, 
  0.6624157775901719, 0.7491363945234591, -0.7491363945234594, 
  -0.898674465693954, 0.898674465693954, 0.4386162385385274, 
  -0.4386162385385277, -0.325310292162263, 0.3253102921622629, 
  0.945607325380521, -0.945607325380521, -0.966976471044852, 
  0.966976471044852, 0.2548656596045145, -0.2548656596045146, 
  -0.5035383837257176, 0.5035383837257175, 0.863972856121587, 
  -0.863972856121587, -0.7958369046088836, 0.7958369046088835, 
  0.6055110414043254, -0.6055110414043256, -0.1345807085071262, 
  0.1345807085071261, 0.99090263542778, -0.99090263542778, 
  -0.987301418157858, 0.987301418157858, 0.1588581433338613, 
  -0.1588581433338614, -0.5857978574564389, 0.5857978574564389, 
  0.810457198252595, -0.810457198252595, -0.851355193105265, 
  0.851355193105265, 0.5245896826784687, -0.524589682678469, 
  -0.2310581082806713, 0.2310581082806711, 0.97293995220556, 
  -0.97293995220556, -0.937339011912575, 0.937339011912575, 
  0.3484186802494344, -0.3484186802494345, -0.4164295600976374, 
  0.416429560097637, 0.909167983090523, -0.909167983090523, 
  -0.7326542716724129, 0.7326542716724127, 0.6806009977954531, 
  -0.6806009977954531, -0.03680722294135899, 0.03680722294135887, 
  0.99932238458835, -0.99932238458835};

static const double mod256[256] =
{-0.999981175282601, 0.999981175282601, 0.006135884649154394, 
  -0.006135884649154516, -0.7027547444572254, 0.7027547444572252, 
  0.7114321957452165, -0.7114321957452165, -0.921514039342042, 
  0.921514039342042, 0.3883450466988262, -0.3883450466988263, 
  -0.3770074102164183, 0.3770074102164182, 0.926210242138311, 
  -0.926210242138311, -0.97956976568544, 0.97956976568544, 
  0.2011046348420918, -0.2011046348420919, -0.5504579729366049, 
  0.5504579729366048, 0.83486287498638, -0.83486287498638, 
  -0.828045045257756, 0.828045045257756, 0.5606615761973359, 
  -0.5606615761973361, -0.1890686641498063, 0.1890686641498062, 
  0.981963869109555, -0.981963869109555, -0.994564570734255, 
  0.994564570734255, 0.1041216338720546, -0.1041216338720547, 
  -0.6296382389149271, 0.629638238914927, 0.7768884656732322, 
  -0.7768884656732325, -0.879012226428634, 0.879012226428634, 
  0.476799230063322, -0.4767992300633223, -0.2844075372112718, 
  0.2844075372112717, 0.958703474895872, -0.958703474895872, 
  -0.955141168305771, 0.955141168305771, 0.2961508882436238, 
  -0.2961508882436239, -0.4659764957679661, 0.465976495767966, 
  0.884797098430938, -0.884797098430938, -0.7691033376455798, 
  0.7691033376455795, 0.6391244448637758, -0.6391244448637759, 
  -0.0919089564971327, 0.0919089564971326, 0.99576741446766, 
  -0.99576741446766, -0.998475580573295, 0.998475580573295, 
  0.05519524434968992, -0.05519524434969004, -0.6669999223036376, 
  0.6669999223036374, 0.7450577854414659, -0.7450577854414661, 
  -0.901348847046022, 0.901348847046022, 0.433093818853152, 
  -0.433093818853152, -0.3311063057598764, 0.3311063057598763, 
  0.94359345816196, -0.94359345816196, -0.968522094274417, 0.968522094274417, 
  0.2489276057457201, -0.2489276057457203, -0.5088301425431072, 
  0.5088301425431072, 0.860866938637767, -0.860866938637767, 
  -0.799537269107905, 0.799537269107905, 0.6006164793838687, 
  -0.600616479383869, -0.1406582393328492, 0.1406582393328491, 
  0.990058210262297, -0.990058210262297, -0.988257567730749, 
  0.988257567730749, 0.1527971852584433, -0.1527971852584434, 
  -0.5907597018588743, 0.5907597018588741, 0.806847553543799, 
  -0.806847553543799, -0.8545579883654, 0.8545579883654, 0.5193559901655897, 
  -0.5193559901655897, -0.2370236059943673, 0.2370236059943672, 
  0.971503890986252, -0.971503890986252, -0.93945922360219, 0.93945922360219, 
  0.3426607173119943, -0.3426607173119944, -0.4220002707997998, 
  0.4220002707997998, 0.906595704514915, -0.906595704514915, 
  -0.7368165688773699, 0.7368165688773698, 0.6760927035753159, 
  -0.6760927035753161, -0.04293825693494096, 0.04293825693494084, 
  0.999077727752645, -0.999077727752645, -0.999529417501093, 
  0.999529417501093, 0.03067480317663646, -0.03067480317663658, 
  -0.6850836677727005, 0.6850836677727001, 0.7284643904482252, 
  -0.7284643904482254, -0.91170603200543, 0.91170603200543, 
  0.4108431710579038, -0.4108431710579039, -0.3541635254204905, 
  0.3541635254204904, 0.935183509938948, -0.935183509938948, 
  -0.974339382785576, 0.974339382785576, 0.2250839113597927, 
  -0.2250839113597927, -0.5298036246862949, 0.5298036246862946, 
  0.848120344803297, -0.848120344803297, -0.814036329705948, 
  0.814036329705948, 0.5808139580957644, -0.5808139580957647, 
  -0.1649131204899701, 0.1649131204899699, 0.986308097244599, 
  -0.986308097244599, -0.9917097536691, 0.9917097536691, 0.1284981107937931, 
  -0.1284981107937932, -0.6103828062763095, 0.6103828062763095, 
  0.7921065773002122, -0.7921065773002124, -0.867046245515693, 
  0.867046245515693, 0.4982276669727816, -0.498227666972782, 
  -0.2607941179152756, 0.2607941179152755, 0.965394441697689, 
  -0.96539444169769, -0.947585591017741, 0.947585591017741, 
  0.3195020308160156, -0.3195020308160157, -0.4441221445704293, 
  0.4441221445704292, 0.895966249756185, -0.895966249756185, 
  -0.7531867990436126, 0.7531867990436125, 0.6578066932970785, 
  -0.6578066932970788, -0.06744391956366412, 0.067443919563664, 
  0.997723066644192, -0.997723066644192, -0.996820299291166, 
  0.996820299291166, 0.07968243797143002, -0.07968243797143014, 
  -0.6485144010221126, 0.6485144010221124, 0.7612023854842617, 
  -0.7612023854842618, -0.890448723244758, 0.890448723244758, 
  0.4550835871263438, -0.4550835871263439, -0.307849640041535, 
  0.3078496400415349, 0.951435020969008, -0.951435020969008, 
  -0.962121404269042, 0.962121404269042, 0.2726213554499488, 
  -0.272621355449949, -0.4875501601484361, 0.4875501601484357, 
  0.87309497841829, -0.87309497841829, -0.7845565971555754, 
  0.7845565971555751, 0.6200572117632892, -0.6200572117632892, 
  -0.1163186309119049, 0.1163186309119047, 0.993211949234795, 
  -0.993211949234795, -0.984210092386929, 0.984210092386929, 
  0.1770042204121487, -0.1770042204121489, -0.5707807458869674, 
  0.5707807458869672, 0.821102514991105, -0.821102514991105, 
  -0.841554977436898, 0.841554977436898, 0.5401714727298929, 
  -0.540171472729893, -0.2131103199160913, 0.2131103199160913, 
  0.977028142657754, -0.977028142657754, -0.930766961078984, 
  0.930766961078984, 0.3656129978047739, -0.365612997804774, 
  -0.3996241998456468, 0.3996241998456467, 0.916679059921043, 
  -0.916679059921043, -0.7200025079613816, 0.7200025079613816, 
  0.6939714608896538, -0.693971460889654, -0.01840672990580482, 
  0.01840672990580469, 0.999830581795824, -0.999830581795823};

static const double mod512[512] = 
{-0.999995293809576, 0.999995293809576, 0.003067956762966015, 
  -0.003067956762966138, -0.704934080375905, 0.7049340803759049, 
  0.7092728264388655, -0.7092728264388657, -0.922701128333879, 
  0.922701128333879, 0.3855160538439189, -0.385516053843919, 
  -0.3798472089240511, 0.379847208924051, 0.925049240782677, 
  -0.925049240782677, -0.980182135968117, 0.980182135968117, 
  0.1980984107179536, -0.1980984107179537, -0.5530167055800276, 
  0.5530167055800274, 0.833170164701913, -0.833170164701913, 
  -0.829761233794523, 0.829761233794523, 0.5581185312205561, 
  -0.5581185312205563, -0.1920803970498924, 0.1920803970498923, 
  0.981379193313755, -0.981379193313755, -0.994879330794806, 
  0.994879330794806, 0.1010698627548277, -0.1010698627548278, 
  -0.6320187359398091, 0.632018735939809, 0.7749531065948739, 
  -0.7749531065948739, -0.880470889052161, 0.880470889052161, 
  0.47410021465055, -0.4741002146505501, -0.2873474595447296, 
  0.2873474595447294, 0.957826413027533, -0.957826413027533, 
  -0.956045251349996, 0.956045251349996, 0.2932191626942586, 
  -0.2932191626942587, -0.468688822035828, 0.4686888220358278, 
  0.883363338665732, -0.883363338665732, -0.7710605242618139, 
  0.7710605242618135, 0.6367618612362844, -0.6367618612362844, 
  -0.0949634953296391, 0.0949634953296389, 0.995480755491927, 
  -0.995480755491927, -0.998640218180265, 0.998640218180265, 
  0.05213170468028319, -0.05213170468028333, -0.6692825883466362, 
  0.6692825883466358, 0.7430079521351218, -0.7430079521351218, 
  -0.902673318237259, 0.902673318237259, 0.4303264813400828, 
  -0.4303264813400827, -0.3339996514420095, 0.3339996514420094, 
  0.942573197601447, -0.942573197601447, -0.969281235356549, 
  0.969281235356549, 0.2459550503357945, -0.2459550503357946, 
  -0.5114688504379706, 0.5114688504379704, 0.859301818357008, 
  -0.859301818357008, -0.80137617172314, 0.80137617172314, 
  0.5981607069963422, -0.5981607069963424, -0.1436950331502946, 
  0.1436950331502945, 0.989622017463201, -0.989622017463201, 
  -0.988721691960324, 0.988721691960324, 0.1497645346773215, 
  -0.1497645346773216, -0.5932322950397998, 0.5932322950397998, 
  0.805031331142964, -0.805031331142964, -0.856147328375194, 
  0.856147328375195, 0.5167317990176496, -0.51673179901765, 
  -0.2400030224487415, 0.2400030224487414, 0.97077214072895, 
  -0.97077214072895, -0.940506070593268, 0.940506070593268, 
  0.3397768844068269, -0.339776884406827, -0.4247796812091088, 
  0.4247796812091088, 0.905296759318119, -0.905296759318119, 
  -0.7388873244606151, 0.738887324460615, 0.6738290003787561, 
  -0.6738290003787562, -0.04600318213091465, 0.04600318213091452, 
  0.998941293186857, -0.998941293186857, -0.999618822495179, 
  0.999618822495179, 0.02760814577896569, -0.02760814577896582, 
  -0.6873153408917592, 0.6873153408917592, 0.7263591550843458, 
  -0.726359155084346, -0.912962190428398, 0.912962190428398, 
  0.4080441628649786, -0.4080441628649788, -0.35703096123343, 
  0.35703096123343, 0.934092550404259, -0.934092550404259, 
  -0.975025345066994, 0.975025345066994, 0.2220936209732035, 
  -0.2220936209732036, -0.5324031278771981, 0.5324031278771978, 
  0.846490938774052, -0.846490938774052, -0.815814410806734, 
  0.815814410806734, 0.5783137964116555, -0.5783137964116556, 
  -0.1679382949747312, 0.1679382949747311, 0.985797509167568, 
  -0.985797509167568, -0.992099313142192, 0.992099313142192, 
  0.1254549834115461, -0.1254549834115462, -0.6128100824294097, 
  0.6128100824294097, 0.79023022143731, -0.7902302214373102, 
  -0.868570705971341, 0.868570705971341, 0.4955652618257723, 
  -0.4955652618257726, -0.2637546789748315, 0.2637546789748314, 
  0.964589793289813, -0.964589793289813, -0.94856134991573, 0.94856134991573, 
  0.3165933755561658, -0.3165933755561658, -0.4468688401623744, 
  0.446868840162374, 0.894599485631383, -0.894599485631383, 
  -0.7552013768965366, 0.7552013768965363, 0.6554928529996154, 
  -0.6554928529996155, -0.07050457338961401, 0.07050457338961391, 
  0.997511456140303, -0.997511456140303, -0.997060070339483, 
  0.997060070339483, 0.0766238613920315, -0.07662386139203161, 
  -0.650846684996381, 0.6508466849963808, 0.759209188978388, 
  -0.7592091889783881, -0.891840709392343, 0.891840709392343, 
  0.452349587233771, -0.452349587233771, -0.3107671527496115, 
  0.3107671527496114, 0.950486073949482, -0.950486073949482, 
  -0.962953266873684, 0.962953266873684, 0.2696683255729151, 
  -0.2696683255729152, -0.4902264832882912, 0.4902264832882912, 
  0.871595086655951, -0.871595086655951, -0.786455213599086, 
  0.7864552135990858, 0.6176473079378038, -0.617647307937804, 
  -0.1193652148109913, 0.1193652148109912, 0.992850414459865, 
  -0.992850414459865, -0.984748501801904, 0.984748501801904, 
  0.1739838733874637, -0.1739838733874639, -0.5732971666980423, 
  0.5732971666980421, 0.819347520076797, -0.819347520076797, 
  -0.843208239641846, 0.843208239641845, 0.5375870762956456, 
  -0.5375870762956456, -0.2161067970762196, 0.2161067970762195, 
  0.976369731330021, -0.976369731330021, -0.931884265581668, 
  0.931884265581668, 0.3627557243673971, -0.3627557243673972, 
  -0.4024346508594185, 0.4024346508594184, 0.915448716088268, 
  -0.915448716088268, -0.7221281939292154, 0.7221281939292153, 
  0.6917592583641577, -0.6917592583641579, -0.02147408027546961, 
  0.02147408027546948, 0.999769405351215, -0.999769405351215, 
  -0.999882347454212, 0.999882347454212, 0.0153392062849881, 
  -0.01533920628498822, -0.6961771314914631, 0.696177131491463, 
  0.7178700450557315, -0.7178700450557317, -0.91790077562139, 
  0.91790077562139, 0.3968099874167103, -0.3968099874167104, 
  -0.3684668299533723, 0.3684668299533722, 0.929640895843181, 
  -0.929640895843181, -0.97767735782451, 0.97767735782451, 
  0.2101118368804696, -0.2101118368804697, -0.542750784864516, 
  0.5427507848645158, 0.839893794195999, -0.839893794195999, 
  -0.822849781375826, 0.822849781375826, 0.5682589526701315, 
  -0.5682589526701316, -0.1800229014056995, 0.1800229014056994, 
  0.98366241921173, -0.98366241921173, -0.993564135520595, 0.993564135520595, 
  0.1132709521775642, -0.1132709521775643, -0.6224612793741501, 
  0.6224612793741499, 0.7826505961665756, -0.7826505961665758, 
  -0.874586652278176, 0.874586652278176, 0.484869248000791, 
  -0.4848692480007912, -0.2755718193109582, 0.2755718193109581, 
  0.961280485811321, -0.961280485811321, -0.952375012719766, 
  0.952375012719766, 0.3049292297354023, -0.3049292297354023, 
  -0.4578133035988773, 0.4578133035988771, 0.889048355854665, 
  -0.889048355854665, -0.7631884172633815, 0.7631884172633811, 
  0.6461760129833164, -0.6461760129833164, -0.0827402645493758, 
  0.0827402645493757, 0.996571145790555, -0.996571145790555, 
  -0.997925286198596, 0.997925286198596, 0.06438263092985731, 
  -0.06438263092985741, -0.6601143420674206, 0.6601143420674203, 
  0.7511651319096864, -0.7511651319096865, -0.897324580705418, 
  0.897324580705418, 0.4413712687317167, -0.4413712687317167, 
  -0.3224076788010699, 0.3224076788010699, 0.946600913083284, 
  -0.946600913083284, -0.966190003445412, 0.966190003445412, 
  0.2578311021621588, -0.2578311021621589, -0.5008853826112409, 
  0.5008853826112408, 0.865513624090569, -0.865513624090569, 
  -0.7939754775543372, 0.7939754775543372, 0.6079497849677736, 
  -0.6079497849677738, -0.1315400287028833, 0.1315400287028831, 
  0.991310859846115, -0.991310859846115, -0.986809401814185, 
  0.986809401814186, 0.1618863937801118, -0.1618863937801119, 
  -0.5833086529376984, 0.5833086529376984, 0.812250586585204, 
  -0.812250586585204, -0.849741768000852, 0.849741768000852, 
  0.5271991347819011, -0.5271991347819015, -0.2280720831708858, 
  0.2280720831708857, 0.973644249650812, -0.973644249650812, 
  -0.936265667170278, 0.936265667170278, 0.351292756085567, 
  -0.3512927560855672, -0.4136383122384346, 0.4136383122384345, 
  0.910441292258067, -0.910441292258067, -0.7305627692278276, 
  0.7305627692278275, 0.682845546385248, -0.6828455463852481, 
  -0.03374117185137764, 0.03374117185137751, 0.999430604555462, 
  -0.999430604555462, -0.999204758618364, 0.999204758618364, 
  0.03987292758773972, -0.03987292758773985, -0.6783500431298616, 
  0.6783500431298613, 0.7347388780959636, -0.7347388780959636, 
  -0.907886116487666, 0.907886116487666, 0.4192168883632241, 
  -0.419216888363224, -0.3455413249639891, 0.345541324963989, 
  0.938403534063108, -0.938403534063108, -0.972226497078936, 
  0.972226497078936, 0.2340419585835433, -0.2340419585835435, 
  -0.5219752929371544, 0.5219752929371543, 0.852960604930363, 
  -0.852960604930363, -0.808656181588175, 0.808656181588175, 
  0.5882815482226453, -0.5882815482226454, -0.1558283976542653, 
  0.1558283976542652, 0.987784141644572, -0.987784141644572, 
  -0.990485084256457, 0.990485084256457, 0.1376201215864861, 
  -0.1376201215864862, -0.6030665985403483, 0.6030665985403482, 
  0.7976908409433909, -0.7976908409433912, -0.862423956111041, 
  0.862423956111041, 0.5061866453451551, -0.5061866453451555, 
  -0.2518978181542169, 0.2518978181542168, 0.967753837093476, 
  -0.967753837093476, -0.94460483726148, 0.94460483726148, 
  0.3282098435790925, -0.3282098435790926, -0.4358570799222555, 
  0.4358570799222554, 0.90001589201616, -0.90001589201616, 
  -0.7471006059801803, 0.74710060598018, 0.6647109782033449, 
  -0.6647109782033449, -0.05825826450043574, 0.05825826450043561, 
  0.998301544933893, -0.998301544933893, -0.996044700901252, 
  0.996044700901252, 0.0888535525825246, -0.0888535525825247, 
  -0.6414810128085832, 0.6414810128085831, 0.7671389119358203, 
  -0.7671389119358205, -0.886222530148881, 0.886222530148881, 
  0.4632597835518602, -0.4632597835518603, -0.2990798263080405, 
  0.2990798263080403, 0.954228095109106, -0.954228095109106, 
  -0.959571513081985, 0.959571513081985, 0.2814649379257579, 
  -0.2814649379257581, -0.4794937576601531, 0.4794937576601531, 
  0.877545290207261, -0.877545290207261, -0.778816512381476, 
  0.778816512381476, 0.6272518154951439, -0.6272518154951442, 
  -0.1071724249568089, 0.1071724249568088, 0.994240449453188, 
  -0.994240449453188, -0.982539302287441, 0.982539302287441, 
  0.1860551516634465, -0.1860551516634466, -0.5631993440138343, 
  0.5631993440138339, 0.826321062845663, -0.826321062845664, 
  -0.836547727223512, 0.836547727223512, 0.5478940591731002, 
  -0.5478940591731004, -0.204108966092817, 0.2041089660928169, 
  0.978948175319062, -0.978948175319062, -0.927362525650401, 
  0.927362525650401, 0.3741640629714579, -0.3741640629714579, 
  -0.391170384302254, 0.3911703843022539, 0.920318276709111, 
  -0.920318276709111, -0.7135848687807937, 0.7135848687807936, 
  0.7005687939432482, -0.7005687939432485, -0.00920375478205996, 
  0.00920375478205984, 0.999957644551964, -0.999957644551964};



static const double mod1024[1024] = 
{-0.999998823451702, 0.999998823451702, 0.001533980186284644, 
  -0.001533980186284766, -0.7060212614493399, 0.7060212614493395, 
  0.7081906370331953, -0.7081906370331954, -0.923291416719528, 
  0.923291416719528, 0.3841001950169349, -0.3841001950169351, 
  -0.3812657692221625, 0.3812657692221624, 0.924465474325263, 
  -0.924465474325263, -0.980484861773469, 0.980484861773469, 
  0.1965945976700801, -0.1965945976700802, -0.5542941214536202, 
  0.5542941214536201, 0.83232086776793, -0.83232086776793, 
  -0.830616400308846, 0.830616400308846, 0.5568450372751599, 
  -0.5568450372751603, -0.1935855872958037, 0.1935855872958036, 
  0.981083391150487, -0.981083391150487, -0.995033199438119, 
  0.995033199438119, 0.0995436186600693, -0.0995436186600694, 
  -0.6332067550500574, 0.6332067550500574, 0.7739826906068226, 
  -0.773982690606823, -0.881197113471222, 0.881197113471222, 
  0.4727490319503426, -0.4727490319503429, -0.2888164082060495, 
  0.2888164082060494, 0.957384500788976, -0.957384500788976, 
  -0.956493918902395, 0.956493918902395, 0.2917522632349892, 
  -0.2917522632349894, -0.4700433324595956, 0.4700433324595955, 
  0.882643339979563, -0.882643339979563, -0.7720363971503846, 
  0.7720363971503845, 0.6355783204885562, -0.6355783204885563, 
  -0.0964904313552526, 0.0964904313552525, 0.995333912140482, 
  -0.995333912140482, -0.998719012233873, 0.998719012233873, 
  0.05059974903689922, -0.05059974903689933, -0.6704215603801732, 
  0.670421560380173, 0.7419804117208308, -0.7419804117208311, 
  -0.903332368494512, 0.903332368494512, 0.4289412920553295, 
  -0.4289412920553296, -0.3354451470845317, 0.3354451470845316, 
  0.942059739771017, -0.942059739771017, -0.969657385124292, 
  0.969657385124292, 0.2444679027478241, -0.2444679027478242, 
  -0.5127864006335631, 0.5127864006335628, 0.858516224264443, 
  -0.858516224264443, -0.802292795538116, 0.802292795538116, 
  0.5969307080621965, -0.5969307080621965, -0.1452129246528475, 
  0.1452129246528474, 0.98940042779138, -0.98940042779138, 
  -0.988950264510303, 0.988950264510303, 0.1482476789868961, 
  -0.1482476789868962, -0.5944664991846646, 0.5944664991846642, 
  0.804120377398266, -0.804120377398266, -0.856938977417829, 
  0.856938977417829, 0.5154178780194629, -0.5154178780194632, 
  -0.2414918853028693, 0.2414918853028692, 0.970402838687556, 
  -0.970402838687556, -0.941026175050889, 0.941026175050889, 
  0.3383337669655412, -0.3383337669655413, -0.4261678887267996, 
  0.4261678887267997, 0.904644090578246, -0.904644090578246, 
  -0.7399200954595163, 0.7399200954595161, 0.6726947690707728, 
  -0.6726947690707731, -0.04753548415695926, 0.04753548415695914, 
  0.998869549914284, -0.998869549914284, -0.999659996743959, 
  0.999659996743959, 0.02607471782910391, -0.02607471782910404, 
  -0.6884287527840906, 0.6884287527840903, 0.7253039723730607, 
  -0.7253039723730608, -0.913587047945251, 0.913587047945251, 
  0.406643216870369, -0.4066432168703692, -0.3584634206337365, 
  0.3584634206337364, 0.933543772978836, -0.933543772978836, 
  -0.975364885116657, 0.975364885116657, 0.2205976901088735, 
  -0.2205976901088737, -0.533701001807153, 0.533701001807153, 
  0.845673246987299, -0.845673246987299, -0.816700572866828, 
  0.816700572866828, 0.5770616728556793, -0.5770616728556796, 
  -0.1694502912339679, 0.1694502912339678, 0.985538735312176, 
  -0.985538735312176, -0.992290591348257, 0.992290591348257, 
  0.1239329751185121, -0.1239329751185122, -0.6140215589310385, 
  0.6140215589310382, 0.7892892531688857, -0.7892892531688857, 
  -0.869329871348607, 0.869329871348607, 0.4942323085159598, 
  -0.4942323085159598, -0.2652340302855119, 0.2652340302855118, 
  0.964184063951746, -0.964184063951746, -0.949045881852701, 
  0.949045881852701, 0.3151379287525224, -0.3151379287525224, 
  -0.44824061228522, 0.4482406122852199, 0.893912945145203, 
  -0.893912945145203, -0.7562060014143946, 0.7562060014143945, 
  0.6543336178318003, -0.6543336178318006, -0.07203465324688941, 
  0.07203465324688931, 0.997402129901275, -0.997402129901275, 
  -0.997176436735326, 0.997176436735326, 0.07509430084792117, 
  -0.07509430084792128, -0.6520105310969596, 0.6520105310969595, 
  0.7582099098130152, -0.7582099098130153, -0.892533555402765, 
  0.892533555402765, 0.4509809890451038, -0.4509809890451038, 
  -0.3122248139218251, 0.3122248139218249, 0.950008245001843, 
  -0.950008245001843, -0.963365799780954, 0.963365799780954, 
  0.2681908570634031, -0.2681908570634031, -0.4915629161065502, 
  0.4915629161065497, 0.870842063470079, -0.870842063470079, 
  -0.7874017470290315, 0.7874017470290312, 0.6164401745308537, 
  -0.6164401745308537, -0.1208880872357772, 0.1208880872357771, 
  0.992666142448948, -0.992666142448948, -0.98501423101224, 0.98501423101224, 
  0.1724730839967959, -0.172473083996796, -0.5745533550477159, 
  0.5745533550477157, 0.818467129580299, -0.818467129580299, 
  -0.844031895490067, 0.844031895490067, 0.5362929790659631, 
  -0.5362929790659632, -0.2176042746384837, 0.2176042746384835, 
  0.976037079039039, -0.976037079039039, -0.932439629268462, 
  0.932439629268463, 0.3613258055684542, -0.3613258055684543, 
  -0.4038384575676542, 0.403838457567654, 0.914830312237946, 
  -0.914830312237946, -0.7231884893065275, 0.7231884893065275, 
  0.6906507141345344, -0.6906507141345348, -0.02300768146883941, 
  0.02300768146883929, 0.999735288260562, -0.999735288260562, 
  -0.999904701082853, 0.999904701082853, 0.01380538852806023, 
  -0.01380538852806035, -0.6972775108308867, 0.6972775108308865, 
  0.7168012785210996, -0.7168012785210996, -0.918508394325212, 
  0.918508394325212, 0.3954014789478162, -0.3954014789478163, 
  -0.3698924471489342, 0.3698924471489342, 0.929074581259316, 
  -0.929074581259316, -0.977998514934557, 0.977998514934557, 
  0.2086118519782633, -0.2086118519782634, -0.5440385267308839, 
  0.5440385267308839, 0.839060237070312, -0.839060237070313, 
  -0.823720511227391, 0.823720511227391, 0.5669960488251085, 
  -0.5669960488251088, -0.1815316082611251, 0.181531608261125, 
  0.983385110321551, -0.983385110321551, -0.993736721940725, 
  0.993736721940725, 0.1117467112111265, -0.1117467112111266, 
  -0.6236611175256947, 0.6236611175256947, 0.7816948320710592, 
  -0.7816948320710595, -0.875329403104111, 0.875329403104111, 
  0.4835270789329184, -0.4835270789329189, -0.2770460803060999, 
  0.2770460803060998, 0.96085663310768, -0.96085663310768, 
  -0.952841647601199, 0.952841647601199, 0.3034679465720113, 
  -0.3034679465720114, -0.4591765475219442, 0.4591765475219441, 
  0.888345033309596, -0.888345033309596, -0.7641787405361168, 
  0.7641787405361166, 0.6450045368155438, -0.6450045368155441, 
  -0.0842688875933241, 0.084268887593324, 0.996443051350043, 
  -0.996443051350043, -0.998022873771486, 0.998022873771486, 
  0.06285175756416131, -0.06285175756416141, -0.6612658378399923, 
  0.6612658378399922, 0.750151645806215, -0.7501516458062151, 
  -0.89800057974074, 0.89800057974074, 0.4399942713096332, 
  -0.4399942713096333, -0.323859366517853, 0.3238593665178528, 
  0.946105232370403, -0.946105232370403, -0.966584374478333, 
  0.966584374478333, 0.2563486824899428, -0.2563486824899429, 
  -0.5022124740457109, 0.5022124740457106, 0.864744257519462, 
  -0.864744257519462, -0.7949071263282371, 0.7949071263282369, 
  0.6067311270345246, -0.6067311270345246, -0.1330605251571391, 
  0.1330605251571391, 0.991107913723277, -0.991107913723277, 
  -0.987056571305751, 0.987056571305751, 0.1603724572429283, 
  -0.1603724572429284, -0.5845539429530155, 0.5845539429530151, 
  0.811354847017064, -0.811354847017064, -0.850549481265603, 
  0.850549481265603, 0.5258950274710847, -0.5258950274710849, 
  -0.2295653658205189, 0.2295653658205187, 0.973293246054698, 
  -0.973293246054698, -0.936803441735922, 0.936803441735922, 
  0.3498561297901349, -0.349856129790135, -0.4150344244760817, 
  0.4150344244760815, 0.909805708104652, -0.909805708104652, 
  -0.7316093812238927, 0.7316093812238926, 0.6817240741716497, 
  -0.6817240741716498, -0.03527423889821395, 0.03527423889821382, 
  0.999377670388003, -0.999377670388003, -0.999264747286594, 
  0.999264747286594, 0.03834012037355267, -0.03834012037355279, 
  -0.6794763198993651, 0.679476319899365, 0.7336974381146602, 
  -0.7336974381146604, -0.908528118716306, 0.908528118716306, 
  0.4178237158202123, -0.4178237158202124, -0.3469804108459237, 
  0.3469804108459236, 0.93787237643999, -0.93787237643999, 
  -0.972584368934732, 0.972584368934732, 0.2325503070387752, 
  -0.2325503070387753, -0.5232831034756565, 0.5232831034756565, 
  0.85215890162392, -0.85215890162392, -0.809557642404051, 0.809557642404051, 
  0.5870403935209178, -0.5870403935209181, -0.1573434556162383, 
  0.1573434556162382, 0.987543941794359, -0.987543941794359, 
  -0.990695025442665, 0.990695025442665, 0.1361005751757061, 
  -0.1361005751757062, -0.6042895309481561, 0.6042895309481559, 
  0.7967648102084187, -0.7967648102084189, -0.863199421712124, 
  0.863199421712124, 0.5048631085312677, -0.5048631085312677, 
  -0.2533820369955703, 0.2533820369955702, 0.967366292222328, 
  -0.967366292222328, -0.945107193285261, 0.945107193285261, 
  0.3267604523201317, -0.3267604523201317, -0.4372371736610443, 
  0.4372371736610442, 0.899346236979341, -0.899346236979341, 
  -0.7481193804504036, 0.7481193804504036, 0.6635641586120397, 
  -0.6635641586120399, -0.05978957074664001, 0.05978957074663989, 
  0.998211003360478, -0.998211003360478, -0.996179828595697, 
  0.996179828595697, 0.0873255352061921, -0.0873255352061922, 
  -0.642657033966227, 0.6426570339662269, 0.7661539901963127, 
  -0.766153990196313, -0.886932118794342, 0.886932118794342, 
  0.4618997907024626, -0.4618997907024628, -0.3005432414172734, 
  0.3005432414172733, 0.95376818988599, -0.95376818988599, 
  -0.960002145737666, 0.960002145737666, 0.2799926430802733, 
  -0.2799926430802734, -0.480839330600334, 0.4808393306003338, 
  0.876808723809146, -0.876808723809146, -0.7797777879230146, 
  0.7797777879230143, 0.6260563884043436, -0.6260563884043436, 
  -0.1086974440131387, 0.1086974440131386, 0.994074879304879, 
  -0.994074879304879, -0.982823551198705, 0.982823551198705, 
  0.1845477369386195, -0.1845477369386196, -0.5644662415205195, 
  0.5644662415205194, 0.825456154004377, -0.825456154004378, 
  -0.837387201615662, 0.837387201615662, 0.5466101669108348, 
  -0.546610166910835, -0.2056104130530993, 0.2056104130530992, 
  0.978633924429423, -0.978633924429423, -0.927935394822618, 
  0.927935394822618, 0.3727410670095157, -0.3727410670095158, 
  -0.3925816740729515, 0.3925816740729514, 0.919717146291228, 
  -0.919717146291227, -0.7146586878627691, 0.7146586878627688, 
  0.6994733446402839, -0.6994733446402839, -0.01073765916726457, 
  0.01073765916726445, 0.999942349676024, -0.999942349676024, 
  -0.999970586430974, 0.999970586430974, 0.007669828739530954, 
  -0.007669828739531078, -0.7016625947401686, 0.7016625947401685, 
  0.7125093705646921, -0.7125093705646925, -0.920917241529189, 
  0.920917241529189, 0.3897581740698563, -0.3897581740698564, 
  -0.3755861784892173, 0.3755861784892172, 0.926787474304582, 
  -0.926787474304582, -0.979260122649082, 0.979260122649082, 
  0.202607038844421, -0.2026070388444211, -0.5491766621877198, 
  0.5491766621877196, 0.835706284353753, -0.835706284353753, 
  -0.827184027273669, 0.827184027273669, 0.5619311212446894, 
  -0.5619311212446895, -0.1875621285825297, 0.1875621285825296, 
  0.982252741366289, -0.982252741366289, -0.994403680057679, 
  0.994403680057679, 0.1056471537134106, -0.1056471537134107, 
  -0.6284457666018328, 0.6284457666018327, 0.7778534042094531, 
  -0.7778534042094531, -0.878279791656541, 0.878279791656541, 
  0.478147056424843, -0.4781470564248432, -0.2829365704570554, 
  0.2829365704570553, 0.959138622461842, -0.959138622461842, 
  -0.954685754941338, 0.954685754941338, 0.2976157074350862, 
  -0.2976157074350863, -0.4646186863062379, 0.4646186863062379, 
  0.8855108561362, -0.8855108561362, -0.7681220285233655, 0.7681220285233655, 
  0.6403034821841515, -0.6403034821841518, -0.090381360877865, 
  0.0903813608778649, 0.995907229417412, -0.995907229417412, 
  -0.99838973740734, 0.99838973740734, 0.05672682116690766, 
  -0.05672682116690778, -0.6658562336655098, 0.6658562336655094, 
  0.7460800735100638, -0.7460800735100638, -0.900683429228647, 
  0.900683429228647, 0.4344759605696559, -0.4344759605696557, 
  -0.3296584625285876, 0.3296584625285874, 0.944100258491273, 
  -0.944100258491273, -0.968139104746362, 0.968139104746362, 
  0.2504130065729652, -0.2504130065729653, -0.507508991052971, 
  0.5075089910529708, 0.861646461143081, -0.861646461143081, 
  -0.798614994634761, 0.7986149946347608, 0.6018422470585799, 
  -0.6018422470585802, -0.1391393441638263, 0.1391393441638262, 
  0.990272812363169, -0.990272812363169, -0.988022017143284, 
  0.988022017143284, 0.1543129730130201, -0.1543129730130202, 
  -0.589521318641064, 0.589521318641064, 0.80775281792619, -0.80775281792619, 
  -0.853760301138111, 0.853760301138111, 0.520666254140367, 
  -0.5206662541403673, -0.2355330594049755, 0.2355330594049753, 
  0.971866337480279, -0.971866337480279, -0.938932483532065, 
  0.938932483532065, 0.3441014259899389, -0.344101425989939, 
  -0.4206090744484025, 0.4206090744484025, 0.907241977915296, 
  -0.907241977915296, -0.7357785891657136, 0.7357785891657134, 
  0.6772221701371804, -0.6772221701371805, -0.04140564097707672, 
  0.0414056409770766, 0.999142418724817, -0.999142418724817, 
  -0.999481186966167, 0.999481186966167, 0.03220802540830458, 
  -0.0322080254083047, -0.6839654117973156, 0.6839654117973155, 
  0.7295144381469969, -0.729514438146997, -0.911074734055176, 
  0.911074734055176, 0.4122412266698829, -0.412241226669883, 
  -0.3527285557552107, 0.3527285557552106, 0.93572568948108, 
  -0.93572568948108, -0.973992962167956, 0.973992962167956, 0.22657826384561, 
  -0.2265782638456101, -0.5285020015422285, 0.5285020015422283, 
  0.84893205521164, -0.84893205521164, -0.813144414849254, 0.813144414849253, 
  0.5820619903407755, -0.5820619903407756, -0.1633999493829732, 
  0.1633999493829731, 0.986559910264776, -0.986559910264776, 
  -0.991511473318744, 0.991511473318744, 0.1300192227222332, 
  -0.1300192227222333, -0.6091670123364534, 0.6091670123364531, 
  0.7930419604794436, -0.7930419604794437, -0.866280954024513, 
  0.866280954024513, 0.4995571125450818, -0.4995571125450819, 
  -0.2593129151328863, 0.2593129151328863, 0.965793358874084, 
  -0.965793358874084, -0.947094366352777, 0.947094366352777, 
  0.3209552324278751, -0.3209552324278752, -0.4427472275645702, 
  0.4427472275645699, 0.89664647017868, -0.89664647017868, 
  -0.7521768504490428, 0.7521768504490425, 0.6589612929820374, 
  -0.6589612929820374, -0.06591335279700392, 0.06591335279700381, 
  0.997825350411112, -0.997825350411112, -0.996696895202896, 
  0.996696895202896, 0.0812114468095923, -0.0812114468095924, 
  -0.6473459686365122, 0.6473459686365119, 0.7621962981345789, 
  -0.7621962981345791, -0.889749586383073, 0.889749586383073, 
  0.456448982396884, -0.4564489823968839, -0.3063897953708611, 
  0.306389795370861, 0.951906136807932, -0.951906136807932, 
  -0.961702076529123, 0.961702076529123, 0.2740969098687062, 
  -0.2740969098687063, -0.4862102761244866, 0.4862102761244865, 
  0.873841843465367, -0.873841843465367, -0.7836045186096384, 
  0.7836045186096383, 0.6212599765110875, -0.6212599765110877, 
  -0.1147949266065102, 0.1147949266065101, 0.993389211148081, 
  -0.993389211148081, -0.983937413449219, 0.983937413449219, 
  0.1785137709389974, -0.1785137709389976, -0.5695205193469473, 
  0.5695205193469473, 0.821977115279241, -0.821977115279242, 
  -0.840725374970458, 0.840725374970458, 0.5414617658531232, 
  -0.5414617658531236, -0.2116113273692276, 0.2116113273692275, 
  0.9773539001452, -0.9773539001452, -0.930205022892219, 0.930205022892219, 
  0.3670403457197671, -0.3670403457197672, -0.3982175621533736, 
  0.3982175621533735, 0.917290997008378, -0.917290997008378, 
  -0.7189371223728046, 0.7189371223728043, 0.6950751139800008, 
  -0.6950751139800009, -0.01687298794728177, 0.01687298794728165, 
  0.999857641005824, -0.999857641005824, -0.999801169887884, 
  0.999801169887884, 0.01994042855151448, -0.0199404285515146, 
  -0.6928661748174248, 0.6928661748174246, 0.7210661993145079, 
  -0.7210661993145081, -0.916064965799332, 0.916064965799332, 
  0.4010298971835757, -0.4010298971835759, -0.3641847895670798, 
  0.3641847895670797, 0.93132670908118, -0.93132670908118, 
  -0.976700086128712, 0.976700086128712, 0.2146088109937868, 
  -0.2146088109937869, -0.5388799085310084, 0.5388799085310083, 
  0.842382599643186, -0.842382599643186, -0.820225982569435, 
  0.820225982569434, 0.5720396293247571, -0.5720396293247572, 
  -0.1754942533772714, 0.1754942533772712, 0.984480455383221, 
  -0.984480455383221, -0.993032350197851, 0.993032350197851, 
  0.1178420615083249, -0.117842061508325, -0.6188529879609765, 
  0.6188529879609762, 0.7855068295640538, -0.7855068295640539, 
  -0.872346058894392, 0.872346058894392, 0.4888888969197631, 
  -0.4888888969197632, -0.271145159526808, 0.2711451595268079, 
  0.962538468044359, -0.962538468044359, -0.950961666311575, 
  0.950961666311575, 0.3093087603122687, -0.3093087603122687, 
  -0.4537171210001639, 0.4537171210001637, 0.891145764794583, 
  -0.891145764794583, -0.7602066816512025, 0.7602066816512023, 
  0.6496813073906833, -0.6496813073906833, -0.07815324163279431, 
  0.07815324163279419, 0.996941357764982, -0.996941357764982, 
  -0.99761843513852, 0.997618435138519, 0.06897432762826662, 
  -0.06897432762826674, -0.6566505457294291, 0.6566505457294288, 
  0.7541949753168892, -0.7541949753168894, -0.895283921038558, 
  0.895283921038557, 0.4454960165139818, -0.4454960165139818, 
  -0.318048077385015, 0.3180480773850149, 0.948074585922276, 
  -0.948074585922276, -0.96499325285492, 0.96499325285492, 
  0.2622747070239135, -0.2622747070239136, -0.4968970490226547, 
  0.4968970490226545, 0.867809496763303, -0.867809496763303, 
  -0.7911693302176902, 0.7911693302176901, 0.6115971639264619, 
  -0.611597163926462, -0.126976696496886, 0.1269766964968859, 
  0.991905700430609, -0.991905700430609, -0.986053963346195, 
  0.986053963346195, 0.1664259035404641, -0.1664259035404642, 
  -0.5795645591394058, 0.5795645591394058, 0.814926329056526, 
  -0.814926329056527, -0.847306638685858, 0.847306638685858, 
  0.5311040011512547, -0.5311040011512552, -0.22358902922979, 
  0.2235890292297899, 0.974683510688511, -0.974683510688511, 
  -0.934639129819681, 0.934639129819681, 0.3555976617047838, 
  -0.355597661704784, -0.4094441486922576, 0.4094441486922575, 
  0.912335184623323, -0.912335184623323, -0.7274126286023758, 
  0.7274126286023757, 0.6862003116800385, -0.6862003116800387, 
  -0.02914150876419374, 0.02914150876419362, 0.999575296046749, 
  -0.999575296046749, -0.999010685854073, 0.999010685854073, 
  0.04447077185493863, -0.04447077185493875, -0.6749616461020121, 
  0.6749616461020121, 0.7378528147884658, -0.7378528147884662, 
  -0.905947297807268, 0.905947297807268, 0.4233904741437958, 
  -0.4233904741437961, -0.3412192023202824, 0.3412192023202823, 
  0.939983753034014, -0.939983753034014, -0.971139158449725, 
  0.971139158449725, 0.2385135948443184, -0.2385135948443185, 
  -0.5180445040959995, 0.5180445040959993, 0.855353664735196, 
  -0.855353664735196, -0.805940390571177, 0.805940390571176, 
  0.5919966949620409, -0.591996694962041, -0.1512810379573302, 
  0.1512810379573301, 0.988490792852697, -0.988490792852697, 
  -0.98984127845882, 0.98984127845882, 0.1421768035194479, 
  -0.142176803519448, -0.5993892984005647, 0.5993892984005646, 
  0.800457662192623, -0.800457662192623, -0.86008539042939, 0.86008539042939, 
  0.5101500967067666, -0.5101500967067669, -0.2474416191677734, 
  0.2474416191677733, 0.968902804776429, -0.968902804776429, 
  -0.943084437466093, 0.943084437466093, 0.3325533698660441, 
  -0.3325533698660442, -0.4317106580250574, 0.4317106580250571, 
  0.902012143902493, -0.902012143902493, -0.7440337441799293, 
  0.7440337441799291, 0.6681420414265185, -0.6681420414265186, 
  -0.05366353765273068, 0.05366353765273056, 0.998559074229759, 
  -0.998559074229759, -0.995625256380994, 0.995625256380994, 
  0.0934363358457478, -0.0934363358457479, -0.6379439036218442, 
  0.637943903621844, 0.7700828369933479, -0.770082836993348, 
  -0.884081258712635, 0.884081258712635, 0.4673332087419884, 
  -0.4673332087419885, -0.2946853721805143, 0.2946853721805142, 
  0.955594334130771, -0.955594334130771, -0.958266071408018, 
  0.958266071408018, 0.2858778347270806, -0.2858778347270807, 
  -0.4754502817471559, 0.475450281747156, 0.879742592800047, 
  -0.879742592800048, -0.7759216990434077, 0.7759216990434077, 
  0.6308292296284244, -0.6308292296284246, -0.1025958690224363, 
  0.1025958690224362, 0.994723121104326, -0.994723121104326, 
  -0.981672686196983, 0.981672686196983, 0.1905747548202526, 
  -0.1905747548202528, -0.5593907118591362, 0.5593907118591358, 
  0.828904114771865, -0.828904114771865, -0.834017501106018, 
  0.834017501106018, 0.5517379884047075, -0.5517379884047075, 
  -0.199601757621131, 0.1996017576211309, 0.979877103699518, 
  -0.979877103699518, -0.925630830509873, 0.925630830509873, 
  0.3784277548087655, -0.3784277548087656, -0.3869310055143887, 
  0.3869310055143886, 0.922108668743345, -0.922108668743345, 
  -0.7103533468570625, 0.7103533468570623, 0.7038452405244849, 
  -0.7038452405244851, -0.004601926120448672, 0.004601926120448549, 
  0.999989411081928, -0.999989411081928};

static const double mod2048[2048] = 
{-0.999999705862882, 0.999999705862882, 0.000766990318742724, 
  -0.0007669903187428464, -0.7065642291447097, 0.7065642291447095, 
  0.7076489172556844, -0.7076489172556844, -0.923585746276257, 
  0.923585746276257, 0.3833919264608086, -0.3833919264608088, 
  -0.3819747131465672, 0.3819747131465671, 0.924172775251791, 
  -0.924172775251791, -0.980635359529608, 0.980635359529608, 
  0.1958425174476579, -0.195842517447658, -0.5549323404628105, 
  0.5549323404628104, 0.831895484726578, -0.831895484726578, 
  -0.831043250746362, 0.831043250746362, 0.5562077987487398, 
  -0.5562077987487401, -0.1943380118179886, 0.1943380118179885, 
  0.980934624306142, -0.980934624306142, -0.995109255753726, 
  0.995109255753726, 0.0987804085497995, -0.0987804085497996, 
  -0.6338002060310173, 0.633800206031017, 0.7734967994988992, 
  -0.7734967994988992, -0.881559448209144, 0.881559448209144, 
  0.4720730232423688, -0.4720730232423687, -0.2895506278978432, 
  0.289550627897843, 0.95716269979767, -0.95716269979767, -0.956717408723403, 
  0.956717408723403, 0.291018555844085, -0.2910185558440851, 
  -0.4707201730990718, 0.4707201730990717, 0.882282561676009, 
  -0.882282561676009, -0.7725236524844413, 0.7725236524844413, 
  0.6349859890990494, -0.6349859890990496, -0.0972538144483634, 
  0.0972538144483633, 0.995259612149133, -0.995259612149133, 
  -0.998757527991183, 0.998757527991183, 0.04983372634010714, 
  -0.04983372634010726, -0.6709904549767943, 0.6709904549767943, 
  0.7414659866305631, -0.7414659866305633, -0.903661096609248, 
  0.903661096609248, 0.4282483187065318, -0.4282483187065319, 
  -0.3361675991177446, 0.3361675991177446, 0.941802179495998, 
  -0.941802179495998, -0.969844604426715, 0.969844604426715, 
  0.243724113013852, -0.2437241130138521, -0.5134447234365436, 
  0.5134447234365433, 0.858122669538086, -0.858122669538086, 
  -0.802750399628069, 0.802750399628069, 0.5963151816757437, 
  -0.5963151816757439, -0.1459717424898123, 0.1459717424898122, 
  0.989288759864625, -0.989288759864625, -0.989063678157882, 
  0.989063678157882, 0.1474891201031535, -0.1474891201031536, 
  -0.5950830768745701, 0.5950830768745698, 0.803664190826924, 
  -0.803664190826924, -0.857334045882816, 0.857334045882816, 
  0.5147604625165011, -0.5147604625165013, -0.242236103853696, 
  0.2422361038536959, 0.970217331317979, -0.970217331317979, 
  -0.941285396983929, 0.941285396983929, 0.3376119094830746, 
  -0.3376119094830747, -0.4268616166343865, 0.4268616166343867, 
  0.904316957844028, -0.904316957844028, -0.740435828196898, 
  0.740435828196898, 0.6721270596564115, -0.6721270596564119, 
  -0.04830159344948018, 0.04830159344948006, 0.998832796853528, 
  -0.998832796853528, -0.999679701762988, 0.999679701762988, 
  0.02530798062002451, -0.02530798062002463, -0.6889848514165972, 
  0.6889848514165969, 0.7247757408457112, -0.7247757408457113, 
  -0.913898670635912, 0.913898670635912, 0.4059423848404025, 
  -0.4059423848404025, -0.3591793342323366, 0.3591793342323364, 
  0.933268560415712, -0.933268560415712, -0.975533794518291, 
  0.975533794518291, 0.2198495297987786, -0.2198495297987788, 
  -0.5343494680191375, 0.5343494680191372, 0.845263654741918, 
  -0.845263654741918, -0.817142933361273, 0.817142933361273, 
  0.5764351016877219, -0.5764351016877219, -0.1702061400610781, 
  0.170206140061078, 0.985408478695769, -0.985408478695769, 
  -0.992385354870852, 0.992385354870852, 0.1231718613882805, 
  -0.1231718613882806, -0.6146267555403751, 0.6146267555403748, 
  0.7888180724184203, -0.7888180724184203, -0.869708687042266, 
  0.869708687042266, 0.4935653955487748, -0.493565395548775, 
  -0.2659734721128755, 0.2659734721128754, 0.963980348415994, 
  -0.963980348415994, -0.949287310443502, 0.949287310443502, 
  0.3144099270553367, -0.3144099270553368, -0.4489261030157432, 
  0.4489261030157433, 0.893568886002136, -0.893568886002136, 
  -0.7567076465362458, 0.7567076465362457, 0.653753422685936, 
  -0.6537534226859362, -0.07279962983635162, 0.07279962983635152, 
  0.997346586646633, -0.997346586646633, -0.997233740030466, 
  0.997233740030466, 0.07432945408684576, -0.07432945408684587, 
  -0.6525918789768626, 0.6525918789768626, 0.7577096010302679, 
  -0.7577096010302683, -0.892879190928052, 0.892879190928052, 
  0.4502962917987085, -0.4502962917987088, -0.3129533692115602, 
  0.3129533692115601, 0.949768492159607, -0.949768492159607, 
  -0.963571216210257, 0.963571216210257, 0.2674518859366776, 
  -0.2674518859366777, -0.4922306989514861, 0.492230698951486, 
  0.870464783325398, -0.870464783325398, -0.7878743190709003, 
  0.7878743190709001, 0.6158360636959851, -0.6158360636959852, 
  -0.1216494169991055, 0.1216494169991054, 0.992573130476429, 
  -0.992573130476429, -0.985146226468662, 0.985146226468662, 
  0.1717175368870498, -0.17171753688705, -0.5751809424148452, 
  0.5751809424148452, 0.818026211977813, -0.818026211977814, 
  -0.844442978751911, 0.844442978751911, 0.5356454570297409, 
  -0.5356454570297411, -0.2183528216233464, 0.2183528216233463, 
  0.975869891578341, -0.975869891578341, -0.93271648839814, 0.93271648839814, 
  0.3606105271206621, -0.3606105271206623, -0.4045400047765531, 
  0.404540004776553, 0.914520302965105, -0.914520302965105, 
  -0.7237179990013236, 0.7237179990013233, 0.6900958324186, 
  -0.6900958324186001, -0.02377446198882768, 0.02377446198882755, 
  0.999717347532362, -0.999717347532362, -0.999914995573113, 
  0.999914995573113, 0.01303846724198731, -0.01303846724198743, 
  -0.6978270853767774, 0.6978270853767772, 0.716266262582953, 
  -0.7162662625829533, -0.91881139326417, 0.91881139326417, 
  0.3946968755994335, -0.3946968755994337, -0.3706049295590517, 
  0.3706049295590516, 0.928790604058057, -0.928790604058057, 
  -0.978158230539735, 0.978158230539735, 0.207861675225075, 
  -0.2078616752250752, -0.5446819177876347, 0.5446819177876347, 
  0.838642717988527, -0.838642717988527, -0.824155149420829, 
  0.824155149420829, 0.5663640963930636, -0.566364096393064, 
  -0.1822858017251533, 0.1822858017251532, 0.983245588085407, 
  -0.983245588085407, -0.99382213829152, 0.99382213829152, 
  0.1109844918971633, -0.1109844918971634, -0.6242604864522208, 
  0.6242604864522205, 0.7812162601062762, -0.7812162601062762, 
  -0.875700006225635, 0.875700006225635, 0.4828555675317657, 
  -0.4828555675317657, -0.2777829665518578, 0.2777829665518577, 
  0.960643858822639, -0.960643858822639, -0.953074124312172, 
  0.953074124312172, 0.302737036991819, -0.3027370369918191, 
  -0.4598577645013296, 0.4598577645013295, 0.887992588047806, 
  -0.887992588047806, -0.7646732279980672, 0.7646732279980672, 
  0.6444182293999882, -0.6444182293999886, -0.0850331249802804, 
  0.0850331249802803, 0.9963781248382, -0.9963781248382, -0.998070786905482, 
  0.998070786905482, 0.06208626519506013, -0.06208626519506025, 
  -0.661841002387087, 0.6618410023870869, 0.7496442406630333, 
  -0.7496442406630336, -0.898337786951834, 0.898337786951834, 
  0.4393053841400998, -0.4393053841401001, -0.3245849248125321, 
  0.324584924812532, 0.945856557086984, -0.945856557086984, 
  -0.966780707127683, 0.966780707127683, 0.2556072462308074, 
  -0.2556072462308076, -0.5028755768000871, 0.5028755768000868, 
  0.864358811060534, -0.864358811060534, -0.7953722494170613, 
  0.7953722494170611, 0.6061212625021862, -0.6061212625021862, 
  -0.1338206561937547, 0.1338206561937546, 0.991005566067049, 
  -0.991005566067049, -0.987179285097874, 0.987179285097874, 
  0.159615347237193, -0.1596153472371931, -0.5851760723267306, 
  0.5851760723267303, 0.81090626115246, -0.81090626115246, 
  -0.850952587482176, 0.850952587482176, 0.5252425095680947, 
  -0.5252425095680948, -0.2303118047938455, 0.2303118047938454, 
  0.973116885359925, -0.973116885359925, -0.937071502451759, 
  0.937071502451759, 0.3491375077140849, -0.349137507714085, 
  -0.4157321145691055, 0.4157321145691054, 0.909487113111505, 
  -0.909487113111505, -0.7321320417953614, 0.7321320417953611, 
  0.6811627363387954, -0.6811627363387954, -0.0360407415207063, 
  0.03604074152070618, 0.9993503214342, -0.999350321434199, 
  -0.999293859866888, 0.999293859866888, 0.03757368270927039, 
  -0.03757368270927052, -0.6800388588720791, 0.680038858872079, 
  0.7331760705478327, -0.7331760705478329, -0.908848318229439, 
  0.908848318229439, 0.4171267606513878, -0.4171267606513879, 
  -0.3476996478190514, 0.3476996478190514, 0.937605969961, -0.937605969961, 
  -0.972762446695689, 0.972762446695688, 0.2318042758419647, 
  -0.2318042758419648, -0.5239365471862488, 0.5239365471862483, 
  0.851757297898029, -0.851757297898029, -0.810007658581641, 
  0.810007658581641, 0.5864192979763607, -0.5864192979763607, 
  -0.1581008459783771, 0.158100845978377, 0.987422970413855, 
  -0.987422970413855, -0.99079912186602, 0.99079912186602, 
  0.1353406816501342, -0.1353406816501343, -0.60490046409992, 
  0.6049004640999197, 0.796301091630359, -0.7963010916303591, 
  -0.863586392929668, 0.863586392929668, 0.5042008944326904, 
  -0.5042008944326906, -0.2541239230473206, 0.2541239230473205, 
  0.967171666114677, -0.967171666114677, -0.945357537397632, 
  0.945357537397632, 0.3260354681403302, -0.3260354681403303, 
  -0.4379268349103229, 0.437926834910323, 0.899010615769039, 
  -0.899010615769039, -0.7486281076862455, 0.7486281076862454, 
  0.6629901631111213, -0.6629901631111215, -0.06055517133594778, 
  0.06055517133594766, 0.998164851727646, -0.998164851727646, 
  -0.996246513422316, 0.996246513422316, 0.0865614492362511, 
  -0.0865614492362512, -0.6432444776300859, 0.6432444776300859, 
  0.7656608531186622, -0.7656608531186625, -0.887286130582383, 
  0.887286130582383, 0.4612193864920922, -0.4612193864920925, 
  -0.301274683984318, 0.3012746839843179, 0.953537395590833, 
  -0.953537395590833, -0.960216615011963, 0.960216615011963, 
  0.2792562483722911, -0.2792562483722913, -0.48151169297019, 
  0.4815116929701898, 0.876439666795714, -0.876439666795714, 
  -0.7802577377503166, 0.7802577377503165, 0.6254581222438143, 
  -0.6254581222438144, -0.109459857849718, 0.1094598578497179, 
  0.993991217023329, -0.993991217023329, -0.982964808441396, 
  0.982964808441396, 0.1837938665074783, -0.1837938665074784, 
  -0.5650991923687141, 0.565099192368714, 0.82502297106458, 
  -0.82502297106458, -0.837806200015151, 0.837806200015151, 
  0.5459677382558174, -0.5459677382558177, -0.2063609553210757, 
  0.2063609553210756, 0.978475935380617, -0.978475935380617, 
  -0.928221010672169, 0.928221010672169, 0.3720292399082848, 
  -0.372029239908285, -0.3932869727472965, 0.3932869727472965, 
  0.919415769424947, -0.919415769424947, -0.7151949669386802, 
  0.7151949669386799, 0.6989250026044142, -0.6989250026044143, 
  -0.01150460211042287, 0.01150460211042275, 0.999933819875236, 
  -0.999933819875236, -0.999976174986898, 0.999976174986898, 
  0.006902858724729755, -0.006902858724729877, -0.7022088761443919, 
  0.7022088761443919, 0.7119709925720499, -0.7119709925720502, 
  -0.921215911399409, 0.921215911399409, 0.3890517248188944, 
  -0.3890517248188945, -0.3762969050357048, 0.3762969050357046, 
  0.926499130739231, -0.926499130739231, -0.979415232249635, 
  0.979415232249635, 0.201855896216568, -0.2018558962165681, 
  -0.549817479283891, 0.5498174792838908, 0.835284825358337, 
  -0.835284825358337, -0.827614779697938, 0.827614779697938, 
  0.5612965138191515, -0.5612965138191516, -0.1883154517567321, 
  0.188315451756732, 0.982108594112514, -0.982108594112514, 
  -0.994484417910748, 0.994484417910748, 0.1048844246431348, 
  -0.104884424643135, -0.629042187783036, 0.6290421877830359, 
  0.7773711635950562, -0.7773711635950563, -0.878646267485068, 
  0.878646267485068, 0.477473283686698, -0.4774732836866981, 
  -0.2836721372726685, 0.2836721372726684, 0.958921330733213, 
  -0.958921330733213, -0.95491374249913, 0.95491374249913, 
  0.2968833851637782, -0.2968833851637782, -0.4652977278984347, 
  0.4652977278984344, 0.885154237640285, -0.885154237640285, 
  -0.7686129091620585, 0.7686129091620582, 0.6397141516876406, 
  -0.6397141516876406, -0.0911451854966811, 0.091145185496681, 
  0.995837614855342, -0.995837614855341, -0.998432952666508, 
  0.998432952666508, 0.0559610492185204, -0.05596104921852053, 
  -0.6664282740058654, 0.6664282740058651, 0.7455691487753253, 
  -0.7455691487753255, -0.901016403159702, 0.901016403159702, 
  0.4337850173036787, -0.4337850173036786, -0.3303824813219829, 
  0.3303824813219828, 0.943847135947093, -0.943847135947093, 
  -0.968330884332445, 0.968330884332445, 0.2496703795966684, 
  -0.2496703795966685, -0.5081697162696149, 0.5081697162696147, 
  0.861256953218062, -0.861256953218062, -0.7990763669093523, 
  0.7990763669093523, 0.6012295400651484, -0.6012295400651487, 
  -0.1398988328977774, 0.1398988328977772, 0.990165802557248, 
  -0.990165802557248, -0.988140083085693, 0.988140083085693, 
  0.1535551243019934, -0.1535551243019935, -0.590140683832249, 
  0.590140683832249, 0.807300423192014, -0.807300423192014, 
  -0.854159395991739, 0.854159395991739, 0.5200112751075957, 
  -0.5200112751075962, -0.2362784021979196, 0.2362784021979195, 
  0.971685400042009, -0.971685400042009, -0.93919612981957, 0.93919612981957, 
  0.343381172652115, -0.3433811726521151, -0.4213047965454797, 
  0.4213047965454796, 0.906919107973678, -0.906919107973678, 
  -0.7362977955940532, 0.7362977955940531, 0.6766576358863749, 
  -0.676657635886375, -0.04217196136034801, 0.04217196136034788, 
  0.999110367114175, -0.999110367114175, -0.999505596225325, 
  0.999505596225325, 0.03144142354056022, -0.03144142354056034, 
  -0.6845247411291425, 0.6845247411291421, 0.7289896287205195, 
  -0.7289896287205195, -0.911390651104122, 0.911390651104122, 
  0.4115423199137652, -0.4115423199137653, -0.3534461445494808, 
  0.3534461445494808, 0.935454874862015, -0.935454874862015, 
  -0.97416645901528, 0.97416645901528, 0.2258311540280261, 
  -0.2258311540280262, -0.5291529687577908, 0.5291529687577907, 
  0.848526449590593, -0.848526449590593, -0.813590611584799, 
  0.813590611584798, 0.5814381452408102, -0.5814381452408103, 
  -0.1641565832210159, 0.1641565832210158, 0.986434293901627, 
  -0.986434293901627, -0.991610905163495, 0.991610905163495, 
  0.1292587047777962, -0.1292587047777963, -0.6097750886638684, 
  0.6097750886638684, 0.7925745020154075, -0.7925745020154077, 
  -0.866663854688111, 0.866663854688111, 0.4988925365017444, 
  -0.4988925365017449, -0.2600535930154951, 0.260053593015495, 
  0.965594184302977, -0.965594184302977, -0.947340257333192, 
  0.947340257333192, 0.3202287258130999, -0.3202287258131, 
  -0.4434348164981384, 0.4434348164981384, 0.89630662360448, 
  -0.89630662360448, -0.7526820461380554, 0.7526820461380552, 
  0.658384186794785, -0.6583841867947852, -0.06667865579300153, 
  0.06667865579300142, 0.997774502010168, -0.997774502010168, 
  -0.996758890430818, 0.996758890430818, 0.08044696605295, 
  -0.0804469660529501, -0.6479303754096854, 0.6479303754096853, 
  0.7616995658535353, -0.7616995658535354, -0.890099416625192, 
  0.890099416625192, 0.4557664188194347, -0.4557664188194348, 
  -0.3071198080415331, 0.307119808041533, 0.951670858810194, 
  -0.951670858810194, -0.961912023333112, 0.961912023333112, 
  0.2733592130644187, -0.2733592130644188, -0.4868803613460475, 
  0.4868803613460475, 0.873468667861385, -0.873468667861385, 
  -0.78408078850987, 0.78408078850987, 0.6206587766959718, 
  -0.6206587766959722, -0.1155568127487553, 0.1155568127487552, 
  0.993300872358093, -0.993300872358093, -0.984074042370777, 
  0.984074042370776, 0.177759047961107, -0.1777590479611071, 
  -0.5701508003194704, 0.5701508003194701, 0.821540056780598, 
  -0.821540056780598, -0.841140423614298, 0.841140423614298, 
  0.5408167783657967, -0.5408167783657967, -0.2123608861058785, 
  0.2123608861058784, 0.977191308829712, -0.977191308829712, 
  -0.93048626567615, 0.93048626567615, 0.3663267795125735, 
  -0.3663267795125736, -0.398920998336983, 0.3989209983369829, 
  0.916985298184123, -0.916985298184123, -0.7194700267899332, 
  0.7194700267899331, 0.6945234917199655, -0.6945234917199656, 
  -0.01763986411508219, 0.01763986411508207, 0.999844405492175, 
  -0.999844405492175, -0.9998161699249, 0.9998161699249, 0.01917358486832258, 
  -0.0191735848683227, -0.6934190218138119, 0.6934190218138119, 
  0.720534565573905, -0.7205345655739053, -0.916372282399289, 
  0.916372282399289, 0.4003271662656901, -0.4003271662656902, 
  -0.3648990010162673, 0.3648990010162673, 0.931047108935595, 
  -0.931047108935595, -0.976864401725313, 0.976864401725313, 
  0.2138596283589937, -0.2138596283589938, -0.5395258493250291, 
  0.5395258493250288, 0.841969036194388, -0.841969036194388, 
  -0.820664490168157, 0.820664490168157, 0.5714103556788572, 
  -0.5714103556788574, -0.1762492887361679, 0.1762492887361678, 
  0.984345563417642, -0.984345563417642, -0.993122441830496, 
  0.993122441830496, 0.1170803806478004, -0.1170803806478005, 
  -0.619455282066924, 0.619455282066924, 0.7850319442668479, 
  -0.7850319442668481, -0.872720775355914, 0.872720775355914, 
  0.4882196721376266, -0.4882196721376268, -0.2718833374593599, 
  0.2718833374593598, 0.962330219213737, -0.962330219213737, 
  -0.951198623423113, 0.951198623423113, 0.3085792909415249, 
  -0.308579290941525, -0.4544004877193038, 0.4544004877193035, 
  0.890797506036282, -0.890797506036282, -0.760704757319237, 
  0.7607047573192367, 0.649098045130226, -0.6490980451302261, 
  -0.0789178630147851, 0.07891786301478499, 0.996881121747814, 
  -0.996881121747814, -0.997671044343441, 0.997671044343441, 
  0.06820914365880635, -0.06820914365880646, -0.6572288128286427, 
  0.6572288128286425, 0.7536911088687813, -0.7536911088687814, 
  -0.89562534883403, 0.89562534883403, 0.4448092113771049, 
  -0.4448092113771051, -0.3187751478641185, 0.3187751478641184, 
  0.947830367262101, -0.947830367262101, -0.965194131175725, 
  0.965194131175725, 0.2615344893965955, -0.2615344893965956, 
  -0.4975625043493192, 0.4975625043493192, 0.867428126282307, 
  -0.867428126282307, -0.7916381866091259, 0.7916381866091258, 
  0.6109901648162716, -0.6109901648162718, -0.1277374412176623, 
  0.1277374412176622, 0.991808018777407, -0.991808018777406, 
  -0.986181320367928, 0.986181320367928, 0.165669560744784, 
  -0.1656695607447841, -0.5801894292728318, 0.5801894292728314, 
  0.814481568950499, -0.814481568950499, -0.847713741088654, 
  0.847713741088654, 0.5304539689449764, -0.5304539689449764, 
  -0.2243365362804937, 0.2243365362804936, 0.974511733377116, 
  -0.974511733377116, -0.934911594871516, 0.934911594871516, 
  0.3548806979462227, -0.3548806979462228, -0.4101437805135904, 
  0.4101437805135903, 0.912020876573568, -0.912020876573568, 
  -0.7279387236390987, 0.7279387236390985, 0.6856421913991874, 
  -0.6856421913991876, -0.02990816476751665, 0.02990816476751653, 
  0.999552650779457, -0.999552650779457, -0.999044500659429, 
  0.999044500659429, 0.0437045272500633, -0.04370452725006342, 
  -0.6755273735363386, 0.6755273735363385, 0.7373349087104828, 
  -0.737334908710483, -0.906271767729258, 0.906271767729258, 
  0.4226954968022331, -0.422695496802233, -0.3419400603934023, 
  0.3419400603934022, 0.939721764725153, -0.939721764725153, 
  -0.971321810419786, 0.971321810419786, 0.2377686703559341, 
  -0.2377686703559342, -0.5187003996998352, 0.518700399699835, 
  0.854956078024615, -0.854956078024615, -0.806394209247956, 
  0.806394209247956, 0.5913783723567874, -0.5913783723567878, 
  -0.1520391563282462, 0.152039156328246, 0.988374471009341, 
  -0.988374471009341, -0.989950035541609, 0.989950035541609, 
  0.141417563022303, -0.1414175630223031, -0.6000030653753891, 
  0.6000030653753891, 0.7999977009592817, -0.7999977009592821, 
  -0.860476417631632, 0.860476417631632, 0.5094902694849361, 
  -0.5094902694849364, -0.2481846854570748, 0.2481846854570747, 
  0.968712734459795, -0.968712734459795, -0.943339225285108, 
  0.943339225285108, 0.3318299354164611, -0.3318299354164612, 
  -0.4324023656246902, 0.4324023656246901, 0.901680760692038, 
  -0.901680760692038, -0.7445459838093074, 0.7445459838093072, 
  0.6675711782225403, -0.6675711782225405, -0.05442940701091916, 
  0.05442940701091902, 0.998517621102622, -0.998517621102622, 
  -0.995696628295663, 0.995696628295663, 0.0926726734299132, 
  -0.0926726734299134, -0.6385343620594668, 0.6385343620594667, 
  0.7695933136854229, -0.769593313685423, -0.884439438718254, 
  0.884439438718254, 0.4666549895155309, -0.466654989515531, 
  -0.295418217105532, 0.295418217105532, 0.95536803222747, -0.95536803222747, 
  -0.958485055077976, 0.958485055077976, 0.2851427698402486, 
  -0.2851427698402487, -0.4761248959512436, 0.4761248959512434, 
  0.879377668271953, -0.879377668271953, -0.7764053107279404, 
  0.7764053107279402, 0.6302339196468645, -0.6302339196468645, 
  -0.1033587818488997, 0.1033587818488996, 0.994644138481051, 
  -0.994644138481051, -0.981818566442552, 0.981818566442552, 
  0.1898217653186565, -0.1898217653186566, -0.5600263087527605, 
  0.5600263087527602, 0.828474823700007, -0.828474823700007, 
  -0.834440433486103, 0.834440433486103, 0.5510981427690754, 
  -0.5510981427690755, -0.2003532551629404, 0.2003532551629403, 
  0.979723722865591, -0.979723722865591, -0.92592080867177, 0.92592080867177, 
  0.3777176936133857, -0.3777176936133858, -0.3876381401253727, 
  0.3876381401253726, 0.921811625181708, -0.921811625181708, 
  -0.7108929804011518, 0.7108929804011517, 0.7033001993575486, 
  -0.7033001993575488, -0.005368906963996303, 0.00536890696399618, 
  0.999985587315143, -0.999985587315143, -0.999992646580707, 
  0.999992646580707, 0.003834942569706126, -0.003834942569706248, 
  -0.7043898676374006, 0.7043898676374003, 0.7098132954304007, 
  -0.7098132954304008, -0.92240516985221, 0.92240516985221, 
  0.3862236432818629, -0.386223643281863, -0.3791375933848474, 
  0.3791375933848473, 0.925340307823206, -0.925340307823206, 
  -0.98002990809699, 0.98002990809699, 0.19885014265875, -0.1988501426587501, 
  -0.5523775094670962, 0.5523775094670958, 0.833594078094925, 
  -0.833594078094925, -0.829332918220788, 0.829332918220788, 
  0.5587547858903684, -0.5587547858903684, -0.191327632211631, 
  0.1913276322116309, 0.981526228458665, -0.981526228458665, 
  -0.994801518557617, 0.994801518557617, 0.1018328958414665, 
  -0.1018328958414667, -0.6314241685094019, 0.6314241685094017, 
  0.7754376309041305, -0.7754376309041306, -0.88010699979824, 
  0.88010699979824, 0.4747753878479172, -0.4747753878479173, 
  -0.2866127314393478, 0.2866127314393477, 0.958046524014819, 
  -0.958046524014819, -0.955820073882545, 0.955820073882545, 
  0.2939523538996846, -0.2939523538996848, -0.4680111530483599, 
  0.4680111530483599, 0.88372255862479, -0.88372255862479, 
  -0.7705719072813809, 0.7705719072813807, 0.6373530698982589, 
  -0.6373530698982592, -0.0941999432953932, 0.0941999432953931, 
  0.995553298765639, -0.995553298765638, -0.99859993993032, 0.99859993993032, 
  0.05289763672566528, -0.0528976367256654, -0.6687125115797481, 
  0.6687125115797481, 0.7435210668546689, -0.7435210668546692, 
  -0.902342996482444, 0.902342996482444, 0.4310186964611668, 
  -0.4310186964611671, -0.3332766086830479, 0.3332766086830479, 
  0.942829094854803, -0.942829094854803, -0.969092305112506, 
  0.969092305112506, 0.2466984073149424, -0.2466984073149425, 
  -0.5108096238204391, 0.510809623820439, 0.859693857261073, 
  -0.859693857261073, -0.800917152537344, 0.800917152537344, 
  0.5987751788204587, -0.5987751788204588, -0.1429359603776427, 
  0.1429359603776426, 0.989731939077911, -0.989731939077911, 
  -0.988606533192387, 0.988606533192387, 0.1505228305916773, 
  -0.1505228305916774, -0.5926146693108913, 0.5926146693108912, 
  0.805486097780429, -0.805486097780429, -0.855750748263254, 
  0.855750748263254, 0.5173883037399289, -0.5173883037399291, 
  -0.2392583790213001, 0.2392583790213, 0.970955935183518, 
  -0.970955935183518, -0.940245188374651, 0.940245188374651, 
  0.340498143516697, -0.3404981435166971, -0.4240852024156517, 
  0.4240852024156514, 0.905622294939825, -0.905622294939825, 
  -0.7383702868066486, 0.7383702868066484, 0.674395521605139, 
  -0.6743955216051391, -0.04523699029880475, 0.04523699029880463, 
  0.99897628335647, -0.99897628335647, -0.999597353289648, 0.999597353289648, 
  0.02837483561767213, -0.02837483561767225, -0.686758028286926, 
  0.6867580282869259, 0.7268861056475448, -0.726886105647545, 
  -0.912648955969794, 0.912648955969794, 0.4087442760054814, 
  -0.4087442760054815, -0.3563144162744023, 0.3563144162744023, 
  0.934366114943726, -0.934366114943726, -0.974854714618708, 
  0.974854714618708, 0.2228413906474212, -0.2228413906474213, 
  -0.5317537209227333, 0.5317537209227332, 0.846899037834397, 
  -0.846899037834397, -0.815370609762391, 0.815370609762391, 
  0.5789393480630818, -0.578939348063082, -0.1671821484320729, 
  0.1671821484320728, 0.985926026254321, -0.985926026254321, 
  -0.992002798571244, 0.992002798571244, 0.1262158770789903, 
  -0.1262158770789904, -0.6122038032497981, 0.6122038032497979, 
  0.7907000084017215, -0.7907000084017217, -0.868190356734331, 
  0.868190356734331, 0.4962313013842582, -0.4962313013842584, 
  -0.2630147703617791, 0.2630147703617789, 0.964791806853448, 
  -0.964791806853448, -0.948318246854599, 0.948318246854599, 
  0.3173208198064217, -0.3173208198064218, -0.4461825595770301, 
  0.4461825595770299, 0.894941966570621, -0.894941966570621, 
  -0.7546983980915245, 0.7546983980915242, 0.6560718923396177, 
  -0.6560718923396177, -0.06973947102190738, 0.06973947102190726, 
  0.997565239060376, -0.997565239060376, -0.997001007307235, 
  0.997001007307235, 0.07738857427526492, -0.07738857427526504, 
  -0.650264187460366, 0.6502641874603658, 0.7597081587731634, 
  -0.7597081587731635, -0.891493499314791, 0.891493499314791, 
  0.4530334873709318, -0.4530334873709316, -0.310038047724638, 
  0.3100380477246379, 0.95072414977379, -0.950724149773789, 
  -0.962746150638399, 0.962746150638399, 0.2704068220865447, 
  -0.2704068220865448, -0.4895578341011576, 0.4895578341011574, 
  0.871970829254158, -0.871970829254158, -0.7859812527678302, 
  0.7859812527678302, 0.6182503297997601, -0.6182503297997603, 
  -0.1186036730454008, 0.1186036730454007, 0.992941674389861, 
  -0.992941674389861, -0.984614768204313, 0.984614768204313, 
  0.1747391147796272, -0.1747391147796273, -0.5726685664544813, 
  0.5726685664544813, 0.819786992452899, -0.819786992452899, 
  -0.842795667540004, 0.842795667540004, 0.5382336507278214, 
  -0.5382336507278218, -0.2153578673797456, 0.2153578673797454, 
  0.976535195964614, -0.976535195964614, -0.931605761351258, 
  0.931605761351258, 0.3634703638773638, -0.3634703638773638, 
  -0.401732392185905, 0.4017323921859049, 0.915757110301957, 
  -0.915757110301957, -0.7215974088704438, 0.7215974088704437, 
  0.6923129202257181, -0.6923129202257183, -0.02070726050426591, 
  0.02070726050426579, 0.999785581693599, -0.999785581693599, 
  -0.999870288328983, 0.999870288328983, 0.01610610185353714, 
  -0.01610610185353727, -0.6956263273452549, 0.6956263273452549, 
  0.7184037950234896, -0.7184037950234899, -0.917596156213973, 
  0.917596156213973, 0.3975138917086322, -0.3975138917086323, 
  -0.3677536960065821, 0.367753696006582, 0.92992323289264, 
  -0.92992323289264, -0.977515916508569, 0.977515916508569, 
  0.2108616441470847, -0.2108616441470848, -0.5421064348124441, 
  0.5421064348124438, 0.840309831749541, -0.840309831749541, 
  -0.822413690229926, 0.822413690229926, 0.5688899033401759, 
  -0.568889903340176, -0.1792683889018359, 0.1792683889018358, 
  0.983800205702632, -0.983800205702632, -0.993476965552789, 
  0.993476965552789, 0.1140329729333672, -0.1140329729333673, 
  -0.6218608108549654, 0.6218608108549653, 0.7831277877350572, 
  -0.7831277877350575, -0.874214505010706, 0.874214505010706, 
  0.4855399048779469, -0.4855399048779471, -0.2748344454288439, 
  0.2748344454288438, 0.961491563980579, -0.961491563980579, 
  -0.952140854823816, 0.952140854823816, 0.3056596024589661, 
  -0.3056596024589662, -0.4571312774571571, 0.4571312774571572, 
  0.889399232724195, -0.889399232724196, -0.762692582035178, 
  0.762692582035178, 0.6467611810463838, -0.646761181046384, 
  -0.0819758797916331, 0.081975879791633, 0.99663431364387, 
  -0.99663431364387, -0.99787561181711, 0.99787561181711, 
  0.06514801102587875, -0.06514801102587886, -0.6595380115193388, 
  0.6595380115193385, 0.7516712122737685, -0.7516712122737685, 
  -0.896985789278864, 0.896985789278864, 0.4420593781742149, 
  -0.4420593781742148, -0.3216815502329566, 0.3216815502329565, 
  0.946847918221148, -0.946847918221148, -0.965991965293841, 
  0.965991965293841, 0.2585720847031703, -0.2585720847031704, 
  -0.5002213947118407, 0.5002213947118407, 0.865897543750149, 
  -0.865897543750149, -0.7935089524173267, 0.7935089524173266, 
  0.6085585776517794, -0.6085585776517794, -0.1307796641797118, 
  0.1307796641797117, 0.991411458193339, -0.991411458193339, 
  -0.986684946260147, 0.986684946260147, 0.1626432194209503, 
  -0.1626432194209504, -0.5826854930286684, 0.5826854930286684, 
  0.812697739761799, -0.8126977397618, -0.849337161427831, 0.849337161427831, 
  0.5278507234225552, -0.5278507234225555, -0.2273252403730388, 
  0.2273252403730387, 0.973818892345666, -0.973818892345666, 
  -0.935995953636831, 0.935995953636831, 0.3520107594598191, 
  -0.3520107594598192, -0.412939890915108, 0.4129398909151079, 
  0.910758281044438, -0.910758281044438, -0.7300388184189263, 
  0.7300388184189261, 0.6834056801062588, -0.6834056801062589, 
  -0.03297460832889731, 0.03297460832889719, 0.999456189737977, 
  -0.999456189737977, -0.999173882565716, 0.999173882565716, 
  0.04063929623593374, -0.04063929623593385, -0.6777863059956317, 
  0.6777863059956316, 0.7352589498977867, -0.7352589498977869, 
  -0.907564314149833, 0.907564314149833, 0.4199131049178435, 
  -0.4199131049178437, -0.3448214769017593, 0.3448214769017592, 
  0.93866828489477, -0.93866828489477, -0.972046703194623, 0.972046703194623, 
  0.234787578054001, -0.2347875780540011, -0.5213209268785957, 
  0.5213209268785955, 0.853360704039296, -0.853360704039296, 
  -0.808204737480195, 0.808204737480195, 0.5889016066496758, 
  -0.5889016066496759, -0.1550707309457005, 0.1550707309457004, 
  0.987903369972978, -0.987903369972978, -0.990379239617108, 
  0.990379239617108, 0.1383797735777838, -0.1383797735777839, 
  -0.6024546000037239, 0.6024546000037238, 0.7981531525555436, 
  -0.7981531525555439, -0.862035462183687, 0.862035462183687, 
  0.5068479672818632, -0.5068479672818633, -0.251155486237742, 
  0.2511554862377419, 0.967946755628988, -0.967946755628988, 
  -0.944352825645595, 0.944352825645595, 0.3289342498056121, 
  -0.3289342498056122, -0.4351666482446194, 0.4351666482446191, 
  0.900349925448736, -0.900349925448736, -0.7465905593451173, 
  0.7465905593451171, 0.6652838016190872, -0.6652838016190872, 
  -0.0574925597443677, 0.05749255974436755, 0.998345934821212, 
  -0.998345934821212, -0.995976258112918, 0.995976258112918, 
  0.0896174830900228, -0.0896174830900229, -0.6408924360066214, 
  0.6408924360066212, 0.7676306960182733, -0.7676306960182734, 
  -0.885866953708893, 0.885866953708893, 0.4639393713908386, 
  -0.4639393713908385, -0.2983478546267416, 0.2983478546267415, 
  0.954457205766514, -0.954457205766514, -0.959355349953931, 
  0.959355349953931, 0.2822008371971474, -0.2822008371971475, 
  -0.4788205478813941, 0.478820547881394, 0.877912799158642, 
  -0.877912799158642, -0.7783351872327332, 0.7783351872327331, 
  0.6278489757221763, -0.6278489757221766, -0.1064098206341878, 
  0.1064098206341877, 0.994322357222546, -0.994322357222546, 
  -0.982396310786085, 0.982396310786085, 0.1868086950703592, 
  -0.1868086950703593, -0.5625653981006266, 0.5625653981006266, 
  0.826752788238348, -0.826752788238349, -0.836127251724692, 
  0.836127251724692, 0.5485355220250671, -0.5485355220250675, 
  -0.2033580622837733, 0.2033580622837733, 0.979104436975029, 
  -0.979104436975029, -0.92707527266474, 0.92707527266474, 
  0.3748752309950575, -0.3748752309950576, -0.3904643940361266, 
  0.3904643940361265, 0.920618029907084, -0.920618029907084, 
  -0.7130473294064294, 0.7130473294064292, 0.7011159005659186, 
  -0.7011159005659187, -0.00843679424236986, 0.00843679424236974, 
  0.999964409618118, -0.999964409618118, -0.99995029123649, 0.99995029123649, 
  0.00997070990741791, -0.00997070990741803, -0.7000212751940064, 
  0.7000212751940062, 0.7141219883715647, -0.7141219883715648, 
  -0.920017982111607, 0.920017982111606, 0.3918761444529222, 
  -0.3918761444529224, -0.3734526748367804, 0.3734526748367803, 
  0.927649233092581, -0.927649233092581, -0.978791337773106, 
  0.978791337773106, 0.2048597498298143, -0.2048597498298144, 
  -0.5472522740091741, 0.5472522740091741, 0.836967710602857, 
  -0.836967710602857, -0.825888851349587, 0.825888851349587, 
  0.563832958611378, -0.5638329586113783, -0.185301498805082, 
  0.1853014988050819, 0.982681715786241, -0.982681715786241, 
  -0.99415795679779, 0.99415795679779, 0.1079349662326537, 
  -0.1079349662326537, -0.6266542862720295, 0.6266542862720295, 
  0.7792973793725301, -0.7792973793725304, -0.877177265018596, 
  0.877177265018596, 0.4801666853650881, -0.4801666853650885, 
  -0.2807288730757972, 0.2807288730757971, 0.95978711171884, 
  -0.95978711171884, -0.953998423103895, 0.953998423103895, 
  0.2998116220483833, -0.2998116220483835, -0.4625799231890868, 
  0.4625799231890868, 0.886577585246987, -0.886577585246987, 
  -0.7666466765653106, 0.7666466765653103, 0.6420692122437925, 
  -0.6420692122437927, -0.0880895698047705, 0.0880895698047704, 
  0.996112557742151, -0.996112557742151, -0.998256567771495, 
  0.998256567771495, 0.05902393498466786, -0.05902393498466799, 
  -0.6641377637552601, 0.66413776375526, 0.7476102131152051, 
  -0.7476102131152053, -0.899681329127424, 0.899681329127424, 
  0.4365472551964011, -0.4365472551964013, -0.3274852442751781, 
  0.3274852442751779, 0.944856293190677, -0.944856293190677, 
  -0.967560349253315, 0.967560349253314, 0.2526400018856955, 
  -0.2526400018856956, -0.5055250256318855, 0.5055250256318851, 
  0.8628119426966, -0.8628119426966, -0.7972280600702688, 0.7972280600702685, 
  0.6036782423084305, -0.6036782423084305, -0.1368603886368164, 
  0.1368603886368163, 0.99059034621895, -0.99059034621895, 
  -0.987664332228206, 0.987664332228206, 0.1565859726929985, 
  -0.1565859726929986, -0.5876611437247368, 0.5876611437247366, 
  0.809107149984558, -0.809107149984558, -0.852560004046684, 
  0.852560004046684, 0.5226293519310966, -0.5226293519310969, 
  -0.2332962014322315, 0.2332962014322315, 0.97240571902745, 
  -0.97240571902745, -0.938138231192824, 0.938138231192824, 0.34626096975316, 
  -0.3462609697531601, -0.4185204251941097, 0.4185204251941098, 
  0.908207384739489, -0.908207384739489, -0.7342183740661883, 
  0.7342183740661882, 0.6789133812082382, -0.6789133812082385, 
  -0.03910653548332985, 0.03910653548332972, 0.999235046864596, 
  -0.999235046864596, -0.999404431433671, 0.999404431433671, 
  0.03450771552479576, -0.03450771552479589, -0.6822850109637957, 
  0.6822850109637955, 0.7310862902654743, -0.7310862902654744, 
  -0.910123767882542, 0.910123767882542, 0.4143364902289992, 
  -0.4143364902289992, -0.3505745460548375, 0.3505745460548375, 
  0.936534829922756, -0.936534829922756, -0.973469034186131, 
  0.973469034186131, 0.2288187917998022, -0.2288187917998024, 
  -0.5265472360035794, 0.5265472360035794, 0.850145874692685, 
  -0.850145874692685, -0.811802955582516, 0.811802955582515, 
  0.5839314697012761, -0.5839314697012763, -0.1611294729056788, 
  0.1611294729056787, 0.986933276853678, -0.986933276853678, 
  -0.991209678336254, 0.991209678336254, 0.1323003158444446, 
  -0.1323003158444447, -0.607340634642573, 0.6073406346425726, 
  0.7944415356160306, -0.7944415356160306, -0.865129195271624, 
  0.865129195271624, 0.5015490758526754, -0.5015490758526754, 
  -0.2570899679457532, 0.2570899679457531, 0.966387473212299, 
  -0.966387473212299, -0.946353351084491, 0.946353351084491, 
  0.3231336177050522, -0.3231336177050523, -0.440682899641873, 
  0.4406828996418729, 0.897662844259041, -0.897662844259041, 
  -0.7506586096545107, 0.7506586096545105, 0.6606902842872423, 
  -0.6606902842872424, -0.0636172129591932, 0.06361721295919308, 
  0.997974373526347, -0.997974373526347, -0.996507391680111, 
  0.996507391680111, 0.0835046006331523, -0.0835046006331524, 
  -0.6455904647915488, 0.6455904647915487, 0.7636838035275018, 
  -0.763683803527502, -0.888696955980892, 0.888696955980892, 
  0.4584950604208262, -0.4584950604208263, -0.3041986776298293, 
  0.3041986776298291, 0.952608610358033, -0.952608610358033, 
  -0.961068842145519, 0.961068842145519, 0.2763090310812709, 
  -0.276309031081271, -0.4841983058875492, 0.4841983058875489, 
  0.874958285048852, -0.874958285048852, -0.782172944184913, 
  0.7821729441849128, 0.6230613817154013, -0.6230613817154014, 
  -0.1125088647873788, 0.1125088647873787, 0.993650721000219, 
  -0.993650721000219, -0.983524054057571, 0.983524054057571, 
  0.1807773080067286, -0.1807773080067287, -0.5676276677079864, 
  0.5676276677079862, 0.8232853884604, -0.8232853884604, -0.839477262554579, 
  0.839477262554578, 0.5433948156302847, -0.5433948156302849, 
  -0.2093619060104742, 0.2093619060104741, 0.97783822399805, 
  -0.97783822399805, -0.929358011909936, 0.929358011909936, 0.36917974714062, 
  -0.36917974714062, -0.3961058496916963, 0.3961058496916962, 
  0.918204855051431, -0.918204855051431, -0.7173358727835218, 
  0.7173358727835218, 0.6967275260946009, -0.6967275260946013, 
  -0.0145723016927791, 0.01457230169277898, 0.999893818374419, 
  -0.999893818374419, -0.999752640870249, 0.999752640870249, 
  0.02224088741402479, -0.02224088741402492, -0.6912051895584486, 
  0.6912051895584482, 0.7226585541785756, -0.7226585541785758, 
  -0.915139783339685, 0.915139783339685, 0.4031366727909952, 
  -0.4031366727909952, -0.3620408714575843, 0.3620408714575842, 
  0.932162221608575, -0.932162221608575, -0.976203692322271, 
  0.976203692322271, 0.2168555996426325, -0.2168555996426326, 
  -0.5369401856148432, 0.536940185614843, 0.843620315706004, 
  -0.843620315706004, -0.818907565699659, 0.818907565699659, 
  0.5739254296856506, -0.5739254296856508, -0.1732285296450705, 
  0.1732285296450704, 0.984881656097324, -0.984881656097324, 
  -0.992758570461551, 0.992758570461551, 0.1201266863571015, 
  -0.1201266863571016, -0.6170439227298498, 0.6170439227298498, 
  0.7869287117790016, -0.7869287117790018, -0.871218831320811, 
  0.871218831320811, 0.4908948440878148, -0.4908948440878153, 
  -0.2689296704203573, 0.2689296704203572, 0.963159816628371, 
  -0.963159816628371, -0.950247438978705, 0.950247438978705, 
  0.3114960749582758, -0.311496074958276, -0.4516654209910026, 
  0.4516654209910025, 0.892187394822983, -0.892187394822983, 
  -0.7587097725604074, 0.7587097725604073, 0.6514287996560597, 
  -0.6514287996560598, -0.07585910343295449, 0.07585910343295438, 
  0.99711854682698, -0.99711854682698, -0.997457086409942, 0.997457086409942, 
  0.07126963428129631, -0.07126963428129641, -0.6549134280500562, 
  0.6549134280500561, 0.7557039114360358, -0.755703911436036, 
  -0.894256478422316, 0.894256478422316, 0.4475548578662929, 
  -0.447554857866293, -0.3158657450621841, 0.315865745062184, 
  0.948803894962658, -0.948803894962658, -0.964387212282854, 
  0.964387212282854, 0.2644944324278015, -0.2644944324278016, 
  -0.4948989307390114, 0.4948989307390109, 0.868950544250582, 
  -0.868950544250582, -0.7897599696008192, 0.7897599696008189, 
  0.6134160011086387, -0.6134160011086387, -0.1246940159421678, 
  0.1246940159421676, 0.992195244086674, -0.992195244086674, 
  -0.985668412161538, 0.985668412161538, 0.1686943427236173, 
  -0.1686943427236174, -0.577687904553123, 0.5776879045531226, 
  0.816257731928477, -0.816257731928478, -0.846082341744897, 
  0.846082341744897, 0.5330522216326195, -0.5330522216326197, 
  -0.2213457206470308, 0.2213457206470307, 0.97519540193299, 
  -0.97519540193299, -0.933818436362211, 0.933818436362211, 
  0.3577472961603419, -0.3577472961603419, -0.407343809682608, 
  0.4073438096826079, 0.913274887814868, -0.913274887814868, 
  -0.7258317772227704, 0.7258317772227703, 0.6878722491666853, 
  -0.6878722491666856, -0.02684143969909853, 0.02684143969909841, 
  0.99963970365071, -0.99963970365071, -0.998905715365818, 0.998905715365818, 
  0.04676934690053784, -0.04676934690053797, -0.6732620827561331, 
  0.6732620827561329, 0.7394039274462056, -0.7394039274462059, 
  -0.904970691133653, 0.904970691133653, 0.4254739101156238, 
  -0.4254739101156239, -0.3390554254149696, 0.3390554254149695, 
  0.940766399536396, -0.940766399536396, -0.970587775194143, 
  0.970587775194144, 0.2407475246885884, -0.2407475246885885, 
  -0.5160749903153668, 0.5160749903153668, 0.85654340483772, 
  -0.85654340483772, -0.804576090926307, 0.804576090926307, 
  0.5938495717854333, -0.5938495717854337, -0.1490061506603485, 
  0.1490061506603484, 0.988836269088764, -0.988836269088764, 
  -0.989511513679355, 0.989511513679355, 0.1444540213908603, 
  -0.1444540213908604, -0.5975458832896933, 0.5975458832896931, 
  0.801834719479981, -0.801834719479981, -0.858909273947824, 
  0.858909273947824, 0.5121277761715547, -0.5121277761715547, 
  -0.2452115486676277, 0.2452115486676276, 0.969469595397413, 
  -0.969469595397413, -0.942316745856564, 0.942316745856564, 
  0.3347224977175811, -0.3347224977175812, -0.4296340130690166, 
  0.4296340130690164, 0.903003108972617, -0.903003108972617, 
  -0.7424944003231393, 0.7424944003231392, 0.6698522713918209, 
  -0.6698522713918212, -0.05136574196716273, 0.05136574196716261, 
  0.998679908955899, -0.998679908955899, -0.995407626602535, 
  0.995407626602535, 0.0957269914993072, -0.0957269914993073, 
  -0.6361702779837123, 0.6361702779837123, 0.7715486876472062, 
  -0.7715486876472064, -0.883003599046781, 0.883003599046781, 
  0.4693662153057374, -0.4693662153057377, -0.2924857989955538, 
  0.2924857989955537, 0.956269866400658, -0.956269866400658, 
  -0.957605738575646, 0.957605738575646, 0.2880820186110042, 
  -0.2880820186110043, -0.4734247625522415, 0.4734247625522415, 
  0.880834260347742, -0.880834260347742, -0.7744681264006709, 
  0.7744681264006707, 0.6326129315698774, -0.6326129315698776, 
  -0.1003067702113928, 0.1003067702113927, 0.994956557770116, 
  -0.994956557770116, -0.98123158084875, 0.98123158084875, 
  0.1928330488922052, -0.1928330488922052, -0.5574819482239917, 
  0.5574819482239915, 0.830189061241102, -0.830189061241102, 
  -0.83274576117636, 0.832745761176359, 0.5536555763674792, 
  -0.5536555763674793, -0.197346562240966, 0.1973465622409659, 
  0.980333787223348, -0.980333787223348, -0.924757629559514, 
  0.924757629559514, 0.3805566010089285, -0.3805566010089286, 
  -0.3848082376168129, 0.3848082376168128, 0.922996544014246, 
  -0.922996544014246, -0.7087319402004008, 0.7087319402004005, 
  0.7054778784198522, -0.7054778784198522, -0.002300969151425886, 
  0.002300969151425764, 0.999997352766978, -0.999997352766978};


static const double mod4096[4096] = 
{-0.999999926465718, 0.999999926465718, 0.0003834951875713746, 
  -0.0003834951875714971, -0.7068355571422739, 0.7068355571422739, 
  0.7073779012376419, -0.7073779012376422, -0.923732707319793, 
  0.923732707319793, 0.3830377075793521, -0.3830377075793521, 
  -0.3823291008701245, 0.3823291008701244, 0.924026221829144, 
  -0.924026221829144, -0.980710392082254, 0.980710392082254, 
  0.1954664341053769, -0.1954664341053771, -0.5552513275712141, 
  0.555251327571214, 0.831682609671745, -0.831682609671745, 
  -0.831256492650303, 0.831256492650303, 0.5558890567610738, 
  -0.5558890567610739, -0.194714181235226, 0.1947141812352259, 
  0.980860024481524, -0.980860024481524, -0.995147064390386, 
  0.995147064390386, 0.0983987816753638, -0.0983987816753639, 
  -0.6340967917251838, 0.6340967917251838, 0.7732536832914724, 
  -0.7732536832914727, -0.881740421116898, 0.881740421116898, 
  0.4717349147228714, -0.4717349147228715, -0.2899176738950409, 
  0.2899176738950407, 0.957051588141041, -0.957051588141041, 
  -0.956828942587535, 0.956828942587535, 0.2906516379221331, 
  -0.2906516379221332, -0.4710584896014826, 0.4710584896014823, 
  0.882101977876918, -0.882101977876918, -0.7727671097484638, 
  0.7727671097484637, 0.6346896833027978, -0.6346896833027979, 
  -0.0976354845685173, 0.0976354845685172, 0.995222242593618, 
  -0.995222242593618, -0.998776565542496, 0.998776565542496, 
  0.0494507039700847, -0.04945070397008483, -0.6712747542736137, 
  0.6712747542736133, 0.7412086104970043, -0.7412086104970044, 
  -0.903825261328487, 0.903825261328487, 0.4279017375338542, 
  -0.4279017375338542, -0.3365287510013823, 0.3365287510013823, 
  0.941673191584771, -0.941673191584771, -0.969938000134324, 
  0.969938000134324, 0.2433521643532848, -0.2433521643532849, 
  -0.5137737715948681, 0.5137737715948681, 0.85792570285613, 
  -0.85792570285613, -0.802979024600843, 0.802979024600843, 
  0.5960072869110564, -0.5960072869110567, -0.1463511192344114, 
  0.1463511192344113, 0.98923270765722, -0.98923270765722, 
  -0.989120166795573, 0.989120166795573, 0.1471098080968717, 
  -0.1471098080968718, -0.5953912344651688, 0.5953912344651684, 
  0.803435920233868, -0.803435920233868, -0.857531390999499, 
  0.857531390999499, 0.514431641183223, -0.514431641183223, 
  -0.2426081597184969, 0.2426081597184968, 0.97012436359366, 
  -0.97012436359366, -0.941414800309736, 0.941414800309736, 
  0.3372509062371505, -0.3372509062371507, -0.4272083864467965, 
  0.4272083864467963, 0.904153191969992, -0.904153191969992, 
  -0.7406935312422958, 0.7406935312422956, 0.6718430566552119, 
  -0.6718430566552121, -0.04868463746843902, 0.0486846374684389, 
  0.998814199976435, -0.998814199976435, -0.999689333741033, 
  0.999689333741034, 0.02492460640428136, -0.02492460640428149, 
  -0.6892627487612736, 0.6892627487612733, 0.7245114651750196, 
  -0.7245114651750196, -0.914054280384047, 0.914054280384046, 
  0.4055918792476038, -0.4055918792476039, -0.3595372118219732, 
  0.3595372118219731, 0.933130748242325, -0.933130748242325, 
  -0.975618034019782, 0.975618034019782, 0.2194754011167902, 
  -0.2194754011167903, -0.5346735832699557, 0.5346735832699555, 
  0.845058672136596, -0.845058672136596, -0.817363933360699, 
  0.817363933360698, 0.5761216889174783, -0.5761216889174784, 
  -0.1705840269544637, 0.1705840269544636, 0.985343132998855, 
  -0.985343132998855, -0.992432517712594, 0.992432517712594, 
  0.1227912773231168, -0.1227912773231169, -0.6149292182788797, 
  0.6149292182788796, 0.788582308010347, -0.7885823080103473, 
  -0.869897903042807, 0.869897903042807, 0.4932318301587278, 
  -0.4932318301587281, -0.2663431343792382, 0.266343134379238, 
  0.963878277983814, -0.963878277983814, -0.949407815332292, 
  0.949407815332292, 0.3140458568202507, -0.3140458568202508, 
  -0.44926874937183, 0.4492687493718299, 0.893396659294108, 
  -0.893396659294108, -0.7569583021837506, 0.7569583021837504, 
  0.6534631808718024, -0.6534631808718025, -0.07318210209940288, 
  0.07318210209940278, 0.997318594999769, -0.997318594999769, 
  -0.997262171687536, 0.997262171687536, 0.07394701428089716, 
  -0.07394701428089727, -0.652882408974559, 0.6528824089745589, 
  0.7574592794676006, -0.7574592794676008, -0.893051811731707, 
  0.893051811731707, 0.4499538438136905, -0.4499538438136906, 
  -0.313317577844809, 0.313317577844809, 0.949648406208036, 
  -0.949648406208036, -0.963673711865903, 0.963673711865903, 
  0.2670823413454962, -0.2670823413454963, -0.4925644818110107, 
  0.4925644818110107, 0.870275951212172, -0.870275951212172, 
  -0.7881104313018881, 0.7881104313018881, 0.6155338724011471, 
  -0.6155338724011475, -0.1220300550725534, 0.1220300550725533, 
  0.992526405522286, -0.992526405522286, -0.985212006875659, 
  0.985212006875659, 0.1713397254230191, -0.1713397254230192, 
  -0.5754946092349283, 0.5754946092349281, 0.817805572701444, 
  -0.817805572701444, -0.844648334111418, 0.844648334111418, 
  0.5353215778229071, -0.5353215778229071, -0.2187270469740446, 
  0.2187270469740445, 0.975786082562164, -0.975786082562164, 
  -0.932854712213241, 0.932854712213241, 0.3602528083187567, 
  -0.3602528083187568, -0.4048906891641178, 0.4048906891641177, 
  0.914365096571498, -0.914365096571498, -0.7239825942139357, 
  0.7239825942139355, 0.6898182393031222, -0.6898182393031225, 
  -0.02415784703230002, 0.0241578470322999, 0.999708156627105, 
  -0.999708156627105, -0.999919922234523, 0.999919922234523, 
  0.01265500369443018, -0.0126550036944303, -0.6981017187272839, 
  0.6981017187272835, 0.7159985965838287, -0.7159985965838287, 
  -0.918962690052376, 0.918962690052376, 0.3943444868280795, 
  -0.3943444868280796, -0.370961089033802, 0.3709610890338019, 
  0.92864841055313, -0.92864841055313, -0.978237872563701, 0.978237872563701, 
  0.2074865409660206, -0.2074865409660207, -0.5450034931812812, 
  0.5450034931812811, 0.838433773425308, -0.838433773425308, 
  -0.824372286722551, 0.824372286722551, 0.5660479952122715, 
  -0.5660479952122716, -0.1826628582721293, 0.1826628582721292, 
  0.983175610055424, -0.983175610055424, -0.99386462723006, 0.99386462723006, 
  0.1106033577286618, -0.1106033577286619, -0.6245600332238773, 
  0.6245600332238772, 0.7809768017677536, -0.7809768017677538, 
  -0.875885114618104, 0.875885114618104, 0.4825197052871842, 
  -0.4825197052871845, -0.278151348422115, 0.278151348422115, 
  0.96053725975152, -0.96053725975152, -0.953190152425337, 0.953190152425337, 
  0.302371515390196, -0.3023715153901961, -0.4601982715701343, 
  0.4601982715701342, 0.887816169510255, -0.887816169510255, 
  -0.7649203030581285, 0.7649203030581282, 0.6441249335101544, 
  -0.6441249335101546, -0.0854152249433073, 0.0854152249433072, 
  0.996345441776036, -0.996345441776036, -0.99809452329698, 0.99809452329698, 
  0.0617035052859573, -0.06170350528595742, -0.6621284386777688, 
  0.6621284386777687, 0.7493903726991295, -0.7493903726991296, 
  -0.898506192393902, 0.898506192393902, 0.4389608436179844, 
  -0.4389608436179845, -0.3249476323821884, 0.3249476323821883, 
  0.945732010777477, -0.945732010777477, -0.966878660184996, 
  0.966878660184996, 0.2552364716862917, -0.2552364716862918, 
  -0.503207017265869, 0.503207017265869, 0.864165897136879, 
  -0.864165897136879, -0.7956046355171882, 0.7956046355171882, 
  0.6058161965015147, -0.6058161965015151, -0.134200692218792, 
  0.1342006922187919, 0.990954173616519, -0.990954173616519, 
  -0.987240424223882, 0.987240424223882, 0.1592367569948877, 
  -0.1592367569948878, -0.5854870079449515, 0.5854870079449512, 
  0.810681789315431, -0.810681789315431, -0.851153952882715, 
  0.851153952882715, 0.524916134722613, -0.524916134722613, 
  -0.2306849735005123, 0.2306849735005122, 0.973028490333694, 
  -0.973028490333694, -0.937205326098888, 0.937205326098888, 
  0.3487781196289083, -0.3487781196289084, -0.4160808679295793, 
  0.4160808679295793, 0.909327614967767, -0.909327614967767, 
  -0.732393210589896, 0.732393210589896, 0.6808819171352872, 
  -0.6808819171352873, -0.03642398490944423, 0.0364239849094441, 
  0.999336426496761, -0.999336426496761, -0.999308195711029, 
  0.99930819571103, 0.03719045556008798, -0.0371904555600881, 
  -0.6803199783606074, 0.6803199783606071, 0.7329152250045178, 
  -0.7329152250045179, -0.909008217503247, 0.909008217503247, 
  0.4167781910219978, -0.4167781910219976, -0.3480591896285257, 
  0.3480591896285257, 0.937472559873159, -0.937472559873159, 
  -0.972851270988544, 0.972851270988544, 0.2314312090794456, 
  -0.2314312090794457, -0.5242631534836735, 0.5242631534836734, 
  0.851556308120229, -0.851556308120229, -0.810232487996982, 
  0.810232487996982, 0.5861086208154762, -0.5861086208154765, 
  -0.1584795063097961, 0.158479506309796, 0.987362266890832, 
  -0.987362266890832, -0.990850951508414, 0.990850951508414, 
  0.1349607050028687, -0.1349607050028688, -0.6052057972554966, 
  0.6052057972554966, 0.7960690566579878, -0.796069056657988, 
  -0.863779688043047, 0.863779688043047, 0.5038696761308987, 
  -0.5038696761308991, -0.2544948100400108, 0.2544948100400107, 
  0.967074139692867, -0.967074139692867, -0.945482500914454, 
  0.945482500914454, 0.3256729040994198, -0.3256729040994199, 
  -0.4382715689524105, 0.4382715689524104, 0.898842606827242, 
  -0.898842606827242, -0.7488823061733752, 0.7488823061733751, 
  0.6627030190820374, -0.6627030190820376, -0.06093795830010725, 
  0.06093795830010711, 0.99814155571152, -0.99814155571152, 
  -0.996279636063255, 0.996279636063255, 0.0861793871274848, 
  -0.0861793871274849, -0.6435380575820479, 0.6435380575820476, 
  0.7654141156547381, -0.7654141156547383, -0.887462940751569, 
  0.887462940751569, 0.4608790826155787, -0.4608790826155788, 
  -0.3016403388326789, 0.3016403388326788, 0.9534217880817, -0.9534217880817, 
  -0.960323637830474, 0.960323637830474, 0.2788879893865002, 
  -0.2788879893865003, -0.4818477679569862, 0.4818477679569858, 
  0.876254944930339, -0.876254944930339, -0.7804975405545321, 
  0.7804975405545317, 0.6251588511637078, -0.6251588511637078, 
  -0.1098410406488827, 0.1098410406488826, 0.993949166602181, 
  -0.993949166602181, -0.983035220223096, 0.983035220223096, 
  0.1834168907187391, -0.1834168907187392, -0.5654155431535898, 
  0.5654155431535896, 0.824806197576334, -0.824806197576334, 
  -0.838015514407864, 0.838015514407864, 0.5456464034626486, 
  -0.5456464034626487, -0.2067361809588437, 0.2067361809588435, 
  0.978396724995823, -0.978396724995823, -0.928363613839244, 
  0.928363613839244, 0.3716732442607865, -0.3716732442607866, 
  -0.3936395353501729, 0.3936395353501728, 0.919264878154985, 
  -0.919264878154985, -0.7154629487223038, 0.7154629487223037, 
  0.6986506773814694, -0.6986506773814697, -0.01188807107225207, 
  0.01188807107225195, 0.999929334386276, -0.999929334386276, 
  -0.999978748667469, 0.999978748667469, 0.006519372166339426, 
  -0.006519372166339549, -0.7024818619573081, 0.7024818619573079, 
  0.7117016464931029, -0.7117016464931031, -0.921365043122642, 
  0.921365043122642, 0.3886984143415191, -0.3886984143415192, 
  -0.3766521853229096, 0.3766521853229095, 0.926354754557603, 
  -0.926354754557603, -0.979492570993821, 0.979492570993821, 
  0.2014802803450377, -0.2014802803450378, -0.5501377665642337, 
  0.5501377665642337, 0.835073911578919, -0.835073911578919, 
  -0.82782997335173, 0.82782997335173, 0.560979086259438, 
  -0.5609790862594383, -0.1886920718286052, 0.1886920718286051, 
  0.982036303824369, -0.982036303824369, -0.994524567454152, 
  0.994524567454152, 0.1045030369421504, -0.1045030369421505, 
  -0.6293402596270658, 0.6293402596270656, 0.7771298717798317, 
  -0.7771298717798317, -0.878829311580933, 0.878829311580933, 
  0.4771362919608849, -0.4771362919608848, -0.2840398581286374, 
  0.2840398581286372, 0.958812473320129, -0.958812473320129, 
  -0.955027525629714, 0.955027525629714, 0.2965171585078773, 
  -0.2965171585078774, -0.4656371460734938, 0.4656371460734937, 
  0.884975733111667, -0.884975733111667, -0.7688581799412534, 
  0.7688581799412533, 0.6394193452949505, -0.6394193452949507, 
  -0.091527077727285, 0.0915270777272849, 0.995802587887129, 
  -0.995802587887129, -0.998454340040525, 0.998454340040525, 
  0.0555781508710047, -0.05557815087100482, -0.6667141471810977, 
  0.6667141471810977, 0.7453135219144903, -0.7453135219144906, 
  -0.901182691370684, 0.901182691370684, 0.4334394499510739, 
  -0.4334394499510742, -0.3307444178619829, 0.3307444178619828, 
  0.943720366450326, -0.943720366450326, -0.968426560515983, 
  0.968426560515983, 0.2492990110032182, -0.2492990110032183, 
  -0.5084999667985409, 0.5084999667985408, 0.861062009245492, 
  -0.861062009245492, -0.7993068767850862, 0.799306876785086, 
  0.6009230539129541, -0.6009230539129542, -0.1402785464305954, 
  0.1402785464305953, 0.990112079216954, -0.990112079216954, 
  -0.988198898074718, 0.988198898074718, 0.1531761660439177, 
  -0.1531761660439179, -0.590450236263896, 0.5904502362638957, 
  0.807074047715518, -0.807074047715518, -0.854358755003227, 
  0.854358755003227, 0.5196836708511583, -0.5196836708511585, 
  -0.2366510214981065, 0.2366510214981063, 0.97159471695965, 
  -0.97159471695965, -0.939327745783671, 0.939327745783671, 
  0.3430209702058554, -0.3430209702058555, -0.4216525646785584, 
  0.4216525646785582, 0.906757472922057, -0.906757472922057, 
  -0.7365572363979193, 0.736557236397919, 0.6763752194676118, 
  -0.6763752194676118, -0.04255511227690412, 0.042555112276904, 
  0.999094120901079, -0.999094120901079, -0.999517580362017, 
  0.999517580362017, 0.03105811564243457, -0.0310581156424347, 
  -0.6848042548075107, 0.6848042548075107, 0.7287270631707936, 
  -0.7287270631707939, -0.911548408584834, 0.911548408584834, 
  0.4111927757226001, -0.4111927757226002, -0.3538048610017721, 
  0.3538048610017721, 0.935319261178512, -0.935319261178512, 
  -0.974252992541422, 0.974252992541422, 0.2254575492727684, 
  -0.2254575492727685, -0.5294783356568522, 0.5294783356568518, 
  0.848323459577802, -0.848323459577802, -0.813813530488567, 
  0.813813530488567, 0.5811260944009776, -0.5811260944009778, 
  -0.1645348639544461, 0.164534863954446, 0.986371268105216, 
  -0.986371268105216, -0.991660402337333, 0.991660402337333, 
  0.1288784172627766, -0.1288784172627766, -0.6100789923318098, 
  0.6100789923318095, 0.7923405979220071, -0.7923405979220072, 
  -0.86685511384547, 0.86685511384547, 0.4985601383985251, 
  -0.4985601383985253, -0.260423874615468, 0.2604238746154679, 
  0.96549438399727, -0.96549438399727, -0.947462993846478, 0.947462993846478, 
  0.3198654018356305, -0.3198654018356306, -0.4437785131672183, 
  0.4437785131672184, 0.896136502577087, -0.896136502577087, 
  -0.7529344779573303, 0.7529344779573303, 0.658095488438511, 
  -0.6580954884385113, -0.06706129260963684, 0.06706129260963673, 
  0.997748857695926, -0.997748857695926, -0.996789668159205, 
  0.996789668159205, 0.0800647078996908, -0.0800647078996909, 
  -0.6482224358824706, 0.6482224358824702, 0.7614510316616537, 
  -0.7614510316616537, -0.890274135400644, 0.890274135400644, 
  0.4554250364622426, -0.4554250364622425, -0.3074847466522041, 
  0.3074847466522041, 0.951553009861369, -0.951553009861369, 
  -0.962016784542291, 0.962016784542291, 0.2729903043313299, 
  -0.27299030433133, -0.4872152965742689, 0.4872152965742687, 
  0.873281887355994, -0.873281887355994, -0.784318750507039, 
  0.7843187505070388, 0.6203580398472136, -0.6203580398472139, 
  -0.1159377303557278, 0.1159377303557277, 0.993256483834846, 
  -0.993256483834846, -0.984142139747039, 0.984142139747039, 
  0.1773816472302601, -0.1773816472302602, -0.5704658150520131, 
  0.570465815052013, 0.821321346281127, -0.821321346281127, 
  -0.841347762393502, 0.841347762393502, 0.540494165292695, 
  -0.5404941652926953, -0.2127356186543459, 0.2127356186543458, 
  0.977109797594801, -0.977109797594801, -0.930626681810532, 
  0.930626681810532, 0.3659699155700088, -0.3659699155700089, 
  -0.3992726284515409, 0.3992726284515408, 0.916832246471184, 
  -0.916832246471184, -0.7197363203009511, 0.7197363203009508, 
  0.6942475273558033, -0.6942475273558034, -0.0180232983357737, 
  0.01802329833577358, 0.999837567166337, -0.999837567166337, 
  -0.999823449381661, 0.999823449381661, 0.01879015876878447, 
  -0.0187901587687846, -0.6936952923621184, 0.6936952923621181, 
  0.7202685897320772, -0.7202685897320773, -0.916525738556228, 
  0.916525738556228, 0.3999757124675953, -0.3999757124675954, 
  -0.3652560262693603, 0.3652560262693603, 0.930907103460875, 
  -0.930907103460875, -0.976946344030582, 0.976946344030582, 
  0.213484989836008, -0.2134849898360081, -0.5398487007248477, 
  0.5398487007248474, 0.841762068714013, -0.841762068714013, 
  -0.820883562942715, 0.820883562942714, 0.5710955927780168, 
  -0.5710955927780168, -0.176626767562281, 0.1766267675622808, 
  0.984277900280454, -0.984277900280454, -0.993167268564487, 
  0.993167268564487, 0.1166995143612677, -0.1166995143612678, 
  -0.6197562924884408, 0.6197562924884405, 0.7847943284204991, 
  -0.7847943284204993, -0.872907941075761, 0.872907941075761, 
  0.4878849520193011, -0.4878849520193013, -0.2722523664745367, 
  0.2722523664745365, 0.962225882497979, -0.962225882497979, 
  -0.951316892150466, 0.951316892150466, 0.3082144881558611, 
  -0.3082144881558612, -0.4547420708619554, 0.4547420708619555, 
  0.890623180131856, -0.890623180131856, -0.7609536273579282, 
  0.7609536273579281, 0.6488062707856724, -0.6488062707856727, 
  -0.07930015632438758, 0.07930015632438746, 0.996850783822197, 
  -0.996850783822197, -0.997697128858759, 0.997697128858759, 
  0.06782653659881084, -0.06782653659881096, -0.6575178014129602, 
  0.6575178014129602, 0.7534390093597933, -0.7534390093597937, 
  -0.895795865166813, 0.895795865166814, 0.4444657106572338, 
  -0.4444657106572342, -0.3191386128076959, 0.3191386128076958, 
  0.947708048828952, -0.947708048828952, -0.965294357418935, 
  0.965294357418935, 0.2611643228604665, -0.2611643228604666, 
  -0.4978951222734109, 0.4978951222734108, 0.867237249670668, 
  -0.867237249670668, -0.7918724401844406, 0.7918724401844404, 
  0.6106865304526862, -0.6106865304526864, -0.1281177854267772, 
  0.128117785426777, 0.991758959151536, -0.991758959151536, 
  -0.986244781329065, 0.986244781329065, 0.1652913527719579, 
  -0.165291352771958, -0.5805017363710766, 0.5805017363710765, 
  0.814259009204175, -0.814259009204175, -0.847917105296951, 
  0.847917105296951, 0.5301288357982788, -0.530128835798279, 
  -0.2247102403440496, 0.2247102403440495, 0.974425629735035, 
  -0.974425629735035, -0.935047621163287, 0.935047621163287, 
  0.3545221377528874, -0.3545221377528875, -0.4104935059710925, 
  0.4104935059710925, 0.911863521342729, -0.911863521342728, 
  -0.7282016105914446, 0.7282016105914444, 0.6853629799836188, 
  -0.6853629799836188, -0.03029148619953943, 0.0302914861995393, 
  0.999541107640813, -0.999541107640813, -0.999061187671285, 
  0.999061187671285, 0.04332139527810967, -0.04332139527810979, 
  -0.6758100882510371, 0.675810088251037, 0.7370757929942656, 
  -0.7370757929942658, -0.906433802776045, 0.906433802776045, 
  0.422347914858067, -0.422347914858067, -0.3423004140235137, 
  0.3423004140235136, 0.939590563255789, -0.939590563255789, 
  -0.971412922135171, 0.971412922135171, 0.2373961556319065, 
  -0.2373961556319065, -0.519028233099081, 0.5190282330990807, 
  0.854757096048957, -0.854757096048957, -0.80662094071017, 0.80662094071017, 
  0.5910690805716714, -0.5910690805716716, -0.1524181820013065, 
  0.1524181820013064, 0.98831609204516, -0.98831609204516, 
  -0.990004195701201, 0.990004195701201, 0.1410379115486977, 
  -0.1410379115486978, -0.6003098165229805, 0.6003098165229803, 
  0.7997675438439256, -0.7997675438439257, -0.860671741423578, 
  0.860671741423578, 0.5091602434547546, -0.5091602434547548, 
  -0.2485561638787966, 0.2485561638787965, 0.968617485593698, 
  -0.968617485593698, -0.943466411100659, 0.943466411100659, 
  0.3314681449624408, -0.3314681449624409, -0.4327481240607438, 
  0.4327481240607439, 0.901514870161279, -0.901514870161279, 
  -0.7448019393938626, 0.7448019393938626, 0.6672855993314562, 
  -0.6672855993314565, -0.05481232971088991, 0.05481232971088979, 
  0.998496674261695, -0.998496674261695, -0.995732094602106, 
  0.995732094602106, 0.0922908217500622, -0.0922908217500624, 
  -0.6388294504374864, 0.6388294504374861, 0.7693483822389823, 
  -0.7693483822389823, -0.88461833362437, 0.88461833362437, 
  0.4663157769319446, -0.4663157769319445, -0.2957845744248844, 
  0.2957845744248843, 0.955254670510587, -0.955254670510587, 
  -0.95859433547647, 0.95859433547647, 0.2847751744664982, 
  -0.2847751744664983, -0.4764620980435814, 0.4764620980435812, 
  0.879195012001267, -0.879195012001267, -0.7766469453107621, 
  0.776646945310762, 0.6299361256027965, -0.6299361256027966, 
  -0.1037402154889395, 0.1037402154889394, 0.994604427745176, 
  -0.994604427745176, -0.981891289978725, 0.981891289978725, 
  0.1894452286649502, -0.1894452286649503, -0.560343983679541, 
  0.5603439836795409, 0.828259995384386, -0.828259995384386, 
  -0.834651715611756, 0.834651715611756, 0.550778098353912, 
  -0.5507780983539123, -0.2007289597629761, 0.200728959762976, 
  0.979646816313141, -0.979646816313141, -0.926065593502609, 
  0.926065593502609, 0.3773625796639883, -0.3773625796639885, 
  -0.3879916219427849, 0.3879916219427848, 0.921662900035695, 
  -0.921662900035695, -0.7111626403680185, 0.7111626403680182, 
  0.7030275236040113, -0.7030275236040114, -0.005752396229573736, 
  0.005752396229573613, 0.999983454831938, -0.999983454831938, 
  -0.999994043728986, 0.999994043728986, 0.003451449920135852, 
  -0.003451449920135974, -0.704662025823469, 0.7046620258234687, 
  0.7095431131103768, -0.7095431131103768, -0.922553216932333, 
  0.922553216932333, 0.3858698769375552, -0.3858698769375553, 
  -0.3794924290601527, 0.3794924290601526, 0.925194842336481, 
  -0.925194842336481, -0.980106094103952, 0.980106094103952, 
  0.1984742912830162, -0.1984742912830164, -0.55269714816575, 
  0.5526971481657498, 0.83338218268058, -0.83338218268058, 
  -0.829547137007809, 0.829547137007809, 0.5584366996197039, 
  -0.5584366996197043, -0.1917040287275799, 0.1917040287275798, 
  0.981452783056636, -0.981452783056636, -0.994840497831093, 
  0.994840497831093, 0.101451386758302, -0.1014513867583022, 
  -0.6317214986777924, 0.6317214986777924, 0.7751954257529411, 
  -0.7751954257529415, -0.880289009156621, 0.880289009156621, 
  0.4744378361366791, -0.4744378361366794, -0.2869801165949155, 
  0.2869801165949155, 0.957936538962351, -0.957936538962352, 
  -0.955932732910098, 0.955932732910098, 0.2935857798855912, 
  -0.2935857798855913, -0.4683500219818766, 0.4683500219818765, 
  0.883543013615962, -0.883543013615962, -0.7708162724530185, 
  0.7708162724530184, 0.6370575124128385, -0.6370575124128387, 
  -0.0945817262675155, 0.0945817262675154, 0.995517100333418, 
  -0.995517100333418, -0.998620152488109, 0.998620152488109, 
  0.05251467456460314, -0.05251467456460326, -0.6689975991574504, 
  0.6689975991574502, 0.7432645641503215, -0.7432645641503216, 
  -0.902508223725146, 0.902508223725146, 0.4306726205698268, 
  -0.4306726205698269, -0.3336381545963709, 0.3336381545963708, 
  0.942701215548982, -0.942701215548982, -0.969186841502986, 
  0.969186841502986, 0.2463267469388289, -0.246326746938829, 
  -0.5111392747154646, 0.5111392747154641, 0.859497901011602, 
  -0.859497901011602, -0.801146721041991, 0.801146721041991, 
  0.5984679869163144, -0.5984679869163144, -0.1433155073025716, 
  0.1433155073025715, 0.989677051045747, -0.989677051045747, 
  -0.988664185277066, 0.988664185277066, 0.1501436936752082, 
  -0.1501436936752083, -0.5929235257755514, 0.5929235257755512, 
  0.805258773675822, -0.805258773675822, -0.855949101260827, 
  0.855949101260827, 0.5170600894004319, -0.5170600894004322, 
  -0.2396307183560935, 0.2396307183560934, 0.97086410934803, 
  -0.97086410934803, -0.940375698633812, 0.940375698633812, 
  0.3401375389735318, -0.3401375389735319, -0.4244324730227174, 
  0.4244324730227175, 0.905459593711293, -0.905459593711293, 
  -0.738628859948175, 0.7386288599481749, 0.6741123105623121, 
  -0.6741123105623125, -0.04562008956950013, 0.0456200895695, 
  0.998958861729386, -0.998958861729386, -0.999608161397882, 
  0.999608161397882, 0.02799149275665324, -0.02799149275665336, 
  -0.6870367351100958, 0.6870367351100955, 0.7266226837976229, 
  -0.726622683797623, -0.912805640321604, 0.912805640321604, 
  0.408394249466208, -0.4083942494662082, -0.3566727149815883, 
  0.3566727149815882, 0.934229401371881, -0.934229401371881, 
  -0.974940101534372, 0.974940101534372, 0.2224675221693019, 
  -0.222467522169302, -0.5320784635259736, 0.5320784635259736, 
  0.846695050565337, -0.846695050565337, -0.815592570258577, 
  0.815592570258577, 0.5786266147862613, -0.5786266147862616, 
  -0.1675602340248236, 0.1675602340248234, 0.985861840205587, 
  -0.985861840205587, -0.992051128806486, 0.992051128806486, 
  0.1258354394984869, -0.125835439498487, -0.6125069878798656, 
  0.6125069878798653, 0.7904651730458049, -0.7904651730458049, 
  -0.86838059520858, 0.86838059520858, 0.4958983180705423, 
  -0.4958983180705423, -0.2633847440361134, 0.2633847440361133, 
  0.964690871009481, -0.964690871009481, -0.948439868128009, 
  0.948439868128009, 0.316957120988508, -0.3169571209885081, 
  -0.4465257327046514, 0.4465257327046514, 0.89477079189733, 
  -0.89477079189733, -0.7549499430087327, 0.7549499430087325, 
  0.655782420892106, -0.6557824208921062, -0.07012202736213364, 
  0.07012202736213352, 0.997538420953611, -0.997538420953611, 
  -0.99703061213929, 0.99703061213929, 0.07700622349624548, 
  -0.07700622349624559, -0.650555484066504, 0.6505554840665039, 
  0.7594587297220281, -0.7594587297220283, -0.891667169921672, 
  0.891667169921672, 0.4526915705907008, -0.4526915705907009, 
  -0.3104026230623589, 0.3104026230623588, 0.950605181763705, 
  -0.950605181763705, -0.962849779558509, 0.962849779558509, 
  0.2700375936867504, -0.2700375936867505, -0.4898921947185954, 
  0.489892194718595, 0.871783022060993, -0.871783022060993, 
  -0.7862182909974557, 0.7862182909974555, 0.6179488643092082, 
  -0.6179488643092083, -0.1189844526776325, 0.1189844526776324, 
  0.992896117436766, -0.992896117436766, -0.984681707410971, 
  0.984681707410971, 0.1743615069050937, -0.1743615069050938, 
  -0.5729829087101487, 0.5729829087101485, 0.819567316531142, 
  -0.819567316531142, -0.843002015580473, 0.843002015580473, 
  0.5379104030665888, -0.5379104030665891, -0.2157323480917059, 
  0.2157323480917058, 0.976452535450054, -0.976452535450054, 
  -0.931745081981669, 0.931745081981669, 0.3631130708236394, 
  -0.3631130708236395, -0.4020835510895871, 0.402083551089587, 
  0.91560298052332, -0.91560298052332, -0.7218628544814965, 
  0.7218628544814965, 0.6920361401833186, -0.6920361401833189, 
  -0.02109067194075518, 0.02109067194075505, 0.999777567040333, 
  -0.999777567040333, -0.99987639141679, 0.99987639141679, 
  0.01572265522541689, -0.01572265522541702, -0.6959017805909969, 
  0.6959017805909966, 0.7181369728472975, -0.7181369728472977, 
  -0.917748533403661, 0.917748533403661, 0.3971619687676916, 
  -0.3971619687676917, -0.368110290048703, 0.3681102900487029, 
  0.929782132738772, -0.929782132738772, -0.977596709053412, 
  0.977596709053412, 0.2104867559917698, -0.2104867559917699, 
  -0.5424286497255814, 0.5424286497255812, 0.840101874749058, 
  -0.840101874749059, -0.822631796294515, 0.822631796294515, 
  0.5685744698148689, -0.5685744698148693, -0.1796456583638821, 
  0.179645658363882, 0.983731384795162, -0.983731384795162, 
  -0.993520623594518, 0.993520623594518, 0.1136519709127818, 
  -0.1136519709127819, -0.622161090864727, 0.6221610908647266, 
  0.7828892495200155, -0.7828892495200155, -0.874400642942865, 
  0.874400642942865, 0.485204612118542, -0.485204612118542, 
  -0.2752031526067673, 0.2752031526067673, 0.961386095590786, 
  -0.961386095590786, -0.9522580037954, 0.9522580037954, 0.3052944385467916, 
  -0.3052944385467917, -0.4574723241679161, 0.457472324167916, 
  0.889223859677868, -0.889223859677868, -0.7629405557515657, 
  0.7629405557515656, 0.6464686445524577, -0.646468644552458, 
  -0.0823580782266466, 0.0823580782266465, 0.996602803001684, 
  -0.996602803001684, -0.997900522387752, 0.997900522387752, 
  0.06476532574033977, -0.06476532574033988, -0.6598262253132275, 
  0.6598262253132274, 0.7514182273467273, -0.7514182273467275, 
  -0.897155250963809, 0.897155250963809, 0.4417153559341873, 
  -0.4417153559341874, -0.3220446381983346, 0.3220446381983345, 
  0.946724485268921, -0.946724485268921, -0.966091055410439, 
  0.966091055410439, 0.2582016124193347, -0.2582016124193349, 
  -0.5005534254693777, 0.5005534254693773, 0.865705647579402, 
  -0.865705647579402, -0.7937422733531002, 0.7937422733531001, 
  0.6082542260373146, -0.6082542260373146, -0.1311598560860434, 
  0.1311598560860433, 0.991361231918764, -0.991361231918764, 
  -0.986747246596917, 0.986747246596917, 0.162264818532558, 
  -0.1622648185325581, -0.5829971158534578, 0.5829971158534577, 
  0.81247422291821, -0.81247422291821, -0.849539527184621, 0.849539527184621, 
  0.5275249678933981, -0.5275249678933984, -0.2276986785156212, 
  0.2276986785156211, 0.973731642600896, -0.973731642600896, 
  -0.936130879241267, 0.936130879241267, 0.3516517836311546, 
  -0.3516517836311547, -0.413289131967691, 0.4132891319676909, 
  0.910599853611559, -0.910599853611559, -0.7303008475255255, 
  0.7303008475255255, 0.6831256634789085, -0.6831256634789088, 
  -0.03335789254308616, 0.03335789254308603, 0.999443470640078, 
  -0.999443470640078, -0.999189394066715, 0.999189394066715, 
  0.04025611487204123, -0.04025611487204137, -0.6780682244240066, 
  0.6780682244240066, 0.7349989680444966, -0.7349989680444967, 
  -0.907725282067676, 0.907725282067676, 0.4195650274929469, 
  -0.4195650274929469, -0.3451814263155426, 0.3451814263155425, 
  0.938535978493509, -0.938535978493509, -0.972136671622152, 
  0.972136671622152, 0.2344147855562952, -0.2344147855562952, 
  -0.5216481482668973, 0.5216481482668973, 0.85316071722139, 
  -0.85316071722139, -0.808430518981543, 0.808430518981543, 
  0.5885916207178226, -0.588591620717823, -0.1554495757308559, 
  0.1554495757308558, 0.987843828449162, -0.987843828449162, 
  -0.990432234767506, 0.990432234767506, 0.1379999577298626, 
  -0.1379999577298627, -0.6027606435956074, 0.602760643595607, 
  0.7979220554240931, -0.7979220554240932, -0.862229772550811, 
  0.862229772550811, 0.5065173435598985, -0.5065173435598985, 
  -0.2515266706918128, 0.2515266706918127, 0.967850367531414, 
  -0.967850367531414, -0.944478900905116, 0.944478900905116, 
  0.3285720708536636, -0.3285720708536637, -0.4355118961084922, 
  0.4355118961084921, 0.900182974926757, -0.900182974926757, 
  -0.7468456375814066, 0.7468456375814066, 0.6649974388113252, 
  -0.6649974388113254, -0.05787541637822902, 0.0578754163782289, 
  0.998323813288578, -0.998323813288578, -0.996010552748006, 
  0.996010552748006, 0.089235524398144, -0.0892355243981441, 
  -0.6411867715568114, 0.6411867715568113, 0.7673848604061416, 
  -0.7673848604061418, -0.886044807083555, 0.886044807083556, 
  0.4635996115618138, -0.4635996115618142, -0.2987138624331003, 
  0.2987138624331003, 0.954342720614716, -0.954342720614716, 
  -0.959463502071418, 0.959463502071418, 0.2818329082858333, 
  -0.2818329082858335, -0.4791571880052534, 0.4791571880052532, 
  0.877729109226132, -0.877729109226132, -0.7785759070591251, 
  0.7785759070591248, 0.6275504417551315, -0.6275504417551316, 
  -0.1067911306483074, 0.1067911306483073, 0.994281476451642, 
  -0.994281476451642, -0.982467878781833, 0.982467878781833, 
  0.1864319370760415, -0.1864319370760416, -0.5628824124483846, 
  0.5628824124483844, 0.82653698632081, -0.82653698632081, 
  -0.836337550973584, 0.836337550973584, 0.5482148309116677, 
  -0.548214830911668, -0.203733529169694, 0.2037335291696939, 
  0.979026378139048, -0.979026378139048, -0.927218967339952, 
  0.927218967339952, 0.3745196745232931, -0.3745196745232932, 
  -0.3908174179076686, 0.3908174179076685, 0.920468220994067, 
  -0.920468220994067, -0.7133161515468027, 0.7133161515468025, 
  0.7008423987905262, -0.7008423987905262, -0.00882027516080751, 
  0.00882027516080739, 0.999961100616463, -0.999961100616463, 
  -0.99995404142513, 0.99995404142513, 0.00958723304972906, 
  -0.00958723304972918, -0.7002950860643239, 0.7002950860643238, 
  0.7138534810688823, -0.7138534810688827, -0.920168197074266, 
  0.920168197074266, 0.3915232931679722, -0.3915232931679724, 
  -0.3738083963918513, 0.3738083963918513, 0.927505947574975, 
  -0.927505947574975, -0.978869828526574, 0.978869828526574, 
  0.204484372997927, -0.2044843729979272, -0.5475732068565399, 
  0.5475732068565397, 0.836757780443567, -0.836757780443567, 
  -0.826105017844665, 0.826105017844665, 0.5635161927503649, 
  -0.5635161927503649, -0.1856783388879878, 0.1856783388879877, 
  0.982610581292405, -0.982610581292405, -0.994199276233219, 
  0.994199276233219, 0.1075537035036156, -0.1075537035036157, 
  -0.6269530969861328, 0.6269530969861325, 0.7790570031644006, 
  -0.7790570031644007, -0.877361342129065, 0.877361342129065, 
  0.4798302567965941, -0.4798302567965944, -0.2810969261710383, 
  0.2810969261710382, 0.959679382969747, -0.959679382969747, 
  -0.954113329266539, 0.954113329266539, 0.2994457461977398, 
  -0.29944574619774, -0.4629198874109552, 0.4629198874109553, 
  0.88640012287873, -0.886400122878731, -0.7668928506434807, 
  0.7668928506434807, 0.6417751597186633, -0.6417751597186637, 
  -0.0884715676993408, 0.0884715676993407, 0.996078702567634, 
  -0.996078702567634, -0.998279129760433, 0.998279129760433, 
  0.05864110405468324, -0.05864110405468336, -0.6644244198372754, 
  0.664424419837275, 0.7473554645039402, -0.7473554645039402, 
  -0.899848676741519, 0.899848676741519, 0.4362021996351441, 
  -0.4362021996351439, -0.3278475680351709, 0.3278475680351708, 
  0.944730634696168, -0.944730634696168, -0.96765716432937, 0.96765716432937, 
  0.2522689285703707, -0.2522689285703708, -0.505855872686269, 
  0.5058558726862687, 0.862618012835817, -0.862618012835817, 
  -0.7974595091474426, 0.7974595091474424, 0.6033724647929503, 
  -0.6033724647929504, -0.1372402652035157, 0.1372402652035156, 
  0.990537788076189, -0.990537788076189, -0.987724309567987, 
  0.987724309567987, 0.1562071966602159, -0.156207196660216, 
  -0.5879713892097451, 0.587971389209745, 0.808881725266904, 
  -0.808881725266904, -0.852760367195645, 0.852760367195645, 
  0.5223023608412544, -0.5223023608412549, -0.2336690971905768, 
  0.2336690971905767, 0.972316179551765, -0.972316179551765, 
  -0.938270951623047, 0.938270951623047, 0.345901172794169, 
  -0.3459011727941691, -0.4188686875798751, 0.418868687579875, 
  0.908046817386148, -0.908046817386148, -0.7344786800904384, 
  0.7344786800904382, 0.6786317620717494, -0.6786317620717495, 
  -0.03948973443938412, 0.03948973443938399, 0.999219976218404, 
  -0.999219976218404, -0.999417591486022, 0.999417591486022, 
  0.03412444619740329, -0.03412444619740342, -0.6825653288664734, 
  0.6825653288664734, 0.7308245834873119, -0.7308245834873122, 
  -0.910282597007282, 0.910282597007282, 0.4139874316759854, 
  -0.4139874316759855, -0.3509336768758584, 0.3509336768758582, 
  0.936400317404042, -0.936400317404042, -0.973556713508265, 
  0.973556713508265, 0.2284454542839164, -0.2284454542839165, 
  -0.5268732241359847, 0.5268732241359846, 0.849943883846782, 
  -0.849943883846782, -0.81202683079567, 0.81202683079567, 
  0.5836201042355727, -0.5836201042355728, -0.1615079452192661, 
  0.161507945219266, 0.986871411902813, -0.986871411902813, 
  -0.991260341982802, 0.991260341982802, 0.1319201819743196, 
  -0.1319201819743198, -0.607645254487931, 0.6076452544879309, 
  0.7942085649867404, -0.7942085649867407, -0.86532147331189, 
  0.86532147331189, 0.5012172660886098, -0.50121726608861, 
  -0.2574605539861332, 0.2574605539861331, 0.96628880938421, 
  -0.96628880938421, -0.946477201682409, 0.946477201682409, 
  0.3227706719877706, -0.3227706719877707, -0.4410271166174074, 
  0.441027116617407, 0.89749377847879, -0.89749377847879, 
  -0.7509119259998681, 0.7509119259998678, 0.660402361739545, 
  -0.660402361739545, -0.06399992665071407, 0.06399992665071396, 
  0.997949903246001, -0.997949903246001, -0.996539342015138, 
  0.996539342015138, 0.083122438703613, -0.0831224387036131, 
  -0.6458832863819965, 0.6458832863819963, 0.763436166534172, 
  -0.7634361665341722, -0.888872721280396, 0.888872721280396, 
  0.4581542156998931, -0.4581542156998932, -0.304563976078509, 
  0.304563976078509, 0.952491881579706, -0.952491881579706, 
  -0.961174734657714, 0.961174734657714, 0.2759404454871972, 
  -0.2759404454871973, -0.4845338125740162, 0.4845338125740162, 
  0.874772532989284, -0.874772532989284, -0.7824118277098365, 
  0.7824118277098365, 0.6227613763390863, -0.6227613763390865, 
  -0.1128899167837505, 0.1128899167837503, 0.993607501324622, 
  -0.993607501324622, -0.983593308962479, 0.983593308962479, 
  0.1804001179718071, -0.1804001179718073, -0.5679433519523657, 
  0.5679433519523654, 0.823067645441802, -0.823067645441802, 
  -0.839685590120966, 0.839685590120966, 0.5430728401818719, 
  -0.5430728401818719, -0.2097368868683234, 0.2097368868683232, 
  0.977757862810003, -0.977757862810003, -0.929499522226639, 
  0.929499522226639, 0.3688233156681538, -0.368823315668154, 
  -0.396457947707454, 0.3964579477074538, 0.91805288284477, 
  -0.91805288284477, -0.7176030116880491, 0.717603011688049, 
  0.6964523800061578, -0.696452380006158, -0.01495575508864438, 
  0.01495575508864425, 0.999888156440373, -0.999888156440373, 
  -0.999761096627447, 0.999761096627447, 0.02185748545202175, 
  -0.02185748545202188, -0.6914822748089559, 0.6914822748089559, 
  0.7223934271745774, -0.7223934271745776, -0.915294317019487, 
  0.915294317019487, 0.4027856914437635, -0.4027856914437637, 
  -0.3623983245611913, 0.3623983245611912, 0.932023312130786, 
  -0.932023312130786, -0.976286783616694, 0.976286783616694, 
  0.2164812142782168, -0.2164812142782169, -0.5372636704625426, 
  0.5372636704625423, 0.843414339693793, -0.843414339693793, 
  -0.819127603122188, 0.819127603122188, 0.5736113403719446, 
  -0.5736113403719446, -0.1736062142822754, 0.1736062142822753, 
  0.984815151367289, -0.984815151367289, -0.992804565465879, 
  0.992804565465879, 0.1197459593894795, -0.1197459593894796, 
  -0.617345660729897, 0.6173456607298968, 0.7866920205378767, 
  -0.7866920205378768, -0.871407023066671, 0.871407023066671, 
  0.490560699761082, -0.4905606997610822, -0.2692990177993462, 
  0.2692990177993461, 0.963056612568704, -0.963056612568704, 
  -0.950366826348636, 0.950366826348636, 0.3111316367327852, 
  -0.3111316367327852, -0.4520075373504366, 0.4520075373504363, 
  0.892014117701281, -0.89201411770128, -0.7589595365789426, 
  0.7589595365789422, 0.6511377902071704, -0.6511377902071704, 
  -0.07624148801885616, 0.07624148801885604, 0.997089381903484, 
  -0.997089381903484, -0.997484344624418, 0.997484344624418, 
  0.07088710904808766, -0.07088710904808777, -0.655203188704732, 
  0.6552031887047317, 0.7554526997179582, -0.7554526997179583, 
  -0.894428047797974, 0.894428047797974, 0.4472118818997384, 
  -0.4472118818997383, -0.3162295835628905, 0.3162295835628904, 
  0.948682692199895, -0.948682692199895, -0.964488573709308, 
  0.964488573709308, 0.2641245751235274, -0.2641245751235275, 
  -0.4952321326989315, 0.4952321326989312, 0.868760688994655, 
  -0.868760688994655, -0.7899951536107911, 0.789995153610791, 
  0.6131130868538547, -0.6131130868538551, -0.1250745088741213, 
  0.1250745088741212, 0.992147351571276, -0.992147351571276, 
  -0.985733033149723, 0.985733033149723, 0.1683163312261948, 
  -0.1683163312261949, -0.57800089298527, 0.57800089298527, 
  0.816036131374237, -0.816036131374237, -0.84628670249056, 0.84628670249056, 
  0.5327277139286585, -0.5327277139286589, -0.2217196871141152, 
  0.2217196871141151, 0.975110445204039, -0.975110445204039, 
  -0.933955562060987, 0.933955562060987, 0.3573891549772409, 
  -0.357389154977241, -0.4076940162532802, 0.4076940162532801, 
  0.913118606267154, -0.913118606267154, -0.7260955195464711, 
  0.7260955195464709, 0.687593845590942, -0.6875938455909423, 
  -0.02722479474098791, 0.02722479474098779, 0.99962933657997, 
  -0.99962933657997, -0.998923577731466, 0.998923577731466, 
  0.04638626792670709, -0.04638626792670722, -0.6735455910961362, 
  0.6735455910961358, 0.7391456803059575, -0.7391456803059575, 
  -0.90513379178425, 0.90513379178425, 0.4251268269237626, 
  -0.4251268269237624, -0.3394161798696234, 0.3394161798696233, 
  0.940636304233848, -0.940636304233848, -0.970680029339806, 
  0.970680029339806, 0.2403752912444894, -0.2403752912444895, 
  -0.5164034326398641, 0.5164034326398639, 0.856345429577204, 
  -0.856345429577204, -0.804803770215303, 0.804803770215303, 
  0.5935409770582263, -0.5935409770582264, -0.1493853536537798, 
  0.1493853536537797, 0.988779053233701, -0.988779053233701, 
  -0.989566838338365, 0.989566838338365, 0.1440745378649952, 
  -0.1440745378649953, -0.597853339105734, 0.5978533391057339, 
  0.801605504547046, -0.801605504547046, -0.85910560932613, 0.85910560932613, 
  0.5117983509394867, -0.5117983509394871, -0.245583317560504, 
  0.2455833175605039, 0.969375486659311, -0.969375486659311, 
  -0.942445041031025, 0.942445041031025, 0.3343610991667988, 
  -0.3343610991667989, -0.4299802788228406, 0.4299802788228405, 
  0.902838279994503, -0.902838279994503, -0.7427512308468091, 
  0.7427512308468089, 0.6695674791053925, -0.6695674791053925, 
  -0.05174872712902842, 0.05174872712902829, 0.998660137003838, 
  -0.998660137003838, -0.99544426424651, 0.99544426424651, 
  0.0953452504256176, -0.0953452504256177, -0.6364661164120772, 
  0.6364661164120771, 0.7713046626718448, -0.7713046626718448, 
  -0.883183533800523, 0.883183533800523, 0.4690275531603872, 
  -0.4690275531603873, -0.2928525023796048, 0.2928525023796047, 
  0.956157629185692, -0.956157629185692, -0.957716146226559, 
  0.957716146226559, 0.2877147602347652, -0.2877147602347653, 
  -0.4737625234391829, 0.473762523439183, 0.880652639458111, 
  -0.880652639458111, -0.7747106734655657, 0.7747106734655657, 
  0.6323158802517374, -0.6323158802517377, -0.100688323887154, 
  0.1006883238871538, 0.994918017443043, -0.994918017443043, 
  -0.981305459240845, 0.981305459240845, 0.1924567371232167, 
  -0.1924567371232168, -0.5578002807397171, 0.5578002807397168, 
  0.829975208549444, -0.829975208549444, -0.832958024190107, 
  0.832958024190107, 0.5533361816629324, -0.5533361816629325, 
  -0.197722501018842, 0.1977225010188419, 0.980258033678304, 
  -0.980258033678303, -0.924903503183211, 0.924903503183211, 
  0.3802019329243659, -0.380201932924366, -0.3851621740529899, 
  0.3851621740529898, 0.922848904035094, -0.922848904035094, 
  -0.7090024354556183, 0.7090024354556183, 0.7052060312546978, 
  -0.705206031254698, -0.002684463154596083, 0.002684463154595961, 
  0.999996396822294, -0.999996396822294, -0.999998161643487, 
  0.999998161643487, 0.001917474809855337, -0.00191747480985546, 
  -0.705749621831388, 0.7057496218313877, 0.708461340712994, 
  -0.7084613407129942, -0.923144048249622, 0.923144048249622, 
  0.3844542445874408, -0.3844542445874409, -0.3809112131255781, 
  0.380911213125578, 0.92461161993304, -0.92461161993304, -0.98040939659211, 
  0.98040939659211, 0.1969705944396143, -0.1969705944396144, 
  -0.5539748896466957, 0.5539748896466953, 0.832533375691889, 
  -0.832533375691889, -0.830402791838048, 0.830402791838047, 
  0.5571635337201963, -0.5571635337201963, -0.193209332301514, 
  0.1932093323015139, 0.981157558148335, -0.981157558148335, 
  -0.994994951770357, 0.994994951770357, 0.0999252017836591, 
  -0.0999252017836592, -0.6329098898505419, 0.6329098898505416, 
  0.7742254654358606, -0.7742254654358608, -0.881015751694343, 
  0.881015751694343, 0.4730869320394002, -0.4730869320394003, 
  -0.2884492346194342, 0.288449234619434, 0.957495190091033, 
  -0.957495190091033, -0.956381962978388, 0.956381962978388, 
  0.2921190525960364, -0.2921190525960365, -0.4697048084220725, 
  0.4697048084220726, 0.882823534430966, -0.882823534430966, 
  -0.7717925991520103, 0.7717925991520102, 0.6358743459946976, 
  -0.6358743459946977, -0.0961087184945655, 0.0961087184945654, 
  0.995370842565389, -0.995370842565389, -0.998699534033539, 
  0.998699534033539, 0.05098274925101078, -0.05098274925101089, 
  -0.6701369651640378, 0.6701369651640378, 0.7422374606018839, 
  -0.742237460601884, -0.903167805147361, 0.903167805147361, 
  0.4292876841295345, -0.4292876841295347, -0.3350838470412066, 
  0.3350838470412065, 0.942188312096932, -0.942188312096932, 
  -0.969563561557013, 0.969563561557013, 0.2448397437118406, 
  -0.2448397437118407, -0.5124571260857258, 0.5124571260857256, 
  0.858712812250964, -0.858712812250964, -0.802063816488236, 
  0.802063816488236, 0.5972383395934373, -0.5972383395934376, 
  -0.1448334836720802, 0.1448334836720801, 0.989456043494308, 
  -0.989456043494308, -0.988893339517095, 0.988893339517095, 
  0.1486269257527964, -0.1486269257527965, -0.594158079176037, 
  0.5941580791760368, 0.804348293309461, -0.804348293309461, 
  -0.856741254127627, 0.856741254127627, 0.5157464720924613, 
  -0.5157464720924614, -0.2411197227262947, 0.2411197227262946, 
  0.970495378305531, -0.970495378305531, -0.940896356481781, 
  0.940896356481781, 0.3386946210959211, -0.3386946210959212, 
  -0.4258209307336484, 0.4258209307336481, 0.904807457390317, 
  -0.904807457390317, -0.7396620658433801, 0.7396620658433798, 
  0.6729784754004421, -0.6729784754004422, -0.04715241899606801, 
  0.04715241899606788, 0.998887706092541, -0.998887706092541, 
  -0.999649923705874, 0.999649923705874, 0.02645808070967702, 
  -0.02645808070967714, -0.6881505515780449, 0.6881505515780449, 
  0.7255679281520321, -0.7255679281520324, -0.913431035048555, 
  0.913431035048555, 0.4069935432044664, -0.4069935432044665, 
  -0.3581053847300617, 0.3581053847300617, 0.933681173328098, 
  -0.933681173328098, -0.975280215241354, 0.975280215241354, 
  0.2209717216269489, -0.2209717216269491, -0.5333766509413556, 
  0.5333766509413552, 0.845877856567119, -0.845877856567119, 
  -0.816479212436865, 0.816479212436865, 0.5773748311612449, 
  -0.577374831161245, -0.1690723294114052, 0.1690723294114051, 
  0.985603646212514, -0.985603646212514, -0.992242990681342, 
  0.992242990681342, 0.1243135046716442, -0.1243135046716443, 
  -0.6137188251492118, 0.6137188251492116, 0.7895246694419821, 
  -0.7895246694419822, -0.869140271711201, 0.869140271711201, 
  0.4945656559950159, -0.4945656559950161, -0.2648642508332593, 
  0.2648642508332592, 0.964285709025357, -0.964285709025357, 
  -0.948924958186195, 0.948924958186195, 0.3155018601075559, 
  -0.315501860107556, -0.4478977680115973, 0.4478977680115975, 
  0.894084777529642, -0.894084777529642, -0.7559550120138244, 
  0.7559550120138244, 0.6546235710782024, -0.6546235710782027, 
  -0.07165214903298225, 0.07165214903298214, 0.997429681500884, 
  -0.997429681500884, -0.997147565105683, 0.997147565105683, 
  0.0754767076905633, -0.07547670769056341, -0.651719713300251, 
  0.6517197133002508, 0.7584598969595155, -0.7584598969595155, 
  -0.892360540731965, 0.892360540731965, 0.4513232382057837, 
  -0.4513232382057836, -0.3118604673724861, 0.311860467372486, 
  0.950127911857248, -0.950127911857248, -0.963262879037507, 
  0.963262879037507, 0.2685602834902678, -0.2685602834902679, 
  -0.4912289162193484, 0.4912289162193482, 0.871030511446048, 
  -0.871030511446048, -0.787165287287651, 0.7871652872876509, 
  0.6167420939820387, -0.6167420939820389, -0.1205073956578642, 
  0.1205073956578641, 0.992712429453645, -0.992712429453645, 
  -0.984948015982227, 0.984948015982227, 0.1728508195313941, 
  -0.1728508195313942, -0.5742394345929681, 0.5742394345929679, 
  0.81868740784157, -0.81868740784157, -0.843826167648187, 0.843826167648187, 
  0.5366166218001208, -0.5366166218001213, -0.2172299531144068, 
  0.2172299531144067, 0.976120457458972, -0.976120457458972, 
  -0.932300993994603, 0.932300993994603, 0.3616833651091458, 
  -0.361683365109146, -0.4034875948494954, 0.4034875948494953, 
  0.914985115071589, -0.914985115071589, -0.7229235749022177, 
  0.7229235749022175, 0.6909280026533862, -0.6909280026533863, 
  -0.0226242861050928, 0.02262428610509268, 0.999744038080866, 
  -0.999744038080866, -0.999899333255515, 0.999899333255515, 
  0.01418884615378622, -0.01418884615378634, -0.6970025697163275, 
  0.6970025697163275, 0.7170686283814373, -0.7170686283814377, 
  -0.918356692219022, 0.918356692219022, 0.39575369342122, 
  -0.3957536934212201, -0.3695361243183508, 0.3695361243183506, 
  0.929216364913884, -0.929216364913884, -0.977918441376834, 
  0.977918441376834, 0.20898689436207, -0.2089868943620701, 
  -0.5437167111624025, 0.5437167111624022, 0.839268811527475, 
  -0.839268811527475, -0.823503010399599, 0.823503010399598, 
  0.5673118999834208, -0.5673118999834209, -0.1811544714549909, 
  0.1811544714549908, 0.983454654507193, -0.983454654507193, 
  -0.993693794541032, 0.993693794541032, 0.1121277962444896, 
  -0.1121277962444897, -0.6233612954589734, 0.6233612954589731, 
  0.7819339456269376, -0.7819339456269377, -0.87514390842956, 
  0.87514390842956, 0.4838627279907321, -0.4838627279907324, 
  -0.2766775760389724, 0.2766775760389723, 0.96096280829031, 
  -0.96096280829031, -0.95272519903758, 0.95272519903758, 0.3038333344430864, 
  -0.3038333344430865, -0.4588358377115492, 0.4588358377115492, 
  0.888521059982002, -0.888521059982002, -0.7639313282069511, 
  0.7639313282069511, 0.6452975482550381, -0.6452975482550385, 
  -0.0838867502817902, 0.0838867502817901, 0.996475294790172, 
  -0.996475294790172, -0.997998697036034, 0.997998697036034, 
  0.06323448991158001, -0.06323448991158012, -0.6609781096681682, 
  0.6609781096681679, 0.7504051829108694, -0.7504051829108694, 
  -0.897831778021306, 0.897831778021305, 0.4403386178557374, 
  -0.4403386178557373, -0.3234965158995367, 0.3234965158995366, 
  0.946229361307744, -0.946229361307744, -0.96648599491517, 0.96648599491517, 
  0.2567193440955206, -0.2567193440955207, -0.5018808118546385, 
  0.5018808118546382, 0.864936789998049, -0.864936789998049, 
  -0.7946743894079447, 0.7946743894079445, 0.6070359254764996, 
  -0.6070359254764998, -0.1326804302573521, 0.132680430257352, 
  0.991158868913921, -0.991158868913921, -0.986994996657683, 
  0.986994996657683, 0.1607509768950113, -0.1607509768950114, 
  -0.5842427492890171, 0.5842427492890171, 0.811578960978666, 
  -0.811578960978666, -0.850347740508855, 0.850347740508855, 
  0.5262211704326278, -0.5262211704326282, -0.2291920956636368, 
  0.2291920956636366, 0.973381211697303, -0.973381211697303, 
  -0.936669204706636, 0.936669204706636, 0.3502153636753216, 
  -0.3502153636753218, -0.41468548784614, 0.4146854878461399, 
  0.909964804907206, -0.909964804907206, -0.7313478895238256, 
  0.7313478895238254, 0.6820045927184408, -0.6820045927184408, 
  -0.03489097977718796, 0.03489097977718783, 0.999391124400346, 
  -0.999391124400346, -0.999249970554724, 0.999249970554724, 
  0.03872333077593364, -0.03872333077593376, -0.6791949004979113, 
  0.6791949004979112, 0.7339579600614959, -0.7339579600614961, 
  -0.908367818524073, 0.908367818524073, 0.4181721012571461, 
  -0.4181721012571465, -0.3466207157880473, 0.3466207157880472, 
  0.938005372791959, -0.938005372791959, -0.972495115492821, 
  0.972495115492821, 0.232923271363349, -0.2329232713633491, 
  -0.5229562661585902, 0.5229562661585901, 0.852359515512947, 
  -0.852359515512947, -0.809332455707986, 0.809332455707986, 
  0.5873508118132476, -0.5873508118132477, -0.1569647256969068, 
  0.1569647256969066, 0.987604209634049, -0.987604209634049, 
  -0.990642758677011, 0.990642758677011, 0.1364804919422562, 
  -0.1364804919422563, -0.6039839310418182, 0.6039839310418179, 
  0.7969964937459087, -0.7969964937459089, -0.86300574566487, 
  0.86300574566487, 0.5051941042306622, -0.5051941042306624, 
  -0.253011038045618, 0.2530110380456179, 0.967463391879548, 
  -0.967463391879548, -0.944981812726528, 0.944981812726528, 
  0.3271228723524004, -0.3271228723524005, -0.4368922465552805, 
  0.4368922465552802, 0.899513849198488, -0.899513849198488, 
  -0.7478648517765095, 0.7478648517765092, 0.6638510099994575, 
  -0.6638510099994575, -0.05940675723408725, 0.05940675723408713, 
  0.998233858970397, -0.998233858970397, -0.996146266419825, 
  0.996146266419825, 0.0877075589549935, -0.0877075589549936, 
  -0.6423631703407243, 0.6423631703407242, 0.7664003897375142, 
  -0.7664003897375143, -0.886754917227551, 0.886754917227551, 
  0.4622398909362535, -0.4622398909362533, -0.3001774538061621, 
  0.300177453806162, 0.953883376638072, -0.953883376638072, 
  -0.959894699313421, 0.959894699313421, 0.2803607786941637, 
  -0.2803607786941638, -0.4805030433161577, 0.4805030433161576, 
  0.876993058902926, -0.876993058902926, -0.7795376409705133, 
  0.7795376409705132, 0.6263553833967798, -0.6263553833967802, 
  -0.1083162130878513, 0.1083162130878512, 0.994116491152977, 
  -0.994116491152977, -0.982752705758488, 0.982752705758488, 
  0.1849246314701507, -0.1849246314701509, -0.5641496415502879, 
  0.5641496415502879, 0.825672563392221, -0.825672563392222, 
  -0.837177517670507, 0.837177517670507, 0.5469312606782019, 
  -0.5469312606782023, -0.2052350965332724, 0.2052350965332723, 
  0.9787127030702, -0.978712703070201, -0.927792382182146, 0.927792382182146, 
  0.3730968983585606, -0.3730968983585607, -0.3922289381052103, 
  0.3922289381052102, 0.919867631843223, -0.919867631843223, 
  -0.7143903906493515, 0.7143903906493513, 0.699747361372565, 
  -0.6997473613725651, -0.01035418529872888, 0.01035418529872876, 
  0.999946393986597, -0.999946393986597, -0.999967571556444, 
  0.999967571556444, 0.00805331208314487, -0.00805331208314499, 
  -0.7013892992292023, 0.7013892992292021, 0.7127784023992091, 
  -0.7127784023992091, -0.920767703426129, 0.920767703426129, 
  0.3901113127395468, -0.3901113127395469, -0.37523073233446, 
  0.3752307323344599, 0.926931441645899, -0.926931441645899, 
  -0.979182351815527, 0.979182351815527, 0.2029825654902743, 
  -0.2029825654902745, -0.5488561324661355, 0.5488561324661352, 
  0.835916829507766, -0.835916829507766, -0.826968468566542, 
  0.826968468566541, 0.5622483010171831, -0.5622483010171833, 
  -0.1871854255909904, 0.1871854255909903, 0.982324598310721, 
  -0.982324598310721, -0.994363091759889, 0.994363091759889, 
  0.1060284949705284, -0.1060284949705285, -0.6281474173523742, 
  0.6281474173523741, 0.7780943529377026, -0.7780943529377029, 
  -0.878096359977777, 0.878096359977777, 0.4784838373380838, 
  -0.4784838373380841, -0.2825687246055897, 0.2825687246055896, 
  0.95924705674543, -0.95924705674543, -0.95457155054766, 0.95457155054766, 
  0.2979818029427918, -0.2979818029427919, -0.4642790629889658, 
  0.4642790629889657, 0.885688970051049, -0.885688970051049, 
  -0.7678764187360608, 0.7678764187360605, 0.6405980062013011, 
  -0.6405980062013011, -0.0899994286019873, 0.0899994286019872, 
  0.995941817001031, -0.995941817001031, -0.998367909528544, 
  0.998367909528544, 0.05710969465515802, -0.05710969465515814, 
  -0.6655700665845156, 0.6655700665845154, 0.7463353713088262, 
  -0.7463353713088264, -0.900516743557544, 0.900516743557544, 
  0.4348213363814123, -0.4348213363814124, -0.3292963803816728, 
  0.3292963803816727, 0.94422661150146, -0.94422661150146, 
  -0.968043001372022, 0.968043001372022, 0.2507842648465944, 
  -0.2507842648465945, -0.5071785164624253, 0.5071785164624253, 
  0.861841025038245, -0.861841025038245, -0.7983841323037564, 
  0.7983841323037564, 0.602148467809707, -0.6021484678097073, 
  -0.1387595690743904, 0.1387595690743903, 0.990326098813057, 
  -0.990326098813057, -0.987962766207263, 0.987962766207263, 
  0.1546918633545153, -0.1546918633545154, -0.5892115059726151, 
  0.5892115059726148, 0.807978837117336, -0.807978837117337, 
  -0.853560565354667, 0.853560565354667, 0.5209936288203739, 
  -0.5209936288203739, -0.2351603360218349, 0.2351603360218347, 
  0.971956591809582, -0.971956591809582, -0.938800453247435, 
  0.938800453247435, 0.3444614767755763, -0.3444614767755765, 
  -0.420261120586723, 0.420261120586723, 0.907403212757808, 
  -0.907403212757808, -0.7355188236175989, 0.7355188236175989, 
  0.6775042878861973, -0.6775042878861975, -0.0410224716230634, 
  0.04102247162306327, 0.99915822411765, -0.99915822411765, 
  -0.99946876184729, 0.99946876184729, 0.03259131926518026, 
  -0.03259131926518038, -0.6836855962261167, 0.6836855962261165, 
  0.729776681946566, -0.7297766819465661, -0.910916574533403, 
  0.910916574533403, 0.4125905891320483, -0.4125905891320484, 
  -0.3523696835187666, 0.3523696835187665, 0.935860890376815, 
  -0.935860890376815, -0.97390599887229, 0.97390599887229, 
  0.2269517687980599, -0.22695176879806, -0.5281764013214644, 
  0.5281764013214644, 0.849134670760244, -0.849134670760244, 
  -0.812921137083099, 0.812921137083099, 0.5823737845091599, 
  -0.5823737845091603, -0.1630215963896378, 0.1630215963896377, 
  0.986622500813038, -0.986622500813038, -0.991461538662454, 
  0.991461538662454, 0.1303994530398026, -0.1303994530398027, 
  -0.6088628397664082, 0.6088628397664079, 0.7932755147813308, 
  -0.7932755147813308, -0.866089312574587, 0.866089312574587, 
  0.4998892903874614, -0.4998892903874614, -0.2589425189591806, 
  0.2589425189591805, 0.965892733110191, -0.965892733110191, 
  -0.946971211921811, 0.946971211921811, 0.3213184149583348, 
  -0.3213184149583349, -0.4424033354012042, 0.4424033354012041, 
  0.896816195675507, -0.896816195675507, -0.7519240866536036, 
  0.7519240866536034, 0.6592497007281414, -0.6592497007281417, 
  -0.0655306867301934, 0.06553068673019329, 0.997850554490335, 
  -0.997850554490335, -0.996665677712478, 0.996665677712478, 
  0.0815936693005445, -0.0815936693005446, -0.6470536224220717, 
  0.6470536224220716, 0.7624444961506871, -0.7624444961506872, 
  -0.889574474967855, 0.889574474967855, 0.4567901635167571, 
  -0.4567901635167572, -0.3060247214182219, 0.3060247214182218, 
  0.952023565822244, -0.952023565822244, -0.961596890965188, 
  0.961596890965188, 0.2744656978314131, -0.2744656978314132, 
  -0.4858751262296954, 0.4858751262296951, 0.874028238509076, 
  -0.874028238509076, -0.7833662107766198, 0.7833662107766195, 
  0.6215604393890273, -0.6215604393890273, -0.1144139581832871, 
  0.1144139581832869, 0.993433161401829, -0.993433161401829, 
  -0.983868881924017, 0.983868881924017, 0.1788910930750447, 
  -0.1788910930750448, -0.5692052531996613, 0.5692052531996611, 
  0.822195463214137, -0.822195463214137, -0.840517665166863, 
  0.840517665166862, 0.5417841401724914, -0.5417841401724917, 
  -0.2112365012912807, 0.2112365012912806, 0.977434980201864, 
  -0.977434980201864, -0.930064196284032, 0.930064196284032, 
  0.3673970478794527, -0.3673970478794528, -0.3978657561877758, 
  0.3978657561877756, 0.917443644074735, -0.917443644074735, 
  -0.7186705115450673, 0.7186705115450673, 0.6953507717947475, 
  -0.6953507717947478, -0.01648954611295646, 0.01648954611295633, 
  0.999864038191688, -0.999864038191688, -0.999793449309835, 
  0.999793449309835, 0.02032384602238944, -0.02032384602238957, 
  -0.6925895984506504, 0.6925895984506502, 0.7213318571350963, 
  -0.7213318571350963, -0.91591110540151, 0.91591110540151, 
  0.4013811742000167, -0.4013811742000168, -0.3638276034760236, 
  0.3638276034760235, 0.931466303710925, -0.931466303710925, 
  -0.976617712861546, 0.976617712861546, 0.2149833549954127, 
  -0.2149833549954128, -0.5385568192318044, 0.5385568192318041, 
  0.842589195550787, -0.842589195550787, -0.82000654780976, 0.82000654780976, 
  0.5723541399772698, -0.5723541399772701, -0.17511669695553, 
  0.17511669695553, 0.984547684191774, -0.984547684191774, 
  -0.992987085312448, 0.992987085312448, 0.1182228759702971, 
  -0.1182228759702973, -0.6185517043651238, 0.6185517043651238, 
  0.7857440989450702, -0.7857440989450704, -0.872158508207824, 
  0.872158508207825, 0.4892234014851517, -0.4892234014851521, 
  -0.270776010717996, 0.2707760107179959, 0.962642380128596, 
  -0.962642380128596, -0.950842977962238, 0.950842977962238, 
  0.3096734267900664, -0.3096734267900665, -0.4533753375241778, 
  0.4533753375241777, 0.891319697597241, -0.891319697597241, 
  -0.7599574760951105, 0.7599574760951102, 0.6499727952208075, 
  -0.6499727952208075, -0.07777091367285798, 0.07777091367285787, 
  0.996971255847674, -0.996971255847674, -0.997591910456653, 
  0.997591910456653, 0.06935690442519713, -0.06935690442519724, 
  -0.6563612672995781, 0.6563612672995779, 0.7544467421819064, 
  -0.7544467421819065, -0.895113009626082, 0.895113009626082, 
  0.4458393208299803, -0.4458393208299804, -0.317684471956418, 
  0.3176844719564179, 0.948196486113386, -0.948196486113386, 
  -0.964892600806869, 0.964892600806869, 0.26264475800624, 
  -0.2626447580062401, -0.4965642117179494, 0.496564211717949, 
  0.867999990576574, -0.867999990576574, -0.7909347274705234, 
  0.7909347274705231, 0.6119005285837961, -0.6119005285837961, 
  -0.1265962960971059, 0.1265962960971058, 0.991954322443576, 
  -0.991954322443576, -0.98599006730433, 0.98599006730433, 
  0.1668040382520838, -0.1668040382520839, -0.5792519961961237, 
  0.5792519961961233, 0.815148529350821, -0.815148529350821, 
  -0.847102900551231, 0.847102900551231, 0.5314289001152368, 
  -0.5314289001152371, -0.2232152263525769, 0.2232152263525768, 
  0.974769184332562, -0.974769184332562, -0.934502691099688, 
  0.934502691099688, 0.3559560651645669, -0.355956065164567, 
  -0.409094242431321, 0.4090942424313208, 0.912492137396013, 
  -0.912492137396013, -0.7271494205953712, 0.727149420595371, 
  0.6864792204632387, -0.686479220463239, -0.0287581743056446, 
  0.02875817430564447, 0.999586398172067, -0.999586398172067, 
  -0.998993558065546, 0.998993558065546, 0.04485388437516981, 
  -0.04485388437516994, -0.6746786334655846, 0.6746786334655843, 
  0.7381116050740643, -0.7381116050740645, -0.905784862979786, 
  0.905784862979786, 0.4237378694389839, -0.423737869438984, 
  -0.3408586979832894, 0.3408586979832893, 0.94011453983498, 
  -0.94011453983498, -0.971047618221911, 0.971047618221911, 0.23888600449912, 
  -0.2388860044991202, -0.5177164419878712, 0.5177164419878712, 
  0.855552269411647, -0.855552269411647, -0.805713303423352, 
  0.805713303423352, 0.5923057256912422, -0.5923057256912424, 
  -0.15090194537097, 0.1509019453709699, 0.988548735714763, 
  -0.988548735714763, -0.989786681551619, 0.989786681551619, 
  0.1425563924313272, -0.1425563924313273, -0.5990822826635974, 
  0.599082282663597, 0.800687466242962, -0.800687466242962, 
  -0.859889687076602, 0.859889687076602, 0.5104798978013758, 
  -0.5104798978013758, -0.2470700314094754, 0.2470700314094753, 
  0.968997626199012, -0.968997626199012, -0.942956835500102, 
  0.942956835500102, 0.3329150137552125, -0.3329150137552126, 
  -0.4313647089632065, 0.4313647089632064, 0.902177636533454, 
  -0.902177636533454, -0.7437774602104409, 0.7437774602104409, 
  0.6684273256554567, -0.6684273256554569, -0.05328059110714807, 
  0.05328059110714794, 0.998579580509873, -0.998579580509873, 
  -0.995589350783265, 0.995589350783265, 0.0938181464694204, 
  -0.0938181464694205, -0.6376485336490788, 0.6376485336490788, 
  0.7703274287828387, -0.7703274287828389, -0.88390197366581, 
  0.88390197366581, 0.4676722152851146, -0.4676722152851147, 
  -0.2943188846826276, 0.2943188846826275, 0.955707274283907, 
  -0.955707274283907, -0.958156368168759, 0.958156368168759, 
  0.286245304132057, -0.2862453041320571, -0.4751128697346205, 
  0.4751128697346202, 0.879924861003787, -0.879924861003787, 
  -0.7756797220128206, 0.7756797220128205, 0.6311267454783654, 
  -0.6311267454783655, -0.1022143899482134, 0.1022143899482133, 
  0.99476239298011, -0.99476239298011, -0.981599529509041, 0.981599529509041, 
  0.1909512075574017, -0.1909512075574019, -0.5590727899857687, 
  0.5590727899857684, 0.829118577464966, -0.829118577464966, 
  -0.833805850913786, 0.833805850913786, 0.5520577895310749, 
  -0.5520577895310752, -0.1992259647898789, 0.1992259647898788, 
  0.979953577958437, -0.979953577958437, -0.925485637221462, 
  0.925485637221462, 0.3787827019503205, -0.3787827019503206, 
  -0.386577352824814, 0.3865773528248139, 0.922256987115283, 
  -0.922256987115283, -0.7100833733592028, 0.7100833733592028, 
  0.7041176058577251, -0.7041176058577255, -0.004218434655277025, 
  0.004218434655276902, 0.999991102364946, -0.999991102364946, 
  -0.999987572731904, 0.999987572731904, 0.004985416908821528, 
  -0.004985416908821653, -0.7035727716777356, 0.7035727716777356, 
  0.7106232158842749, -0.7106232158842751, -0.921960214758209, 
  0.921960214758209, 0.3872846012985758, -0.3872846012985759, 
  -0.378072752012384, 0.3780727520123839, 0.925775887667087, 
  -0.925775887667087, -0.97980048533148, 0.97980048533148, 
  0.1999775210972392, -0.1999775210972393, -0.5514181061350261, 
  0.5514181061350259, 0.834229028640493, -0.834229028640493, 
  -0.828689530173026, 0.828689530173026, 0.5597085514637148, 
  -0.5597085514637148, -0.1901982740555481, 0.190198274055548, 
  0.981745698511733, -0.981745698511733, -0.99468370293604, 0.99468370293604, 
  0.1029773330080321, -0.1029773330080322, -0.6305316210033347, 
  0.6305316210033345, 0.7761635619603043, -0.7761635619603045, 
  -0.879560195213828, 0.879560195213828, 0.4757876238359011, 
  -0.4757876238359012, -0.2855103232784614, 0.2855103232784612, 
  0.958375633716461, -0.958375633716461, -0.955481253439749, 
  0.955481253439749, 0.2950518163394466, -0.2950518163394467, 
  -0.4669941334688382, 0.4669941334688378, 0.884260413738899, 
  -0.884260413738899, -0.76983813194888, 0.7698381319488796, 
  0.6382391797731155, -0.6382391797731155, -0.0930545114805273, 
  0.0930545114805272, 0.995661015553547, -0.995661015553547, 
  -0.998538421092997, 0.998538421092997, 0.05404647630609352, 
  -0.05404647630609364, -0.6678566589348895, 0.6678566589348893, 
  0.7442899187254432, -0.7442899187254433, -0.901846518613902, 
  0.901846518613902, 0.4320565435958416, -0.4320565435958415, 
  -0.3321916770687293, 0.3321916770687292, 0.943211900734011, 
  -0.943211900734011, -0.968807840858701, 0.968807840858701, 
  0.2478131705351875, -0.2478131705351876, -0.5098202205851158, 
  0.5098202205851155, 0.860280967290654, -0.860280967290654, 
  -0.800227740420125, 0.800227740420125, 0.5996962259862081, 
  -0.5996962259862084, -0.1417971936978305, 0.1417971936978304, 
  0.989895729791487, -0.989895729791487, -0.988432704614708, 
  0.988432704614708, 0.1516601082950053, -0.1516601082950054, 
  -0.5916875771687355, 0.5916875771687355, 0.806167359190504, 
  -0.806167359190505, -0.85515493426311, 0.85515493426311, 
  0.5183724900160659, -0.5183724900160663, -0.2381411501116649, 
  0.2381411501116648, 0.971230555853497, -0.971230555853497, 
  -0.939852827990987, 0.939852827990987, 0.3415796564746571, 
  -0.3415796564746572, -0.4230430165811791, 0.4230430165811791, 
  0.906109599398382, -0.906109599398382, -0.7375939159879136, 
  0.7375939159879135, 0.6752445594727991, -0.6752445594727994, 
  -0.04408765279445498, 0.04408765279445487, 0.999027666719534, 
  -0.999027666719534, -0.999564046915328, 0.999564046915328, 
  0.02952483893694291, -0.02952483893694303, -0.6859213019783437, 
  0.6859213019783434, 0.7276757296298496, -0.7276757296298496, 
  -0.912178097674807, 0.912178097674807, 0.4097939947368312, 
  -0.4097939947368312, -0.3552392059477634, 0.3552392059477633, 
  0.934775431083639, -0.934775431083639, -0.974597693699155, 
  0.974597693699155, 0.2239627992240854, -0.2239627992240855, 
  -0.5307790240785703, 0.5307790240785701, 0.847510252208314, 
  -0.847510252208314, -0.814704008912187, 0.814704008912187, 
  0.5798770368469603, -0.5798770368469604, -0.1660477443528258, 
  0.1660477443528257, 0.98611771437052, -0.98611771437052, 
  -0.991856932539495, 0.991856932539495, 0.1273570782223854, 
  -0.1273570782223856, -0.611293709322411, 0.6112937093224109, 
  0.7914038166087194, -0.7914038166087197, -0.867618875322536, 
  0.867618875322536, 0.497229813249424, -0.4972298132494244, 
  -0.2619046174692226, 0.2619046174692224, 0.9650937629828, -0.9650937629828, 
  -0.947952546299199, 0.947952546299199, 0.3184116360387378, 
  -0.3184116360387379, -0.4451526466795236, 0.4451526466795235, 
  0.895454700782912, -0.895454700782912, -0.7539430975334998, 
  0.7539430975334996, 0.6569397275866271, -0.6569397275866271, 
  -0.06859174068738089, 0.06859174068738078, 0.997644813102076, 
  -0.997644813102076, -0.996911313063556, 0.996911313063556, 
  0.07853555809884548, -0.0785355580988456, -0.6493897240128618, 
  0.6493897240128617, 0.7604557754047892, -0.7604557754047893, 
  -0.890971700932397, 0.890971700932397, 0.4540588377486245, 
  -0.4540588377486246, -0.3089440483448757, 0.3089440483448756, 
  0.951080214804345, -0.951080214804345, -0.962434414400972, 
  0.962434414400972, 0.2715142684586907, -0.2715142684586908, 
  -0.4885543204541863, 0.4885543204541863, 0.872533481286276, 
  -0.872533481286276, -0.785269444659676, 0.785269444659676, 
  0.6191541805430081, -0.6191541805430086, -0.11746122971549, 
  0.1174612297154899, 0.993077469039412, -0.993077469039412, 
  -0.984413081788541, 0.984413081788541, 0.1758717839893249, 
  -0.175871783989325, -0.5717250345431973, 0.571725034543197, 
  0.820445296699652, -0.820445296699652, -0.842175879847586, 
  0.842175879847586, 0.5392029185779183, -0.5392029185779183, 
  -0.2142342354299511, 0.214234235429951, 0.976782315753999, 
  -0.976782315753999, -0.931186977482554, 0.931186977482554, 
  0.364541922098002, -0.3645419220980021, -0.4006785611882434, 
  0.4006785611882433, 0.916218691472794, -0.916218691472794, 
  -0.7208004354477494, 0.7208004354477492, 0.6931426492853653, 
  -0.6931426492853655, -0.0195570081480292, 0.01955700814802908, 
  0.999808743426611, -0.999808743426611, -0.999851096772332, 
  0.999851096772332, 0.01725642730012085, -0.01725642730012098, 
  -0.694799353941555, 0.694799353941555, 0.7192036274674911, 
  -0.7192036274674914, -0.917138215037351, 0.917138215037351, 
  0.3985693095536863, -0.3985693095536864, -0.3666835895799849, 
  0.3666835895799848, 0.930345712696489, -0.930345712696489, 
  -0.977272676350501, 0.977272676350501, 0.2119861223258003, 
  -0.2119861223258004, -0.5411393119017509, 0.5411393119017509, 
  0.84093296112978, -0.84093296112978, -0.821758646457352, 0.821758646457352, 
  0.5698357017356681, -0.5698357017356681, -0.1781364225491863, 
  0.1781364225491862, 0.984005800268158, -0.984005800268158, 
  -0.993345114798007, 0.993345114798007, 0.1151758781470081, 
  -0.1151758781470082, -0.6209594222653353, 0.6209594222653352, 
  0.783842711199065, -0.7838427111990653, -0.873655319906993, 
  0.873655319906993, 0.4865453545130302, -0.4865453545130303, 
  -0.2737280815949607, 0.2737280815949605, 0.961807120656913, 
  -0.961807120656913, -0.951788567798152, 0.951788567798152, 
  0.3067548242631926, -0.3067548242631928, -0.4561077341477143, 
  0.4561077341477139, 0.889924566944097, -0.889924566944097, 
  -0.7619479880233556, 0.7619479880233553, 0.6476382196467104, 
  -0.6476382196467104, -0.0808292123749895, 0.0808292123749894, 
  0.996727966110533, -0.996727966110533, -0.997799999583146, 
  0.997799999583146, 0.06629600917003219, -0.06629600917003229, 
  -0.6586727883234421, 0.6586727883234417, 0.7524295036229124, 
  -0.7524295036229124, -0.896476612813344, 0.896476612813344, 
  0.4430910546137369, -0.443091054613737, -0.3205920026949903, 
  0.3205920026949902, 0.947217381495935, -0.947217381495935, 
  -0.965693842600134, 0.965693842600134, 0.2596832731698138, 
  -0.2596832731698139, -0.4992248612335552, 0.4992248612335552, 
  0.866472468071743, -0.866472468071743, -0.7928082895460143, 
  0.7928082895460142, 0.6094710953171801, -0.6094710953171804, 
  -0.1296389732829235, 0.1296389732829234, 0.991561262154865, 
  -0.991561262154865, -0.986497174624563, 0.986497174624563, 
  0.1637782783453126, -0.1637782783453127, -0.5817501105693698, 
  0.5817501105693694, 0.813367573027427, -0.813367573027427, 
  -0.848729314811817, 0.848729314811817, 0.528827524036962, 
  -0.528827524036962, -0.2262047255706203, 0.2262047255706201, 
  0.974079782219876, -0.974079782219876, -0.935590350969512, 
  0.935590350969512, 0.3530873761163724, -0.3530873761163725, 
  -0.4118918035799922, 0.4118918035799921, 0.911232759586496, 
  -0.911232759586496, -0.729252087058787, 0.7292520870587869, 
  0.684245126778703, -0.6842451267787031, -0.03182472681464096, 
  0.03182472681464084, 0.999493465092781, -0.999493465092781, 
  -0.999126466389543, 0.999126466389543, 0.04178880424162196, 
  -0.04178880424162208, -0.6769399527900713, 0.6769399527900709, 
  0.7360382465039275, -0.7360382465039275, -0.907080609646009, 
  0.907080609646008, 0.4209569664517096, -0.4209569664517094, 
  -0.3437413245977986, 0.3437413245977985, 0.939064375729242, 
  -0.939064375729242, -0.97177594021999, 0.97177594021999, 
  0.2359057481486073, -0.2359057481486074, -0.5203388028867221, 
  0.5203388028867219, 0.853959911360254, -0.853959911360254, 
  -0.807526679939997, 0.807526679939997, 0.5898310446094587, 
  -0.589831044609459, -0.1539340599769374, 0.1539340599769373, 
  0.988081122772324, -0.988081122772324, -0.99021938027528, 0.99021938027528, 
  0.1395190987902385, -0.1395190987902386, -0.6015359377953777, 
  0.6015359377953777, 0.7988457395146045, -0.7988457395146046, 
  -0.861451770526809, 0.861451770526809, 0.5078393910048976, 
  -0.507839391004898, -0.2500417114714546, 0.2500417114714545, 
  0.968235065737874, -0.968235065737874, -0.943973766633616, 
  0.943973766633616, 0.3300204961931054, -0.3300204961931055, 
  -0.4341305208601434, 0.4341305208601433, 0.900849982437532, 
  -0.900849982437532, -0.7458246659863761, 0.745824665986376, 
  0.6661423028199835, -0.6661423028199836, -0.05634393933592529, 
  0.05634393933592517, 0.998411418454391, -0.998411418454391, 
  -0.995872495367146, 0.995872495367146, 0.0907632798614856, 
  -0.0907632798614857, -0.6400088639984886, 0.6400088639984883, 
  0.7683675253440662, -0.7683675253440664, -0.885332611990541, 
  0.885332611990541, 0.4649582412927067, -0.4649582412927068, 
  -0.2972495681574659, 0.2972495681574658, 0.954799818930754, 
  -0.954799818930754, -0.959030047119114, 0.959030047119114, 
  0.2833043746974457, -0.2833043746974458, -0.4778102051912011, 
  0.4778102051912012, 0.878463094167958, -0.878463094167958, 
  -0.7776123410834201, 0.7776123410834201, 0.6287440234266745, 
  -0.6287440234266749, -0.1052657969189176, 0.1052657969189175, 
  0.994444122109948, -0.994444122109948, -0.982180739963357, 
  0.982180739963357, 0.1879388039895757, -0.1879388039895759, 
  -0.5616138588297926, 0.5616138588297922, 0.827399464328029, 
  -0.827399464328029, -0.835495616293615, 0.835495616293615, 
  0.549497111142681, -0.5494971111426811, -0.2022314824014416, 
  0.2022314824014415, 0.979337749464257, -0.979337749464257, 
  -0.926643370661961, 0.926643370661961, 0.3759415694070543, 
  -0.3759415694070544, -0.3894049780789911, 0.389404978078991, 
  0.921066644194273, -0.921066644194273, -0.7122402339424456, 
  0.7122402339424455, 0.7019357870586243, -0.7019357870586245, 
  -0.007286344267926684, 0.00728634426792656, 0.999973454241266, 
  -0.999973454241266, -0.999938158305365, 0.999938158305365, 
  0.01112113145662802, -0.01112113145662814, -0.6991992250374622, 
  0.6991992250374619, 0.7149268799723594, -0.7149268799723595, 
  -0.919566525477751, 0.919566525477751, 0.3929343523042695, 
  -0.3929343523042696, -0.3723851808419774, 0.3723851808419773, 
  0.928078270992963, -0.928078270992963, -0.97855500186236, 0.97855500186236, 
  0.2059856993340979, -0.205985699334098, -0.5462889927542954, 
  0.5462889927542953, 0.837596762407483, -0.837596762407483, 
  -0.825239623217882, 0.825239623217882, 0.5647827584755112, 
  -0.5647827584755115, -0.1841708152659177, 0.1841708152659176, 
  0.982894252096474, -0.982894252096474, -0.994033121259616, 
  0.994033121259616, 0.1090786589524491, -0.1090786589524492, 
  -0.625757301338693, 0.6257573013386927, 0.7800178201947161, 
  -0.7800178201947161, -0.876624259764365, 0.876624259764365, 
  0.4811755471681604, -0.4811755471681604, -0.2796244662882667, 
  0.2796244662882666, 0.960109450975774, -0.960109450975774, 
  -0.95365286286459, 0.95365286286459, 0.3009089848279218, 
  -0.3009089848279219, -0.4615596225377331, 0.4615596225377331, 
  0.8871091899213, -0.8871091899213, -0.7659074779779444, 0.7659074779779443, 
  0.642950803077082, -0.6429508030770822, -0.0869434986145495, 
  0.0869434986145494, 0.996213244264832, -0.996213244264832, 
  -0.9981880009451, 0.9981880009451, 0.0601723754660261, 
  -0.06017237546602622, -0.6632772096351943, 0.6632772096351941, 
  0.7483737990994543, -0.7483737990994546, -0.899178492494635, 
  0.899178492494635, 0.4375820364629643, -0.4375820364629643, 
  -0.3263979842316726, 0.3263979842316726, 0.945232434848435, 
  -0.945232434848435, -0.967269050295938, 0.967269050295938, 
  0.2537529986809898, -0.2537529986809899, -0.5045320385823804, 
  0.5045320385823801, 0.863392970809878, -0.863392970809878, 
  -0.796533009491872, 0.7965330094918719, 0.6045950419825004, 
  -0.6045950419825004, -0.1357206383930401, 0.13572063839304, 
  0.990747146508223, -0.990747146508223, -0.987483528718, 0.987483528718, 
  0.1577221623952936, -0.1577221623952937, -0.5867298888934006, 
  0.5867298888934004, 0.809782710039636, -0.809782710039637, 
  -0.851958162409106, 0.851958162409106, 0.5236098638342278, 
  -0.5236098638342281, -0.2321773085133618, 0.2321773085133616, 
  0.972673479340056, -0.972673479340056, -0.937739242156477, 
  0.937739242156477, 0.3473400548738891, -0.3473400548738892, 
  -0.4174752689345444, 0.4174752689345445, 0.908688285292613, 
  -0.908688285292613, -0.7334368082639959, 0.7334368082639959, 
  0.6797576393712119, -0.6797576393712122, -0.03795690433254537, 
  0.03795690433254524, 0.999279377058033, -0.999279377058033, 
  -0.999364069398621, 0.999364069398621, 0.03565749283150814, 
  -0.03565749283150827, -0.6814434553646781, 0.6814434553646779, 
  0.7318707653272182, -0.7318707653272183, -0.90964647749828, 
  0.90964647749828, 0.4153833000675062, -0.4153833000675064, 
  -0.3494968444521096, 0.3494968444521095, 0.93693754099087, 
  -0.93693754099087, -0.973205137271253, 0.973205137271253, 
  0.2299386022155521, -0.2299386022155522, -0.5255688071669147, 
  0.5255688071669144, 0.850751096933261, -0.850751096933261, 
  -0.811130613730669, 0.811130613730669, 0.5848650506475046, 
  -0.5848650506475046, -0.1599939140050983, 0.1599939140050982, 
  0.987118000788826, -0.987118000788826, -0.991056812771815, 
  0.991056812771815, 0.1334406004879057, -0.1334406004879058, 
  -0.6064262393614737, 0.6064262393614733, 0.7951397463426795, 
  -0.7951397463426796, -0.864551597864179, 0.864551597864179, 
  0.5025440623771157, -0.5025440623771159, -0.2559779831835324, 
  0.2559779831835323, 0.96668261188732, -0.96668261188732, 
  -0.945980964290725, 0.945980964290725, 0.324222169506637, 
  -0.3242221695066371, -0.4396498600542035, 0.4396498600542035, 
  0.898169249392518, -0.898169249392518, -0.7498979983778354, 
  0.7498979983778354, 0.6615534687603989, -0.661553468760399, 
  -0.06246901597322498, 0.06246901597322486, 0.998046903729147, 
  -0.998046903729147, -0.996410661364464, 0.996410661364464, 
  0.0846510125115536, -0.0846510125115537, -0.6447114305161584, 
  0.6447114305161584, 0.7644260404786119, -0.7644260404786122, 
  -0.888168875989562, 0.888168875989562, 0.4595171898019033, 
  -0.4595171898019036, -0.303102514070341, 0.3031025140703409, 
  0.952957956031765, -0.952957956031765, -0.960750316613244, 
  0.960750316613244, 0.2774145438284581, -0.2774145438284582, 
  -0.483191358763472, 0.4831913587634718, 0.875514769045223, 
  -0.875514769045223, -0.7814556035524446, 0.7814556035524446, 
  0.6239608478714707, -0.6239608478714708, -0.1113656097433352, 
  0.1113656097433351, 0.993779503192985, -0.993779503192985, 
  -0.983315421510873, 0.983315421510873, 0.181908718369666, 
  -0.1819087183696661, -0.5666801142795018, 0.5666801142795017, 
  0.823937890911791, -0.823937890911791, -0.838851539213766, 
  0.838851539213766, 0.5443602622884002, -0.5443602622884005, 
  -0.2082367789142115, 0.2082367789142113, 0.978078444659442, 
  -0.978078444659442, -0.928932660967083, 0.928932660967083, 
  0.3702487155799663, -0.3702487155799663, -0.3950492063232849, 
  0.3950492063232848, 0.918659961347692, -0.918659961347692, 
  -0.7165338232418267, 0.7165338232418265, 0.6975523493978432, 
  -0.6975523493978433, -0.0134219288719959, 0.01342192887199578, 
  0.999909921855642, -0.999909921855642, -0.999726391410624, 
  0.999726391410624, 0.02339107344887921, -0.02339107344887934, 
  -0.6903733240426742, 0.6903733240426739, 0.7234532973525443, 
  -0.7234532973525444, -0.914675374861522, 0.914675374861522, 
  0.4041892608938708, -0.4041892608938708, -0.3609681928880952, 
  0.3609681928880952, 0.932578127409764, -0.932578127409764, 
  -0.975953557074734, 0.975953557074734, 0.2179785641598122, 
  -0.2179785641598123, -0.5359692574599668, 0.5359692574599668, 
  0.844237499201387, -0.844237499201387, -0.818246730948242, 
  0.818246730948242, 0.5748671910037264, -0.5748671910037268, 
  -0.172095323096829, 0.1720953230968289, 0.985080301177624, 
  -0.985080301177624, -0.992619709454266, 0.992619709454266, 
  0.1212687610348524, -0.1212687610348526, -0.616138164420697, 
  0.6161381644206968, 0.7876380909683675, -0.7876380909683675, 
  -0.870653487420617, 0.870653487420617, 0.4918968437002994, 
  -0.4918968437002994, -0.2678213911940943, 0.2678213911940942, 
  0.963468578843576, -0.963468578843576, -0.949888438430089, 
  0.949888438430089, 0.3125891145527086, -0.3125891145527087, 
  -0.4506386735592978, 0.4506386735592977, 0.892706438809935, 
  -0.892706438809935, -0.7579598111576723, 0.7579598111576722, 
  0.6523012530034153, -0.6523012530034155, -0.07471188296126837, 
  0.07471188296126825, 0.997205161711662, -0.997205161711662, 
  -0.997374431615167, 0.997374431615167, 0.07241714686676343, 
  -0.07241714686676354, -0.6540435683534928, 0.6540435683534927, 
  0.7564568796008336, -0.7564568796008338, -0.893740981294271, 
  0.893740981294271, 0.4485833906367391, -0.4485833906367393, 
  -0.3147739510506061, 0.314773951050606, 0.949166665944391, 
  -0.949166665944391, -0.964082277076968, 0.964082277076968, 
  0.2656037707301763, -0.2656037707301764, -0.4938988883508675, 
  0.4938988883508673, 0.869519343134917, -0.869519343134917, 
  -0.7890537208161521, 0.7890537208161518, 0.614324202409596, 
  -0.614324202409596, -0.1235524273387353, 0.1235524273387353, 
  0.99233804608042, -0.99233804608042, -0.985473679470072, 0.985473679470072, 
  0.1698282281357198, -0.1698282281357199, -0.5767484296824826, 
  0.5767484296824823, 0.816921813185809, -0.81692181318581, 
  -0.845468513035529, 0.845468513035529, 0.5340252741823103, 
  -0.5340252741823105, -0.2202236261478125, 0.2202236261478124, 
  0.975449411546446, -0.975449411546446, -0.933406235334632, 
  0.933406235334632, 0.3588214038187108, -0.3588214038187108, 
  -0.4062928307318375, 0.4062928307318374, 0.913742926482011, 
  -0.913742926482011, -0.7250399099246754, 0.7250399099246751, 
  0.6887068527439079, -0.6887068527439079, -0.0256913511137594, 
  0.02569135111375927, 0.999669922763484, -0.999669922763484, 
  -0.998851246833715, 0.998851246833715, 0.0479185423268752, 
  -0.04791854232687533, -0.6724109638088499, 0.6724109638088498, 
  0.7401780162566661, -0.7401780162566663, -0.904480590721468, 
  0.904480590721468, 0.4265147840440515, -0.4265147840440516, 
  -0.3379728630768998, 0.3379728630768997, 0.941155855224629, 
  -0.941155855224629, -0.970310156353828, 0.970310156353828, 
  0.2418640123635791, -0.2418640123635792, -0.5150892081446975, 
  0.5150892081446969, 0.857136574679245, -0.857136574679245, 
  -0.803892343226241, 0.803892343226241, 0.5947748317659576, 
  -0.5947748317659576, -0.1478684104184223, 0.1478684104184222, 
  0.989007044060015, -0.989007044060015, -0.989344666578753, 
  0.989344666578753, 0.1455923442773583, -0.1455923442773585, 
  -0.5966229887412134, 0.5966229887412132, 0.802521656595946, 
  -0.802521656595946, -0.858319510017173, 0.858319510017173, 
  0.5131155997666405, -0.5131155997666407, -0.2440960258302642, 
  0.2440960258302641, 0.969751066085452, -0.969751066085452, 
  -0.94193102889773, 0.94193102889773, 0.3358063977944204, 
  -0.3358063977944206, -0.4285948368973444, 0.4285948368973445, 
  0.903496798989868, -0.903496798989868, -0.7417232537177842, 
  0.7417232537177842, 0.6707060569983719, -0.6707060569983722, 
  -0.05021674138115533, 0.0502167413811552, 0.998738343554035, 
  -0.998738343554035, -0.995296835333246, 0.995296835333246, 
  0.0968721300252304, -0.0968721300252305, -0.6352822015088236, 
  0.6352822015088232, 0.7722800816064744, -0.7722800816064744, 
  -0.88246301571907, 0.88246301571907, 0.4703817873685209, 
  -0.4703817873685207, -0.2913854309663557, 0.2913854309663556, 
  0.956605734156215, -0.956605734156215, -0.957273670685755, 
  0.957273670685755, 0.2891835393168502, -0.2891835393168502, 
  -0.4724110623347641, 0.4724110623347641, 0.881378345651707, 
  -0.881378345651707, -0.7737398019492618, 0.7737398019492617, 
  0.6335035271247643, -0.6335035271247645, -0.0991620208967426, 
  0.0991620208967425, 0.995071300767776, -0.995071300767776, 
  -0.981009079866113, 0.981009079866113, 0.1939618138197389, 
  -0.193961813819739, -0.5565264589357238, 0.5565264589357236, 
  0.830829886622083, -0.830829886622084, -0.832108237435736, 
  0.832108237435735, 0.5546132717413039, -0.5546132717413041, 
  -0.1962185719876608, 0.1962185719876607, 0.980560182756328, 
  -0.980560182756328, -0.924319192757675, 0.924319192757675, 
  0.3816202692465374, -0.3816202692465374, -0.383746088957365, 
  0.3837460889573649, 0.92343864940229, -0.92343864940229, 
  -0.7079198292008164, 0.7079198292008161, 0.7062927972337585, 
  -0.7062927972337585, -0.001150485337113809, 0.001150485337113686, 
  0.999999338191526, -0.999999338191526};

/*** "interface" to the above arrays ***/

/************************************************************************

  get supermoduli lists

  These are the values of the T0 components of the supermoduli in the
  proper order.

  ************************************************************************/
const double *get_mods(int n)
{
  switch(n)
    {
    case 2: return mod2;
    case 4: return mod4;
    case 8: return mod8;
    case 16: return mod16;
    case 32: return mod32;
    case 64: return mod64;
    case 128: return mod128;
    case 256: return mod256;
    case 512: return mod512;
    case 1024: return mod1024;
    case 2048: return mod2048;
    case 4096: return mod4096;
    default: return 0 ;
    }
} 
