# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/utils.ipynb.

# %% auto 0
__all__ = ['first_not_na']

# %% ../nbs/utils.ipynb 2
from math import sqrt
from typing import Optional, Tuple

import numpy as np
from numba import njit  # type: ignore

# %% ../nbs/utils.ipynb 3
@njit
def _validate_rolling_sizes(window_size: int,
                            min_samples: Optional[int] = None) -> Tuple[int,int]:
    # have to split the following if because of numba
    if min_samples is None:
        min_samples = window_size
    if min_samples > window_size:
        min_samples = window_size
    return window_size, min_samples

@njit
def _gt(x: float, y: float) -> float:
    return x - y

@njit
def _lt(x: float, y: float) -> float:
    return -_gt(x, y)

# %% ../nbs/utils.ipynb 4
@njit
def first_not_na(input_array: np.ndarray) -> int:
    """Returns the index of the first non-na value in the array."""
    for index, element in enumerate(input_array):
        if not np.isnan(element):
            return index
    return input_array.size
