Window ops
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

This library is intended to be used as an alternative to
`pd.Series.rolling` and `pd.Series.expanding` to gain a speedup by using
numba optimized functions operating on numpy arrays. There are also
online classes for more efficient updates of window statistics.

## Install

`pip install window-ops`

## How to use

### Transformations

For a transformations `n_samples` -\> `n_samples` you can use
`{[seasonal_](rolling|expanding)}_{(mean|max|min|std)}` on an array.

#### Benchmarks

``` python
pd.__version__
```

    '1.3.5'

``` python
n_samples = 10_000  # array size
window_size = 8  # for rolling operations
season_length = 7  # for seasonal operations
execute_times = 10 # number of times each function will be executed
```

Average times in milliseconds.

``` python
times.applymap('{:.2f}'.format)
```

<div>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>window_ops</th>
      <th>pandas</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>rolling_mean</th>
      <td>0.03</td>
      <td>0.43</td>
    </tr>
    <tr>
      <th>rolling_max</th>
      <td>0.14</td>
      <td>0.57</td>
    </tr>
    <tr>
      <th>rolling_min</th>
      <td>0.14</td>
      <td>0.58</td>
    </tr>
    <tr>
      <th>rolling_std</th>
      <td>0.06</td>
      <td>0.54</td>
    </tr>
    <tr>
      <th>expanding_mean</th>
      <td>0.03</td>
      <td>0.31</td>
    </tr>
    <tr>
      <th>expanding_max</th>
      <td>0.05</td>
      <td>0.76</td>
    </tr>
    <tr>
      <th>expanding_min</th>
      <td>0.05</td>
      <td>0.47</td>
    </tr>
    <tr>
      <th>expanding_std</th>
      <td>0.09</td>
      <td>0.41</td>
    </tr>
    <tr>
      <th>seasonal_rolling_mean</th>
      <td>0.05</td>
      <td>3.89</td>
    </tr>
    <tr>
      <th>seasonal_rolling_max</th>
      <td>0.18</td>
      <td>4.27</td>
    </tr>
    <tr>
      <th>seasonal_rolling_min</th>
      <td>0.18</td>
      <td>3.75</td>
    </tr>
    <tr>
      <th>seasonal_rolling_std</th>
      <td>0.08</td>
      <td>4.38</td>
    </tr>
    <tr>
      <th>seasonal_expanding_mean</th>
      <td>0.04</td>
      <td>3.18</td>
    </tr>
    <tr>
      <th>seasonal_expanding_max</th>
      <td>0.06</td>
      <td>3.29</td>
    </tr>
    <tr>
      <th>seasonal_expanding_min</th>
      <td>0.06</td>
      <td>3.28</td>
    </tr>
    <tr>
      <th>seasonal_expanding_std</th>
      <td>0.12</td>
      <td>3.89</td>
    </tr>
  </tbody>
</table>
</div>

``` python
speedups = times['pandas'] / times['window_ops']
speedups = speedups.to_frame('times faster')
speedups.applymap('{:.0f}'.format)
```

<div>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>times faster</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>rolling_mean</th>
      <td>15</td>
    </tr>
    <tr>
      <th>rolling_max</th>
      <td>4</td>
    </tr>
    <tr>
      <th>rolling_min</th>
      <td>4</td>
    </tr>
    <tr>
      <th>rolling_std</th>
      <td>9</td>
    </tr>
    <tr>
      <th>expanding_mean</th>
      <td>12</td>
    </tr>
    <tr>
      <th>expanding_max</th>
      <td>15</td>
    </tr>
    <tr>
      <th>expanding_min</th>
      <td>9</td>
    </tr>
    <tr>
      <th>expanding_std</th>
      <td>4</td>
    </tr>
    <tr>
      <th>seasonal_rolling_mean</th>
      <td>77</td>
    </tr>
    <tr>
      <th>seasonal_rolling_max</th>
      <td>23</td>
    </tr>
    <tr>
      <th>seasonal_rolling_min</th>
      <td>21</td>
    </tr>
    <tr>
      <th>seasonal_rolling_std</th>
      <td>52</td>
    </tr>
    <tr>
      <th>seasonal_expanding_mean</th>
      <td>78</td>
    </tr>
    <tr>
      <th>seasonal_expanding_max</th>
      <td>52</td>
    </tr>
    <tr>
      <th>seasonal_expanding_min</th>
      <td>51</td>
    </tr>
    <tr>
      <th>seasonal_expanding_std</th>
      <td>33</td>
    </tr>
  </tbody>
</table>
</div>

### Online

If you have an array for which you want to compute a window statistic
and then keep updating it as more samples come in you can use the
classes in the `window_ops.online` module. They all have a
`fit_transform` method which take the array and return the
transformations defined above but also have an `update` method that take
a single value and return the new statistic.

#### Benchmarks

Average time in milliseconds it takes to transform the array and perform
100 updates.

``` python
times.to_frame().applymap('{:.2f}'.format)
```

<div>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>average time (ms)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>RollingMean</th>
      <td>0.12</td>
    </tr>
    <tr>
      <th>RollingMax</th>
      <td>0.23</td>
    </tr>
    <tr>
      <th>RollingMin</th>
      <td>0.22</td>
    </tr>
    <tr>
      <th>RollingStd</th>
      <td>0.32</td>
    </tr>
    <tr>
      <th>ExpandingMean</th>
      <td>0.10</td>
    </tr>
    <tr>
      <th>ExpandingMax</th>
      <td>0.07</td>
    </tr>
    <tr>
      <th>ExpandingMin</th>
      <td>0.07</td>
    </tr>
    <tr>
      <th>ExpandingStd</th>
      <td>0.17</td>
    </tr>
    <tr>
      <th>SeasonalRollingMean</th>
      <td>0.28</td>
    </tr>
    <tr>
      <th>SeasonalRollingMax</th>
      <td>0.35</td>
    </tr>
    <tr>
      <th>SeasonalRollingMin</th>
      <td>0.38</td>
    </tr>
    <tr>
      <th>SeasonalRollingStd</th>
      <td>0.42</td>
    </tr>
    <tr>
      <th>SeasonalExpandingMean</th>
      <td>0.17</td>
    </tr>
    <tr>
      <th>SeasonalExpandingMax</th>
      <td>0.14</td>
    </tr>
    <tr>
      <th>SeasonalExpandingMin</th>
      <td>0.15</td>
    </tr>
    <tr>
      <th>SeasonalExpandingStd</th>
      <td>0.23</td>
    </tr>
  </tbody>
</table>
</div>
