"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Specifies the type responses the lambda returns.
 *
 * @experimental
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * (experimental) Authorize Http Api routes via a lambda function.
 *
 * @experimental
 */
class HttpLambdaAuthorizer {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpLambdaAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c, _d;
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const id = this.props.authorizerName;
            const responseTypes = (_b = this.props.responseTypes) !== null && _b !== void 0 ? _b : [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_1.HttpAuthorizerType.LAMBDA,
                authorizerName: this.props.authorizerName,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.props.handler),
                resultsCacheTtl: (_d = this.props.resultsCacheTtl) !== null && _d !== void 0 ? _d : core_1.Duration.minutes(5),
            });
            this.props.handler.addPermission(`${core_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: core_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpLambdaAuthorizer", version: "1.133.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${core_1.Stack.of(handler).partition}:apigateway:${core_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLGdFQVFtQztBQUNuQyw4Q0FBb0Q7QUFFcEQsd0NBQXVEOzs7Ozs7QUFPdkQsSUFBWSxzQkFNWDtBQU5ELFdBQVksc0JBQXNCO0lBRWhDLHVFQUFNLENBQUE7SUFHTixpRUFBRyxDQUFBO0FBQ0wsQ0FBQyxFQU5XLHNCQUFzQixHQUF0Qiw4QkFBc0IsS0FBdEIsOEJBQXNCLFFBTWpDOzs7Ozs7QUFzQkQsTUFBYSxvQkFBb0I7Ozs7SUFJL0IsWUFBNkIsS0FBZ0M7UUFBaEMsVUFBSyxHQUFMLEtBQUssQ0FBMkI7O0tBQzVEOzs7Ozs7SUFFTSxJQUFJLENBQUMsT0FBdUM7O1FBQ2pELElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxLQUFLLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3hFLE1BQU0sSUFBSSxLQUFLLENBQUMsb0RBQW9ELENBQUMsQ0FBQztTQUN2RTtRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ3BCLE1BQU0sRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDO1lBRXJDLE1BQU0sYUFBYSxTQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxtQ0FBSSxDQUFDLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQy9FLE1BQU0scUJBQXFCLEdBQUcsYUFBYSxDQUFDLFFBQVEsQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLENBQUMsSUFBSSxTQUFTLENBQUM7WUFFakcsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQztZQUNyQyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksaUNBQWMsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtnQkFDdEQsT0FBTyxFQUFFLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTztnQkFDOUIsY0FBYyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxtQ0FBSTtvQkFDM0MsK0JBQStCO2lCQUNoQztnQkFDRCxJQUFJLEVBQUUscUNBQWtCLENBQUMsTUFBTTtnQkFDL0IsY0FBYyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYztnQkFDekMscUJBQXFCO2dCQUNyQixvQkFBb0IsRUFBRSxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsMkNBQXdCLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQywyQ0FBd0IsQ0FBQyxXQUFXO2dCQUN6SCxhQUFhLEVBQUUsbUJBQW1CLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUM7Z0JBQ3RELGVBQWUsUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsbUNBQUksZUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7YUFDbkUsQ0FBQyxDQUFDO1lBRUgsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLEdBQUcsWUFBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUU7Z0JBQ3pGLEtBQUssRUFBRSxPQUFPLENBQUMsS0FBc0I7Z0JBQ3JDLFNBQVMsRUFBRSxJQUFJLDBCQUFnQixDQUFDLDBCQUEwQixDQUFDO2dCQUMzRCxTQUFTLEVBQUUsWUFBSyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsU0FBUyxDQUFDO29CQUMzQyxPQUFPLEVBQUUsYUFBYTtvQkFDdEIsUUFBUSxFQUFFLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUs7b0JBQ3JDLFlBQVksRUFBRSxlQUFlLElBQUksQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFO2lCQUM1RCxDQUFDO2FBQ0gsQ0FBQyxDQUFDO1NBQ0o7UUFFRCxPQUFPO1lBQ0wsWUFBWSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsWUFBWTtZQUMxQyxpQkFBaUIsRUFBRSxRQUFRO1NBQzVCLENBQUM7S0FDSDs7QUEvQ0gsb0RBZ0RDOzs7QUFFRDs7R0FFRztBQUNILFNBQVMsbUJBQW1CLENBQUMsT0FBa0I7SUFDN0MsT0FBTyxPQUFPLFlBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsU0FBUyxlQUFlLFlBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxxQ0FBcUMsT0FBTyxDQUFDLFdBQVcsY0FBYyxDQUFDO0FBQ3pKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBIdHRwQXV0aG9yaXplcixcbiAgSHR0cEF1dGhvcml6ZXJUeXBlLFxuICBIdHRwUm91dGVBdXRob3JpemVyQmluZE9wdGlvbnMsXG4gIEh0dHBSb3V0ZUF1dGhvcml6ZXJDb25maWcsXG4gIElIdHRwUm91dGVBdXRob3JpemVyLFxuICBBdXRob3JpemVyUGF5bG9hZFZlcnNpb24sXG4gIElIdHRwQXBpLFxufSBmcm9tICdAYXdzLWNkay9hd3MtYXBpZ2F0ZXdheXYyJztcbmltcG9ydCB7IFNlcnZpY2VQcmluY2lwYWwgfSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCB7IElGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgU3RhY2ssIER1cmF0aW9uLCBOYW1lcyB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gSHR0cExhbWJkYVJlc3BvbnNlVHlwZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFNJTVBMRSxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIElBTSxcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cExhbWJkYUF1dGhvcml6ZXJQcm9wcyB7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXV0aG9yaXplck5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpZGVudGl0eVNvdXJjZT86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBoYW5kbGVyOiBJRnVuY3Rpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlc3VsdHNDYWNoZVR0bD86IER1cmF0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlc3BvbnNlVHlwZXM/OiBIdHRwTGFtYmRhUmVzcG9uc2VUeXBlW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBIdHRwTGFtYmRhQXV0aG9yaXplciBpbXBsZW1lbnRzIElIdHRwUm91dGVBdXRob3JpemVyIHtcbiAgcHJpdmF0ZSBhdXRob3JpemVyPzogSHR0cEF1dGhvcml6ZXI7XG4gIHByaXZhdGUgaHR0cEFwaT86IElIdHRwQXBpO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEh0dHBMYW1iZGFBdXRob3JpemVyUHJvcHMpIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKG9wdGlvbnM6IEh0dHBSb3V0ZUF1dGhvcml6ZXJCaW5kT3B0aW9ucyk6IEh0dHBSb3V0ZUF1dGhvcml6ZXJDb25maWcge1xuICAgIGlmICh0aGlzLmh0dHBBcGkgJiYgKHRoaXMuaHR0cEFwaS5hcGlJZCAhPT0gb3B0aW9ucy5yb3V0ZS5odHRwQXBpLmFwaUlkKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdDYW5ub3QgYXR0YWNoIHRoZSBzYW1lIGF1dGhvcml6ZXIgdG8gbXVsdGlwbGUgQXBpcycpO1xuICAgIH1cblxuICAgIGlmICghdGhpcy5hdXRob3JpemVyKSB7XG4gICAgICBjb25zdCBpZCA9IHRoaXMucHJvcHMuYXV0aG9yaXplck5hbWU7XG5cbiAgICAgIGNvbnN0IHJlc3BvbnNlVHlwZXMgPSB0aGlzLnByb3BzLnJlc3BvbnNlVHlwZXMgPz8gW0h0dHBMYW1iZGFSZXNwb25zZVR5cGUuSUFNXTtcbiAgICAgIGNvbnN0IGVuYWJsZVNpbXBsZVJlc3BvbnNlcyA9IHJlc3BvbnNlVHlwZXMuaW5jbHVkZXMoSHR0cExhbWJkYVJlc3BvbnNlVHlwZS5TSU1QTEUpIHx8IHVuZGVmaW5lZDtcblxuICAgICAgdGhpcy5odHRwQXBpID0gb3B0aW9ucy5yb3V0ZS5odHRwQXBpO1xuICAgICAgdGhpcy5hdXRob3JpemVyID0gbmV3IEh0dHBBdXRob3JpemVyKG9wdGlvbnMuc2NvcGUsIGlkLCB7XG4gICAgICAgIGh0dHBBcGk6IG9wdGlvbnMucm91dGUuaHR0cEFwaSxcbiAgICAgICAgaWRlbnRpdHlTb3VyY2U6IHRoaXMucHJvcHMuaWRlbnRpdHlTb3VyY2UgPz8gW1xuICAgICAgICAgICckcmVxdWVzdC5oZWFkZXIuQXV0aG9yaXphdGlvbicsXG4gICAgICAgIF0sXG4gICAgICAgIHR5cGU6IEh0dHBBdXRob3JpemVyVHlwZS5MQU1CREEsXG4gICAgICAgIGF1dGhvcml6ZXJOYW1lOiB0aGlzLnByb3BzLmF1dGhvcml6ZXJOYW1lLFxuICAgICAgICBlbmFibGVTaW1wbGVSZXNwb25zZXMsXG4gICAgICAgIHBheWxvYWRGb3JtYXRWZXJzaW9uOiBlbmFibGVTaW1wbGVSZXNwb25zZXMgPyBBdXRob3JpemVyUGF5bG9hZFZlcnNpb24uVkVSU0lPTl8yXzAgOiBBdXRob3JpemVyUGF5bG9hZFZlcnNpb24uVkVSU0lPTl8xXzAsXG4gICAgICAgIGF1dGhvcml6ZXJVcmk6IGxhbWJkYUF1dGhvcml6ZXJBcm4odGhpcy5wcm9wcy5oYW5kbGVyKSxcbiAgICAgICAgcmVzdWx0c0NhY2hlVHRsOiB0aGlzLnByb3BzLnJlc3VsdHNDYWNoZVR0bCA/PyBEdXJhdGlvbi5taW51dGVzKDUpLFxuICAgICAgfSk7XG5cbiAgICAgIHRoaXMucHJvcHMuaGFuZGxlci5hZGRQZXJtaXNzaW9uKGAke05hbWVzLm5vZGVVbmlxdWVJZCh0aGlzLmF1dGhvcml6ZXIubm9kZSl9LVBlcm1pc3Npb25gLCB7XG4gICAgICAgIHNjb3BlOiBvcHRpb25zLnNjb3BlIGFzIENvcmVDb25zdHJ1Y3QsXG4gICAgICAgIHByaW5jaXBhbDogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ2FwaWdhdGV3YXkuYW1hem9uYXdzLmNvbScpLFxuICAgICAgICBzb3VyY2VBcm46IFN0YWNrLm9mKG9wdGlvbnMucm91dGUpLmZvcm1hdEFybih7XG4gICAgICAgICAgc2VydmljZTogJ2V4ZWN1dGUtYXBpJyxcbiAgICAgICAgICByZXNvdXJjZTogb3B0aW9ucy5yb3V0ZS5odHRwQXBpLmFwaUlkLFxuICAgICAgICAgIHJlc291cmNlTmFtZTogYGF1dGhvcml6ZXJzLyR7dGhpcy5hdXRob3JpemVyLmF1dGhvcml6ZXJJZH1gLFxuICAgICAgICB9KSxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBhdXRob3JpemVySWQ6IHRoaXMuYXV0aG9yaXplci5hdXRob3JpemVySWQsXG4gICAgICBhdXRob3JpemF0aW9uVHlwZTogJ0NVU1RPTScsXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIGNvbnN0cnVjdHMgdGhlIGF1dGhvcml6ZXJVUklBcm4uXG4gKi9cbmZ1bmN0aW9uIGxhbWJkYUF1dGhvcml6ZXJBcm4oaGFuZGxlcjogSUZ1bmN0aW9uKSB7XG4gIHJldHVybiBgYXJuOiR7U3RhY2sub2YoaGFuZGxlcikucGFydGl0aW9ufTphcGlnYXRld2F5OiR7U3RhY2sub2YoaGFuZGxlcikucmVnaW9ufTpsYW1iZGE6cGF0aC8yMDE1LTAzLTMxL2Z1bmN0aW9ucy8ke2hhbmRsZXIuZnVuY3Rpb25Bcm59L2ludm9jYXRpb25zYDtcbn1cbiJdfQ==