"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpJwtAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
class HttpJwtAuthorizer {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpJwtAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b;
        if (!this.authorizer) {
            const id = this.props.authorizerName && !core_1.Token.isUnresolved(this.props.authorizerName) ?
                this.props.authorizerName : 'JwtAuthorizer';
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, id, {
                httpApi: options.route.httpApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: this.props.authorizerName,
                jwtAudience: this.props.jwtAudience,
                jwtIssuer: this.props.jwtIssuer,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpJwtAuthorizer = HttpJwtAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpJwtAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpJwtAuthorizer", version: "1.133.0" };
//# sourceMappingURL=data:application/json;base64,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