# flake8: noqa

from typing import Dict

from hyperstyle.src.python.review.inspectors.issue import IssueType

# The configuration was made using the following table: https://bit.ly/3Kvz0nK
CODE_TO_ISSUE_TYPE: Dict[str, IssueType] = {
    'errcheck': IssueType.ERROR_PRONE,
    'ineffassign': IssueType.ERROR_PRONE,
    # 'typecheck': IssueType.ERROR_PRONE,
    'unused': IssueType.ERROR_PRONE,
    # 'asasalint': IssueType.ERROR_PRONE,
    'asciicheck': IssueType.ERROR_PRONE,
    # 'bidichk': IssueType.ERROR_PRONE,
    'bodyclose': IssueType.ERROR_PRONE,
    # 'containedctx': IssueType.BEST_PRACTICES,
    # 'contextcheck': IssueType.ERROR_PRONE,
    'cyclop': IssueType.CYCLOMATIC_COMPLEXITY,
    # 'decorder': IssueType.CODE_STYLE,
    # 'depguard': IssueType.BEST_PRACTICES,
    'dogsled': IssueType.COMPLEXITY,
    # 'dupl': IssueType.ERROR_PRONE,
    'durationcheck': IssueType.ERROR_PRONE,
    # 'errchkjson': IssueType.ERROR_PRONE,
    'errname': IssueType.CODE_STYLE,
    'errorlint': IssueType.ERROR_PRONE,
    'execinquery': IssueType.BEST_PRACTICES,
    'exhaustive': IssueType.ERROR_PRONE,
    # 'exhaustruct': IssueType.ERROR_PRONE,
    # 'exportloopref': IssueType.ERROR_PRONE,
    # 'forbidigo': IssueType.CODE_STYLE,
    # 'forcetypeassert': IssueType.ERROR_PRONE,
    'funlen': IssueType.FUNC_LEN,
    # 'gci': IssueType.CODE_STYLE,
    'gochecknoglobals': IssueType.BEST_PRACTICES,
    # 'gochecknoinits': IssueType.BEST_PRACTICES,
    # 'gocognit': IssueType.COMPLEXITY,
    'goconst': IssueType.COMPLEXITY,
    # 'gocyclo': IssueType.CYCLOMATIC_COMPLEXITY,
    # 'godot': IssueType.CODE_STYLE,
    # 'godox': IssueType.BEST_PRACTICES,
    # 'goerr113': IssueType.ERROR_PRONE,
    # 'gofmt': IssueType.CODE_STYLE,
    # 'gofumpt': IssueType.CODE_STYLE,
    # 'goheader': IssueType.CODE_STYLE,
    # 'goimports': IssueType.CODE_STYLE,
    'gomnd': IssueType.INFO,
    # 'gomoddirectives': IssueType.BEST_PRACTICES,
    # 'gomodguard': IssueType.CODE_STYLE,
    # 'goprintffuncname': IssueType.CODE_STYLE,
    # 'gosec': IssueType.ERROR_PRONE,
    # 'grouper': IssueType.CODE_STYLE,
    # 'importas': IssueType.CODE_STYLE,
    # 'interfacebloat': IssueType.COMPLEXITY,
    # 'ireturn': IssueType.BEST_PRACTICES,
    'lll': IssueType.LINE_LEN,
    # 'logrlint': IssueType.ERROR_PRONE,
    'maintidx': IssueType.MAINTAINABILITY,
    # 'makezero': IssueType.ERROR_PRONE,
    'misspell': IssueType.INFO,
    # 'nakedret': IssueType.BEST_PRACTICES,
    # 'nestif': IssueType.COMPLEXITY,
    'nilerr': IssueType.ERROR_PRONE,
    # 'nilnil': IssueType.BEST_PRACTICES,
    # 'nlreturn': IssueType.CODE_STYLE,
    # 'noctx': IssueType.ERROR_PRONE,
    # 'nolintlint': IssueType.CODE_STYLE,
    # 'nonamedreturns': IssueType.ERROR_PRONE,
    # 'nosprintfhostport': IssueType.ERROR_PRONE,
    # 'paralleltest': IssueType.ERROR_PRONE,
    # 'prealloc': IssueType.BEST_PRACTICES,
    'predeclared': IssueType.ERROR_PRONE,
    # 'promlinter': IssueType.CODE_STYLE,
    # 'reassign': IssueType.ERROR_PRONE,
    'rowserrcheck': IssueType.ERROR_PRONE,
    'sqlclosecheck': IssueType.ERROR_PRONE,
    # 'tagliatelle': IssueType.CODE_STYLE,
    # 'tenv': IssueType.BEST_PRACTICES,
    # 'testpackage': IssueType.CODE_STYLE,
    # 'thelper': IssueType.BEST_PRACTICES,
    # 'tparallel': IssueType.BEST_PRACTICES,
    'unconvert': IssueType.ERROR_PRONE,
    'unparam': IssueType.ERROR_PRONE,
    'usestdlibvars': IssueType.INFO,
    'varnamelen': IssueType.INFO,
    # 'wastedassign': IssueType.ERROR_PRONE,
    'whitespace': IssueType.CODE_STYLE,
    # 'wrapcheck': IssueType.BEST_PRACTICES,
    # 'wsl': IssueType.CODE_STYLE,
    # ------------
    # -- revive --
    # ------------
    # 'revive-context-keys-type': IssueType.ERROR_PRONE,
    'revive-time-equal': IssueType.BEST_PRACTICES,
    # 'revive-time-naming': IssueType.CODE_STYLE,
    'revive-var-declaration': IssueType.CODE_STYLE,
    # 'revive-unexported-return': IssueType.BEST_PRACTICES,
    # 'revive-errorf': IssueType.BEST_PRACTICES,
    # 'revive-blank-imports': IssueType.BEST_PRACTICES,
    'revive-context-as-argument': IssueType.CODE_STYLE,
    # 'revive-dot-imports': IssueType.BEST_PRACTICES,
    'revive-error-return': IssueType.CODE_STYLE,
    # 'revive-error-strings': IssueType.CODE_STYLE,
    # 'revive-error-naming': IssueType.CODE_STYLE,
    # 'revive-exported': IssueType.CODE_STYLE,
    'revive-if-return': IssueType.BEST_PRACTICES,
    'revive-increment-decrement': IssueType.BEST_PRACTICES,
    'revive-var-naming': IssueType.CODE_STYLE,
    # 'revive-package-comments': IssueType.CODE_STYLE,
    # 'revive-range': IssueType.BEST_PRACTICES,
    # 'revive-receiver-naming': IssueType.CODE_STYLE,
    'revive-indent-error-flow': IssueType.BEST_PRACTICES,
    # 'revive-argument-limit': IssueType.COMPLEXITY,
    # 'revive-cyclomatic': IssueType.CYCLOMATIC_COMPLEXITY,
    # 'revive-max-public-structs': IssueType.COMPLEXITY,
    # 'revive-file-header': IssueType.CODE_STYLE,
    'revive-empty-block': IssueType.ERROR_PRONE,
    'revive-superfluous-else': IssueType.BEST_PRACTICES,
    'revive-confusing-naming': IssueType.ERROR_PRONE,
    'revive-get-return': IssueType.BEST_PRACTICES,
    # 'revive-modifies-parameter': IssueType.ERROR_PRONE,
    # 'revive-confusing-results': IssueType.ERROR_PRONE,
    # 'revive-deep-exit': IssueType.BEST_PRACTICES,
    # 'revive-unused-parameter': IssueType.ERROR_PRONE,
    # 'revive-unreachable-code': IssueType.ERROR_PRONE,
    # 'revive-add-constant': IssueType.INFO,
    # 'revive-flag-parameter': IssueType.COMPLEXITY,
    'revive-unnecessary-stmt': IssueType.BEST_PRACTICES,
    # 'revive-struct-tag': IssueType.ERROR_PRONE,
    # 'revive-modifies-value-receiver': IssueType.ERROR_PRONE,
    # 'revive-constant-logical-expr': IssueType.ERROR_PRONE,
    'revive-bool-literal-in-expr': IssueType.BEST_PRACTICES,
    # 'revive-redefines-builtin-id': IssueType.ERROR_PRONE,
    # 'revive-function-result-limit': IssueType.COMPLEXITY,
    # 'revive-imports-blacklist': IssueType.CODE_STYLE,
    # 'revive-range-val-in-closure': IssueType.ERROR_PRONE,
    'revive-range-val-address': IssueType.ERROR_PRONE,
    # 'revive-waitgroup-by-value': IssueType.ERROR_PRONE,
    # 'revive-atomic': IssueType.ERROR_PRONE,
    # 'revive-empty-lines': IssueType.CODE_STYLE,
    # 'revive-line-length-limit': IssueType.LINE_LEN,
    # 'revive-call-to-gc': IssueType.ERROR_PRONE,
    'revive-duplicated-imports': IssueType.ERROR_PRONE,
    # 'revive-import-shadowing': IssueType.ERROR_PRONE,
    # 'revive-bare-return': IssueType.ERROR_PRONE,
    'revive-unused-receiver': IssueType.ERROR_PRONE,
    # 'revive-unhandled-error': IssueType.ERROR_PRONE,
    # 'revive-cognitive-complexity': IssueType.COMPLEXITY,
    # 'revive-string-of-int': IssueType.ERROR_PRONE,
    # 'revive-string-format': IssueType.CODE_STYLE,
    'revive-early-return': IssueType.COMPLEXITY,
    # 'revive-unconditional-recursion': IssueType.ERROR_PRONE,
    'revive-identical-branches': IssueType.ERROR_PRONE,
    # 'revive-defer': IssueType.ERROR_PRONE,
    'revive-unexported-naming': IssueType.CODE_STYLE,
    # 'revive-function-length': IssueType.FUNC_LEN,
    # 'revive-nested-structs': IssueType.BEST_PRACTICES,
    # 'revive-useless-break': IssueType.ERROR_PRONE,
    # 'revive-banned-characters': IssueType.CODE_STYLE,
    # 'revive-optimize-operands-order': IssueType.BEST_PRACTICES,
    # 'revive-use-any': IssueType.BEST_PRACTICES,
    # 'revive-datarace': IssueType.ERROR_PRONE,
    # --------------
    # -- gocritic --
    # --------------
    # Diagnostic group:
    # 'gocritic-appendAssign': IssueType.ERROR_PRONE,
    # 'gocritic-argOrder': IssueType.ERROR_PRONE,
    # 'gocritic-badCall': IssueType.ERROR_PRONE,
    # 'gocritic-badCond': IssueType.ERROR_PRONE,
    # 'gocritic-badLock': IssueType.ERROR_PRONE,
    # 'gocritic-badRegexp': IssueType.ERROR_PRONE,
    # 'gocritic-builtinShadowDecl': IssueType.ERROR_PRONE,
    # 'gocritic-caseOrder': IssueType.ERROR_PRONE,
    # 'gocritic-codegenComment': IssueType.CODE_STYLE,
    # 'gocritic-commentedOutCode': IssueType.BEST_PRACTICES,
    # 'gocritic-deprecatedComment': IssueType.CODE_STYLE,
    # 'gocritic-dupArg': IssueType.ERROR_PRONE,
    # 'gocritic-dupBranchBody': IssueType.ERROR_PRONE,
    'gocritic-dupCase': IssueType.ERROR_PRONE,
    'gocritic-dupSubExpr': IssueType.ERROR_PRONE,
    # 'gocritic-emptyDecl': IssueType.ERROR_PRONE,
    # 'gocritic-evalOrder': IssueType.BEST_PRACTICES,
    'gocritic-exitAfterDefer': IssueType.ERROR_PRONE,
    # 'gocritic-externalErrorReassign': IssueType.ERROR_PRONE,
    # 'gocritic-filepathJoin': IssueType.ERROR_PRONE,
    # 'gocritic-flagDeref': IssueType.BEST_PRACTICES,
    # 'gocritic-flagName': IssueType.ERROR_PRONE,
    # 'gocritic-mapKey': IssueType.ERROR_PRONE,
    # 'gocritic-nilValReturn': IssueType.ERROR_PRONE,
    # 'gocritic-offBy1': IssueType.ERROR_PRONE,
    # 'gocritic-regexpPattern': IssueType.ERROR_PRONE,
    # 'gocritic-returnAfterHttpError': IssueType.ERROR_PRONE,
    # 'gocritic-sloppyReassign': IssueType.ERROR_PRONE,
    # 'gocritic-sloppyTypeAssert': IssueType.ERROR_PRONE,
    # 'gocritic-sortSlice': IssueType.ERROR_PRONE,
    # 'gocritic-sprintfQuotedString': IssueType.ERROR_PRONE,
    # 'gocritic-sqlQuery': IssueType.ERROR_PRONE,
    # 'gocritic-suspiciousSorting': IssueType.ERROR_PRONE,
    # 'gocritic-syncMapLoadAndDelete': IssueType.ERROR_PRONE,
    # 'gocritic-truncateCmp': IssueType.ERROR_PRONE,
    # 'gocritic-unnecessaryDefer': IssueType.ERROR_PRONE,
    # 'gocritic-weakCond': IssueType.ERROR_PRONE,
    # Style group
    'gocritic-assignOp': IssueType.BEST_PRACTICES,
    # 'gocritic-boolExprSimplify': IssueType.BEST_PRACTICES,
    # 'gocritic-builtinShadow': IssueType.ERROR_PRONE,
    # 'gocritic-captLocal': IssueType.CODE_STYLE,
    # 'gocritic-commentFormatting': IssueType.CODE_STYLE,
    # 'gocritic-commentedOutImport': IssueType.ERROR_PRONE,
    # 'gocritic-defaultCaseOrder': IssueType.CODE_STYLE,
    # 'gocritic-deferUnlambda': IssueType.BEST_PRACTICES,
    # 'gocritic-docStub': IssueType.BEST_PRACTICES,
    # 'gocritic-dupImport': IssueType.BEST_PRACTICES,
    'gocritic-elseif': IssueType.COMPLEXITY,
    # 'gocritic-emptyFallthrough': IssueType.BEST_PRACTICES,
    # 'gocritic-emptyStringTest': IssueType.BEST_PRACTICES,
    # 'gocritic-exposedSyncMutex': IssueType.BEST_PRACTICES,
    # 'gocritic-hexLiteral': IssueType.CODE_STYLE,
    # 'gocritic-httpNoBody': IssueType.BEST_PRACTICES,
    'gocritic-ifElseChain': IssueType.COMPLEXITY,
    # 'gocritic-importShadow': IssueType.ERROR_PRONE,
    # 'gocritic-initClause': IssueType.BEST_PRACTICES,
    # 'gocritic-ioutilDeprecated': IssueType.ERROR_PRONE,
    # 'gocritic-methodExprCall': IssueType.BEST_PRACTICES,
    # 'gocritic-nestingReduce': IssueType.COMPLEXITY,
    'gocritic-newDeref': IssueType.BEST_PRACTICES,
    # 'gocritic-octalLiteral': IssueType.BEST_PRACTICES,
    # 'gocritic-paramTypeCombine': IssueType.CODE_STYLE,
    # 'gocritic-preferFilepathJoin': IssueType.BEST_PRACTICES,
    # 'gocritic-ptrToRefParam': IssueType.BEST_PRACTICES,
    # 'gocritic-redundantSprint': IssueType.BEST_PRACTICES,
    # 'gocritic-regexpMust': IssueType.BEST_PRACTICES,
    # 'gocritic-regexpSimplify': IssueType.COMPLEXITY,
    # 'gocritic-ruleguard': IssueType.BEST_PRACTICES,
    # 'gocritic-singleCaseSwitch': IssueType.BEST_PRACTICES,
    # 'gocritic-sloppyLen': IssueType.ERROR_PRONE,
    # 'gocritic-stringConcatSimplify': IssueType.COMPLEXITY,
    'gocritic-switchTrue': IssueType.BEST_PRACTICES,
    # 'gocritic-timeExprSimplify': IssueType.COMPLEXITY,
    # 'gocritic-timeCmpSimplify': IssueType.COMPLEXITY,
    # 'gocritic-tooManyResultsChecker': IssueType.COMPLEXITY,
    # 'gocritic-typeAssertChain': IssueType.COMPLEXITY,
    # 'gocritic-typeDefFirst': IssueType.BEST_PRACTICES,
    # 'gocritic-typeSwitchVar': IssueType.BEST_PRACTICES,
    # 'gocritic-typeUnparen': IssueType.CODE_STYLE,
    'gocritic-underef': IssueType.BEST_PRACTICES,
    # 'gocritic-unlabelStmt': IssueType.BEST_PRACTICES,
    'gocritic-unlambda': IssueType.COMPLEXITY,
    # 'gocritic-unnamedResult': IssueType.BEST_PRACTICES,
    # 'gocritic-unnecessaryBlock': IssueType.BEST_PRACTICES,
    'gocritic-unslice': IssueType.COMPLEXITY,
    'gocritic-valSwap': IssueType.BEST_PRACTICES,
    # 'gocritic-whyNoLint': IssueType.CODE_STYLE,
    # 'gocritic-wrapperFunc': IssueType.BEST_PRACTICES,
    # 'gocritic-yodaStyleExpr': IssueType.CODE_STYLE,
    # Performance group
    'gocritic-appendCombine': IssueType.BEST_PRACTICES,
    # 'gocritic-equalFold': IssueType.BEST_PRACTICES,
    # 'gocritic-hugeParam': IssueType.BEST_PRACTICES,
    # 'gocritic-indexAlloc': IssueType.BEST_PRACTICES,
    # 'gocritic-preferDecodeRune': IssueType.BEST_PRACTICES,
    # 'gocritic-preferFprint': IssueType.BEST_PRACTICES,
    # 'gocritic-preferStringWriter': IssueType.BEST_PRACTICES,
    # 'gocritic-preferWriteByte': IssueType.BEST_PRACTICES,
    # 'gocritic-rangeExprCopy': IssueType.BEST_PRACTICES,
    # 'gocritic-rangeValCopy': IssueType.BEST_PRACTICES,
    # 'gocritic-sliceClear': IssueType.BEST_PRACTICES,
    'gocritic-stringXbytes': IssueType.BEST_PRACTICES,
    # --------------
    # -- gosimple --
    # --------------
    'gosimple-S1006': IssueType.CODE_STYLE,
    'gosimple-S1007': IssueType.COMPLEXITY,
    'gosimple-S1008': IssueType.COMPLEXITY,
    'gosimple-S1021': IssueType.CODE_STYLE,
    'gosimple-S1040': IssueType.ERROR_PRONE,
    # ------------------
    # -- staticcheck --
    # ------------------
    'staticcheck-SA4021': IssueType.BEST_PRACTICES,
    'staticcheck-SA6000': IssueType.BEST_PRACTICES,
    # 'staticcheck-SA6001': IssueType.BEST_PRACTICES,
    'staticcheck-SA6002': IssueType.BEST_PRACTICES,
    # 'staticcheck-SA6003': IssueType.BEST_PRACTICES,
    'staticcheck-SA6005': IssueType.BEST_PRACTICES,
    # -----------
    # -- govet --
    # -----------
    'govet-composites': IssueType.BEST_PRACTICES,
    'govet-stdmethods': IssueType.BEST_PRACTICES,
    # ----------------
    # -- stylecheck --
    # ----------------
    # 'stylecheck-ST1001': IssueType.BEST_PRACTICES,
    # 'stylecheck-ST1013': IssueType.INFO,
    # 'stylecheck-ST1018': IssueType.ERROR_PRONE,
    # 'stylecheck-ST1019': IssueType.ERROR_PRONE,
}

CODE_PREFIX_TO_ISSUE_TYPE: Dict[str, IssueType] = {
    'gosimple': IssueType.BEST_PRACTICES,
    'staticcheck': IssueType.ERROR_PRONE,
    'govet': IssueType.ERROR_PRONE,
    'stylecheck': IssueType.CODE_STYLE,
}
