"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.IoTAnalyticsMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class IoTAnalyticsMetrics {
    static incomingMessagesSum(dimensions) {
        return {
            namespace: 'AWS/IoTAnalytics',
            metricName: 'IncomingMessages',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static actionExecutionSum(dimensions) {
        return {
            namespace: 'AWS/IoTAnalytics',
            metricName: 'ActionExecution',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static actionExecutionThrottledSum(dimensions) {
        return {
            namespace: 'AWS/IoTAnalytics',
            metricName: 'ActionExecutionThrottled',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static activityExecutionErrorSum(dimensions) {
        return {
            namespace: 'AWS/IoTAnalytics',
            metricName: 'ActivityExecutionError',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static pipelineConcurrentExecutionCountSum(dimensions) {
        return {
            namespace: 'AWS/IoTAnalytics',
            metricName: 'PipelineConcurrentExecutionCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.IoTAnalyticsMetrics = IoTAnalyticsMetrics;
//# sourceMappingURL=data:application/json;base64,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