"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcIngressConnection = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * The App Runner VPC Ingress Connection
 *
 * @resource AWS::AppRunner::VpcIngressConnection
 */
let VpcIngressConnection = class VpcIngressConnection extends cdk.Resource {
    /**
     * Import from VPC Ingress Connection from attributes.
     */
    static fromVpcIngressConnectionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcIngressConnectionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcIngressConnectionAttributes);
            }
            throw error;
        }
        const vpcIngressConnectionArn = attrs.vpcIngressConnectionArn;
        const domainName = attrs.domainName;
        const status = attrs.status;
        const vpcIngressConnectionName = attrs.vpcIngressConnectionName;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcIngressConnectionArn = vpcIngressConnectionArn;
                this.domainName = domainName;
                this.status = status;
                this.vpcIngressConnectionName = vpcIngressConnectionName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner VPC Ingress Connection from its ARN
     */
    static fromArn(scope, id, vpcIngressConnectionArn) {
        const resourceParts = cdk.Fn.split('/', vpcIngressConnectionArn);
        const vpcIngressConnectionName = cdk.Fn.select(0, resourceParts);
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcIngressConnectionName = vpcIngressConnectionName;
                this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcIngressConnectionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcIngressConnectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcIngressConnection);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.vpcIngressConnectionName !== undefined && !cdk.Token.isUnresolved(props.vpcIngressConnectionName)) {
            if (props.vpcIngressConnectionName.length < 4 || props.vpcIngressConnectionName.length > 40) {
                throw new cdk.ValidationError(`\`vpcIngressConnectionName\` must be between 4 and 40 characters, got: ${props.vpcIngressConnectionName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.vpcIngressConnectionName)) {
                throw new cdk.ValidationError(`\`vpcIngressConnectionName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.vpcIngressConnectionName}.`, this);
            }
        }
        const resource = new aws_apprunner_1.CfnVpcIngressConnection(this, 'Resource', {
            ingressVpcConfiguration: {
                vpcEndpointId: props.interfaceVpcEndpoint.vpcEndpointId,
                vpcId: props.vpc.vpcId,
            },
            serviceArn: props.service.serviceArn,
            vpcIngressConnectionName: this.physicalName,
        });
        this.vpcIngressConnectionArn = resource.attrVpcIngressConnectionArn;
        this.vpcIngressConnectionName = resource.ref;
        this.domainName = resource.attrDomainName;
        this.status = resource.attrStatus;
    }
};
exports.VpcIngressConnection = VpcIngressConnection;
_a = JSII_RTTI_SYMBOL_1;
VpcIngressConnection[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcIngressConnection", version: "2.210.0-alpha.0" };
/** Uniquely identifies this class. */
VpcIngressConnection.PROPERTY_INJECTION_ID = '@aws-cdk.aws-apprunner-alpha.VpcIngressConnection';
exports.VpcIngressConnection = VpcIngressConnection = __decorate([
    prop_injectable_1.propertyInjectable
], VpcIngressConnection);
//# sourceMappingURL=data:application/json;base64,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