"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcConnector = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * The App Runner VPC Connector
 *
 * @resource AWS::AppRunner::VpcConnector
 */
let VpcConnector = class VpcConnector extends cdk.Resource {
    /**
     * Import from VPC connector attributes.
     */
    static fromVpcConnectorAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcConnectorAttributes);
            }
            throw error;
        }
        const vpcConnectorArn = attrs.vpcConnectorArn;
        const vpcConnectorName = attrs.vpcConnectorName;
        const vpcConnectorRevision = attrs.vpcConnectorRevision;
        const securityGroups = attrs.securityGroups;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcConnectorArn = vpcConnectorArn;
                this.vpcConnectorName = vpcConnectorName;
                this.vpcConnectorRevision = vpcConnectorRevision;
                this.connections = new aws_ec2_1.Connections({ securityGroups });
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcConnectorName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcConnector);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.vpcConnectorName !== undefined && !cdk.Token.isUnresolved(props.vpcConnectorName)) {
            if (props.vpcConnectorName.length < 4 || props.vpcConnectorName.length > 40) {
                throw new cdk.ValidationError(`\`vpcConnectorName\` must be between 4 and 40 characters, got: ${props.vpcConnectorName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.vpcConnectorName)) {
                throw new cdk.ValidationError(`\`vpcConnectorName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.vpcConnectorName}.`, this);
            }
        }
        const securityGroups = props.securityGroups?.length ?
            props.securityGroups
            : [new ec2.SecurityGroup(this, 'SecurityGroup', { vpc: props.vpc })];
        const resource = new aws_apprunner_1.CfnVpcConnector(this, 'Resource', {
            subnets: props.vpc.selectSubnets(props.vpcSubnets).subnetIds,
            securityGroups: cdk.Lazy.list({ produce: () => this.connections.securityGroups.map(sg => sg.securityGroupId) }),
            vpcConnectorName: this.physicalName,
        });
        this.vpcConnectorArn = resource.attrVpcConnectorArn;
        this.vpcConnectorRevision = resource.attrVpcConnectorRevision;
        this.vpcConnectorName = resource.ref;
        this.connections = new aws_ec2_1.Connections({ securityGroups });
    }
};
exports.VpcConnector = VpcConnector;
_a = JSII_RTTI_SYMBOL_1;
VpcConnector[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcConnector", version: "2.210.0-alpha.0" };
/** Uniquely identifies this class. */
VpcConnector.PROPERTY_INJECTION_ID = '@aws-cdk.aws-apprunner-alpha.VpcConnector';
exports.VpcConnector = VpcConnector = __decorate([
    prop_injectable_1.propertyInjectable
], VpcConnector);
//# sourceMappingURL=data:application/json;base64,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