import * as cdk from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
/**
 * The implementation provider chosen for tracing App Runner services
 *
 * @see https://docs.aws.amazon.com/apprunner/latest/dg/monitor.html
 */
export declare enum TraceConfigurationVendor {
    /**
     * Tracing (X-Ray)
     */
    AWSXRAY = "AWSXRAY"
}
/**
 * Properties of the AppRunner Observability configuration
 */
export interface ObservabilityConfigurationProps {
    /**
     * The name for the ObservabilityConfiguration.
     *
     * @default - a name generated by CloudFormation
     */
    readonly observabilityConfigurationName?: string;
    /**
     * The implementation provider chosen for tracing App Runner services.
     */
    readonly traceConfigurationVendor: TraceConfigurationVendor;
}
/**
 * Attributes for the App Runner Observability configuration
 */
export interface ObservabilityConfigurationAttributes {
    /**
     * The name of the Observability configuration.
     */
    readonly observabilityConfigurationName: string;
    /**
     * The revision of the Observability configuration.
     */
    readonly observabilityConfigurationRevision: number;
}
/**
 * Represents the App Runner Observability configuration.
 */
export interface IObservabilityConfiguration extends cdk.IResource {
    /**
     * The Name of the Observability configuration.
     * @attribute
     */
    readonly observabilityConfigurationName: string;
    /**
     * The ARN of the Observability configuration.
     * @attribute
     */
    readonly observabilityConfigurationArn: string;
    /**
     * The revision of the Observability configuration.
     * @attribute
     */
    readonly observabilityConfigurationRevision: number;
}
/**
 * The App Runner Observability configuration
 *
 * @resource AWS::AppRunner::ObservabilityConfiguration
 */
export declare class ObservabilityConfiguration extends cdk.Resource implements IObservabilityConfiguration {
    /** Uniquely identifies this class. */
    static readonly PROPERTY_INJECTION_ID: string;
    /**
     * Imports an App Runner Observability Configuration from attributes.
     */
    static fromObservabilityConfigurationAttributes(scope: Construct, id: string, attrs: ObservabilityConfigurationAttributes): IObservabilityConfiguration;
    /**
     * Imports an App Runner Observability Configuration from its ARN
     */
    static fromArn(scope: Construct, id: string, observabilityConfigurationArn: string): IObservabilityConfiguration;
    /**
     * The ARN of the Observability configuration.
     * @attribute
     */
    readonly observabilityConfigurationArn: string;
    /**
     * The revision of the Observability configuration.
     * @attribute
     */
    readonly observabilityConfigurationRevision: number;
    /**
     * The name of the Observability configuration.
     * @attribute
     */
    readonly observabilityConfigurationName: string;
    constructor(scope: Construct, id: string, props: ObservabilityConfigurationProps);
}
