import * as cdk from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
/**
 * Properties of the App Runner Auto Scaling Configuration.
 */
export interface AutoScalingConfigurationProps {
    /**
     * The name for the Auto Scaling Configuration.
     *
     * @default - a name generated by CloudFormation
     */
    readonly autoScalingConfigurationName?: string;
    /**
     * The maximum number of concurrent requests that an instance processes.
     * If the number of concurrent requests exceeds this limit, App Runner scales the service up.
     *
     * Must be between 1 and 200.
     *
     * @default 100
     */
    readonly maxConcurrency?: number;
    /**
     * The maximum number of instances that a service scales up to.
     * At most maxSize instances actively serve traffic for your service.
     *
     * Must be between 1 and 25.
     *
     * @default 25
     */
    readonly maxSize?: number;
    /**
     * The minimum number of instances that App Runner provisions for a service.
     * The service always has at least minSize provisioned instances.
     *
     *
     * Must be between 1 and 25.
     *
     * @default 1
     */
    readonly minSize?: number;
}
/**
 * Attributes for the App Runner Auto Scaling Configuration.
 */
export interface AutoScalingConfigurationAttributes {
    /**
     * The name of the Auto Scaling Configuration.
     */
    readonly autoScalingConfigurationName: string;
    /**
     * The revision of the Auto Scaling Configuration.
     */
    readonly autoScalingConfigurationRevision: number;
}
/**
 * Represents the App Runner Auto Scaling Configuration.
 */
export interface IAutoScalingConfiguration extends cdk.IResource {
    /**
     * The ARN of the Auto Scaling Configuration.
     * @attribute
     */
    readonly autoScalingConfigurationArn: string;
    /**
     * The Name of the Auto Scaling Configuration.
     * @attribute
     */
    readonly autoScalingConfigurationName: string;
    /**
     * The revision of the Auto Scaling Configuration.
     * @attribute
     */
    readonly autoScalingConfigurationRevision: number;
}
/**
 * The App Runner Auto Scaling Configuration.
 *
 * @resource AWS::AppRunner::AutoScalingConfiguration
 */
export declare class AutoScalingConfiguration extends cdk.Resource implements IAutoScalingConfiguration {
    /** Uniquely identifies this class. */
    static readonly PROPERTY_INJECTION_ID: string;
    /**
     * Imports an App Runner Auto Scaling Configuration from attributes
     */
    static fromAutoScalingConfigurationAttributes(scope: Construct, id: string, attrs: AutoScalingConfigurationAttributes): IAutoScalingConfiguration;
    /**
     * Imports an App Runner Auto Scaling Configuration from its ARN
     */
    static fromArn(scope: Construct, id: string, autoScalingConfigurationArn: string): IAutoScalingConfiguration;
    /**
     * The ARN of the Auto Scaling Configuration.
     * @attribute
     */
    readonly autoScalingConfigurationArn: string;
    /**
     * The name of the Auto Scaling Configuration.
     * @attribute
     */
    readonly autoScalingConfigurationName: string;
    /**
     * The revision of the Auto Scaling Configuration.
     * @attribute
     */
    readonly autoScalingConfigurationRevision: number;
    constructor(scope: Construct, id: string, props?: AutoScalingConfigurationProps);
    private validateAutoScalingConfiguration;
}
