/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.ComplexArray;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.SetHolder;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.annotations.Property;

public class RichComplexArray
extends ComplexArray
implements SetHolder {
    @XmlTransient
    private DataType dataType = null;

    private RichComplexArray() {
    }

    public RichComplexArray(DataType dataType) {
        this.setDataType(dataType);
    }

    @Override
    public Set<?> getSet() {
        return (Set)this.getValue();
    }

    public RichComplexArray setValue(List<?> values) {
        throw new UnsupportedOperationException();
    }

    public RichComplexArray setValue(Set<?> values) {
        final DataType dataType = this.getDataType();
        Function<Object, Object> function = new Function<Object, Object>(){

            public Object apply(Object value) {
                return TypeUtil.parseOrCast(dataType, value);
            }
        };
        values = Sets.newHashSet((Iterable)Iterables.transform(values, (Function)function));
        return (RichComplexArray)super.setValue((Set)values);
    }

    public RichComplexArray setValue(@Property(value="value") Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType);
    }
}

