/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayDeque;
import java.util.Objects;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.SymbolTable;

public class FunctionNameStack
extends ArrayDeque<String>
implements SymbolTable<String> {
    private int capacity = 16;

    public FunctionNameStack() {
    }

    public FunctionNameStack(int capacity) {
        this.setCapacity(capacity);
    }

    public FunctionNameStack(FunctionNameStack parent) {
        super(parent);
        this.setCapacity(parent.getCapacity());
    }

    public FunctionNameStack fork() {
        return new FunctionNameStack(this);
    }

    @Override
    public void lock(String name) {
        int capacity = this.getCapacity();
        int size = this.size();
        if (size >= capacity) {
            throw new EvaluationException("Function call stack is too high");
        }
        this.push(name);
    }

    @Override
    public void release(String name) {
        String tail = (String)this.pop();
        if (!Objects.equals(name, tail)) {
            throw new IllegalStateException();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    private void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }
}

