/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.tree.Node;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Vote;
import org.jpmml.evaluator.tree.HasDecisionPath;
import org.jpmml.model.ToStringHelper;

public abstract class NodeVote
extends Vote
implements HasEntityRegistry<Node>,
HasDecisionPath {
    private Node node = null;

    NodeVote(Node node) {
        this.setNode(Objects.requireNonNull(node));
    }

    @Override
    protected void computeResult(DataType dataType) {
        Node node = this.getNode();
        Object result = TypeUtil.parseOrCast(dataType, node.getScore());
        this.setResult(result);
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = super.toStringHelper().add("entityId", (Object)this.getEntityId());
        return helper;
    }

    @Override
    public String getEntityId() {
        Node node = this.getNode();
        return EntityUtil.getId(node, this);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private void setNode(Node node) {
        this.node = node;
    }
}

