# Generated by Django 2.2.10 on 2020-02-29 15:12

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sessions', '0001_initial'),
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='AriesUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('first_name', models.CharField(blank=True, max_length=80)),
                ('last_name', models.CharField(blank=True, max_length=150)),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into the admin site.')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now)),
                ('last_login', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AgentConnection',
            fields=[
                ('guid', models.CharField(max_length=80, primary_key=True, serialize=False)),
                ('partner_name', models.CharField(max_length=200)),
                ('invitation', models.TextField(blank=True, max_length=4000)),
                ('status', models.CharField(blank=True, max_length=80)),
            ],
        ),
        migrations.CreateModel(
            name='AriesAgent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('agent_name', models.CharField(max_length=200, unique=True)),
                ('api_key', models.CharField(max_length=40, unique=True)),
                ('callback_key', models.CharField(max_length=40, unique=True)),
                ('agent_config', models.TextField(blank=True, max_length=4000, null=True)),
                ('agent_admin_port', models.IntegerField(null=True)),
                ('agent_http_port', models.IntegerField(null=True)),
                ('public_endpoint', models.CharField(blank=True, max_length=200, null=True)),
                ('admin_endpoint', models.CharField(blank=True, max_length=200, null=True)),
                ('managed_agent', models.BooleanField(default=False)),
                ('mobile_agent', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='AriesOrganization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('org_name', models.CharField(max_length=60, unique=True)),
                ('ico_url', models.CharField(blank=True, max_length=120, null=True)),
                ('managed_agent', models.BooleanField(default=True)),
                ('agent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='agent_org', to='aries_community.AriesAgent', to_field='agent_name')),
            ],
        ),
        migrations.CreateModel(
            name='AriesOrgRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='IndyProofRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('proof_req_name', models.CharField(max_length=400, unique=True)),
                ('proof_req_description', models.TextField(max_length=4000)),
                ('proof_req_attrs', models.TextField(max_length=4000)),
                ('proof_req_predicates', models.TextField(blank=True, max_length=4000)),
            ],
        ),
        migrations.CreateModel(
            name='IndySchema',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ledger_schema_id', models.CharField(max_length=80, unique=True)),
                ('schema_name', models.CharField(max_length=80)),
                ('schema_version', models.CharField(max_length=80)),
                ('schema', models.TextField(max_length=4000)),
                ('schema_template', models.TextField(max_length=4000)),
                ('schema_data', models.TextField(max_length=4000)),
                ('roles', models.ManyToManyField(to='aries_community.AriesOrgRole')),
            ],
        ),
        migrations.CreateModel(
            name='IndyCredentialDefinition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ledger_creddef_id', models.CharField(max_length=80, unique=True)),
                ('creddef_name', models.CharField(max_length=80)),
                ('creddef_handle', models.CharField(max_length=80)),
                ('creddef_template', models.TextField(max_length=4000)),
                ('creddef_data', models.TextField(max_length=4000)),
                ('agent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='indycreddef_set', to='aries_community.AriesAgent', to_field='agent_name')),
                ('ledger_schema', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='aries_community.IndySchema')),
            ],
        ),
        migrations.CreateModel(
            name='AriesSession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('agent_name', models.CharField(blank=True, max_length=60, null=True)),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sessions.Session')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='AriesOrgRelationship',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('org', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ariesrelationship_set', to='aries_community.AriesOrganization')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ariesrelationship_set', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='ariesorganization',
            name='role',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='aries_community.AriesOrgRole'),
        ),
        migrations.CreateModel(
            name='AgentInvitation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('partner_name', models.CharField(max_length=200)),
                ('invitation', models.TextField(blank=True, max_length=4000)),
                ('connecion_guid', models.CharField(blank=True, max_length=80)),
                ('agent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='aries_community.AriesAgent', to_field='agent_name')),
            ],
        ),
        migrations.CreateModel(
            name='AgentConversation',
            fields=[
                ('guid', models.CharField(max_length=80, primary_key=True, serialize=False)),
                ('conversation_type', models.CharField(max_length=30)),
                ('connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='aries_community.AgentConnection')),
            ],
        ),
        migrations.AddField(
            model_name='agentconnection',
            name='agent',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='aries_community.AriesAgent', to_field='agent_name'),
        ),
        migrations.AddField(
            model_name='ariesuser',
            name='agent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='agent_user', to='aries_community.AriesAgent', to_field='agent_name'),
        ),
        migrations.AddField(
            model_name='ariesuser',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='ariesuser',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
    ]
