"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeadersReferrerPolicy = exports.HeadersFrameOption = exports.ResponseHeadersPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cloudfront_generated_1 = require("./cloudfront.generated");
/**
 * A Response Headers Policy configuration
 *
 * @resource AWS::CloudFront::ResponseHeadersPolicy
 */
class ResponseHeadersPolicy extends core_1.Resource {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id, {
            physicalName: props.responseHeadersPolicyName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_ResponseHeadersPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const responseHeadersPolicyName = (_b = props.responseHeadersPolicyName) !== null && _b !== void 0 ? _b : core_1.Names.uniqueId(this);
        const resource = new cloudfront_generated_1.CfnResponseHeadersPolicy(this, 'Resource', {
            responseHeadersPolicyConfig: {
                name: responseHeadersPolicyName,
                comment: props.comment,
                corsConfig: props.corsBehavior ? this._renderCorsConfig(props.corsBehavior) : undefined,
                customHeadersConfig: props.customHeadersBehavior ? this._renderCustomHeadersConfig(props.customHeadersBehavior) : undefined,
                securityHeadersConfig: props.securityHeadersBehavior ? this._renderSecurityHeadersConfig(props.securityHeadersBehavior) : undefined,
            },
        });
        this.responseHeadersPolicyId = resource.ref;
    }
    /**
     * Import an existing Response Headers Policy from its ID.
     */
    static fromResponseHeadersPolicyId(scope, id, responseHeadersPolicyId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.responseHeadersPolicyId = responseHeadersPolicyId;
            }
        }
        return new Import(scope, id);
    }
    static fromManagedResponseHeadersPolicy(managedResponseHeadersPolicyId) {
        return new class {
            constructor() {
                this.responseHeadersPolicyId = managedResponseHeadersPolicyId;
            }
        };
    }
    _renderCorsConfig(behavior) {
        return {
            accessControlAllowCredentials: behavior.accessControlAllowCredentials,
            accessControlAllowHeaders: { items: behavior.accessControlAllowHeaders },
            accessControlAllowMethods: { items: behavior.accessControlAllowMethods },
            accessControlAllowOrigins: { items: behavior.accessControlAllowOrigins },
            accessControlExposeHeaders: behavior.accessControlExposeHeaders ? { items: behavior.accessControlExposeHeaders } : undefined,
            accessControlMaxAgeSec: behavior.accessControlMaxAge ? behavior.accessControlMaxAge.toSeconds() : undefined,
            originOverride: behavior.originOverride,
        };
    }
    _renderCustomHeadersConfig(behavior) {
        return {
            items: behavior.customHeaders,
        };
    }
    _renderSecurityHeadersConfig(behavior) {
        return {
            contentSecurityPolicy: behavior.contentSecurityPolicy,
            contentTypeOptions: behavior.contentTypeOptions,
            frameOptions: behavior.frameOptions,
            referrerPolicy: behavior.referrerPolicy,
            strictTransportSecurity: behavior.strictTransportSecurity ? {
                ...behavior.strictTransportSecurity,
                accessControlMaxAgeSec: behavior.strictTransportSecurity.accessControlMaxAge.toSeconds(),
            } : undefined,
            xssProtection: behavior.xssProtection,
        };
    }
}
exports.ResponseHeadersPolicy = ResponseHeadersPolicy;
_a = JSII_RTTI_SYMBOL_1;
ResponseHeadersPolicy[_a] = { fqn: "@aws-cdk/aws-cloudfront.ResponseHeadersPolicy", version: "1.157.0" };
/** Use this managed policy to allow simple CORS requests from any origin. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('60669652-455b-4ae9-85a4-c4c02393f86c');
/** Use this managed policy to allow CORS requests from any origin, including preflight requests. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('5cc3b908-e619-4b99-88e5-2cf7f45965bd');
/** Use this managed policy to add a set of security headers to all responses that CloudFront sends to viewers. */
ResponseHeadersPolicy.SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('67f7725c-6f97-4210-82d7-5512b31e9d03');
/** Use this managed policy to allow simple CORS requests from any origin and add a set of security headers to all responses that CloudFront sends to viewers. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_AND_SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('e61eb60c-9c35-4d20-a928-2b84e02af89c');
/** Use this managed policy to allow CORS requests from any origin, including preflight requests, and add a set of security headers to all responses that CloudFront sends to viewers. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT_AND_SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('eaab4381-ed33-4a86-88ca-d9558dc6cd63');
/**
 * Enum representing possible values of the X-Frame-Options HTTP response header.
 */
var HeadersFrameOption;
(function (HeadersFrameOption) {
    /**
     * The page can only be displayed in a frame on the same origin as the page itself.
     */
    HeadersFrameOption["DENY"] = "DENY";
    /**
     * The page can only be displayed in a frame on the specified origin.
     */
    HeadersFrameOption["SAMEORIGIN"] = "SAMEORIGIN";
})(HeadersFrameOption = exports.HeadersFrameOption || (exports.HeadersFrameOption = {}));
/**
 * Enum representing possible values of the Referrer-Policy HTTP response header.
 */
var HeadersReferrerPolicy;
(function (HeadersReferrerPolicy) {
    /**
     * The referrer policy is not set.
     */
    HeadersReferrerPolicy["NO_REFERRER"] = "no-referrer";
    /**
     * The referrer policy is no-referrer-when-downgrade.
     */
    HeadersReferrerPolicy["NO_REFERRER_WHEN_DOWNGRADE"] = "no-referrer-when-downgrade";
    /**
     * The referrer policy is origin.
     */
    HeadersReferrerPolicy["ORIGIN"] = "origin";
    /**
     * The referrer policy is origin-when-cross-origin.
     */
    HeadersReferrerPolicy["ORIGIN_WHEN_CROSS_ORIGIN"] = "origin-when-cross-origin";
    /**
     * The referrer policy is same-origin.
     */
    HeadersReferrerPolicy["SAME_ORIGIN"] = "same-origin";
    /**
     * The referrer policy is strict-origin.
     */
    HeadersReferrerPolicy["STRICT_ORIGIN"] = "strict-origin";
    /**
     * The referrer policy is strict-origin-when-cross-origin.
     */
    HeadersReferrerPolicy["STRICT_ORIGIN_WHEN_CROSS_ORIGIN"] = "strict-origin-when-cross-origin";
    /**
     * The referrer policy is unsafe-url.
     */
    HeadersReferrerPolicy["UNSAFE_URL"] = "unsafe-url";
})(HeadersReferrerPolicy = exports.HeadersReferrerPolicy || (exports.HeadersReferrerPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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