import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::LookoutMetrics::Alert`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html
 */
export interface CfnAlertProps {
    /**
     * `AWS::LookoutMetrics::Alert.Action`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-action
     */
    readonly action: CfnAlert.ActionProperty | cdk.IResolvable;
    /**
     * `AWS::LookoutMetrics::Alert.AlertSensitivityThreshold`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-alertsensitivitythreshold
     */
    readonly alertSensitivityThreshold: number;
    /**
     * `AWS::LookoutMetrics::Alert.AnomalyDetectorArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-anomalydetectorarn
     */
    readonly anomalyDetectorArn: string;
    /**
     * `AWS::LookoutMetrics::Alert.AlertDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-alertdescription
     */
    readonly alertDescription?: string;
    /**
     * `AWS::LookoutMetrics::Alert.AlertName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-alertname
     */
    readonly alertName?: string;
}
/**
 * A CloudFormation `AWS::LookoutMetrics::Alert`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::Alert
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html
 */
export declare class CfnAlert extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LookoutMetrics::Alert";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAlert;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::LookoutMetrics::Alert.Action`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-action
     */
    action: CfnAlert.ActionProperty | cdk.IResolvable;
    /**
     * `AWS::LookoutMetrics::Alert.AlertSensitivityThreshold`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-alertsensitivitythreshold
     */
    alertSensitivityThreshold: number;
    /**
     * `AWS::LookoutMetrics::Alert.AnomalyDetectorArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-anomalydetectorarn
     */
    anomalyDetectorArn: string;
    /**
     * `AWS::LookoutMetrics::Alert.AlertDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-alertdescription
     */
    alertDescription: string | undefined;
    /**
     * `AWS::LookoutMetrics::Alert.AlertName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html#cfn-lookoutmetrics-alert-alertname
     */
    alertName: string | undefined;
    /**
     * Create a new `AWS::LookoutMetrics::Alert`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAlertProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::LookoutMetrics::Alert`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::Alert
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html
 */
export declare namespace CfnAlert {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-action.html
     */
    interface ActionProperty {
        /**
         * `CfnAlert.ActionProperty.LambdaConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-action.html#cfn-lookoutmetrics-alert-action-lambdaconfiguration
         */
        readonly lambdaConfiguration?: CfnAlert.LambdaConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnAlert.ActionProperty.SNSConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-action.html#cfn-lookoutmetrics-alert-action-snsconfiguration
         */
        readonly snsConfiguration?: CfnAlert.SNSConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::Alert`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::Alert
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html
 */
export declare namespace CfnAlert {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-lambdaconfiguration.html
     */
    interface LambdaConfigurationProperty {
        /**
         * `CfnAlert.LambdaConfigurationProperty.LambdaArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-lambdaconfiguration.html#cfn-lookoutmetrics-alert-lambdaconfiguration-lambdaarn
         */
        readonly lambdaArn: string;
        /**
         * `CfnAlert.LambdaConfigurationProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-lambdaconfiguration.html#cfn-lookoutmetrics-alert-lambdaconfiguration-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::Alert`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::Alert
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-alert.html
 */
export declare namespace CfnAlert {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-snsconfiguration.html
     */
    interface SNSConfigurationProperty {
        /**
         * `CfnAlert.SNSConfigurationProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-snsconfiguration.html#cfn-lookoutmetrics-alert-snsconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnAlert.SNSConfigurationProperty.SnsTopicArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-alert-snsconfiguration.html#cfn-lookoutmetrics-alert-snsconfiguration-snstopicarn
         */
        readonly snsTopicArn: string;
    }
}
/**
 * Properties for defining a `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export interface CfnAnomalyDetectorProps {
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.AnomalyDetectorConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig
     */
    readonly anomalyDetectorConfig: CfnAnomalyDetector.AnomalyDetectorConfigProperty | cdk.IResolvable;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.MetricSetList`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-metricsetlist
     */
    readonly metricSetList: Array<CfnAnomalyDetector.MetricSetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.AnomalyDetectorDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectordescription
     */
    readonly anomalyDetectorDescription?: string;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.AnomalyDetectorName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorname
     */
    readonly anomalyDetectorName?: string;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.KmsKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-kmskeyarn
     */
    readonly kmsKeyArn?: string;
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare class CfnAnomalyDetector extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LookoutMetrics::AnomalyDetector";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAnomalyDetector;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.AnomalyDetectorConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig
     */
    anomalyDetectorConfig: CfnAnomalyDetector.AnomalyDetectorConfigProperty | cdk.IResolvable;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.MetricSetList`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-metricsetlist
     */
    metricSetList: Array<CfnAnomalyDetector.MetricSetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.AnomalyDetectorDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectordescription
     */
    anomalyDetectorDescription: string | undefined;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.AnomalyDetectorName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorname
     */
    anomalyDetectorName: string | undefined;
    /**
     * `AWS::LookoutMetrics::AnomalyDetector.KmsKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-kmskeyarn
     */
    kmsKeyArn: string | undefined;
    /**
     * Create a new `AWS::LookoutMetrics::AnomalyDetector`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnomalyDetectorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-anomalydetectorconfig.html
     */
    interface AnomalyDetectorConfigProperty {
        /**
         * `CfnAnomalyDetector.AnomalyDetectorConfigProperty.AnomalyDetectorFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-anomalydetectorconfig.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig-anomalydetectorfrequency
         */
        readonly anomalyDetectorFrequency: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html
     */
    interface AppFlowConfigProperty {
        /**
         * `CfnAnomalyDetector.AppFlowConfigProperty.FlowName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html#cfn-lookoutmetrics-anomalydetector-appflowconfig-flowname
         */
        readonly flowName: string;
        /**
         * `CfnAnomalyDetector.AppFlowConfigProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html#cfn-lookoutmetrics-anomalydetector-appflowconfig-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-cloudwatchconfig.html
     */
    interface CloudwatchConfigProperty {
        /**
         * `CfnAnomalyDetector.CloudwatchConfigProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-cloudwatchconfig.html#cfn-lookoutmetrics-anomalydetector-cloudwatchconfig-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html
     */
    interface CsvFormatDescriptorProperty {
        /**
         * `CfnAnomalyDetector.CsvFormatDescriptorProperty.Charset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-charset
         */
        readonly charset?: string;
        /**
         * `CfnAnomalyDetector.CsvFormatDescriptorProperty.ContainsHeader`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-containsheader
         */
        readonly containsHeader?: boolean | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.CsvFormatDescriptorProperty.Delimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-delimiter
         */
        readonly delimiter?: string;
        /**
         * `CfnAnomalyDetector.CsvFormatDescriptorProperty.FileCompression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-filecompression
         */
        readonly fileCompression?: string;
        /**
         * `CfnAnomalyDetector.CsvFormatDescriptorProperty.HeaderList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-headerlist
         */
        readonly headerList?: string[];
        /**
         * `CfnAnomalyDetector.CsvFormatDescriptorProperty.QuoteSymbol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-quotesymbol
         */
        readonly quoteSymbol?: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html
     */
    interface FileFormatDescriptorProperty {
        /**
         * `CfnAnomalyDetector.FileFormatDescriptorProperty.CsvFormatDescriptor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-fileformatdescriptor-csvformatdescriptor
         */
        readonly csvFormatDescriptor?: CfnAnomalyDetector.CsvFormatDescriptorProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.FileFormatDescriptorProperty.JsonFormatDescriptor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-fileformatdescriptor-jsonformatdescriptor
         */
        readonly jsonFormatDescriptor?: CfnAnomalyDetector.JsonFormatDescriptorProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html
     */
    interface JsonFormatDescriptorProperty {
        /**
         * `CfnAnomalyDetector.JsonFormatDescriptorProperty.Charset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-jsonformatdescriptor-charset
         */
        readonly charset?: string;
        /**
         * `CfnAnomalyDetector.JsonFormatDescriptorProperty.FileCompression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-jsonformatdescriptor-filecompression
         */
        readonly fileCompression?: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html
     */
    interface MetricProperty {
        /**
         * `CfnAnomalyDetector.MetricProperty.AggregationFunction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-aggregationfunction
         */
        readonly aggregationFunction: string;
        /**
         * `CfnAnomalyDetector.MetricProperty.MetricName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-metricname
         */
        readonly metricName: string;
        /**
         * `CfnAnomalyDetector.MetricProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-namespace
         */
        readonly namespace?: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html
     */
    interface MetricSetProperty {
        /**
         * `CfnAnomalyDetector.MetricSetProperty.DimensionList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-dimensionlist
         */
        readonly dimensionList?: string[];
        /**
         * `CfnAnomalyDetector.MetricSetProperty.MetricList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metriclist
         */
        readonly metricList: Array<CfnAnomalyDetector.MetricProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.MetricSetProperty.MetricSetDescription`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetdescription
         */
        readonly metricSetDescription?: string;
        /**
         * `CfnAnomalyDetector.MetricSetProperty.MetricSetFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetfrequency
         */
        readonly metricSetFrequency?: string;
        /**
         * `CfnAnomalyDetector.MetricSetProperty.MetricSetName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetname
         */
        readonly metricSetName: string;
        /**
         * `CfnAnomalyDetector.MetricSetProperty.MetricSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsource
         */
        readonly metricSource: CfnAnomalyDetector.MetricSourceProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.MetricSetProperty.Offset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-offset
         */
        readonly offset?: number;
        /**
         * `CfnAnomalyDetector.MetricSetProperty.TimestampColumn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-timestampcolumn
         */
        readonly timestampColumn?: CfnAnomalyDetector.TimestampColumnProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.MetricSetProperty.Timezone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-timezone
         */
        readonly timezone?: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html
     */
    interface MetricSourceProperty {
        /**
         * `CfnAnomalyDetector.MetricSourceProperty.AppFlowConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-appflowconfig
         */
        readonly appFlowConfig?: CfnAnomalyDetector.AppFlowConfigProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.MetricSourceProperty.CloudwatchConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-cloudwatchconfig
         */
        readonly cloudwatchConfig?: CfnAnomalyDetector.CloudwatchConfigProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.MetricSourceProperty.RDSSourceConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-rdssourceconfig
         */
        readonly rdsSourceConfig?: CfnAnomalyDetector.RDSSourceConfigProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.MetricSourceProperty.RedshiftSourceConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-redshiftsourceconfig
         */
        readonly redshiftSourceConfig?: CfnAnomalyDetector.RedshiftSourceConfigProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.MetricSourceProperty.S3SourceConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-s3sourceconfig
         */
        readonly s3SourceConfig?: CfnAnomalyDetector.S3SourceConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html
     */
    interface RDSSourceConfigProperty {
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.DBInstanceIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-dbinstanceidentifier
         */
        readonly dbInstanceIdentifier: string;
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.DatabaseHost`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasehost
         */
        readonly databaseHost: string;
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasename
         */
        readonly databaseName: string;
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.DatabasePort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databaseport
         */
        readonly databasePort: number;
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.SecretManagerArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-secretmanagerarn
         */
        readonly secretManagerArn: string;
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-tablename
         */
        readonly tableName: string;
        /**
         * `CfnAnomalyDetector.RDSSourceConfigProperty.VpcConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-vpcconfiguration
         */
        readonly vpcConfiguration: CfnAnomalyDetector.VpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html
     */
    interface RedshiftSourceConfigProperty {
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.ClusterIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-clusteridentifier
         */
        readonly clusterIdentifier: string;
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.DatabaseHost`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databasehost
         */
        readonly databaseHost: string;
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databasename
         */
        readonly databaseName: string;
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.DatabasePort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databaseport
         */
        readonly databasePort: number;
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.SecretManagerArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-secretmanagerarn
         */
        readonly secretManagerArn: string;
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-tablename
         */
        readonly tableName: string;
        /**
         * `CfnAnomalyDetector.RedshiftSourceConfigProperty.VpcConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-vpcconfiguration
         */
        readonly vpcConfiguration: CfnAnomalyDetector.VpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html
     */
    interface S3SourceConfigProperty {
        /**
         * `CfnAnomalyDetector.S3SourceConfigProperty.FileFormatDescriptor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-fileformatdescriptor
         */
        readonly fileFormatDescriptor: CfnAnomalyDetector.FileFormatDescriptorProperty | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.S3SourceConfigProperty.HistoricalDataPathList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-historicaldatapathlist
         */
        readonly historicalDataPathList?: string[];
        /**
         * `CfnAnomalyDetector.S3SourceConfigProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnAnomalyDetector.S3SourceConfigProperty.TemplatedPathList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-templatedpathlist
         */
        readonly templatedPathList?: string[];
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html
     */
    interface TimestampColumnProperty {
        /**
         * `CfnAnomalyDetector.TimestampColumnProperty.ColumnFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html#cfn-lookoutmetrics-anomalydetector-timestampcolumn-columnformat
         */
        readonly columnFormat?: string;
        /**
         * `CfnAnomalyDetector.TimestampColumnProperty.ColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html#cfn-lookoutmetrics-anomalydetector-timestampcolumn-columnname
         */
        readonly columnName?: string;
    }
}
/**
 * A CloudFormation `AWS::LookoutMetrics::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::LookoutMetrics::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html
     */
    interface VpcConfigurationProperty {
        /**
         * `CfnAnomalyDetector.VpcConfigurationProperty.SecurityGroupIdList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html#cfn-lookoutmetrics-anomalydetector-vpcconfiguration-securitygroupidlist
         */
        readonly securityGroupIdList: string[];
        /**
         * `CfnAnomalyDetector.VpcConfigurationProperty.SubnetIdList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html#cfn-lookoutmetrics-anomalydetector-vpcconfiguration-subnetidlist
         */
        readonly subnetIdList: string[];
    }
}
