# This file is automatically generated by r3build.internal.defconv. DO NOT EDIT.

from typing import Dict, List, Union
from r3build.config_validator import AccessValidator


class Log(AccessValidator):
    _slots = {
        "accepted_events",
        "all",
        "ignored_events",
        "job_output",
        "launched_events",
        "result",
        "time",
    }
    _required = set()
    all: bool = False
    accepted_events: bool = False
    ignored_events: bool = False
    launched_events: bool = True
    job_output: bool = True
    result: bool = True
    time: bool = True


class Event(AccessValidator):
    _slots = {"ignore_events_while_run", "rate_limit_duration"}
    _required = set()
    rate_limit_duration: float = 0.01
    ignore_events_while_run: bool = True


class Processor(AccessValidator):
    _slots = {
        "glob",
        "glob_exclude",
        "name",
        "path",
        "regex",
        "regex_exclude",
        "type",
        "when",
    }
    _required = {"type"}
    type: str = ""
    name: str = "noname"
    when: Union[List[str], str] = ""
    path: str = "."
    glob: Union[List[str], str] = ""
    glob_exclude: Union[List[str], str] = ""
    regex: Union[List[str], str] = ""
    regex_exclude: Union[List[str], str] = ""


class MakeProcessorConfig(Processor):
    _slots = Processor._slots.union({"directory", "environment", "jobs", "target"})
    _required = Processor._required.union(set())
    target: str = ""
    environment: Dict[str, str] = ""
    jobs: int = 0
    directory: str = ""


class CommandProcessorConfig(Processor):
    _slots = Processor._slots.union({"command", "environment"})
    _required = Processor._required.union({"command"})
    command: str = ""
    environment: Dict[str, str] = ""


class DaemonProcessorConfig(Processor):
    _slots = Processor._slots.union(
        {"command", "environment", "signal", "stderr", "stdout", "timeout"}
    )
    _required = Processor._required.union({"command"})
    command: str = ""
    signal: Union[int, str] = "SIGINT"
    timeout: int = 10
    stdout: bool = True
    stderr: bool = True
    environment: Dict[str, str] = ""


class PytestProcessorConfig(Processor):
    _slots = Processor._slots.union({"target"})
    _required = Processor._required.union({"target"})
    target: str = ""


class InternaltestProcessorConfig(Processor):
    _slots = Processor._slots.union({})
    _required = Processor._required.union(set())


processors = {
    "make": MakeProcessorConfig,
    "command": CommandProcessorConfig,
    "daemon": DaemonProcessorConfig,
    "pytest": PytestProcessorConfig,
    "internaltest": InternaltestProcessorConfig,
}
