<p align="center">
    <img src="https://banners.beyondco.de/Masonite%20OAuth2.png?theme=light&packageManager=pip+install&packageName=masonite-oauth2&pattern=topography&style=style_1&description=Social%20authentication%20for%20your%20apps%20(OAuth%202)&md=1&showWatermark=1&fontSize=100px&images=https%3A%2F%2Fgblobscdn.gitbook.com%2Fspaces%2F-L9uc-9XAlqhXkBwrLMA%2Favatar.png">
</p>
<p align="center">
  <a href="https://docs.masoniteproject.com">
    <img alt="Masonite Package" src="https://img.shields.io/static/v1?label=Masonite&message=package&labelColor=grey&color=blue&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAYAAAAfSC3RAAAAAXNSR0IArs4c6QAAAIRlWElmTU0AKgAAAAgABQESAAMAAAABAAEAAAEaAAUAAAABAAAASgEbAAUAAAABAAAAUgEoAAMAAAABAAIAAIdpAAQAAAABAAAAWgAAAAAAAABIAAAAAQAAAEgAAAABAAOgAQADAAAAAQABAACgAgAEAAAAAQAAAA6gAwAEAAAAAQAAAA4AAAAATspU+QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KTMInWQAAAnxJREFUKBVNUl1IVEEUPjPObdd1VdxWM0rMIl3bzbVWLSofVm3th0AhMakHHyqRiNSHEAq5b2HSVvoQRUiEECQUQkkPbRslRGigG8auoon2oPSjpev+3PWeZq7eaC5nDt93vplz5txDQJYpNxX4st4JFiwj9aCqmswUFQNS/A2YskrZJPYefkECC2GhQwAqvLYybwXrwBvq8HSNOXRO92+aH7nW8vc/wS2Z9TqneYt2KHjlf9Iv+43wFJMExzO0YE5OKe60N+AOW6OmE+WJTBrg23jjzWxMBauOlfyycsV24F+cH+zAXYUOGl+DaiDxfl245/W9OnVrSY+O2eqPkyz4sVvHoKp9gOihf5KoAVv3hkQgbj/ihG9fI3RixKcUVx7lJVaEc0vnyf2FFll+ny80ZHZiGhIKowWJBCEAKr+FSuNDLt+lxybSF51lo74arqs113dOZqwsptxNs5bwi7Q3q8npSC2AWmvjTncZf1l61e5DEizNn5mtufpsqk5+CZTuq00sP1wkNPv8jeEikVVlJso+GEwRtNs3QeBt2YP2V2ZI3Tx0e+7T89zK5tNASOLEytJAryGtkLc2PcBM5byyUWYkMQpMioYcDcchC6xN220Iv36Ot8pV0454RHLEwmmD7UWfIdX0zq3GjMPG5NKBtv5qiPEPekK2U51j1451BZoc3i+1ohSQ/UzzG5uYFFn2mwVUnO4O3JblXA91T51l3pB3QweDl7sNXMyEjbguSjrPcQNmwDkNc8CbCvDd0+xCC7RFi9wFulD3mJeXqxQevB4prrqgc0TmQ85NG/K43e2UwnMVAJIEBNfWRYR3HfnvivrIzMyo4Hgy+hfscvLo53jItAAAAABJRU5ErkJggg==">
  </a>
  <img alt="GitHub Workflow Status" src="https://img.shields.io/github/workflow/status/girardinsamuel/masonite-oauth/Test%20Application">
  <img src="https://codecov.io/gh/girardinsamuel/masonite-oauth/branch/main/graph/badge.svg?token=H2JOM785OQ"/>
  <!-- <img alt="PyPI" src="https://img.shields.io/pypi/v/masonite-oauth"> -->
  <img src="https://img.shields.io/badge/python-3.6+-blue.svg" alt="Python Version">
  <img alt="GitHub release (latest by date including pre-releases)" src="https://img.shields.io/github/v/release/girardinsamuel/masonite-oauth?include_prereleases">
  <img alt="License" src="https://img.shields.io/github/license/girardinsamuel/masonite-oauth">
  <a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>
</p>

## Introduction

Social authentication for your Masonite app (OAuth 2).

## Features

- Officially supports GitHub, GitLab, BitBucket, Google, Apple and Facebook providers

## Official Masonite Documentation

New to Masonite ? Please first read the [Official Documentation](https://docs.masoniteproject.com/).
Masonite strives to have extremely comprehensive documentation 😃. It would be wise to go through the tutorials there.
If you find any discrepencies or anything that doesn't make sense, be sure to comment directly on the documentation to start a discussion!

Also be sure to join the [Slack channel](http://slack.masoniteproject.com/)!

## Installation

```bash
pip install masonite-oauth2
```

## Configuration

Add OauthProvider to your project in `config/providers.py`:

```python
# config/providers.py
# ...
from masonite.oauth import OAuthProvider

# ...
PROVIDERS = [
    # ...
    # Third Party Providers
    OAuthProvider,
    # ...
]
```

Then you can publish the configuration file to your project:

```bash
python craft package:publish oauth
```

Finally you will need to add credentials for the OAuth providers your application utilizes.

```python
# config/oauth.py
DRIVERS = {
  "github": {
    "client_id": env("GITHUB_CLIENT_ID"),
    "client_secret": env("GITHUB_CLIENT_SECRET"),
    "redirect": "auth.callback",
  }
}
```

`redirect` can be a route name or a path.

## Usage

To authenticate users using an OAuth provider, you will need two routes: one for redirecting the user to the OAuth provider, and another for receiving the callback from the provider after authentication.

In your controller, you can then easily access `OAuth` facade methods:

- `redirect()` is redirecting to the OAuth endpoint provider
- `user()` is the route callback the user will be redirected to after entering its credentials through the OAuth provider screen. This method is returning a `OAuthUser` instance containing user informations.

```python
from masonite.oauth import OAuth

class YourController(Controller):

    def auth(self):
        return OAuth.driver("github").redirect()

    def callback(self):
        user = OAuth.driver("github").user()
        # you now have a user object with data and a token
```

### Get user data

When retrieving user data with `user()` method, you will get a `OAuthUser` with the following
fields:

- id
- name
- nickname
- email
- avatar
- token

### Get user data from a token

If you already have a valid access token for a user, you can retrieve user data using `user_from_token()`:

```python
user = OAuth.driver("github").user_from_token(token)
```

### Scopes

OAuth providers have default scopes used when redirecting to OAuth provider screen:

- GitHub: `user:email`
- BitBucket: `email`
- Gitlab: `read_user`
- Google: `openid`, `profile`, `email`
- Apple: `name`, `email`
- Facebook: `email`

You can add new scopes in the redirect request by using `scopes()` method (merged with default scopes):

```python
user = OAuth.driver("github").scopes(["admin:org", "read:discussion"]).redirect()
# scopes will be: user:email, admin:org, read:discussion
```

You can override all scopes in the redirect request by using `set_scopes()`method:

```python
user = OAuth.driver("github").set_scopes(["user:email", "user:follow"]).redirect()
# scopes will be: user:email, user:follow
```

### Optional parameters

Some OAuth providers support optional parameters. To include those in the redirect request, you can use `with_data()` method.

```python
return OAuth.driver("github").with_data({"key": "value"})
```

## Contributing

Please read the [Contributing Documentation](CONTRIBUTING.md) here.
Feel free to open a PR to add a new OAuth 2.0 provider 😀 !

## Maintainers

- [Samuel Girardin](https://www.github.com/girardinsamuel)

## Credits

Based on non maintained package https://github.com/hellomasonite/masonite-socialite.

## License

Masonite oauth is open-sourced software licensed under the [MIT license](LICENSE).
