# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import nodeum_sdk
from nodeum_sdk.models.by_primary_cloud_facet_all_of import ByPrimaryCloudFacetAllOf  # noqa: E501
from nodeum_sdk.rest import ApiException

class TestByPrimaryCloudFacetAllOf(unittest.TestCase):
    """ByPrimaryCloudFacetAllOf unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test ByPrimaryCloudFacetAllOf
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = nodeum_sdk.models.by_primary_cloud_facet_all_of.ByPrimaryCloudFacetAllOf()  # noqa: E501
        if include_optional :
            return ByPrimaryCloudFacetAllOf(
                prim_cloud_connector_name_s = nodeum_sdk.models.by_date_facet_buckets.by_date_facet_buckets(
                    buckets = [
                        null
                        ], ), 
                prim_cloud_bucket_name_s = nodeum_sdk.models.by_date_facet_buckets.by_date_facet_buckets(
                    buckets = [
                        null
                        ], ), 
                prim_pool_name_s = nodeum_sdk.models.by_date_facet_buckets.by_date_facet_buckets(
                    buckets = [
                        null
                        ], )
            )
        else :
            return ByPrimaryCloudFacetAllOf(
        )

    def testByPrimaryCloudFacetAllOf(self):
        """Test ByPrimaryCloudFacetAllOf"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
