# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nodeum_sdk.configuration import Configuration


class TapeDriveAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'tape_library_id': 'int',
        'name': 'str',
        'comment': 'str',
        'libso': 'str',
        'acs': 'int',
        'lsm': 'int',
        'panel': 'int',
        'transport': 'int',
        'status': 'str',
        'full': 'int',
        'mount_count': 'int',
        'use_to': 'str',
        'use_by': 'str',
        'barcode': 'str',
        'task_id': 'int',
        'use_file_processed_size': 'int',
        'use_file_size_to_process': 'int',
        'use_file_name_processed': 'str',
        'bandwidth': 'int'
    }

    attribute_map = {
        'id': 'id',
        'tape_library_id': 'tape_library_id',
        'name': 'name',
        'comment': 'comment',
        'libso': 'libso',
        'acs': 'acs',
        'lsm': 'lsm',
        'panel': 'panel',
        'transport': 'transport',
        'status': 'status',
        'full': 'full',
        'mount_count': 'mount_count',
        'use_to': 'use_to',
        'use_by': 'use_by',
        'barcode': 'barcode',
        'task_id': 'task_id',
        'use_file_processed_size': 'use_file_processed_size',
        'use_file_size_to_process': 'use_file_size_to_process',
        'use_file_name_processed': 'use_file_name_processed',
        'bandwidth': 'bandwidth'
    }

    def __init__(self, id=None, tape_library_id=None, name=None, comment=None, libso=None, acs=None, lsm=None, panel=None, transport=None, status=None, full=None, mount_count=None, use_to=None, use_by=None, barcode=None, task_id=None, use_file_processed_size=None, use_file_size_to_process=None, use_file_name_processed=None, bandwidth=None, local_vars_configuration=None):  # noqa: E501
        """TapeDriveAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._tape_library_id = None
        self._name = None
        self._comment = None
        self._libso = None
        self._acs = None
        self._lsm = None
        self._panel = None
        self._transport = None
        self._status = None
        self._full = None
        self._mount_count = None
        self._use_to = None
        self._use_by = None
        self._barcode = None
        self._task_id = None
        self._use_file_processed_size = None
        self._use_file_size_to_process = None
        self._use_file_name_processed = None
        self._bandwidth = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if tape_library_id is not None:
            self.tape_library_id = tape_library_id
        if name is not None:
            self.name = name
        if comment is not None:
            self.comment = comment
        if libso is not None:
            self.libso = libso
        if acs is not None:
            self.acs = acs
        if lsm is not None:
            self.lsm = lsm
        if panel is not None:
            self.panel = panel
        if transport is not None:
            self.transport = transport
        if status is not None:
            self.status = status
        if full is not None:
            self.full = full
        if mount_count is not None:
            self.mount_count = mount_count
        if use_to is not None:
            self.use_to = use_to
        if use_by is not None:
            self.use_by = use_by
        if barcode is not None:
            self.barcode = barcode
        if task_id is not None:
            self.task_id = task_id
        if use_file_processed_size is not None:
            self.use_file_processed_size = use_file_processed_size
        if use_file_size_to_process is not None:
            self.use_file_size_to_process = use_file_size_to_process
        if use_file_name_processed is not None:
            self.use_file_name_processed = use_file_name_processed
        if bandwidth is not None:
            self.bandwidth = bandwidth

    @property
    def id(self):
        """Gets the id of this TapeDriveAllOf.  # noqa: E501


        :return: The id of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TapeDriveAllOf.


        :param id: The id of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def tape_library_id(self):
        """Gets the tape_library_id of this TapeDriveAllOf.  # noqa: E501


        :return: The tape_library_id of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._tape_library_id

    @tape_library_id.setter
    def tape_library_id(self, tape_library_id):
        """Sets the tape_library_id of this TapeDriveAllOf.


        :param tape_library_id: The tape_library_id of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._tape_library_id = tape_library_id

    @property
    def name(self):
        """Gets the name of this TapeDriveAllOf.  # noqa: E501


        :return: The name of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TapeDriveAllOf.


        :param name: The name of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def comment(self):
        """Gets the comment of this TapeDriveAllOf.  # noqa: E501


        :return: The comment of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this TapeDriveAllOf.


        :param comment: The comment of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def libso(self):
        """Gets the libso of this TapeDriveAllOf.  # noqa: E501


        :return: The libso of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._libso

    @libso.setter
    def libso(self, libso):
        """Sets the libso of this TapeDriveAllOf.


        :param libso: The libso of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """

        self._libso = libso

    @property
    def acs(self):
        """Gets the acs of this TapeDriveAllOf.  # noqa: E501


        :return: The acs of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._acs

    @acs.setter
    def acs(self, acs):
        """Sets the acs of this TapeDriveAllOf.


        :param acs: The acs of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._acs = acs

    @property
    def lsm(self):
        """Gets the lsm of this TapeDriveAllOf.  # noqa: E501


        :return: The lsm of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._lsm

    @lsm.setter
    def lsm(self, lsm):
        """Sets the lsm of this TapeDriveAllOf.


        :param lsm: The lsm of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._lsm = lsm

    @property
    def panel(self):
        """Gets the panel of this TapeDriveAllOf.  # noqa: E501


        :return: The panel of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._panel

    @panel.setter
    def panel(self, panel):
        """Sets the panel of this TapeDriveAllOf.


        :param panel: The panel of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._panel = panel

    @property
    def transport(self):
        """Gets the transport of this TapeDriveAllOf.  # noqa: E501


        :return: The transport of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._transport

    @transport.setter
    def transport(self, transport):
        """Sets the transport of this TapeDriveAllOf.


        :param transport: The transport of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._transport = transport

    @property
    def status(self):
        """Gets the status of this TapeDriveAllOf.  # noqa: E501


        :return: The status of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this TapeDriveAllOf.


        :param status: The status of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """
        allowed_values = ["offline", "online"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def full(self):
        """Gets the full of this TapeDriveAllOf.  # noqa: E501


        :return: The full of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._full

    @full.setter
    def full(self, full):
        """Sets the full of this TapeDriveAllOf.


        :param full: The full of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._full = full

    @property
    def mount_count(self):
        """Gets the mount_count of this TapeDriveAllOf.  # noqa: E501


        :return: The mount_count of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._mount_count

    @mount_count.setter
    def mount_count(self, mount_count):
        """Sets the mount_count of this TapeDriveAllOf.


        :param mount_count: The mount_count of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._mount_count = mount_count

    @property
    def use_to(self):
        """Gets the use_to of this TapeDriveAllOf.  # noqa: E501


        :return: The use_to of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._use_to

    @use_to.setter
    def use_to(self, use_to):
        """Sets the use_to of this TapeDriveAllOf.


        :param use_to: The use_to of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """

        self._use_to = use_to

    @property
    def use_by(self):
        """Gets the use_by of this TapeDriveAllOf.  # noqa: E501


        :return: The use_by of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._use_by

    @use_by.setter
    def use_by(self, use_by):
        """Sets the use_by of this TapeDriveAllOf.


        :param use_by: The use_by of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """

        self._use_by = use_by

    @property
    def barcode(self):
        """Gets the barcode of this TapeDriveAllOf.  # noqa: E501


        :return: The barcode of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._barcode

    @barcode.setter
    def barcode(self, barcode):
        """Sets the barcode of this TapeDriveAllOf.


        :param barcode: The barcode of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """

        self._barcode = barcode

    @property
    def task_id(self):
        """Gets the task_id of this TapeDriveAllOf.  # noqa: E501


        :return: The task_id of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this TapeDriveAllOf.


        :param task_id: The task_id of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._task_id = task_id

    @property
    def use_file_processed_size(self):
        """Gets the use_file_processed_size of this TapeDriveAllOf.  # noqa: E501


        :return: The use_file_processed_size of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._use_file_processed_size

    @use_file_processed_size.setter
    def use_file_processed_size(self, use_file_processed_size):
        """Sets the use_file_processed_size of this TapeDriveAllOf.


        :param use_file_processed_size: The use_file_processed_size of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._use_file_processed_size = use_file_processed_size

    @property
    def use_file_size_to_process(self):
        """Gets the use_file_size_to_process of this TapeDriveAllOf.  # noqa: E501


        :return: The use_file_size_to_process of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._use_file_size_to_process

    @use_file_size_to_process.setter
    def use_file_size_to_process(self, use_file_size_to_process):
        """Sets the use_file_size_to_process of this TapeDriveAllOf.


        :param use_file_size_to_process: The use_file_size_to_process of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._use_file_size_to_process = use_file_size_to_process

    @property
    def use_file_name_processed(self):
        """Gets the use_file_name_processed of this TapeDriveAllOf.  # noqa: E501


        :return: The use_file_name_processed of this TapeDriveAllOf.  # noqa: E501
        :rtype: str
        """
        return self._use_file_name_processed

    @use_file_name_processed.setter
    def use_file_name_processed(self, use_file_name_processed):
        """Sets the use_file_name_processed of this TapeDriveAllOf.


        :param use_file_name_processed: The use_file_name_processed of this TapeDriveAllOf.  # noqa: E501
        :type: str
        """

        self._use_file_name_processed = use_file_name_processed

    @property
    def bandwidth(self):
        """Gets the bandwidth of this TapeDriveAllOf.  # noqa: E501


        :return: The bandwidth of this TapeDriveAllOf.  # noqa: E501
        :rtype: int
        """
        return self._bandwidth

    @bandwidth.setter
    def bandwidth(self, bandwidth):
        """Sets the bandwidth of this TapeDriveAllOf.


        :param bandwidth: The bandwidth of this TapeDriveAllOf.  # noqa: E501
        :type: int
        """

        self._bandwidth = bandwidth

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TapeDriveAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TapeDriveAllOf):
            return True

        return self.to_dict() != other.to_dict()
