# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nodeum_sdk.configuration import Configuration


class Tape(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'tape_library_id': 'int',
        'pool_id': 'int',
        'barcode': 'str',
        'location': 'str',
        'type': 'str',
        'locked': 'bool',
        'scratch': 'bool',
        'cleaning': 'bool',
        'write_protect': 'bool',
        'mounted': 'bool',
        'ejected': 'bool',
        'known': 'bool',
        'mount_count': 'int',
        'date_in': 'str',
        'date_move': 'str',
        'free': 'int',
        'max': 'int',
        'last_size_update': 'str',
        'last_maintenance': 'str',
        'last_repack': 'str',
        'repack_status': 'bool',
        'hash': 'str',
        'force_import_type': 'bool',
        'need_to_check': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'tape_library_id': 'tape_library_id',
        'pool_id': 'pool_id',
        'barcode': 'barcode',
        'location': 'location',
        'type': 'type',
        'locked': 'locked',
        'scratch': 'scratch',
        'cleaning': 'cleaning',
        'write_protect': 'write_protect',
        'mounted': 'mounted',
        'ejected': 'ejected',
        'known': 'known',
        'mount_count': 'mount_count',
        'date_in': 'date_in',
        'date_move': 'date_move',
        'free': 'free',
        'max': 'max',
        'last_size_update': 'last_size_update',
        'last_maintenance': 'last_maintenance',
        'last_repack': 'last_repack',
        'repack_status': 'repack_status',
        'hash': 'hash',
        'force_import_type': 'force_import_type',
        'need_to_check': 'need_to_check'
    }

    def __init__(self, id=None, tape_library_id=None, pool_id=None, barcode=None, location=None, type=None, locked=None, scratch=None, cleaning=None, write_protect=None, mounted=None, ejected=None, known=None, mount_count=None, date_in=None, date_move=None, free=None, max=None, last_size_update=None, last_maintenance=None, last_repack=None, repack_status=None, hash=None, force_import_type=None, need_to_check=None, local_vars_configuration=None):  # noqa: E501
        """Tape - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._tape_library_id = None
        self._pool_id = None
        self._barcode = None
        self._location = None
        self._type = None
        self._locked = None
        self._scratch = None
        self._cleaning = None
        self._write_protect = None
        self._mounted = None
        self._ejected = None
        self._known = None
        self._mount_count = None
        self._date_in = None
        self._date_move = None
        self._free = None
        self._max = None
        self._last_size_update = None
        self._last_maintenance = None
        self._last_repack = None
        self._repack_status = None
        self._hash = None
        self._force_import_type = None
        self._need_to_check = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if tape_library_id is not None:
            self.tape_library_id = tape_library_id
        if pool_id is not None:
            self.pool_id = pool_id
        if barcode is not None:
            self.barcode = barcode
        if location is not None:
            self.location = location
        if type is not None:
            self.type = type
        if locked is not None:
            self.locked = locked
        if scratch is not None:
            self.scratch = scratch
        if cleaning is not None:
            self.cleaning = cleaning
        if write_protect is not None:
            self.write_protect = write_protect
        if mounted is not None:
            self.mounted = mounted
        if ejected is not None:
            self.ejected = ejected
        if known is not None:
            self.known = known
        if mount_count is not None:
            self.mount_count = mount_count
        if date_in is not None:
            self.date_in = date_in
        if date_move is not None:
            self.date_move = date_move
        if free is not None:
            self.free = free
        if max is not None:
            self.max = max
        if last_size_update is not None:
            self.last_size_update = last_size_update
        if last_maintenance is not None:
            self.last_maintenance = last_maintenance
        if last_repack is not None:
            self.last_repack = last_repack
        if repack_status is not None:
            self.repack_status = repack_status
        if hash is not None:
            self.hash = hash
        if force_import_type is not None:
            self.force_import_type = force_import_type
        if need_to_check is not None:
            self.need_to_check = need_to_check

    @property
    def id(self):
        """Gets the id of this Tape.  # noqa: E501


        :return: The id of this Tape.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Tape.


        :param id: The id of this Tape.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def tape_library_id(self):
        """Gets the tape_library_id of this Tape.  # noqa: E501


        :return: The tape_library_id of this Tape.  # noqa: E501
        :rtype: int
        """
        return self._tape_library_id

    @tape_library_id.setter
    def tape_library_id(self, tape_library_id):
        """Sets the tape_library_id of this Tape.


        :param tape_library_id: The tape_library_id of this Tape.  # noqa: E501
        :type: int
        """

        self._tape_library_id = tape_library_id

    @property
    def pool_id(self):
        """Gets the pool_id of this Tape.  # noqa: E501


        :return: The pool_id of this Tape.  # noqa: E501
        :rtype: int
        """
        return self._pool_id

    @pool_id.setter
    def pool_id(self, pool_id):
        """Sets the pool_id of this Tape.


        :param pool_id: The pool_id of this Tape.  # noqa: E501
        :type: int
        """

        self._pool_id = pool_id

    @property
    def barcode(self):
        """Gets the barcode of this Tape.  # noqa: E501


        :return: The barcode of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._barcode

    @barcode.setter
    def barcode(self, barcode):
        """Sets the barcode of this Tape.


        :param barcode: The barcode of this Tape.  # noqa: E501
        :type: str
        """

        self._barcode = barcode

    @property
    def location(self):
        """Gets the location of this Tape.  # noqa: E501


        :return: The location of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this Tape.


        :param location: The location of this Tape.  # noqa: E501
        :type: str
        """

        self._location = location

    @property
    def type(self):
        """Gets the type of this Tape.  # noqa: E501


        :return: The type of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Tape.


        :param type: The type of this Tape.  # noqa: E501
        :type: str
        """
        allowed_values = ["unknown", "data", "cleaning", "diagnostic", "data_lto1", "data_lto2", "data_lto3", "data_lto4", "data_lto5", "data_lto6", "data_lto7", "data_lto8", "data_lto9", "data_lto10", "data_lto11", "data_lto12"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def locked(self):
        """Gets the locked of this Tape.  # noqa: E501


        :return: The locked of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this Tape.


        :param locked: The locked of this Tape.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def scratch(self):
        """Gets the scratch of this Tape.  # noqa: E501


        :return: The scratch of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._scratch

    @scratch.setter
    def scratch(self, scratch):
        """Sets the scratch of this Tape.


        :param scratch: The scratch of this Tape.  # noqa: E501
        :type: bool
        """

        self._scratch = scratch

    @property
    def cleaning(self):
        """Gets the cleaning of this Tape.  # noqa: E501


        :return: The cleaning of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._cleaning

    @cleaning.setter
    def cleaning(self, cleaning):
        """Sets the cleaning of this Tape.


        :param cleaning: The cleaning of this Tape.  # noqa: E501
        :type: bool
        """

        self._cleaning = cleaning

    @property
    def write_protect(self):
        """Gets the write_protect of this Tape.  # noqa: E501


        :return: The write_protect of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._write_protect

    @write_protect.setter
    def write_protect(self, write_protect):
        """Sets the write_protect of this Tape.


        :param write_protect: The write_protect of this Tape.  # noqa: E501
        :type: bool
        """

        self._write_protect = write_protect

    @property
    def mounted(self):
        """Gets the mounted of this Tape.  # noqa: E501


        :return: The mounted of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._mounted

    @mounted.setter
    def mounted(self, mounted):
        """Sets the mounted of this Tape.


        :param mounted: The mounted of this Tape.  # noqa: E501
        :type: bool
        """

        self._mounted = mounted

    @property
    def ejected(self):
        """Gets the ejected of this Tape.  # noqa: E501


        :return: The ejected of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._ejected

    @ejected.setter
    def ejected(self, ejected):
        """Sets the ejected of this Tape.


        :param ejected: The ejected of this Tape.  # noqa: E501
        :type: bool
        """

        self._ejected = ejected

    @property
    def known(self):
        """Gets the known of this Tape.  # noqa: E501


        :return: The known of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._known

    @known.setter
    def known(self, known):
        """Sets the known of this Tape.


        :param known: The known of this Tape.  # noqa: E501
        :type: bool
        """

        self._known = known

    @property
    def mount_count(self):
        """Gets the mount_count of this Tape.  # noqa: E501


        :return: The mount_count of this Tape.  # noqa: E501
        :rtype: int
        """
        return self._mount_count

    @mount_count.setter
    def mount_count(self, mount_count):
        """Sets the mount_count of this Tape.


        :param mount_count: The mount_count of this Tape.  # noqa: E501
        :type: int
        """

        self._mount_count = mount_count

    @property
    def date_in(self):
        """Gets the date_in of this Tape.  # noqa: E501


        :return: The date_in of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._date_in

    @date_in.setter
    def date_in(self, date_in):
        """Sets the date_in of this Tape.


        :param date_in: The date_in of this Tape.  # noqa: E501
        :type: str
        """

        self._date_in = date_in

    @property
    def date_move(self):
        """Gets the date_move of this Tape.  # noqa: E501


        :return: The date_move of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._date_move

    @date_move.setter
    def date_move(self, date_move):
        """Sets the date_move of this Tape.


        :param date_move: The date_move of this Tape.  # noqa: E501
        :type: str
        """

        self._date_move = date_move

    @property
    def free(self):
        """Gets the free of this Tape.  # noqa: E501


        :return: The free of this Tape.  # noqa: E501
        :rtype: int
        """
        return self._free

    @free.setter
    def free(self, free):
        """Sets the free of this Tape.


        :param free: The free of this Tape.  # noqa: E501
        :type: int
        """

        self._free = free

    @property
    def max(self):
        """Gets the max of this Tape.  # noqa: E501


        :return: The max of this Tape.  # noqa: E501
        :rtype: int
        """
        return self._max

    @max.setter
    def max(self, max):
        """Sets the max of this Tape.


        :param max: The max of this Tape.  # noqa: E501
        :type: int
        """

        self._max = max

    @property
    def last_size_update(self):
        """Gets the last_size_update of this Tape.  # noqa: E501


        :return: The last_size_update of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._last_size_update

    @last_size_update.setter
    def last_size_update(self, last_size_update):
        """Sets the last_size_update of this Tape.


        :param last_size_update: The last_size_update of this Tape.  # noqa: E501
        :type: str
        """

        self._last_size_update = last_size_update

    @property
    def last_maintenance(self):
        """Gets the last_maintenance of this Tape.  # noqa: E501


        :return: The last_maintenance of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._last_maintenance

    @last_maintenance.setter
    def last_maintenance(self, last_maintenance):
        """Sets the last_maintenance of this Tape.


        :param last_maintenance: The last_maintenance of this Tape.  # noqa: E501
        :type: str
        """

        self._last_maintenance = last_maintenance

    @property
    def last_repack(self):
        """Gets the last_repack of this Tape.  # noqa: E501


        :return: The last_repack of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._last_repack

    @last_repack.setter
    def last_repack(self, last_repack):
        """Sets the last_repack of this Tape.


        :param last_repack: The last_repack of this Tape.  # noqa: E501
        :type: str
        """

        self._last_repack = last_repack

    @property
    def repack_status(self):
        """Gets the repack_status of this Tape.  # noqa: E501


        :return: The repack_status of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._repack_status

    @repack_status.setter
    def repack_status(self, repack_status):
        """Sets the repack_status of this Tape.


        :param repack_status: The repack_status of this Tape.  # noqa: E501
        :type: bool
        """

        self._repack_status = repack_status

    @property
    def hash(self):
        """Gets the hash of this Tape.  # noqa: E501


        :return: The hash of this Tape.  # noqa: E501
        :rtype: str
        """
        return self._hash

    @hash.setter
    def hash(self, hash):
        """Sets the hash of this Tape.


        :param hash: The hash of this Tape.  # noqa: E501
        :type: str
        """

        self._hash = hash

    @property
    def force_import_type(self):
        """Gets the force_import_type of this Tape.  # noqa: E501


        :return: The force_import_type of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._force_import_type

    @force_import_type.setter
    def force_import_type(self, force_import_type):
        """Sets the force_import_type of this Tape.


        :param force_import_type: The force_import_type of this Tape.  # noqa: E501
        :type: bool
        """

        self._force_import_type = force_import_type

    @property
    def need_to_check(self):
        """Gets the need_to_check of this Tape.  # noqa: E501


        :return: The need_to_check of this Tape.  # noqa: E501
        :rtype: bool
        """
        return self._need_to_check

    @need_to_check.setter
    def need_to_check(self, need_to_check):
        """Sets the need_to_check of this Tape.


        :param need_to_check: The need_to_check of this Tape.  # noqa: E501
        :type: bool
        """

        self._need_to_check = need_to_check

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Tape):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Tape):
            return True

        return self.to_dict() != other.to_dict()
