# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nodeum_sdk.configuration import Configuration


class Container(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'comment': 'str',
        'quota_total_size': 'int',
        'quota_on_cache': 'int',
        'stat_total_files': 'int',
        'only_on_cache_file_count': 'int',
        'stat_total_size': 'int',
        'stat_size_on_cache': 'int',
        'only_on_cache_file_size_sum': 'int',
        'guest_right': 'str',
        'last_update': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'comment': 'comment',
        'quota_total_size': 'quota_total_size',
        'quota_on_cache': 'quota_on_cache',
        'stat_total_files': 'stat_total_files',
        'only_on_cache_file_count': 'only_on_cache_file_count',
        'stat_total_size': 'stat_total_size',
        'stat_size_on_cache': 'stat_size_on_cache',
        'only_on_cache_file_size_sum': 'only_on_cache_file_size_sum',
        'guest_right': 'guest_right',
        'last_update': 'last_update'
    }

    def __init__(self, id=None, name=None, comment=None, quota_total_size=None, quota_on_cache=None, stat_total_files=None, only_on_cache_file_count=None, stat_total_size=None, stat_size_on_cache=None, only_on_cache_file_size_sum=None, guest_right=None, last_update=None, local_vars_configuration=None):  # noqa: E501
        """Container - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._comment = None
        self._quota_total_size = None
        self._quota_on_cache = None
        self._stat_total_files = None
        self._only_on_cache_file_count = None
        self._stat_total_size = None
        self._stat_size_on_cache = None
        self._only_on_cache_file_size_sum = None
        self._guest_right = None
        self._last_update = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if comment is not None:
            self.comment = comment
        if quota_total_size is not None:
            self.quota_total_size = quota_total_size
        if quota_on_cache is not None:
            self.quota_on_cache = quota_on_cache
        if stat_total_files is not None:
            self.stat_total_files = stat_total_files
        if only_on_cache_file_count is not None:
            self.only_on_cache_file_count = only_on_cache_file_count
        if stat_total_size is not None:
            self.stat_total_size = stat_total_size
        if stat_size_on_cache is not None:
            self.stat_size_on_cache = stat_size_on_cache
        if only_on_cache_file_size_sum is not None:
            self.only_on_cache_file_size_sum = only_on_cache_file_size_sum
        if guest_right is not None:
            self.guest_right = guest_right
        if last_update is not None:
            self.last_update = last_update

    @property
    def id(self):
        """Gets the id of this Container.  # noqa: E501


        :return: The id of this Container.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Container.


        :param id: The id of this Container.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Container.  # noqa: E501


        :return: The name of this Container.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Container.


        :param name: The name of this Container.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def comment(self):
        """Gets the comment of this Container.  # noqa: E501


        :return: The comment of this Container.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this Container.


        :param comment: The comment of this Container.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def quota_total_size(self):
        """Gets the quota_total_size of this Container.  # noqa: E501


        :return: The quota_total_size of this Container.  # noqa: E501
        :rtype: int
        """
        return self._quota_total_size

    @quota_total_size.setter
    def quota_total_size(self, quota_total_size):
        """Sets the quota_total_size of this Container.


        :param quota_total_size: The quota_total_size of this Container.  # noqa: E501
        :type: int
        """

        self._quota_total_size = quota_total_size

    @property
    def quota_on_cache(self):
        """Gets the quota_on_cache of this Container.  # noqa: E501


        :return: The quota_on_cache of this Container.  # noqa: E501
        :rtype: int
        """
        return self._quota_on_cache

    @quota_on_cache.setter
    def quota_on_cache(self, quota_on_cache):
        """Sets the quota_on_cache of this Container.


        :param quota_on_cache: The quota_on_cache of this Container.  # noqa: E501
        :type: int
        """

        self._quota_on_cache = quota_on_cache

    @property
    def stat_total_files(self):
        """Gets the stat_total_files of this Container.  # noqa: E501


        :return: The stat_total_files of this Container.  # noqa: E501
        :rtype: int
        """
        return self._stat_total_files

    @stat_total_files.setter
    def stat_total_files(self, stat_total_files):
        """Sets the stat_total_files of this Container.


        :param stat_total_files: The stat_total_files of this Container.  # noqa: E501
        :type: int
        """

        self._stat_total_files = stat_total_files

    @property
    def only_on_cache_file_count(self):
        """Gets the only_on_cache_file_count of this Container.  # noqa: E501


        :return: The only_on_cache_file_count of this Container.  # noqa: E501
        :rtype: int
        """
        return self._only_on_cache_file_count

    @only_on_cache_file_count.setter
    def only_on_cache_file_count(self, only_on_cache_file_count):
        """Sets the only_on_cache_file_count of this Container.


        :param only_on_cache_file_count: The only_on_cache_file_count of this Container.  # noqa: E501
        :type: int
        """

        self._only_on_cache_file_count = only_on_cache_file_count

    @property
    def stat_total_size(self):
        """Gets the stat_total_size of this Container.  # noqa: E501


        :return: The stat_total_size of this Container.  # noqa: E501
        :rtype: int
        """
        return self._stat_total_size

    @stat_total_size.setter
    def stat_total_size(self, stat_total_size):
        """Sets the stat_total_size of this Container.


        :param stat_total_size: The stat_total_size of this Container.  # noqa: E501
        :type: int
        """

        self._stat_total_size = stat_total_size

    @property
    def stat_size_on_cache(self):
        """Gets the stat_size_on_cache of this Container.  # noqa: E501


        :return: The stat_size_on_cache of this Container.  # noqa: E501
        :rtype: int
        """
        return self._stat_size_on_cache

    @stat_size_on_cache.setter
    def stat_size_on_cache(self, stat_size_on_cache):
        """Sets the stat_size_on_cache of this Container.


        :param stat_size_on_cache: The stat_size_on_cache of this Container.  # noqa: E501
        :type: int
        """

        self._stat_size_on_cache = stat_size_on_cache

    @property
    def only_on_cache_file_size_sum(self):
        """Gets the only_on_cache_file_size_sum of this Container.  # noqa: E501


        :return: The only_on_cache_file_size_sum of this Container.  # noqa: E501
        :rtype: int
        """
        return self._only_on_cache_file_size_sum

    @only_on_cache_file_size_sum.setter
    def only_on_cache_file_size_sum(self, only_on_cache_file_size_sum):
        """Sets the only_on_cache_file_size_sum of this Container.


        :param only_on_cache_file_size_sum: The only_on_cache_file_size_sum of this Container.  # noqa: E501
        :type: int
        """

        self._only_on_cache_file_size_sum = only_on_cache_file_size_sum

    @property
    def guest_right(self):
        """Gets the guest_right of this Container.  # noqa: E501


        :return: The guest_right of this Container.  # noqa: E501
        :rtype: str
        """
        return self._guest_right

    @guest_right.setter
    def guest_right(self, guest_right):
        """Sets the guest_right of this Container.


        :param guest_right: The guest_right of this Container.  # noqa: E501
        :type: str
        """
        allowed_values = ["none", "read", "read_write"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and guest_right not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `guest_right` ({0}), must be one of {1}"  # noqa: E501
                .format(guest_right, allowed_values)
            )

        self._guest_right = guest_right

    @property
    def last_update(self):
        """Gets the last_update of this Container.  # noqa: E501


        :return: The last_update of this Container.  # noqa: E501
        :rtype: str
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this Container.


        :param last_update: The last_update of this Container.  # noqa: E501
        :type: str
        """

        self._last_update = last_update

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Container):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Container):
            return True

        return self.to_dict() != other.to_dict()
