# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nodeum_sdk.api_client import ApiClient
from nodeum_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TapesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def index_tape_stats(self, **kwargs):  # noqa: E501
        """List all tape statistics.  # noqa: E501

        **API Key Scope**: tape_stats / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_stats(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeStatCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tape_stats_with_http_info(**kwargs)  # noqa: E501

    def index_tape_stats_with_http_info(self, **kwargs):  # noqa: E501
        """List all tape statistics.  # noqa: E501

        **API Key Scope**: tape_stats / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_stats_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeStatCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tape_stats" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeStatCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tapes(self, **kwargs):  # noqa: E501
        """Lists all tapes.  # noqa: E501

        **API Key Scope**: tapes / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str tape_library_id: Filter on tape library id
        :param str pool_id: Filter on a pool id
        :param str barcode: Filter on barcode
        :param str location: Filter on location
        :param str type: Filter on type
        :param str locked: Filter on locked
        :param str scratch: Filter on scratch
        :param str cleaning: Filter on cleaning
        :param str write_protect: Filter on write protect
        :param str mounted: Filter on mounted
        :param str ejected: Filter on ejected
        :param str known: Filter on known
        :param str mount_count: Filter on mount count
        :param str date_in: Filter on date in
        :param str date_move: Filter on date move
        :param str free: Filter on free
        :param str max: Filter on max
        :param str last_size_update: Filter on last size update
        :param str last_maintenance: Filter on last maintenance
        :param str last_repack: Filter on last repack
        :param str repack_status: Filter on repack status
        :param str hash: Filter on hash
        :param str force_import_type: Filter on force import type
        :param str need_to_check: Filter on need to check
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tapes_with_http_info(**kwargs)  # noqa: E501

    def index_tapes_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all tapes.  # noqa: E501

        **API Key Scope**: tapes / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str tape_library_id: Filter on tape library id
        :param str pool_id: Filter on a pool id
        :param str barcode: Filter on barcode
        :param str location: Filter on location
        :param str type: Filter on type
        :param str locked: Filter on locked
        :param str scratch: Filter on scratch
        :param str cleaning: Filter on cleaning
        :param str write_protect: Filter on write protect
        :param str mounted: Filter on mounted
        :param str ejected: Filter on ejected
        :param str known: Filter on known
        :param str mount_count: Filter on mount count
        :param str date_in: Filter on date in
        :param str date_move: Filter on date move
        :param str free: Filter on free
        :param str max: Filter on max
        :param str last_size_update: Filter on last size update
        :param str last_maintenance: Filter on last maintenance
        :param str last_repack: Filter on last repack
        :param str repack_status: Filter on repack status
        :param str hash: Filter on hash
        :param str force_import_type: Filter on force import type
        :param str need_to_check: Filter on need to check
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset',
            'sort_by',
            'id',
            'tape_library_id',
            'pool_id',
            'barcode',
            'location',
            'type',
            'locked',
            'scratch',
            'cleaning',
            'write_protect',
            'mounted',
            'ejected',
            'known',
            'mount_count',
            'date_in',
            'date_move',
            'free',
            'max',
            'last_size_update',
            'last_maintenance',
            'last_repack',
            'repack_status',
            'hash',
            'force_import_type',
            'need_to_check'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tapes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'tape_library_id' in local_var_params and local_var_params['tape_library_id'] is not None:  # noqa: E501
            query_params.append(('tape_library_id', local_var_params['tape_library_id']))  # noqa: E501
        if 'pool_id' in local_var_params and local_var_params['pool_id'] is not None:  # noqa: E501
            query_params.append(('pool_id', local_var_params['pool_id']))  # noqa: E501
        if 'barcode' in local_var_params and local_var_params['barcode'] is not None:  # noqa: E501
            query_params.append(('barcode', local_var_params['barcode']))  # noqa: E501
        if 'location' in local_var_params and local_var_params['location'] is not None:  # noqa: E501
            query_params.append(('location', local_var_params['location']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'locked' in local_var_params and local_var_params['locked'] is not None:  # noqa: E501
            query_params.append(('locked', local_var_params['locked']))  # noqa: E501
        if 'scratch' in local_var_params and local_var_params['scratch'] is not None:  # noqa: E501
            query_params.append(('scratch', local_var_params['scratch']))  # noqa: E501
        if 'cleaning' in local_var_params and local_var_params['cleaning'] is not None:  # noqa: E501
            query_params.append(('cleaning', local_var_params['cleaning']))  # noqa: E501
        if 'write_protect' in local_var_params and local_var_params['write_protect'] is not None:  # noqa: E501
            query_params.append(('write_protect', local_var_params['write_protect']))  # noqa: E501
        if 'mounted' in local_var_params and local_var_params['mounted'] is not None:  # noqa: E501
            query_params.append(('mounted', local_var_params['mounted']))  # noqa: E501
        if 'ejected' in local_var_params and local_var_params['ejected'] is not None:  # noqa: E501
            query_params.append(('ejected', local_var_params['ejected']))  # noqa: E501
        if 'known' in local_var_params and local_var_params['known'] is not None:  # noqa: E501
            query_params.append(('known', local_var_params['known']))  # noqa: E501
        if 'mount_count' in local_var_params and local_var_params['mount_count'] is not None:  # noqa: E501
            query_params.append(('mount_count', local_var_params['mount_count']))  # noqa: E501
        if 'date_in' in local_var_params and local_var_params['date_in'] is not None:  # noqa: E501
            query_params.append(('date_in', local_var_params['date_in']))  # noqa: E501
        if 'date_move' in local_var_params and local_var_params['date_move'] is not None:  # noqa: E501
            query_params.append(('date_move', local_var_params['date_move']))  # noqa: E501
        if 'free' in local_var_params and local_var_params['free'] is not None:  # noqa: E501
            query_params.append(('free', local_var_params['free']))  # noqa: E501
        if 'max' in local_var_params and local_var_params['max'] is not None:  # noqa: E501
            query_params.append(('max', local_var_params['max']))  # noqa: E501
        if 'last_size_update' in local_var_params and local_var_params['last_size_update'] is not None:  # noqa: E501
            query_params.append(('last_size_update', local_var_params['last_size_update']))  # noqa: E501
        if 'last_maintenance' in local_var_params and local_var_params['last_maintenance'] is not None:  # noqa: E501
            query_params.append(('last_maintenance', local_var_params['last_maintenance']))  # noqa: E501
        if 'last_repack' in local_var_params and local_var_params['last_repack'] is not None:  # noqa: E501
            query_params.append(('last_repack', local_var_params['last_repack']))  # noqa: E501
        if 'repack_status' in local_var_params and local_var_params['repack_status'] is not None:  # noqa: E501
            query_params.append(('repack_status', local_var_params['repack_status']))  # noqa: E501
        if 'hash' in local_var_params and local_var_params['hash'] is not None:  # noqa: E501
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
        if 'force_import_type' in local_var_params and local_var_params['force_import_type'] is not None:  # noqa: E501
            query_params.append(('force_import_type', local_var_params['force_import_type']))  # noqa: E501
        if 'need_to_check' in local_var_params and local_var_params['need_to_check'] is not None:  # noqa: E501
            query_params.append(('need_to_check', local_var_params['need_to_check']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tapes_by_pool(self, **kwargs):  # noqa: E501
        """Lists all tapes.  # noqa: E501

        **API Key Scope**: tapes / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_pool(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str tape_library_id: Filter on tape library id
        :param str barcode: Filter on barcode
        :param str location: Filter on location
        :param str type: Filter on type
        :param str locked: Filter on locked
        :param str scratch: Filter on scratch
        :param str cleaning: Filter on cleaning
        :param str write_protect: Filter on write protect
        :param str mounted: Filter on mounted
        :param str ejected: Filter on ejected
        :param str known: Filter on known
        :param str mount_count: Filter on mount count
        :param str date_in: Filter on date in
        :param str date_move: Filter on date move
        :param str free: Filter on free
        :param str max: Filter on max
        :param str last_size_update: Filter on last size update
        :param str last_maintenance: Filter on last maintenance
        :param str last_repack: Filter on last repack
        :param str repack_status: Filter on repack status
        :param str hash: Filter on hash
        :param str force_import_type: Filter on force import type
        :param str need_to_check: Filter on need to check
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tapes_by_pool_with_http_info(**kwargs)  # noqa: E501

    def index_tapes_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all tapes.  # noqa: E501

        **API Key Scope**: tapes / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_pool_with_http_info(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str tape_library_id: Filter on tape library id
        :param str barcode: Filter on barcode
        :param str location: Filter on location
        :param str type: Filter on type
        :param str locked: Filter on locked
        :param str scratch: Filter on scratch
        :param str cleaning: Filter on cleaning
        :param str write_protect: Filter on write protect
        :param str mounted: Filter on mounted
        :param str ejected: Filter on ejected
        :param str known: Filter on known
        :param str mount_count: Filter on mount count
        :param str date_in: Filter on date in
        :param str date_move: Filter on date move
        :param str free: Filter on free
        :param str max: Filter on max
        :param str last_size_update: Filter on last size update
        :param str last_maintenance: Filter on last maintenance
        :param str last_repack: Filter on last repack
        :param str repack_status: Filter on repack status
        :param str hash: Filter on hash
        :param str force_import_type: Filter on force import type
        :param str need_to_check: Filter on need to check
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'limit',
            'offset',
            'sort_by',
            'id',
            'tape_library_id',
            'barcode',
            'location',
            'type',
            'locked',
            'scratch',
            'cleaning',
            'write_protect',
            'mounted',
            'ejected',
            'known',
            'mount_count',
            'date_in',
            'date_move',
            'free',
            'max',
            'last_size_update',
            'last_maintenance',
            'last_repack',
            'repack_status',
            'hash',
            'force_import_type',
            'need_to_check'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tapes_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `index_tapes_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'tape_library_id' in local_var_params and local_var_params['tape_library_id'] is not None:  # noqa: E501
            query_params.append(('tape_library_id', local_var_params['tape_library_id']))  # noqa: E501
        if 'barcode' in local_var_params and local_var_params['barcode'] is not None:  # noqa: E501
            query_params.append(('barcode', local_var_params['barcode']))  # noqa: E501
        if 'location' in local_var_params and local_var_params['location'] is not None:  # noqa: E501
            query_params.append(('location', local_var_params['location']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'locked' in local_var_params and local_var_params['locked'] is not None:  # noqa: E501
            query_params.append(('locked', local_var_params['locked']))  # noqa: E501
        if 'scratch' in local_var_params and local_var_params['scratch'] is not None:  # noqa: E501
            query_params.append(('scratch', local_var_params['scratch']))  # noqa: E501
        if 'cleaning' in local_var_params and local_var_params['cleaning'] is not None:  # noqa: E501
            query_params.append(('cleaning', local_var_params['cleaning']))  # noqa: E501
        if 'write_protect' in local_var_params and local_var_params['write_protect'] is not None:  # noqa: E501
            query_params.append(('write_protect', local_var_params['write_protect']))  # noqa: E501
        if 'mounted' in local_var_params and local_var_params['mounted'] is not None:  # noqa: E501
            query_params.append(('mounted', local_var_params['mounted']))  # noqa: E501
        if 'ejected' in local_var_params and local_var_params['ejected'] is not None:  # noqa: E501
            query_params.append(('ejected', local_var_params['ejected']))  # noqa: E501
        if 'known' in local_var_params and local_var_params['known'] is not None:  # noqa: E501
            query_params.append(('known', local_var_params['known']))  # noqa: E501
        if 'mount_count' in local_var_params and local_var_params['mount_count'] is not None:  # noqa: E501
            query_params.append(('mount_count', local_var_params['mount_count']))  # noqa: E501
        if 'date_in' in local_var_params and local_var_params['date_in'] is not None:  # noqa: E501
            query_params.append(('date_in', local_var_params['date_in']))  # noqa: E501
        if 'date_move' in local_var_params and local_var_params['date_move'] is not None:  # noqa: E501
            query_params.append(('date_move', local_var_params['date_move']))  # noqa: E501
        if 'free' in local_var_params and local_var_params['free'] is not None:  # noqa: E501
            query_params.append(('free', local_var_params['free']))  # noqa: E501
        if 'max' in local_var_params and local_var_params['max'] is not None:  # noqa: E501
            query_params.append(('max', local_var_params['max']))  # noqa: E501
        if 'last_size_update' in local_var_params and local_var_params['last_size_update'] is not None:  # noqa: E501
            query_params.append(('last_size_update', local_var_params['last_size_update']))  # noqa: E501
        if 'last_maintenance' in local_var_params and local_var_params['last_maintenance'] is not None:  # noqa: E501
            query_params.append(('last_maintenance', local_var_params['last_maintenance']))  # noqa: E501
        if 'last_repack' in local_var_params and local_var_params['last_repack'] is not None:  # noqa: E501
            query_params.append(('last_repack', local_var_params['last_repack']))  # noqa: E501
        if 'repack_status' in local_var_params and local_var_params['repack_status'] is not None:  # noqa: E501
            query_params.append(('repack_status', local_var_params['repack_status']))  # noqa: E501
        if 'hash' in local_var_params and local_var_params['hash'] is not None:  # noqa: E501
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
        if 'force_import_type' in local_var_params and local_var_params['force_import_type'] is not None:  # noqa: E501
            query_params.append(('force_import_type', local_var_params['force_import_type']))  # noqa: E501
        if 'need_to_check' in local_var_params and local_var_params['need_to_check'] is not None:  # noqa: E501
            query_params.append(('need_to_check', local_var_params['need_to_check']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/tapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tapes_by_tape_library(self, **kwargs):  # noqa: E501
        """Lists all tapes.  # noqa: E501

        **API Key Scope**: tapes / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_tape_library(tape_library_id=tape_library_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str pool_id: Filter on a pool id
        :param str barcode: Filter on barcode
        :param str location: Filter on location
        :param str type: Filter on type
        :param str locked: Filter on locked
        :param str scratch: Filter on scratch
        :param str cleaning: Filter on cleaning
        :param str write_protect: Filter on write protect
        :param str mounted: Filter on mounted
        :param str ejected: Filter on ejected
        :param str known: Filter on known
        :param str mount_count: Filter on mount count
        :param str date_in: Filter on date in
        :param str date_move: Filter on date move
        :param str free: Filter on free
        :param str max: Filter on max
        :param str last_size_update: Filter on last size update
        :param str last_maintenance: Filter on last maintenance
        :param str last_repack: Filter on last repack
        :param str repack_status: Filter on repack status
        :param str hash: Filter on hash
        :param str force_import_type: Filter on force import type
        :param str need_to_check: Filter on need to check
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tapes_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def index_tapes_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all tapes.  # noqa: E501

        **API Key Scope**: tapes / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str pool_id: Filter on a pool id
        :param str barcode: Filter on barcode
        :param str location: Filter on location
        :param str type: Filter on type
        :param str locked: Filter on locked
        :param str scratch: Filter on scratch
        :param str cleaning: Filter on cleaning
        :param str write_protect: Filter on write protect
        :param str mounted: Filter on mounted
        :param str ejected: Filter on ejected
        :param str known: Filter on known
        :param str mount_count: Filter on mount count
        :param str date_in: Filter on date in
        :param str date_move: Filter on date move
        :param str free: Filter on free
        :param str max: Filter on max
        :param str last_size_update: Filter on last size update
        :param str last_maintenance: Filter on last maintenance
        :param str last_repack: Filter on last repack
        :param str repack_status: Filter on repack status
        :param str hash: Filter on hash
        :param str force_import_type: Filter on force import type
        :param str need_to_check: Filter on need to check
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'limit',
            'offset',
            'sort_by',
            'id',
            'pool_id',
            'barcode',
            'location',
            'type',
            'locked',
            'scratch',
            'cleaning',
            'write_protect',
            'mounted',
            'ejected',
            'known',
            'mount_count',
            'date_in',
            'date_move',
            'free',
            'max',
            'last_size_update',
            'last_maintenance',
            'last_repack',
            'repack_status',
            'hash',
            'force_import_type',
            'need_to_check'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tapes_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `index_tapes_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'pool_id' in local_var_params and local_var_params['pool_id'] is not None:  # noqa: E501
            query_params.append(('pool_id', local_var_params['pool_id']))  # noqa: E501
        if 'barcode' in local_var_params and local_var_params['barcode'] is not None:  # noqa: E501
            query_params.append(('barcode', local_var_params['barcode']))  # noqa: E501
        if 'location' in local_var_params and local_var_params['location'] is not None:  # noqa: E501
            query_params.append(('location', local_var_params['location']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'locked' in local_var_params and local_var_params['locked'] is not None:  # noqa: E501
            query_params.append(('locked', local_var_params['locked']))  # noqa: E501
        if 'scratch' in local_var_params and local_var_params['scratch'] is not None:  # noqa: E501
            query_params.append(('scratch', local_var_params['scratch']))  # noqa: E501
        if 'cleaning' in local_var_params and local_var_params['cleaning'] is not None:  # noqa: E501
            query_params.append(('cleaning', local_var_params['cleaning']))  # noqa: E501
        if 'write_protect' in local_var_params and local_var_params['write_protect'] is not None:  # noqa: E501
            query_params.append(('write_protect', local_var_params['write_protect']))  # noqa: E501
        if 'mounted' in local_var_params and local_var_params['mounted'] is not None:  # noqa: E501
            query_params.append(('mounted', local_var_params['mounted']))  # noqa: E501
        if 'ejected' in local_var_params and local_var_params['ejected'] is not None:  # noqa: E501
            query_params.append(('ejected', local_var_params['ejected']))  # noqa: E501
        if 'known' in local_var_params and local_var_params['known'] is not None:  # noqa: E501
            query_params.append(('known', local_var_params['known']))  # noqa: E501
        if 'mount_count' in local_var_params and local_var_params['mount_count'] is not None:  # noqa: E501
            query_params.append(('mount_count', local_var_params['mount_count']))  # noqa: E501
        if 'date_in' in local_var_params and local_var_params['date_in'] is not None:  # noqa: E501
            query_params.append(('date_in', local_var_params['date_in']))  # noqa: E501
        if 'date_move' in local_var_params and local_var_params['date_move'] is not None:  # noqa: E501
            query_params.append(('date_move', local_var_params['date_move']))  # noqa: E501
        if 'free' in local_var_params and local_var_params['free'] is not None:  # noqa: E501
            query_params.append(('free', local_var_params['free']))  # noqa: E501
        if 'max' in local_var_params and local_var_params['max'] is not None:  # noqa: E501
            query_params.append(('max', local_var_params['max']))  # noqa: E501
        if 'last_size_update' in local_var_params and local_var_params['last_size_update'] is not None:  # noqa: E501
            query_params.append(('last_size_update', local_var_params['last_size_update']))  # noqa: E501
        if 'last_maintenance' in local_var_params and local_var_params['last_maintenance'] is not None:  # noqa: E501
            query_params.append(('last_maintenance', local_var_params['last_maintenance']))  # noqa: E501
        if 'last_repack' in local_var_params and local_var_params['last_repack'] is not None:  # noqa: E501
            query_params.append(('last_repack', local_var_params['last_repack']))  # noqa: E501
        if 'repack_status' in local_var_params and local_var_params['repack_status'] is not None:  # noqa: E501
            query_params.append(('repack_status', local_var_params['repack_status']))  # noqa: E501
        if 'hash' in local_var_params and local_var_params['hash'] is not None:  # noqa: E501
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
        if 'force_import_type' in local_var_params and local_var_params['force_import_type'] is not None:  # noqa: E501
            query_params.append(('force_import_type', local_var_params['force_import_type']))  # noqa: E501
        if 'need_to_check' in local_var_params and local_var_params['need_to_check'] is not None:  # noqa: E501
            query_params.append(('need_to_check', local_var_params['need_to_check']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mount_status_tape(self, **kwargs):  # noqa: E501
        """Get mount status of Tape.  # noqa: E501

        **API Key Scope**: tapes / mount_status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mount_status_tape(tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.mount_status_tape_with_http_info(**kwargs)  # noqa: E501

    def mount_status_tape_with_http_info(self, **kwargs):  # noqa: E501
        """Get mount status of Tape.  # noqa: E501

        **API Key Scope**: tapes / mount_status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mount_status_tape_with_http_info(tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MountStatus, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mount_status_tape" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `mount_status_tape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tapes/{tape_id}/mount', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MountStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mount_status_tape_by_pool(self, **kwargs):  # noqa: E501
        """Get mount status of Tape.  # noqa: E501

        **API Key Scope**: tapes / mount_status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mount_status_tape_by_pool(pool_id=pool_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.mount_status_tape_by_pool_with_http_info(**kwargs)  # noqa: E501

    def mount_status_tape_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Get mount status of Tape.  # noqa: E501

        **API Key Scope**: tapes / mount_status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mount_status_tape_by_pool_with_http_info(pool_id=pool_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MountStatus, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mount_status_tape_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `mount_status_tape_by_pool`")  # noqa: E501
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `mount_status_tape_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/tapes/{tape_id}/mount', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MountStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mount_status_tape_by_tape_library(self, **kwargs):  # noqa: E501
        """Get mount status of Tape.  # noqa: E501

        **API Key Scope**: tapes / mount_status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mount_status_tape_by_tape_library(tape_library_id=tape_library_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.mount_status_tape_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def mount_status_tape_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Get mount status of Tape.  # noqa: E501

        **API Key Scope**: tapes / mount_status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mount_status_tape_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MountStatus, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mount_status_tape_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `mount_status_tape_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `mount_status_tape_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tapes/{tape_id}/mount', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MountStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape(self, **kwargs):  # noqa: E501
        """Displays a specific tape.  # noqa: E501

        **API Key Scope**: tapes / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape(tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Tape
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_with_http_info(**kwargs)  # noqa: E501

    def show_tape_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific tape.  # noqa: E501

        **API Key Scope**: tapes / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_with_http_info(tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Tape, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `show_tape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tapes/{tape_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tape',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape_by_pool(self, **kwargs):  # noqa: E501
        """Displays a specific tape.  # noqa: E501

        **API Key Scope**: tapes / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_by_pool(pool_id=pool_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Tape
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_by_pool_with_http_info(**kwargs)  # noqa: E501

    def show_tape_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific tape.  # noqa: E501

        **API Key Scope**: tapes / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_by_pool_with_http_info(pool_id=pool_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Tape, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `show_tape_by_pool`")  # noqa: E501
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `show_tape_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/tapes/{tape_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tape',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape_by_tape_library(self, **kwargs):  # noqa: E501
        """Displays a specific tape.  # noqa: E501

        **API Key Scope**: tapes / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_by_tape_library(tape_library_id=tape_library_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Tape
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def show_tape_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific tape.  # noqa: E501

        **API Key Scope**: tapes / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Tape, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `show_tape_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `show_tape_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tapes/{tape_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tape',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape_stat(self, **kwargs):  # noqa: E501
        """Display statistic for a specific tape.  # noqa: E501

        **API Key Scope**: tape_stats / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_stat(tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeStat
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_stat_with_http_info(**kwargs)  # noqa: E501

    def show_tape_stat_with_http_info(self, **kwargs):  # noqa: E501
        """Display statistic for a specific tape.  # noqa: E501

        **API Key Scope**: tape_stats / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_stat_with_http_info(tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeStat, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape_stat" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `show_tape_stat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tapes/{tape_id}/tape_stat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeStat',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape_stat_by_pool(self, **kwargs):  # noqa: E501
        """Display statistic for a specific tape.  # noqa: E501

        **API Key Scope**: tape_stats / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_stat_by_pool(pool_id=pool_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeStat
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_stat_by_pool_with_http_info(**kwargs)  # noqa: E501

    def show_tape_stat_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Display statistic for a specific tape.  # noqa: E501

        **API Key Scope**: tape_stats / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_stat_by_pool_with_http_info(pool_id=pool_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeStat, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape_stat_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `show_tape_stat_by_pool`")  # noqa: E501
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `show_tape_stat_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/tapes/{tape_id}/tape_stat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeStat',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape_stat_by_tape_library(self, **kwargs):  # noqa: E501
        """Display statistic for a specific tape.  # noqa: E501

        **API Key Scope**: tape_stats / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_stat_by_tape_library(tape_library_id=tape_library_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeStat
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_stat_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def show_tape_stat_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Display statistic for a specific tape.  # noqa: E501

        **API Key Scope**: tape_stats / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_stat_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, tape_id=tape_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_id: Numeric ID, or barcode of tape. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeStat, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'tape_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape_stat_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `show_tape_stat_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_id' is set
        if self.api_client.client_side_validation and ('tape_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_id` when calling `show_tape_stat_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501
        if 'tape_id' in local_var_params:
            path_params['tape_id'] = local_var_params['tape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tapes/{tape_id}/tape_stat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeStat',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
