# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nodeum_sdk.api_client import ApiClient
from nodeum_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TapeDrivesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_tape_drive_by_tape_library(self, **kwargs):  # noqa: E501
        """Creates a new tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tape_drive_by_tape_library(tape_library_id=tape_library_id_value, tape_drive_body=tape_drive_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param TapeDrive tape_drive_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_tape_drive_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def create_tape_drive_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a new tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tape_drive_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, tape_drive_body=tape_drive_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param TapeDrive tape_drive_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDrive, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'tape_drive_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tape_drive_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `create_tape_drive_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_drive_body' is set
        if self.api_client.client_side_validation and ('tape_drive_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_body` when calling `create_tape_drive_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tape_drive_body' in local_var_params:
            body_params = local_var_params['tape_drive_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tape_drives', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDrive',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_tape_drive(self, **kwargs):  # noqa: E501
        """Destroys a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_tape_drive(tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_tape_drive_with_http_info(**kwargs)  # noqa: E501

    def destroy_tape_drive_with_http_info(self, **kwargs):  # noqa: E501
        """Destroys a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_tape_drive_with_http_info(tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_drive_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_tape_drive" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_drive_id' is set
        if self.api_client.client_side_validation and ('tape_drive_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_id` when calling `destroy_tape_drive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_drive_id' in local_var_params:
            path_params['tape_drive_id'] = local_var_params['tape_drive_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_drives/{tape_drive_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_tape_drive_by_tape_library(self, **kwargs):  # noqa: E501
        """Destroys a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_tape_drive_by_tape_library(tape_library_id=tape_library_id_value, tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_tape_drive_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def destroy_tape_drive_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Destroys a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_tape_drive_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'tape_drive_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_tape_drive_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `destroy_tape_drive_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_drive_id' is set
        if self.api_client.client_side_validation and ('tape_drive_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_id` when calling `destroy_tape_drive_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501
        if 'tape_drive_id' in local_var_params:
            path_params['tape_drive_id'] = local_var_params['tape_drive_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tape_drives/{tape_drive_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tape_drive_devices(self, **kwargs):  # noqa: E501
        """Lists tape drives devices.  # noqa: E501

        **API Key Scope**: tape_drives / devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_drive_devices(tape_library_id=tape_library_id_value, job_id=job_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str job_id: ID of active job (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDriveDeviceCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tape_drive_devices_with_http_info(**kwargs)  # noqa: E501

    def index_tape_drive_devices_with_http_info(self, **kwargs):  # noqa: E501
        """Lists tape drives devices.  # noqa: E501

        **API Key Scope**: tape_drives / devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_drive_devices_with_http_info(tape_library_id=tape_library_id_value, job_id=job_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str job_id: ID of active job (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDriveDeviceCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tape_drive_devices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `index_tape_drive_devices`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `index_tape_drive_devices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501

        query_params = []
        if 'job_id' in local_var_params and local_var_params['job_id'] is not None:  # noqa: E501
            query_params.append(('job_id', local_var_params['job_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'queued', 'working', 'failed', ])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tape_drives/-/devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDriveDeviceCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tape_drives(self, **kwargs):  # noqa: E501
        """Lists all tape drives.  # noqa: E501

        **API Key Scope**: tape_drives / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_drives(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str tape_library_id: Filter on tape library id
        :param str name: Filter on name
        :param str serial: Filter on serial
        :param str comment: Filter on comment
        :param str scsi_address: Filter on scsi address
        :param str vendor: Filter on vendor
        :param str product: Filter on product
        :param str firmware: Filter on firmware
        :param str device: Filter on device
        :param str sgdevice: Filter on sgdevice
        :param str libso: Filter on libso
        :param str acs: Filter on acs
        :param str lsm: Filter on lsm
        :param str panel: Filter on panel
        :param str transport: Filter on transport
        :param str status: Filter on status
        :param str full: Filter on full
        :param str mount_count: Filter on mount count
        :param str use_to: Filter on use to
        :param str use_by: Filter on use by
        :param str barcode: Filter on barcode
        :param str task_id: Filter on task id
        :param str use_file_processed_size: Filter on use file processed size
        :param str use_file_size_to_process: Filter on use file size to process
        :param str use_file_name_processed: Filter on use file name processed
        :param str bandwidth: Filter on bandwidth
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDriveCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tape_drives_with_http_info(**kwargs)  # noqa: E501

    def index_tape_drives_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all tape drives.  # noqa: E501

        **API Key Scope**: tape_drives / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_drives_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str tape_library_id: Filter on tape library id
        :param str name: Filter on name
        :param str serial: Filter on serial
        :param str comment: Filter on comment
        :param str scsi_address: Filter on scsi address
        :param str vendor: Filter on vendor
        :param str product: Filter on product
        :param str firmware: Filter on firmware
        :param str device: Filter on device
        :param str sgdevice: Filter on sgdevice
        :param str libso: Filter on libso
        :param str acs: Filter on acs
        :param str lsm: Filter on lsm
        :param str panel: Filter on panel
        :param str transport: Filter on transport
        :param str status: Filter on status
        :param str full: Filter on full
        :param str mount_count: Filter on mount count
        :param str use_to: Filter on use to
        :param str use_by: Filter on use by
        :param str barcode: Filter on barcode
        :param str task_id: Filter on task id
        :param str use_file_processed_size: Filter on use file processed size
        :param str use_file_size_to_process: Filter on use file size to process
        :param str use_file_name_processed: Filter on use file name processed
        :param str bandwidth: Filter on bandwidth
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDriveCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset',
            'sort_by',
            'id',
            'tape_library_id',
            'name',
            'serial',
            'comment',
            'scsi_address',
            'vendor',
            'product',
            'firmware',
            'device',
            'sgdevice',
            'libso',
            'acs',
            'lsm',
            'panel',
            'transport',
            'status',
            'full',
            'mount_count',
            'use_to',
            'use_by',
            'barcode',
            'task_id',
            'use_file_processed_size',
            'use_file_size_to_process',
            'use_file_name_processed',
            'bandwidth'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tape_drives" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'tape_library_id' in local_var_params and local_var_params['tape_library_id'] is not None:  # noqa: E501
            query_params.append(('tape_library_id', local_var_params['tape_library_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'serial' in local_var_params and local_var_params['serial'] is not None:  # noqa: E501
            query_params.append(('serial', local_var_params['serial']))  # noqa: E501
        if 'comment' in local_var_params and local_var_params['comment'] is not None:  # noqa: E501
            query_params.append(('comment', local_var_params['comment']))  # noqa: E501
        if 'scsi_address' in local_var_params and local_var_params['scsi_address'] is not None:  # noqa: E501
            query_params.append(('scsi_address', local_var_params['scsi_address']))  # noqa: E501
        if 'vendor' in local_var_params and local_var_params['vendor'] is not None:  # noqa: E501
            query_params.append(('vendor', local_var_params['vendor']))  # noqa: E501
        if 'product' in local_var_params and local_var_params['product'] is not None:  # noqa: E501
            query_params.append(('product', local_var_params['product']))  # noqa: E501
        if 'firmware' in local_var_params and local_var_params['firmware'] is not None:  # noqa: E501
            query_params.append(('firmware', local_var_params['firmware']))  # noqa: E501
        if 'device' in local_var_params and local_var_params['device'] is not None:  # noqa: E501
            query_params.append(('device', local_var_params['device']))  # noqa: E501
        if 'sgdevice' in local_var_params and local_var_params['sgdevice'] is not None:  # noqa: E501
            query_params.append(('sgdevice', local_var_params['sgdevice']))  # noqa: E501
        if 'libso' in local_var_params and local_var_params['libso'] is not None:  # noqa: E501
            query_params.append(('libso', local_var_params['libso']))  # noqa: E501
        if 'acs' in local_var_params and local_var_params['acs'] is not None:  # noqa: E501
            query_params.append(('acs', local_var_params['acs']))  # noqa: E501
        if 'lsm' in local_var_params and local_var_params['lsm'] is not None:  # noqa: E501
            query_params.append(('lsm', local_var_params['lsm']))  # noqa: E501
        if 'panel' in local_var_params and local_var_params['panel'] is not None:  # noqa: E501
            query_params.append(('panel', local_var_params['panel']))  # noqa: E501
        if 'transport' in local_var_params and local_var_params['transport'] is not None:  # noqa: E501
            query_params.append(('transport', local_var_params['transport']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'full' in local_var_params and local_var_params['full'] is not None:  # noqa: E501
            query_params.append(('full', local_var_params['full']))  # noqa: E501
        if 'mount_count' in local_var_params and local_var_params['mount_count'] is not None:  # noqa: E501
            query_params.append(('mount_count', local_var_params['mount_count']))  # noqa: E501
        if 'use_to' in local_var_params and local_var_params['use_to'] is not None:  # noqa: E501
            query_params.append(('use_to', local_var_params['use_to']))  # noqa: E501
        if 'use_by' in local_var_params and local_var_params['use_by'] is not None:  # noqa: E501
            query_params.append(('use_by', local_var_params['use_by']))  # noqa: E501
        if 'barcode' in local_var_params and local_var_params['barcode'] is not None:  # noqa: E501
            query_params.append(('barcode', local_var_params['barcode']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('task_id', local_var_params['task_id']))  # noqa: E501
        if 'use_file_processed_size' in local_var_params and local_var_params['use_file_processed_size'] is not None:  # noqa: E501
            query_params.append(('use_file_processed_size', local_var_params['use_file_processed_size']))  # noqa: E501
        if 'use_file_size_to_process' in local_var_params and local_var_params['use_file_size_to_process'] is not None:  # noqa: E501
            query_params.append(('use_file_size_to_process', local_var_params['use_file_size_to_process']))  # noqa: E501
        if 'use_file_name_processed' in local_var_params and local_var_params['use_file_name_processed'] is not None:  # noqa: E501
            query_params.append(('use_file_name_processed', local_var_params['use_file_name_processed']))  # noqa: E501
        if 'bandwidth' in local_var_params and local_var_params['bandwidth'] is not None:  # noqa: E501
            query_params.append(('bandwidth', local_var_params['bandwidth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_drives', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDriveCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tape_drives_by_tape_library(self, **kwargs):  # noqa: E501
        """Lists all tape drives.  # noqa: E501

        **API Key Scope**: tape_drives / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_drives_by_tape_library(tape_library_id=tape_library_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str serial: Filter on serial
        :param str comment: Filter on comment
        :param str scsi_address: Filter on scsi address
        :param str vendor: Filter on vendor
        :param str product: Filter on product
        :param str firmware: Filter on firmware
        :param str device: Filter on device
        :param str sgdevice: Filter on sgdevice
        :param str libso: Filter on libso
        :param str acs: Filter on acs
        :param str lsm: Filter on lsm
        :param str panel: Filter on panel
        :param str transport: Filter on transport
        :param str status: Filter on status
        :param str full: Filter on full
        :param str mount_count: Filter on mount count
        :param str use_to: Filter on use to
        :param str use_by: Filter on use by
        :param str barcode: Filter on barcode
        :param str task_id: Filter on task id
        :param str use_file_processed_size: Filter on use file processed size
        :param str use_file_size_to_process: Filter on use file size to process
        :param str use_file_name_processed: Filter on use file name processed
        :param str bandwidth: Filter on bandwidth
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDriveCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tape_drives_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def index_tape_drives_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all tape drives.  # noqa: E501

        **API Key Scope**: tape_drives / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tape_drives_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str serial: Filter on serial
        :param str comment: Filter on comment
        :param str scsi_address: Filter on scsi address
        :param str vendor: Filter on vendor
        :param str product: Filter on product
        :param str firmware: Filter on firmware
        :param str device: Filter on device
        :param str sgdevice: Filter on sgdevice
        :param str libso: Filter on libso
        :param str acs: Filter on acs
        :param str lsm: Filter on lsm
        :param str panel: Filter on panel
        :param str transport: Filter on transport
        :param str status: Filter on status
        :param str full: Filter on full
        :param str mount_count: Filter on mount count
        :param str use_to: Filter on use to
        :param str use_by: Filter on use by
        :param str barcode: Filter on barcode
        :param str task_id: Filter on task id
        :param str use_file_processed_size: Filter on use file processed size
        :param str use_file_size_to_process: Filter on use file size to process
        :param str use_file_name_processed: Filter on use file name processed
        :param str bandwidth: Filter on bandwidth
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDriveCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'limit',
            'offset',
            'sort_by',
            'id',
            'name',
            'serial',
            'comment',
            'scsi_address',
            'vendor',
            'product',
            'firmware',
            'device',
            'sgdevice',
            'libso',
            'acs',
            'lsm',
            'panel',
            'transport',
            'status',
            'full',
            'mount_count',
            'use_to',
            'use_by',
            'barcode',
            'task_id',
            'use_file_processed_size',
            'use_file_size_to_process',
            'use_file_name_processed',
            'bandwidth'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tape_drives_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `index_tape_drives_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'serial' in local_var_params and local_var_params['serial'] is not None:  # noqa: E501
            query_params.append(('serial', local_var_params['serial']))  # noqa: E501
        if 'comment' in local_var_params and local_var_params['comment'] is not None:  # noqa: E501
            query_params.append(('comment', local_var_params['comment']))  # noqa: E501
        if 'scsi_address' in local_var_params and local_var_params['scsi_address'] is not None:  # noqa: E501
            query_params.append(('scsi_address', local_var_params['scsi_address']))  # noqa: E501
        if 'vendor' in local_var_params and local_var_params['vendor'] is not None:  # noqa: E501
            query_params.append(('vendor', local_var_params['vendor']))  # noqa: E501
        if 'product' in local_var_params and local_var_params['product'] is not None:  # noqa: E501
            query_params.append(('product', local_var_params['product']))  # noqa: E501
        if 'firmware' in local_var_params and local_var_params['firmware'] is not None:  # noqa: E501
            query_params.append(('firmware', local_var_params['firmware']))  # noqa: E501
        if 'device' in local_var_params and local_var_params['device'] is not None:  # noqa: E501
            query_params.append(('device', local_var_params['device']))  # noqa: E501
        if 'sgdevice' in local_var_params and local_var_params['sgdevice'] is not None:  # noqa: E501
            query_params.append(('sgdevice', local_var_params['sgdevice']))  # noqa: E501
        if 'libso' in local_var_params and local_var_params['libso'] is not None:  # noqa: E501
            query_params.append(('libso', local_var_params['libso']))  # noqa: E501
        if 'acs' in local_var_params and local_var_params['acs'] is not None:  # noqa: E501
            query_params.append(('acs', local_var_params['acs']))  # noqa: E501
        if 'lsm' in local_var_params and local_var_params['lsm'] is not None:  # noqa: E501
            query_params.append(('lsm', local_var_params['lsm']))  # noqa: E501
        if 'panel' in local_var_params and local_var_params['panel'] is not None:  # noqa: E501
            query_params.append(('panel', local_var_params['panel']))  # noqa: E501
        if 'transport' in local_var_params and local_var_params['transport'] is not None:  # noqa: E501
            query_params.append(('transport', local_var_params['transport']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'full' in local_var_params and local_var_params['full'] is not None:  # noqa: E501
            query_params.append(('full', local_var_params['full']))  # noqa: E501
        if 'mount_count' in local_var_params and local_var_params['mount_count'] is not None:  # noqa: E501
            query_params.append(('mount_count', local_var_params['mount_count']))  # noqa: E501
        if 'use_to' in local_var_params and local_var_params['use_to'] is not None:  # noqa: E501
            query_params.append(('use_to', local_var_params['use_to']))  # noqa: E501
        if 'use_by' in local_var_params and local_var_params['use_by'] is not None:  # noqa: E501
            query_params.append(('use_by', local_var_params['use_by']))  # noqa: E501
        if 'barcode' in local_var_params and local_var_params['barcode'] is not None:  # noqa: E501
            query_params.append(('barcode', local_var_params['barcode']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('task_id', local_var_params['task_id']))  # noqa: E501
        if 'use_file_processed_size' in local_var_params and local_var_params['use_file_processed_size'] is not None:  # noqa: E501
            query_params.append(('use_file_processed_size', local_var_params['use_file_processed_size']))  # noqa: E501
        if 'use_file_size_to_process' in local_var_params and local_var_params['use_file_size_to_process'] is not None:  # noqa: E501
            query_params.append(('use_file_size_to_process', local_var_params['use_file_size_to_process']))  # noqa: E501
        if 'use_file_name_processed' in local_var_params and local_var_params['use_file_name_processed'] is not None:  # noqa: E501
            query_params.append(('use_file_name_processed', local_var_params['use_file_name_processed']))  # noqa: E501
        if 'bandwidth' in local_var_params and local_var_params['bandwidth'] is not None:  # noqa: E501
            query_params.append(('bandwidth', local_var_params['bandwidth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tape_drives', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDriveCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape_drive(self, **kwargs):  # noqa: E501
        """Displays a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_drive(tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_drive_with_http_info(**kwargs)  # noqa: E501

    def show_tape_drive_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_drive_with_http_info(tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDrive, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_drive_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape_drive" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_drive_id' is set
        if self.api_client.client_side_validation and ('tape_drive_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_id` when calling `show_tape_drive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_drive_id' in local_var_params:
            path_params['tape_drive_id'] = local_var_params['tape_drive_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_drives/{tape_drive_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDrive',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_tape_drive_by_tape_library(self, **kwargs):  # noqa: E501
        """Displays a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_drive_by_tape_library(tape_library_id=tape_library_id_value, tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_tape_drive_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def show_tape_drive_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_tape_drive_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, tape_drive_id=tape_drive_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDrive, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'tape_drive_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_tape_drive_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `show_tape_drive_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_drive_id' is set
        if self.api_client.client_side_validation and ('tape_drive_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_id` when calling `show_tape_drive_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501
        if 'tape_drive_id' in local_var_params:
            path_params['tape_drive_id'] = local_var_params['tape_drive_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tape_drives/{tape_drive_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDrive',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tape_drive(self, **kwargs):  # noqa: E501
        """Updates a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tape_drive(tape_drive_id=tape_drive_id_value, tape_drive_body=tape_drive_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param TapeDrive tape_drive_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_tape_drive_with_http_info(**kwargs)  # noqa: E501

    def update_tape_drive_with_http_info(self, **kwargs):  # noqa: E501
        """Updates a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tape_drive_with_http_info(tape_drive_id=tape_drive_id_value, tape_drive_body=tape_drive_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param TapeDrive tape_drive_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDrive, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_drive_id',
            'tape_drive_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tape_drive" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_drive_id' is set
        if self.api_client.client_side_validation and ('tape_drive_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_id` when calling `update_tape_drive`")  # noqa: E501
        # verify the required parameter 'tape_drive_body' is set
        if self.api_client.client_side_validation and ('tape_drive_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_body` when calling `update_tape_drive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_drive_id' in local_var_params:
            path_params['tape_drive_id'] = local_var_params['tape_drive_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tape_drive_body' in local_var_params:
            body_params = local_var_params['tape_drive_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_drives/{tape_drive_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDrive',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tape_drive_by_tape_library(self, **kwargs):  # noqa: E501
        """Updates a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tape_drive_by_tape_library(tape_library_id=tape_library_id_value, tape_drive_id=tape_drive_id_value, tape_drive_body=tape_drive_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param TapeDrive tape_drive_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_tape_drive_by_tape_library_with_http_info(**kwargs)  # noqa: E501

    def update_tape_drive_by_tape_library_with_http_info(self, **kwargs):  # noqa: E501
        """Updates a specific tape drive.  # noqa: E501

        **API Key Scope**: tape_drives / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tape_drive_by_tape_library_with_http_info(tape_library_id=tape_library_id_value, tape_drive_id=tape_drive_id_value, tape_drive_body=tape_drive_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tape_library_id: Numeric ID, serial, or name of tape library. (required)
        :param str tape_drive_id: Numeric ID, serial, or name of tape drive. (required)
        :param TapeDrive tape_drive_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeDrive, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tape_library_id',
            'tape_drive_id',
            'tape_drive_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tape_drive_by_tape_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tape_library_id' is set
        if self.api_client.client_side_validation and ('tape_library_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_library_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_library_id` when calling `update_tape_drive_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_drive_id' is set
        if self.api_client.client_side_validation and ('tape_drive_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_id` when calling `update_tape_drive_by_tape_library`")  # noqa: E501
        # verify the required parameter 'tape_drive_body' is set
        if self.api_client.client_side_validation and ('tape_drive_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['tape_drive_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tape_drive_body` when calling `update_tape_drive_by_tape_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tape_library_id' in local_var_params:
            path_params['tape_library_id'] = local_var_params['tape_library_id']  # noqa: E501
        if 'tape_drive_id' in local_var_params:
            path_params['tape_drive_id'] = local_var_params['tape_drive_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tape_drive_body' in local_var_params:
            body_params = local_var_params['tape_drive_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tape_libraries/{tape_library_id}/tape_drives/{tape_drive_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeDrive',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
