# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nodeum_sdk.api_client import ApiClient
from nodeum_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def files_children(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children(file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_children_with_http_info(**kwargs)  # noqa: E501

    def files_children_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_with_http_info(file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'file_parent_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_children" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `files_children`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_children_by_container(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_container(container_id=container_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_children_by_container_with_http_info(**kwargs)  # noqa: E501

    def files_children_by_container_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_container_with_http_info(container_id=container_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'file_parent_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_children_by_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `files_children_by_container`")  # noqa: E501
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `files_children_by_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_children_by_pool(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_pool(pool_id=pool_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_children_by_pool_with_http_info(**kwargs)  # noqa: E501

    def files_children_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_pool_with_http_info(pool_id=pool_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'file_parent_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_children_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `files_children_by_pool`")  # noqa: E501
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `files_children_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_children_by_task(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_task(task_id=task_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_children_by_task_with_http_info(**kwargs)  # noqa: E501

    def files_children_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_task_with_http_info(task_id=task_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'file_parent_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_children_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `files_children_by_task`")  # noqa: E501
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `files_children_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_children_by_task_execution(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_task_execution(task_execution_id=task_execution_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_children_by_task_execution_with_http_info(**kwargs)  # noqa: E501

    def files_children_by_task_execution_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_task_execution_with_http_info(task_execution_id=task_execution_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_execution_id',
            'file_parent_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_children_by_task_execution" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `files_children_by_task_execution`")  # noqa: E501
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `files_children_by_task_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task_executions/{task_execution_id}/files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_children_by_task_execution_by_task(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_task_execution_by_task(task_id=task_id_value, task_execution_id=task_execution_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_children_by_task_execution_by_task_with_http_info(**kwargs)  # noqa: E501

    def files_children_by_task_execution_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_children_by_task_execution_by_task_with_http_info(task_id=task_id_value, task_execution_id=task_execution_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_execution_id',
            'file_parent_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_children_by_task_execution_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `files_children_by_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `files_children_by_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `files_children_by_task_execution_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/task_executions/{task_execution_id}/files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_files_children_by_pool(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder on tape of pools, specific for Data Exchange.  # noqa: E501

        **API Key Scope**: import_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_files_children_by_pool(pool_id=pool_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.import_files_children_by_pool_with_http_info(**kwargs)  # noqa: E501

    def import_files_children_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder on tape of pools, specific for Data Exchange.  # noqa: E501

        **API Key Scope**: import_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_files_children_by_pool_with_http_info(pool_id=pool_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'file_parent_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_files_children_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `import_files_children_by_pool`")  # noqa: E501
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `import_files_children_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/import_files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_files(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_files_with_http_info(**kwargs)  # noqa: E501

    def index_files_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_files" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_files_by_container(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_container(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_files_by_container_with_http_info(**kwargs)  # noqa: E501

    def index_files_by_container_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_container_with_http_info(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_files_by_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `index_files_by_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_files_by_pool(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_pool(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_files_by_pool_with_http_info(**kwargs)  # noqa: E501

    def index_files_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_pool_with_http_info(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_files_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `index_files_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_files_by_task(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_task(task_id=task_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_files_by_task_with_http_info(**kwargs)  # noqa: E501

    def index_files_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_task_with_http_info(task_id=task_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_files_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `index_files_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_files_by_task_execution(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_task_execution(task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_files_by_task_execution_with_http_info(**kwargs)  # noqa: E501

    def index_files_by_task_execution_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_task_execution_with_http_info(task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_execution_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_files_by_task_execution" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `index_files_by_task_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task_executions/{task_execution_id}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_files_by_task_execution_by_task(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_task_execution_by_task(task_id=task_id_value, task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_files_by_task_execution_by_task_with_http_info(**kwargs)  # noqa: E501

    def index_files_by_task_execution_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root.  # noqa: E501

        **API Key Scope**: files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_files_by_task_execution_by_task_with_http_info(task_id=task_id_value, task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_execution_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_files_by_task_execution_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `index_files_by_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `index_files_by_task_execution_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/task_executions/{task_execution_id}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_import_files_by_pool(self, **kwargs):  # noqa: E501
        """Lists files on root of tape of pools, specific for Data Exchange.  # noqa: E501

        **API Key Scope**: import_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_import_files_by_pool(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_import_files_by_pool_with_http_info(**kwargs)  # noqa: E501

    def index_import_files_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root of tape of pools, specific for Data Exchange.  # noqa: E501

        **API Key Scope**: import_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_import_files_by_pool_with_http_info(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str file_id: Filter on file id
        :param str name: Filter on name
        :param str type: Filter on type
        :param str permission: Filter on permission
        :param str size: Filter on size
        :param str change_date: Filter on change date
        :param str modification_date: Filter on modification date
        :param str access_date: Filter on access date
        :param str gid: Filter on gid
        :param str uid: Filter on uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'limit',
            'offset',
            'file_id',
            'name',
            'type',
            'permission',
            'size',
            'change_date',
            'modification_date',
            'access_date',
            'gid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_import_files_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `index_import_files_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'file_id' in local_var_params and local_var_params['file_id'] is not None:  # noqa: E501
            query_params.append(('file_id', local_var_params['file_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'permission' in local_var_params and local_var_params['permission'] is not None:  # noqa: E501
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'change_date' in local_var_params and local_var_params['change_date'] is not None:  # noqa: E501
            query_params.append(('change_date', local_var_params['change_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'access_date' in local_var_params and local_var_params['access_date'] is not None:  # noqa: E501
            query_params.append(('access_date', local_var_params['access_date']))  # noqa: E501
        if 'gid' in local_var_params and local_var_params['gid'] is not None:  # noqa: E501
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/import_files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_on_tapes_files_by_pool(self, **kwargs):  # noqa: E501
        """Lists files on root of tape of pools, specific for Active and Offline.  # noqa: E501

        **API Key Scope**: on_tapes_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_on_tapes_files_by_pool(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str name: Filter on name
        :param str type: Filter on type
        :param str size: Filter on size
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OnTapesFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_on_tapes_files_by_pool_with_http_info(**kwargs)  # noqa: E501

    def index_on_tapes_files_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files on root of tape of pools, specific for Active and Offline.  # noqa: E501

        **API Key Scope**: on_tapes_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_on_tapes_files_by_pool_with_http_info(pool_id=pool_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str name: Filter on name
        :param str type: Filter on type
        :param str size: Filter on size
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OnTapesFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'limit',
            'offset',
            'name',
            'type',
            'size'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_on_tapes_files_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `index_on_tapes_files_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/on_tapes_files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OnTapesFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tapes_by_file_by_pool(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific pool.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_pool(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tapes_by_file_by_pool_with_http_info(**kwargs)  # noqa: E501

    def index_tapes_by_file_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific pool.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_pool_with_http_info(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tapes_by_file_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `index_tapes_by_file_by_pool`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `index_tapes_by_file_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/files/{file_id}/tapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tapes_by_file_by_task(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific task.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_task(task_id=task_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tapes_by_file_by_task_with_http_info(**kwargs)  # noqa: E501

    def index_tapes_by_file_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific task.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_task_with_http_info(task_id=task_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tapes_by_file_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `index_tapes_by_file_by_task`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `index_tapes_by_file_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/files/{file_id}/tapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tapes_by_file_by_task_execution(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific task.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_task_execution(task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tapes_by_file_by_task_execution_with_http_info(**kwargs)  # noqa: E501

    def index_tapes_by_file_by_task_execution_with_http_info(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific task.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_task_execution_with_http_info(task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_execution_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tapes_by_file_by_task_execution" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `index_tapes_by_file_by_task_execution`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `index_tapes_by_file_by_task_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task_executions/{task_execution_id}/files/{file_id}/tapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_tapes_by_file_by_task_execution_by_task(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific task.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_task_execution_by_task(task_id=task_id_value, task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TapeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_tapes_by_file_by_task_execution_by_task_with_http_info(**kwargs)  # noqa: E501

    def index_tapes_by_file_by_task_execution_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Displays tapes containing specific file, related to the specific task.  # noqa: E501

        **API Key Scope**: files / tapes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_tapes_by_file_by_task_execution_by_task_with_http_info(task_id=task_id_value, task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TapeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_execution_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_tapes_by_file_by_task_execution_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `index_tapes_by_file_by_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `index_tapes_by_file_by_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `index_tapes_by_file_by_task_execution_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/task_executions/{task_execution_id}/files/{file_id}/tapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TapeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def on_tapes_files_children_by_pool(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder on tape of pools, specific for Active and Offline.  # noqa: E501

        **API Key Scope**: on_tapes_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.on_tapes_files_children_by_pool(pool_id=pool_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str name: Filter on name
        :param str type: Filter on type
        :param str size: Filter on size
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OnTapesFileCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.on_tapes_files_children_by_pool_with_http_info(**kwargs)  # noqa: E501

    def on_tapes_files_children_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Lists files under a specific folder on tape of pools, specific for Active and Offline.  # noqa: E501

        **API Key Scope**: on_tapes_files / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.on_tapes_files_children_by_pool_with_http_info(pool_id=pool_id_value, file_parent_id=file_parent_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_parent_id: Numeric ID of parent folder. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param str name: Filter on name
        :param str type: Filter on type
        :param str size: Filter on size
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OnTapesFileCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'file_parent_id',
            'limit',
            'offset',
            'name',
            'type',
            'size'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method on_tapes_files_children_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `on_tapes_files_children_by_pool`")  # noqa: E501
        # verify the required parameter 'file_parent_id' is set
        if self.api_client.client_side_validation and ('file_parent_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_parent_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_parent_id` when calling `on_tapes_files_children_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'file_parent_id' in local_var_params:
            path_params['file_parent_id'] = local_var_params['file_parent_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/on_tapes_files/{file_parent_id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OnTapesFileCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_file(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file(file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileWithPath
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_file_with_http_info(**kwargs)  # noqa: E501

    def show_file_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_with_http_info(file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileWithPath, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileWithPath',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_file_by_container(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_container(container_id=container_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileWithPath
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_file_by_container_with_http_info(**kwargs)  # noqa: E501

    def show_file_by_container_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_container_with_http_info(container_id=container_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileWithPath, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_file_by_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `show_file_by_container`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_file_by_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileWithPath',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_file_by_pool(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_pool(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileWithPath
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_file_by_pool_with_http_info(**kwargs)  # noqa: E501

    def show_file_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_pool_with_http_info(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileWithPath, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_file_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `show_file_by_pool`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_file_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileWithPath',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_file_by_task(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_task(task_id=task_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileWithPath
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_file_by_task_with_http_info(**kwargs)  # noqa: E501

    def show_file_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_task_with_http_info(task_id=task_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileWithPath, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_file_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `show_file_by_task`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_file_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileWithPath',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_file_by_task_execution(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_task_execution(task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileWithPath
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_file_by_task_execution_with_http_info(**kwargs)  # noqa: E501

    def show_file_by_task_execution_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_task_execution_with_http_info(task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileWithPath, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_execution_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_file_by_task_execution" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `show_file_by_task_execution`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_file_by_task_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task_executions/{task_execution_id}/files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileWithPath',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_file_by_task_execution_by_task(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_task_execution_by_task(task_id=task_id_value, task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NodeumFileWithPath
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_file_by_task_execution_by_task_with_http_info(**kwargs)  # noqa: E501

    def show_file_by_task_execution_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file.  # noqa: E501

        **API Key Scope**: files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_file_by_task_execution_by_task_with_http_info(task_id=task_id_value, task_execution_id=task_execution_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NodeumFileWithPath, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_execution_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_file_by_task_execution_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `show_file_by_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `show_file_by_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_file_by_task_execution_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/task_executions/{task_execution_id}/files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeumFileWithPath',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_import_file_by_pool(self, **kwargs):  # noqa: E501
        """Displays a specific file on tape of pools, specific for Data Exchange.  # noqa: E501

        **API Key Scope**: import_files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_import_file_by_pool(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportFileWithPath
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_import_file_by_pool_with_http_info(**kwargs)  # noqa: E501

    def show_import_file_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file on tape of pools, specific for Data Exchange.  # noqa: E501

        **API Key Scope**: import_files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_import_file_by_pool_with_http_info(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportFileWithPath, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_import_file_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `show_import_file_by_pool`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_import_file_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/import_files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportFileWithPath',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_on_tape_file_by_pool(self, **kwargs):  # noqa: E501
        """Displays a specific file on tape of pools, specific for Active and Offline.  # noqa: E501

        **API Key Scope**: on_tapes_files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_on_tape_file_by_pool(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OnTapesFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_on_tape_file_by_pool_with_http_info(**kwargs)  # noqa: E501

    def show_on_tape_file_by_pool_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific file on tape of pools, specific for Active and Offline.  # noqa: E501

        **API Key Scope**: on_tapes_files / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_on_tape_file_by_pool_with_http_info(pool_id=pool_id_value, file_id=file_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str pool_id: Numeric ID, or name of pool. (required)
        :param int file_id: Numeric ID of file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OnTapesFile, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pool_id',
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_on_tape_file_by_pool" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pool_id' is set
        if self.api_client.client_side_validation and ('pool_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pool_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pool_id` when calling `show_on_tape_file_by_pool`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `show_on_tape_file_by_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pool_id' in local_var_params:
            path_params['pool_id'] = local_var_params['pool_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file_id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pools/{pool_id}/on_tapes_files/{file_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OnTapesFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
