"""Contains all the data models used in inputs/outputs"""

from .account_connect_link import AccountConnectLink
from .create_guild import CreateGuild
from .create_match import CreateMatch
from .create_match_cvars import CreateMatchCvars
from .discord_user import DiscordUser
from .guild import Guild
from .interaction_user import InteractionUser
from .map_ import Map
from .map_ban import MapBan
from .map_sides_enum import MapSidesEnum
from .match import Match
from .match_ban_map import MatchBanMap
from .match_ban_map_result import MatchBanMapResult
from .match_config import MatchConfig
from .match_config_cvars import MatchConfigCvars
from .match_config_team_1 import MatchConfigTeam1
from .match_config_team_2 import MatchConfigTeam2
from .match_map_selected import MatchMapSelected
from .match_pick_map import MatchPickMap
from .match_pick_map_result import MatchPickMapResult
from .match_type_enum import MatchTypeEnum
from .match_update import MatchUpdate
from .match_update_cvars import MatchUpdateCvars
from .paginated_discord_user_list import PaginatedDiscordUserList
from .paginated_guild_list import PaginatedGuildList
from .paginated_map_ban_list import PaginatedMapBanList
from .paginated_map_list import PaginatedMapList
from .paginated_match_list import PaginatedMatchList
from .paginated_match_map_selected_list import PaginatedMatchMapSelectedList
from .paginated_player_list import PaginatedPlayerList
from .paginated_server_list import PaginatedServerList
from .paginated_steam_user_list import PaginatedSteamUserList
from .paginated_team_list import PaginatedTeamList
from .patched_discord_user import PatchedDiscordUser
from .patched_guild import PatchedGuild
from .patched_map import PatchedMap
from .patched_match import PatchedMatch
from .patched_player import PatchedPlayer
from .patched_server import PatchedServer
from .patched_steam_user import PatchedSteamUser
from .player import Player
from .schema_retrieve_lang import SchemaRetrieveLang
from .schema_retrieve_response_200 import SchemaRetrieveResponse200
from .server import Server
from .status_enum import StatusEnum
from .steam_user import SteamUser
from .team import Team
from .type_enum import TypeEnum
from .update_guild import UpdateGuild
from .user import User

__all__ = (
    "AccountConnectLink",
    "CreateGuild",
    "CreateMatch",
    "CreateMatchCvars",
    "DiscordUser",
    "Guild",
    "InteractionUser",
    "Map",
    "MapBan",
    "MapSidesEnum",
    "Match",
    "MatchBanMap",
    "MatchBanMapResult",
    "MatchConfig",
    "MatchConfigCvars",
    "MatchConfigTeam1",
    "MatchConfigTeam2",
    "MatchMapSelected",
    "MatchPickMap",
    "MatchPickMapResult",
    "MatchTypeEnum",
    "MatchUpdate",
    "MatchUpdateCvars",
    "PaginatedDiscordUserList",
    "PaginatedGuildList",
    "PaginatedMapBanList",
    "PaginatedMapList",
    "PaginatedMatchList",
    "PaginatedMatchMapSelectedList",
    "PaginatedPlayerList",
    "PaginatedServerList",
    "PaginatedSteamUserList",
    "PaginatedTeamList",
    "PatchedDiscordUser",
    "PatchedGuild",
    "PatchedMap",
    "PatchedMatch",
    "PatchedPlayer",
    "PatchedServer",
    "PatchedSteamUser",
    "Player",
    "SchemaRetrieveLang",
    "SchemaRetrieveResponse200",
    "Server",
    "StatusEnum",
    "SteamUser",
    "Team",
    "TypeEnum",
    "UpdateGuild",
    "User",
)
