from recombee_api_client.api_requests.request import Request
import uuid

DEFAULT = uuid.uuid4()

class AddSeries(Request):
    """
    Creates new series in the database.
    Required parameters:
    
    :param series_id: ID of the series to be created.
    

    """

    def __init__(self, series_id):
        self.series_id = series_id
        self.timeout = 1000
        self.ensure_https = False
        self.method = 'put'
        self.path = "/series/%s" % (self.series_id)

    def get_body_parameters(self):
        """
        Values of body parameters as a dictionary (name of parameter: value of the parameter).
        """
        p = dict()
        return p

    def get_query_parameters(self):
        """
        Values of query parameters as a dictionary (name of parameter: value of the parameter).
        """
        params = dict()
        return params
