import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IHostedZone } from '@aws-cdk/aws-route53';
import { Construct } from '@aws-cdk/core';
export interface HttpsRedirectProps {
    /**
     * HostedZone of the domain
     */
    readonly zone: IHostedZone;
    /**
     * The redirect target domain
     */
    readonly targetDomain: string;
    /**
     * The domain names to create that will redirect to `targetDomain`
     *
     * @default - the domain name of the zone
     */
    readonly recordNames?: string[];
    /**
     * The ACM certificate; Has to be in us-east-1
     *
     * @default - create a new certificate in us-east-1
     */
    readonly certificate?: ICertificate;
}
export declare class HttpsRedirect extends Construct {
    constructor(scope: Construct, id: string, props: HttpsRedirectProps);
}
