"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthFlow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk_lambda_at_edge_pattern_1 = require("@cloudcomponents/cdk-lambda-at-edge-pattern");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AuthFlow extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const edgeRole = new cdk_lambda_at_edge_pattern_1.EdgeRole(this, 'EdgeRole');
        const configuration = {
            logLevel: props.logLevel,
            redirectPathSignIn: props.redirectPaths.signIn,
            redirectPathAuthRefresh: props.redirectPaths.authRefresh,
            redirectPathSignOut: props.redirectPaths.signOut,
            userPoolId: props.userPool.userPoolId,
            clientId: props.userPoolClient.userPoolClientId,
            oauthScopes: props.oauthScopes.map((scope) => scope.scopeName),
            cognitoAuthDomain: props.cognitoAuthDomain,
            cookieSettings: props.cookieSettings,
            nonceSigningSecret: props.nonceSigningSecret,
            clientSecret: props.clientSecret,
        };
        this.checkAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'CheckAuth', {
            name: 'check-auth',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'check-auth')),
            edgeRole,
            configuration,
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.parseAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'ParseAuth', {
            name: 'parse-auth',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'parse-auth')),
            edgeRole,
            configuration,
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.refreshAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'RefreshAuth', {
            name: 'refresh-auth',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'refresh-auth')),
            edgeRole,
            configuration,
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.signOut = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'SignOut', {
            name: 'sign-out',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'sign-out')),
            edgeRole,
            configuration,
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.VIEWER_REQUEST,
        });
    }
}
exports.AuthFlow = AuthFlow;
_a = JSII_RTTI_SYMBOL_1;
AuthFlow[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.AuthFlow", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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