# coding: utf-8

"""
    Sonarr

    Sonarr API docs  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from sonarr.models.add_series_options import AddSeriesOptions
from sonarr.models.alternate_title_resource import AlternateTitleResource
from sonarr.models.language import Language
from sonarr.models.media_cover import MediaCover
from sonarr.models.ratings import Ratings
from sonarr.models.season_resource import SeasonResource
from sonarr.models.series_statistics_resource import SeriesStatisticsResource
from sonarr.models.series_status_type import SeriesStatusType
from sonarr.models.series_types import SeriesTypes

class SeriesResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    title: Optional[str]
    alternate_titles: Optional[List]
    sort_title: Optional[str]
    status: Optional[SeriesStatusType]
    ended: Optional[bool]
    profile_name: Optional[str]
    overview: Optional[str]
    next_airing: Optional[datetime]
    previous_airing: Optional[datetime]
    network: Optional[str]
    air_time: Optional[str]
    images: Optional[List]
    original_language: Optional[Language]
    remote_poster: Optional[str]
    seasons: Optional[List]
    year: Optional[int]
    path: Optional[str]
    quality_profile_id: Optional[int]
    season_folder: Optional[bool]
    monitored: Optional[bool]
    use_scene_numbering: Optional[bool]
    runtime: Optional[int]
    tvdb_id: Optional[int]
    tv_rage_id: Optional[int]
    tv_maze_id: Optional[int]
    first_aired: Optional[datetime]
    series_type: Optional[SeriesTypes]
    clean_title: Optional[str]
    imdb_id: Optional[str]
    title_slug: Optional[str]
    root_folder_path: Optional[str]
    folder: Optional[str]
    certification: Optional[str]
    genres: Optional[List]
    tags: Optional[List]
    added: Optional[datetime]
    add_options: Optional[AddSeriesOptions]
    ratings: Optional[Ratings]
    statistics: Optional[SeriesStatisticsResource]
    episodes_changed: Optional[bool]
    language_profile_id: Optional[int]
    __properties = ["id", "title", "alternateTitles", "sortTitle", "status", "ended", "profileName", "overview", "nextAiring", "previousAiring", "network", "airTime", "images", "originalLanguage", "remotePoster", "seasons", "year", "path", "qualityProfileId", "seasonFolder", "monitored", "useSceneNumbering", "runtime", "tvdbId", "tvRageId", "tvMazeId", "firstAired", "seriesType", "cleanTitle", "imdbId", "titleSlug", "rootFolderPath", "folder", "certification", "genres", "tags", "added", "addOptions", "ratings", "statistics", "episodesChanged", "languageProfileId"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeriesResource:
        """Create an instance of SeriesResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "ended",
                            "language_profile_id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in alternate_titles (list)
        _items = []
        if self.alternate_titles:
            for _item in self.alternate_titles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['alternateTitles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        # override the default output from pydantic by calling `to_dict()` of original_language
        if self.original_language:
            _dict['originalLanguage'] = self.original_language.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in seasons (list)
        _items = []
        if self.seasons:
            for _item in self.seasons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['seasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of add_options
        if self.add_options:
            _dict['addOptions'] = self.add_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ratings
        if self.ratings:
            _dict['ratings'] = self.ratings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        # set to None if alternate_titles (nullable) is None
        if self.alternate_titles is None:
            _dict['alternateTitles'] = None

        # set to None if sort_title (nullable) is None
        if self.sort_title is None:
            _dict['sortTitle'] = None

        # set to None if profile_name (nullable) is None
        if self.profile_name is None:
            _dict['profileName'] = None

        # set to None if overview (nullable) is None
        if self.overview is None:
            _dict['overview'] = None

        # set to None if next_airing (nullable) is None
        if self.next_airing is None:
            _dict['nextAiring'] = None

        # set to None if previous_airing (nullable) is None
        if self.previous_airing is None:
            _dict['previousAiring'] = None

        # set to None if network (nullable) is None
        if self.network is None:
            _dict['network'] = None

        # set to None if air_time (nullable) is None
        if self.air_time is None:
            _dict['airTime'] = None

        # set to None if images (nullable) is None
        if self.images is None:
            _dict['images'] = None

        # set to None if remote_poster (nullable) is None
        if self.remote_poster is None:
            _dict['remotePoster'] = None

        # set to None if seasons (nullable) is None
        if self.seasons is None:
            _dict['seasons'] = None

        # set to None if path (nullable) is None
        if self.path is None:
            _dict['path'] = None

        # set to None if first_aired (nullable) is None
        if self.first_aired is None:
            _dict['firstAired'] = None

        # set to None if clean_title (nullable) is None
        if self.clean_title is None:
            _dict['cleanTitle'] = None

        # set to None if imdb_id (nullable) is None
        if self.imdb_id is None:
            _dict['imdbId'] = None

        # set to None if title_slug (nullable) is None
        if self.title_slug is None:
            _dict['titleSlug'] = None

        # set to None if root_folder_path (nullable) is None
        if self.root_folder_path is None:
            _dict['rootFolderPath'] = None

        # set to None if folder (nullable) is None
        if self.folder is None:
            _dict['folder'] = None

        # set to None if certification (nullable) is None
        if self.certification is None:
            _dict['certification'] = None

        # set to None if genres (nullable) is None
        if self.genres is None:
            _dict['genres'] = None

        # set to None if tags (nullable) is None
        if self.tags is None:
            _dict['tags'] = None

        # set to None if episodes_changed (nullable) is None
        if self.episodes_changed is None:
            _dict['episodesChanged'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeriesResource:
        """Create an instance of SeriesResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeriesResource.parse_obj(obj)

        _obj = SeriesResource.parse_obj({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "alternate_titles": [AlternateTitleResource.from_dict(_item) for _item in obj.get("alternateTitles")] if obj.get("alternateTitles") is not None else None,
            "sort_title": obj.get("sortTitle"),
            "status": obj.get("status"),
            "ended": obj.get("ended"),
            "profile_name": obj.get("profileName"),
            "overview": obj.get("overview"),
            "next_airing": obj.get("nextAiring"),
            "previous_airing": obj.get("previousAiring"),
            "network": obj.get("network"),
            "air_time": obj.get("airTime"),
            "images": [MediaCover.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None,
            "original_language": Language.from_dict(obj.get("originalLanguage")) if obj.get("originalLanguage") is not None else None,
            "remote_poster": obj.get("remotePoster"),
            "seasons": [SeasonResource.from_dict(_item) for _item in obj.get("seasons")] if obj.get("seasons") is not None else None,
            "year": obj.get("year"),
            "path": obj.get("path"),
            "quality_profile_id": obj.get("qualityProfileId"),
            "season_folder": obj.get("seasonFolder"),
            "monitored": obj.get("monitored"),
            "use_scene_numbering": obj.get("useSceneNumbering"),
            "runtime": obj.get("runtime"),
            "tvdb_id": obj.get("tvdbId"),
            "tv_rage_id": obj.get("tvRageId"),
            "tv_maze_id": obj.get("tvMazeId"),
            "first_aired": obj.get("firstAired"),
            "series_type": obj.get("seriesType"),
            "clean_title": obj.get("cleanTitle"),
            "imdb_id": obj.get("imdbId"),
            "title_slug": obj.get("titleSlug"),
            "root_folder_path": obj.get("rootFolderPath"),
            "folder": obj.get("folder"),
            "certification": obj.get("certification"),
            "genres": obj.get("genres"),
            "tags": obj.get("tags"),
            "added": obj.get("added"),
            "add_options": AddSeriesOptions.from_dict(obj.get("addOptions")) if obj.get("addOptions") is not None else None,
            "ratings": Ratings.from_dict(obj.get("ratings")) if obj.get("ratings") is not None else None,
            "statistics": SeriesStatisticsResource.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None,
            "episodes_changed": obj.get("episodesChanged"),
            "language_profile_id": obj.get("languageProfileId")
        })
        return _obj

