# coding: utf-8

"""
    Sonarr

    Sonarr API docs  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel

class NamingConfigResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    rename_episodes: Optional[bool]
    replace_illegal_characters: Optional[bool]
    multi_episode_style: Optional[int]
    standard_episode_format: Optional[str]
    daily_episode_format: Optional[str]
    anime_episode_format: Optional[str]
    series_folder_format: Optional[str]
    season_folder_format: Optional[str]
    specials_folder_format: Optional[str]
    include_series_title: Optional[bool]
    include_episode_title: Optional[bool]
    include_quality: Optional[bool]
    replace_spaces: Optional[bool]
    separator: Optional[str]
    number_style: Optional[str]
    __properties = ["id", "renameEpisodes", "replaceIllegalCharacters", "multiEpisodeStyle", "standardEpisodeFormat", "dailyEpisodeFormat", "animeEpisodeFormat", "seriesFolderFormat", "seasonFolderFormat", "specialsFolderFormat", "includeSeriesTitle", "includeEpisodeTitle", "includeQuality", "replaceSpaces", "separator", "numberStyle"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NamingConfigResource:
        """Create an instance of NamingConfigResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if standard_episode_format (nullable) is None
        if self.standard_episode_format is None:
            _dict['standardEpisodeFormat'] = None

        # set to None if daily_episode_format (nullable) is None
        if self.daily_episode_format is None:
            _dict['dailyEpisodeFormat'] = None

        # set to None if anime_episode_format (nullable) is None
        if self.anime_episode_format is None:
            _dict['animeEpisodeFormat'] = None

        # set to None if series_folder_format (nullable) is None
        if self.series_folder_format is None:
            _dict['seriesFolderFormat'] = None

        # set to None if season_folder_format (nullable) is None
        if self.season_folder_format is None:
            _dict['seasonFolderFormat'] = None

        # set to None if specials_folder_format (nullable) is None
        if self.specials_folder_format is None:
            _dict['specialsFolderFormat'] = None

        # set to None if separator (nullable) is None
        if self.separator is None:
            _dict['separator'] = None

        # set to None if number_style (nullable) is None
        if self.number_style is None:
            _dict['numberStyle'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NamingConfigResource:
        """Create an instance of NamingConfigResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NamingConfigResource.parse_obj(obj)

        _obj = NamingConfigResource.parse_obj({
            "id": obj.get("id"),
            "rename_episodes": obj.get("renameEpisodes"),
            "replace_illegal_characters": obj.get("replaceIllegalCharacters"),
            "multi_episode_style": obj.get("multiEpisodeStyle"),
            "standard_episode_format": obj.get("standardEpisodeFormat"),
            "daily_episode_format": obj.get("dailyEpisodeFormat"),
            "anime_episode_format": obj.get("animeEpisodeFormat"),
            "series_folder_format": obj.get("seriesFolderFormat"),
            "season_folder_format": obj.get("seasonFolderFormat"),
            "specials_folder_format": obj.get("specialsFolderFormat"),
            "include_series_title": obj.get("includeSeriesTitle"),
            "include_episode_title": obj.get("includeEpisodeTitle"),
            "include_quality": obj.get("includeQuality"),
            "replace_spaces": obj.get("replaceSpaces"),
            "separator": obj.get("separator"),
            "number_style": obj.get("numberStyle")
        })
        return _obj

