# coding: utf-8

"""
    Sonarr

    Sonarr API docs  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from sonarr.models.episode_file_resource import EpisodeFileResource
from sonarr.models.media_cover import MediaCover
from sonarr.models.series_resource import SeriesResource

class EpisodeResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    series_id: Optional[int]
    tvdb_id: Optional[int]
    episode_file_id: Optional[int]
    season_number: Optional[int]
    episode_number: Optional[int]
    title: Optional[str]
    air_date: Optional[str]
    air_date_utc: Optional[datetime]
    overview: Optional[str]
    episode_file: Optional[EpisodeFileResource]
    has_file: Optional[bool]
    monitored: Optional[bool]
    absolute_episode_number: Optional[int]
    scene_absolute_episode_number: Optional[int]
    scene_episode_number: Optional[int]
    scene_season_number: Optional[int]
    unverified_scene_numbering: Optional[bool]
    end_time: Optional[datetime]
    grab_date: Optional[datetime]
    series_title: Optional[str]
    series: Optional[SeriesResource]
    images: Optional[List]
    grabbed: Optional[bool]
    __properties = ["id", "seriesId", "tvdbId", "episodeFileId", "seasonNumber", "episodeNumber", "title", "airDate", "airDateUtc", "overview", "episodeFile", "hasFile", "monitored", "absoluteEpisodeNumber", "sceneAbsoluteEpisodeNumber", "sceneEpisodeNumber", "sceneSeasonNumber", "unverifiedSceneNumbering", "endTime", "grabDate", "seriesTitle", "series", "images", "grabbed"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EpisodeResource:
        """Create an instance of EpisodeResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of episode_file
        if self.episode_file:
            _dict['episodeFile'] = self.episode_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of series
        if self.series:
            _dict['series'] = self.series.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        # set to None if air_date (nullable) is None
        if self.air_date is None:
            _dict['airDate'] = None

        # set to None if air_date_utc (nullable) is None
        if self.air_date_utc is None:
            _dict['airDateUtc'] = None

        # set to None if overview (nullable) is None
        if self.overview is None:
            _dict['overview'] = None

        # set to None if absolute_episode_number (nullable) is None
        if self.absolute_episode_number is None:
            _dict['absoluteEpisodeNumber'] = None

        # set to None if scene_absolute_episode_number (nullable) is None
        if self.scene_absolute_episode_number is None:
            _dict['sceneAbsoluteEpisodeNumber'] = None

        # set to None if scene_episode_number (nullable) is None
        if self.scene_episode_number is None:
            _dict['sceneEpisodeNumber'] = None

        # set to None if scene_season_number (nullable) is None
        if self.scene_season_number is None:
            _dict['sceneSeasonNumber'] = None

        # set to None if end_time (nullable) is None
        if self.end_time is None:
            _dict['endTime'] = None

        # set to None if grab_date (nullable) is None
        if self.grab_date is None:
            _dict['grabDate'] = None

        # set to None if series_title (nullable) is None
        if self.series_title is None:
            _dict['seriesTitle'] = None

        # set to None if images (nullable) is None
        if self.images is None:
            _dict['images'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EpisodeResource:
        """Create an instance of EpisodeResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EpisodeResource.parse_obj(obj)

        _obj = EpisodeResource.parse_obj({
            "id": obj.get("id"),
            "series_id": obj.get("seriesId"),
            "tvdb_id": obj.get("tvdbId"),
            "episode_file_id": obj.get("episodeFileId"),
            "season_number": obj.get("seasonNumber"),
            "episode_number": obj.get("episodeNumber"),
            "title": obj.get("title"),
            "air_date": obj.get("airDate"),
            "air_date_utc": obj.get("airDateUtc"),
            "overview": obj.get("overview"),
            "episode_file": EpisodeFileResource.from_dict(obj.get("episodeFile")) if obj.get("episodeFile") is not None else None,
            "has_file": obj.get("hasFile"),
            "monitored": obj.get("monitored"),
            "absolute_episode_number": obj.get("absoluteEpisodeNumber"),
            "scene_absolute_episode_number": obj.get("sceneAbsoluteEpisodeNumber"),
            "scene_episode_number": obj.get("sceneEpisodeNumber"),
            "scene_season_number": obj.get("sceneSeasonNumber"),
            "unverified_scene_numbering": obj.get("unverifiedSceneNumbering"),
            "end_time": obj.get("endTime"),
            "grab_date": obj.get("grabDate"),
            "series_title": obj.get("seriesTitle"),
            "series": SeriesResource.from_dict(obj.get("series")) if obj.get("series") is not None else None,
            "images": [MediaCover.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None,
            "grabbed": obj.get("grabbed")
        })
        return _obj

