# coding: utf-8

"""
    Sonarr

    Sonarr API docs  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import StrictBool, StrictInt, StrictStr, conlist

from typing import List, Optional

from sonarr.models.manual_import_reprocess_resource import ManualImportReprocessResource
from sonarr.models.manual_import_resource import ManualImportResource

from sonarr.api_client import ApiClient
from sonarr.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ManualImportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_manual_import(self, manual_import_reprocess_resource : Optional[conlist(ManualImportReprocessResource)] = None, **kwargs) -> None:  # noqa: E501
        """create_manual_import  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_manual_import(manual_import_reprocess_resource, async_req=True)
        >>> result = thread.get()

        :param manual_import_reprocess_resource:
        :type manual_import_reprocess_resource: List[ManualImportReprocessResource]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.create_manual_import_with_http_info(manual_import_reprocess_resource, **kwargs)  # noqa: E501

    @validate_arguments
    def create_manual_import_with_http_info(self, manual_import_reprocess_resource : Optional[conlist(ManualImportReprocessResource)] = None, **kwargs):  # noqa: E501
        """create_manual_import  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_manual_import_with_http_info(manual_import_reprocess_resource, async_req=True)
        >>> result = thread.get()

        :param manual_import_reprocess_resource:
        :type manual_import_reprocess_resource: List[ManualImportReprocessResource]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'manual_import_reprocess_resource'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_manual_import" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['manual_import_reprocess_resource']:
            _body_params = _params['manual_import_reprocess_resource']

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['apikey', 'X-Api-Key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api/v3/manualimport', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_manual_import(self, folder : Optional[StrictStr] = None, download_id : Optional[StrictStr] = None, series_id : Optional[StrictInt] = None, season_number : Optional[StrictInt] = None, filter_existing_files : Optional[StrictBool] = None, **kwargs) -> List[ManualImportResource]:  # noqa: E501
        """list_manual_import  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_manual_import(folder, download_id, series_id, season_number, filter_existing_files, async_req=True)
        >>> result = thread.get()

        :param folder:
        :type folder: str
        :param download_id:
        :type download_id: str
        :param series_id:
        :type series_id: int
        :param season_number:
        :type season_number: int
        :param filter_existing_files:
        :type filter_existing_files: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[ManualImportResource]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_manual_import_with_http_info(folder, download_id, series_id, season_number, filter_existing_files, **kwargs)  # noqa: E501

    @validate_arguments
    def list_manual_import_with_http_info(self, folder : Optional[StrictStr] = None, download_id : Optional[StrictStr] = None, series_id : Optional[StrictInt] = None, season_number : Optional[StrictInt] = None, filter_existing_files : Optional[StrictBool] = None, **kwargs):  # noqa: E501
        """list_manual_import  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_manual_import_with_http_info(folder, download_id, series_id, season_number, filter_existing_files, async_req=True)
        >>> result = thread.get()

        :param folder:
        :type folder: str
        :param download_id:
        :type download_id: str
        :param series_id:
        :type series_id: int
        :param season_number:
        :type season_number: int
        :param filter_existing_files:
        :type filter_existing_files: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[ManualImportResource], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'folder',
            'download_id',
            'series_id',
            'season_number',
            'filter_existing_files'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_manual_import" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('folder') is not None:  # noqa: E501
            _query_params.append(('folder', _params['folder']))
        if _params.get('download_id') is not None:  # noqa: E501
            _query_params.append(('downloadId', _params['download_id']))
        if _params.get('series_id') is not None:  # noqa: E501
            _query_params.append(('seriesId', _params['series_id']))
        if _params.get('season_number') is not None:  # noqa: E501
            _query_params.append(('seasonNumber', _params['season_number']))
        if _params.get('filter_existing_files') is not None:  # noqa: E501
            _query_params.append(('filterExistingFiles', _params['filter_existing_files']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apikey', 'X-Api-Key']  # noqa: E501

        _response_types_map = {
            '200': "List[ManualImportResource]",
        }

        return self.api_client.call_api(
            '/api/v3/manualimport', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
