import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * Properties for a SamlProvider
 *
 * @deprecated use `SamlProviderProps` from `aws-cdk-lib/aws-iam`
 */
export interface SamlIdentityProviderProps {
    /**
     * A name for the SAML identity provider
     *
     * @default - derived for the node's unique id
     */
    readonly name?: string;
    /**
     * An XML document generated by an identity provider (IdP) that supports SAML 2.0.
     *
     * The document includes the issuer's name, expiration information, and keys that
     * can be used to validate the SAML authentication response (assertions) that are
     * received from the IdP. You must generate the metadata document using the identity
     * management software that is used as your organization's IdP.
     */
    readonly metadataDocument: string;
}
/**
 * Create a SAML identity provider
 *
 * @deprecated use `SamlProvider` from `aws-cdk-lib/aws-iam`
 */
export declare class SamlIdentityProvider extends Construct {
    /**
     * The ARN of the SAML identity provider
     */
    readonly samlIdentityProviderArn: string;
    constructor(scope: Construct, id: string, props: SamlIdentityProviderProps);
}
/**
 * Principal entity that represents a SAML federated identity provider.
 *
 * @deprecated use `SamlPrincipal` from `aws-cdk-lib/aws-iam`
 */
export declare class SamlFederatedPrincipal extends iam.FederatedPrincipal {
    constructor(identityProvider: SamlIdentityProvider);
}
