/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.RB;
import com.sas.util.SimpleTemplate2;
import com.sas.util.WriteToPrintWriterInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;

@SASScope
public class SimpleTemplateToPrintWriter
extends SimpleTemplate2 {
    static final String RB_KEY = "SimpleTemplateToPrintWriter.";
    protected boolean empty;

    public SimpleTemplateToPrintWriter(String pattern, Map dictionary, PrintWriter out) {
        super(pattern, dictionary);
        this.setWriter(out);
    }

    public SimpleTemplateToPrintWriter(String pattern, Map dictionary, char marker, char open, char close, PrintWriter out) {
        super(pattern, dictionary, marker, open, close);
        this.setWriter(out);
    }

    protected void writeToken(String pstring) {
        if (!pstring.startsWith(this.vdelimiter) || pstring.length() <= 1) {
            this.getWriter().print(pstring);
            return;
        }
        int pos = pstring.indexOf(this.openc);
        if (pos == -1) {
            this.writeValue(this.getValueFromDictionary(pstring.substring(1)));
            return;
        }
        String nstring = pstring.substring(pos + 1, pstring.lastIndexOf(this.closec)).trim();
        if (nstring.length() == 0) {
            this.writeValue(this.getValueFromDictionary(pstring.substring(1, pos)));
        } else {
            Object value = this.getValueFromDictionary(pstring.substring(1, pos));
            String[] var = this.findVarDelimiter(nstring);
            if (value != null && var[0] != null) {
                this.writeVar(var[0]);
            } else if (value == null && var[1] != null) {
                this.writeVar(var[1]);
            }
        }
    }

    private void writeValue(Object value) {
        if (value == null) {
            return;
        }
        this.empty = false;
        if (value instanceof WriteToPrintWriterInterface) {
            try {
                ((WriteToPrintWriterInterface)value).write(this.getWriter());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        } else {
            this.getWriter().print(this.checkToStringCache(value));
        }
    }

    private void writeVar(String var) {
        ArrayList var_string_array = new ArrayList();
        this.tokenizeField(var, var_string_array);
        if (var_string_array.isEmpty()) {
            this.empty = false;
            this.getWriter().print("");
        } else {
            int varStringArraySize = var_string_array.size();
            for (int i = 0; i < varStringArraySize; ++i) {
                this.empty = false;
                this.writeToken((String)var_string_array.get(i));
            }
        }
    }

    protected void writeText() {
        this.tokenizeTemplate();
        this.empty = true;
        int nsize = this.text_and_token_string_array.size();
        for (int npos = 0; npos < nsize; ++npos) {
            String pstring = (String)this.text_and_token_string_array.get(npos);
            this.writeToken(pstring);
        }
        if (this.empty) {
            this.getWriter().print("");
        }
    }

    public synchronized void write() {
        if (this.getWriter() == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noWriter.txt"));
        }
        if (this._toStringCacheClearedOnFormat) {
            this.clearToStringCache();
        }
        this.writeText();
    }

    public static void write(String pattern, Map dictionary, PrintWriter out) {
        SimpleTemplateToPrintWriter.write(pattern, dictionary, '%', '(', ')', out);
    }

    public static void write(String pattern, Map dictionary, char marker, char open, char close, PrintWriter out) {
        SimpleTemplateToPrintWriter tmp = new SimpleTemplateToPrintWriter(pattern, dictionary, marker, open, close, out);
        tmp.write();
    }

    private Object getValueFromDictionary(String key) {
        Map values = this.getValueDictionary();
        if (values != null) {
            return values.get(key);
        }
        return null;
    }
}

