/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import java.util.HashSet;
import java.util.Set;

@SASScope
public class UnImplementedFormat {
    private static UnImplementedFormat instance = new UnImplementedFormat();
    private static String[] dateTimeFormats = new String[]{"E8601DN", "IS8601DN", "B8601DN", "E8601DT", "B8601DZ", "E8601DZ", "B8601DT", "IS8601DT", "IS8601DZ"};
    private static final Set dateTimeFormatsSet = UnImplementedFormat.convertToSet(dateTimeFormats);
    private static String[] nlDateTimeFormats = new String[]{"MDYAMPM", "TWMDY"};
    private static final Set nlDateTimeFormatsSet = UnImplementedFormat.convertToSet(nlDateTimeFormats);
    private static String[] timeFormats = new String[]{"B8601TM", "B8601TZ", "B8601LZ", "E8601LZ", "E8601TM", "E8601TZ", "IS8601LZ", "IS8601TM", "IS8601TZ"};
    private static final Set timeFormatset = UnImplementedFormat.convertToSet(timeFormats);
    private static String[] dateFormats = new String[]{"E8601DA", "IS8601DA", "XYYMMDD", "B8601DA"};
    private static final Set dateFormatsset = UnImplementedFormat.convertToSet(dateFormats);
    private static String[] nlDateFormats = new String[]{"HDATE", "HEBDATE", "JDATEYDW", "JDATEYMD", "JDATEYMW", "JNENGO", "JNENGOW", "MINGUO", "NENGO", "YYQN", "JDATEMDW"};
    private static final Set nlDateFormatsset = UnImplementedFormat.convertToSet(nlDateFormats);
    private static String[] numericFormat = new String[]{"BESTD", "BESTX", "FRACT", "ODDSR", "SSN", "WORDF", "WORDS", "Z", "ZD", "EURFRATS", "EURFRBEF", "EURFRCHF", "EURFRCZK", "EURFRDEM", "EURFRDKK", "EURFRESP", "EURFRFIM", "EURFRFRF", "EURFRGBP", "EURFRGRD", "EURFRHUF", "EURFRIEP", "EURFRITL", "EURFRLUF", "EURFRNLG", "EURFRNOK", "EURFRPLZ", "EURFRPTE", "EURFRROL", "EURFRRUR", "EURFRSEK", "EURFRSIT", "EURFRTRL", "EURFRYUD", "EURTOATS", "EURTOBEF", "EURTOCHF", "EURTOCZK", "EURTODEM", "EURTODKK", "EURTOESP", "EURTOFIM", "EURTOFRF", "EURTOGBP", "EURTOGRD", "EURTOHUF", "EURTOIEP", "EURTOITL", "EURTOLUF", "EURTONLG", "EURTONOK", "EURTOPLZ", "EURTOPTE", "EURTOROL", "EURTORUR", "EURTOSEK", "EURTOSIT", "EURTOTRL", "EURTOYUD"};
    private static final Set numericFormatSet = UnImplementedFormat.convertToSet(numericFormat);
    private static String[] charecterFormats = new String[]{"$KANA", "$KTRUNC", "$MSGCASE", "$QUOTE", "$REVERJ", "$REVERS", "$ROMAJI", "$UESC", "$UESCE", "$UNCR", "$UNCRE", "$UPAREN", "$UPARENE", "$UPCASE", "$VARYING", "$VSLOG", "$VSLOGR"};
    private static final Set charecterFormatsSet = UnImplementedFormat.convertToSet(charecterFormats);

    private static Set convertToSet(String[] elements) {
        HashSet<String> set = new HashSet<String>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            set.add(elements[i]);
        }
        return set;
    }

    private UnImplementedFormat() {
    }

    public static UnImplementedFormat getinstance() {
        if (instance == null) {
            instance = new UnImplementedFormat();
        }
        return instance;
    }

    public String getDefaultFormat(String fotmatName) {
        if (dateTimeFormatsSet.contains(fotmatName)) {
            return "DATETIME";
        }
        if (nlDateTimeFormatsSet.contains(fotmatName)) {
            return "NLDATM";
        }
        if (timeFormatset.contains(fotmatName)) {
            return "TIME";
        }
        if (dateFormatsset.contains(fotmatName)) {
            return "DATE";
        }
        if (nlDateFormatsset.contains(fotmatName)) {
            return "NLDATE";
        }
        if (numericFormatSet.contains(fotmatName)) {
            return "NLBEST";
        }
        if (charecterFormatsSet.contains(fotmatName)) {
            return "$CHAR";
        }
        return null;
    }
}

