/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.DataSourceColumnType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.InputFileType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.MaskedType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.OLAPMemberNameType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.util.Strings;
import com.sas.util.macrovar.BaseMacroInfoSource;
import com.sas.util.macrovar.MacroVariableListOptionInterface;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class CollectionType
extends BaseDataType {
    public static final CollectionType DEFAULT_INSTANCE_DATE = new CollectionType(DateType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_DOUBLE = new CollectionType(DoubleType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_INTEGER = new CollectionType(IntegerType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_MONTH = new CollectionType(MonthType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_QUARTER = new CollectionType(QuarterType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_STRING = new CollectionType(StringType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_TIMESTAMP = new CollectionType(TimeStampType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_TIME = new CollectionType(TimeType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_WEEK = new CollectionType(WeekType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_YEAR = new CollectionType(YearType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_WEEKDAY = new CollectionType(WeekdayType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_DATASOURCECOLUMN = new CollectionType(DataSourceColumnType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_OLAPMEMBER = new CollectionType(OLAPMemberNameType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_MASKED = new CollectionType(MaskedType.DEFAULT_INSTANCE);
    public static final CollectionType DEFAULT_INSTANCE_FILEUPLOAD = new CollectionType(InputFileType.DEFAULT_INSTANCE);
    private DataTypeInterface dataType;

    public CollectionType(DataTypeInterface typeOfData) {
        this.setTypeOfData(typeOfData);
    }

    public DataTypeInterface getTypeOfData() {
        return this.dataType;
    }

    public final void setTypeOfData(DataTypeInterface dataType) {
        this.dataType = dataType;
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof Collection) {
            Collection collection = (Collection)inputValue;
            ArrayList<Object> newCollection = new ArrayList<Object>(collection.size());
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                newCollection.add(this.dataType.coerceValue(iter.next(), inputLocale));
            }
            return newCollection;
        }
        if (inputValue instanceof String) {
            String[] uniqueNames = Strings.split((String)inputValue, null, "\n", null);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < uniqueNames.length; ++i) {
                values.add(this.dataType.coerceValue(uniqueNames[i], inputLocale));
            }
            return values;
        }
        if (inputValue instanceof String[]) {
            String[] stringArray = (String[])inputValue;
            ArrayList<Object> values = new ArrayList<Object>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                values.add(this.dataType.coerceValue(stringArray[i], inputLocale));
            }
            return values;
        }
        if (inputValue == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.dataType.coerceValue(inputValue, inputLocale));
        return values;
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        return this.getValueAsString(value, "\n", true, outputLocale);
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        return this.getValueAsString(value, ", ", false, outputLocale);
    }

    private String getValueAsString(Object value, String seperator, boolean useGetValeuAsString, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        Iterator iter = ((Collection)value).iterator();
        StringBuffer buf = new StringBuffer("");
        while (iter.hasNext()) {
            if (buf.length() > 0) {
                buf.append(seperator);
            }
            if (useGetValeuAsString) {
                buf.append(this.dataType.getValueAsString(iter.next(), outputLocale));
                continue;
            }
            buf.append(this.dataType.getDisplayString(iter.next(), outputLocale));
        }
        return buf.toString();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        return this.dataType.coerceValueFromPersistedString(input);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.dataType.getPersistanceString(value);
    }

    @Override
    public int getSQLType() {
        return this.dataType.getSQLType();
    }

    @Override
    public int getExpressionUsage() {
        return this.dataType.getExpressionUsage();
    }

    @Override
    public Map getUnsetMacroVariableValues(MacroVariableOptionInterface macroInfoSource) {
        return this.newSingleItemMap(macroInfoSource.getMacroVariableBaseName() + "_count", "0");
    }

    @Override
    protected Map getMacroVariablesForNull(MacroVariableOptionInterface macroInfoSource) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        return this.newSingleItemMap(baseMacroVariableName + "_count", "0");
    }

    @Override
    public Map getMacroVariableValues(String baseMacroVariableName, Object value, Locale locale) {
        BaseMacroInfoSource macroInfoSource = new BaseMacroInfoSource(baseMacroVariableName);
        return this.getMacroVariableValues(macroInfoSource, value, locale);
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        int listFormat = 2;
        if (macroInfoSource instanceof MacroVariableListOptionInterface) {
            listFormat = ((MacroVariableListOptionInterface)macroInfoSource).getMacroVariableListFormat();
        }
        List values = (List)value;
        if (listFormat == 2) {
            HashMap<String, String> map = new HashMap<String, String>(values.size() + 2);
            if (values.size() > 1) {
                map.put(baseMacroVariableName + "0", values.size() + "");
            }
            map.put(baseMacroVariableName + "_count", values.size() + "");
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                Map oneValueVariables = this.getTypeOfData().getMacroVariableValues(macroInfoSource, values.get(i), locale);
                for (String key : oneValueVariables.keySet()) {
                    Object oneMacroVarValue = oneValueVariables.get(key);
                    if (n > 1) {
                        map.put(key + (i + 1), (String)oneMacroVarValue);
                    }
                    if (i != 0) continue;
                    map.put(key, (String)oneMacroVarValue);
                }
            }
            return map;
        }
        if (listFormat == 1) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(baseMacroVariableName + "_count", values.size() + "");
            MacroVariableOptionInterface facadeWithNoDetails = macroInfoSource;
            HashMap<String, StringBuffer> valuesBufferMap = new HashMap<String, StringBuffer>();
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                Map oneValueVariables = this.getTypeOfData().getMacroVariableValues(facadeWithNoDetails, values.get(i), locale);
                for (String key : oneValueVariables.keySet()) {
                    Object oneMacroVarValue = oneValueVariables.get(key);
                    StringBuffer valuesBuffer = (StringBuffer)valuesBufferMap.get(key);
                    if (valuesBuffer == null) {
                        valuesBuffer = new StringBuffer();
                        valuesBufferMap.put(key, valuesBuffer);
                    } else if (valuesBuffer.length() > 0 && macroInfoSource instanceof MacroVariableListOptionInterface) {
                        valuesBuffer.append(((MacroVariableListOptionInterface)macroInfoSource).getMacroVariableListDelimiter());
                    }
                    String quote = null;
                    if (macroInfoSource instanceof MacroVariableListOptionInterface) {
                        quote = ((MacroVariableListOptionInterface)macroInfoSource).getMacroVariableQuote();
                    }
                    if (quote != null) {
                        valuesBuffer.append(quote);
                    }
                    valuesBuffer.append((String)oneMacroVarValue);
                    if (quote == null) continue;
                    valuesBuffer.append(quote);
                }
            }
            for (String key : valuesBufferMap.keySet()) {
                StringBuffer buf = (StringBuffer)valuesBufferMap.get(key);
                map.put(key, buf.toString());
            }
            return map;
        }
        throw new IllegalStateException("Unknown macro variable format");
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        Collection typeExtensions = this.getTypeOfData().getPossibleMacroVariableExtensions();
        ArrayList extensions = new ArrayList(typeExtensions.size() + 2);
        extensions.addAll(typeExtensions);
        return this.addExtensions(extensions, new String[]{"", "_count"});
    }

    @Override
    public boolean isMacroVariablesIndexed() {
        return true;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }
}

