# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['repassh']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['repassh = repassh:sshcmd']}

setup_kwargs = {
    'name': 'repassh',
    'version': '1.0.2',
    'description': 'SSH wrapper to load private keys on first execution',
    'long_description': '# repassh\n\nSSH wrapper to load private keys via `ssh-add` when they are first needed.\n\nHeavily based on [ssh-ident](https://github.com/ccontavalli/ssh-ident).\n\n## Usage\n\nUse this script to start ssh-agents and load ssh keys on demand,\nwhen they are first needed.\n\nAll you have to do is modify your .bashrc to have:\n\n```\nalias ssh=\'/path/to/repassh\'\n```\n\nor add a link to `repassh` from a directory in your PATH, for example:\n\n```\nln -s /path/to/repassh ~/bin/ssh\n```\n\nIf you use scp or rsync regularly, you should add a few more lines described\nbelow.\n\nIn any case, `repassh`:\n\n- will start ssh-agent and load the keys you need the first time you\n  actually need them, once. No matter how many terminals, ssh or login\n  sessions you have, no matter if your home is shared via NFS.\n- can prepare and use a different agent and different set of keys depending\n  on the host you are connecting to, or the directory you are using ssh\n  from.\n  This allows for isolating keys when using agent forwarding with different\n  sites (eg, university, work, home, secret evil internet identity, ...).\n  It also allows to use multiple accounts on sites like github, unfuddle\n  and gitorious easily.\n- allows to specify different options for each set of keys. For example, you\n  can provide a -t 60 to keep keys loaded for at most 60 seconds. Or -c to\n  always ask for confirmation before using a key.\n\n\n## Installation\n\nAll you need to run `repassh` is a standard installation of python >= 3.6.\n\nTo install it, run:\n\n```\npip install repassh\n```\n\nThen you can use the `repassh` command just as you\'d use `ssh`.\n\n## Alternatives\n\nIn `.bashrc` you can define an alias:\n\n```\nalias ssh=/path/to/repassh\n```\n\nthen all you have to do is:\n\n```\nssh somewhere\n```\n\n`repassh` will be called instead of `ssh`, and it will:\n\n- check if `ssh-agent` is running. If not, it will start one.\n- try to load all the keys in `~/.ssh`, if not loaded.\n\nIf you use `ssh` again, `repassh` will reuse the same agent\nand the same keys.\n\n## About scp, rsync, and friends\n\n`scp`, `rsync`, and most similar tools internally invoke `ssh`. If you don\'t tell\nthem to use `repassh` instead, key loading won\'t work. There are a few ways\nto solve the problem:\n\n### Rename or link\n\nRename `repassh` to `ssh` or create a symlink `ssh` pointing to\n`repassh` in a directory in your PATH before `/usr/bin` or `/bin`.\n\nFor example:\n\n```\nln -s /path/to/repassh ~/bin/ssh\nexport PATH="~/bin:$PATH"\n```\n\nMake sure `echo $PATH` shows `~/bin` *before* `/usr/bin` or `/bin`. You\ncan verify this is working as expected with `which ssh`, which should\nshow `~/bin/ssh`.\n\nThis works for `rsync` and `git`, among others, but not for `scp` and `sftp`, as\nthese do not look for `ssh` in your `PATH` but use a hard-coded path to the\nbinary.\n\nIf you want to use `repassh` with `scp` or `sftp`,  you can simply create\nsymlinks for them as well:\n\n```\nln -s /path/to/repassh ~/bin/scp\nln -s /path/to/repassh ~/bin/sftp\n```\n\n### More aliases\n\nAdd a few more aliases in your .bashrc file, for example:\n\n```\nalias scp=\'BINARY_SSH=scp /path/to/repassh\'\nalias rsync=\'BINARY_SSH=rsync /path/to/repassh\'\n...\n```\n\nThe first alias will make the `scp` command invoke `repassh` instead,\nbut tell `repassh` to invoke `scp` instead of the plain `ssh` command\nafter loading the necessary agents and keys.\n\nNote that aliases don\'t work from scripts - if you have any script that\nyou expect to use with `repassh`, you may prefer the first method, or you will\nneed to update the script accordingly.\n\n### Tell other programs to use `repassh` instead of `ssh`\n\nUse command specific methods to force them to use `repassh` instead of\n`ssh`, for example:\n\n```\nrsync -e \'/path/to/repassh\' ...\nscp -S \'/path/to/repassh\' ...\n```\n\n## Config file with multiple identities\n\nTo have multiple identities:\n\n1. create a `$XDG_CONFIG_HOME/repassh/config.json` file. In this file, you need to tell `repassh`\n   which identities to use and when. The file should be a valid JSON (ignore/remove the lines\n   starting with #, they are comments, but JSON does not have comments):\n\n   ```\n   {\n   # Specifies which identity to use depending on the path I\'m running ssh\n   # from.\n   # For example: ("mod-xslt", "personal") means that for any path that\n   # contains the word "mod-xslt", the "personal" identity should be used.\n   # This is optional - don\'t include any MATCH_PATH if you don\'t need it.\n   \n     "MATCH_PATH": [\n       ["mod-xslt", "personal"],\n       ["repassh", "personal"],\n       ["opt/work", "work"],\n       ["opt/private", "secret"]\n     ],\n  \n   # If any of the ssh arguments have \'cweb\' in it, the \'personal\' identity\n   # has to be used. For example: "ssh myhost.cweb.com" will have cweb in\n   # argv, and the "personal" identity will be used.\n   # This is optional - don\'t include any MATCH_ARGV if you don\'t\n   # need it.\n  \n     "MATCH_ARGV": [\n       ("cweb", "personal"),\n       ("corp", "work")\n     ],\n  \n   # Note that if no match is found, the DEFAULT_IDENTITY is used. This is\n   # generally your loginname, no need to change it.\n   # This is optional - don\'t include any DEFAULT_IDENTITY if you don\'t\n   # need it.\n\n   # "DEFAULT_IDENTITY": "foo",\n\n   # Use running `ssh-agent`, true by default\n   # If `SSH_AUTH_SOCK` and `SSH_AGENT_PID` environment variables are set\n   # and the agent responds then it will be used instead of executing a new\n   # one based on identity matching.\n   # If the agent does not respond, a new one is started just like\n   # `USE_RUNNING_AGENT` would be false.\n\n   # "USE_RUNNING_AGENT": true,\n  \n   # This is optional - don\'t include any SSH_ADD_OPTIONS if you don\'t\n   # need it.\n\n     "SSH_ADD_OPTIONS": {\n       # Regardless, ask for confirmation before using any of the\n       # work keys.\n       "work": "-c",\n       # Forget about secret keys after ten minutes. repassh will\n       # automatically ask you your passphrase again if they are needed.\n       "secret": "-t 600"\n     },\n  \n   # This is optional - don\'t include any SSH_OPTIONS if you don\'t\n   # need it.\n   # Otherwise, provides options to be passed to \'ssh\' for specific\n   # identities.\n\n     "SSH_OPTIONS": {\n       # Disable forwarding of the agent, but enable X forwarding,\n       # when using the work profile.\n       "work": "-Xa",\n  \n       # Always forward the agent when using the secret identity.\n       "secret": "-A"\n     },\n  \n   # Options to pass to ssh by default.\n   # If you don\'t specify anything, UserRoaming=no is passed, due\n   # to CVE-2016-0777. Leave it empty to disable this.\n\n     "SSH_DEFAULT_OPTIONS": "-oUseRoaming=no",\n  \n   # Which options to use by default if no match with SSH_ADD_OPTIONS\n   # was found. Note that repassh hard codes -t 7200 to prevent your\n   # keys from remaining in memory for too long.\n\n     "SSH_ADD_DEFAULT_OPTIONS": "-t 7200",\n  \n   # Output verbosity\n   # valid values are:\n   #   LOG_ERROR = 1, LOG_WARN = 2, LOG_INFO = 3, LOG_DEBUG = 4\n\n     "VERBOSITY": 3\n   }\n   ```\n\n2. Create the directory where all the identities and agents\n   will be kept:\n\n   ```\n   mkdir -p ~/.ssh/identities; chmod u=rwX,go= -R ~/.ssh\n   ```\n\n3. Create a directory for each identity, for example:\n\n   ```\n   mkdir -p ~/.ssh/identities/personal\n   mkdir -p ~/.ssh/identities/work\n   mkdir -p ~/.ssh/identities/secret\n   ```\n\n4. Generate (or copy) keys for those identities:\n\n   ```\n   # Default keys are for my personal account\n   $ cp ~/.ssh/id_rsa* ~/.ssh/identities/personal\n\n   # Generate keys to be used for work only, rsa\n   $ ssh-keygen -t rsa -b 4096 -f ~/.ssh/identities/work/id_rsa\n\n   ...\n   ```\n\n\nNow if you run:\n\n```\n$ ssh corp.mywemployer.com\n```\n\n`repassh` will be invoked and:\n\n1. checks `ssh` argv, determine that the *work* identity has to be used.\n2. checks `~/.ssh/agents` for a *work* agent loaded. If there is no\n   agent, it will prepare one.\n3. checks `~/.ssh/identities/work/` for a list of keys to load for this\n   identity. It will try to load any key that is not already loaded in\n   the agent.\n4. finally run `ssh` with the environment setup such that it will have\n   access only to the agent for the identity work, and the corresponding\n   keys.\n\nNote that `repassh` needs to access both your private and public keys. Note\nalso that it identifies public keys by the .pub extension. All files in your\nidentities subdirectories will be considered keys.\n\nIf you want to only load keys that have "key" in the name, you can add\nto your `config.json`:\n\n```\nPATTERN_KEYS = "key"\n```\n\nThe default is:\n\n```\nPATTERN_KEYS = r"/(id_.*|identity.*|ssh[0-9]-.*)"\n```\n\nYou can also redefine:\n\n```\nDIR_IDENTITIES = "$HOME/.ssh/identities"\nDIR_AGENTS = "$HOME/.ssh/agents"\n```\n\nTo point somewhere else if you so desire.\n',
    'author': 'Gyuri Horak',
    'author_email': 'dyuri@horak.hu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dyuri/repassh',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
