"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToFargate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToFargate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        defaults.CheckFargateProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        // Set up the ALB
        this.loadBalancer = defaults.ObtainAlb(scope, `${id}-lb`, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        const newListener = this.loadBalancer.listeners.length === 0;
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_1.GetActiveListener(this.loadBalancer.listeners);
        }
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Add the Fargate Service to the
        // to the ALB Listener we set up earlier
        const applicationTargetGroupProps = defaults.consolidateProps(defaults.DefaultApplicationTargetGroupProps(this.vpc), props.targetGroupProps);
        const newTargetGroup = defaults.AddFargateTarget(scope, `${id}-target`, this.listener, this.service, props.ruleProps, applicationTargetGroupProps);
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependency(cfnTargetGroup);
        }
    }
}
exports.AlbToFargate = AlbToFargate;
_a = JSII_RTTI_SYMBOL_1;
AlbToFargate[_a] = { fqn: "@aws-solutions-constructs/aws-alb-fargate.AlbToFargate", version: "2.31.0" };
//# sourceMappingURL=data:application/json;base64,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